/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class PackageGroup {
    private boolean isSubpackagesUses = true;
    private final List<String> group;

    public PackageGroup(boolean isSubpackagesUses) {
        this.isSubpackagesUses = isSubpackagesUses;
        this.group = new ArrayList<String>();
    }

    public boolean isEmpty() {
        return this.group.isEmpty();
    }

    public String toString() {
        return this.group.toString();
    }

    public void addPackage(String packageName) {
        this.group.add(packageName);
    }

    public void addPackages(String[] packageNames) {
        this.group.addAll(Arrays.asList(packageNames));
    }

    public boolean checkName(String className) {
        for (String pack : this.group) {
            if ((!className.startsWith(PackageGroup.getPackageName(pack)) || className.lastIndexOf(46) > pack.length() && !this.isSubpackagesUses) && !className.equals(pack)) continue;
            return true;
        }
        return false;
    }

    public boolean checkModuleName(String moduleName) {
        for (String mn : this.group) {
            if (!mn.isEmpty() && !moduleName.equals(mn) && (!this.isSubpackagesUses || !moduleName.startsWith(mn + "."))) continue;
            return true;
        }
        return false;
    }

    private static String getPackageName(String name) {
        return name + (name.endsWith(".") || name.isEmpty() ? "" : ".");
    }

    public void addPackages(List<String> packs) {
        if (packs != null) {
            this.group.addAll(packs);
        }
    }
}

