/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaspic.tssv.util;

import com.sun.ts.lib.util.BASE64Decoder;
import com.sun.ts.tests.jaspic.tssv.util.TSLogger;
import jakarta.security.auth.message.MessageInfo;
import jakarta.security.auth.message.callback.CallerPrincipalCallback;
import jakarta.security.auth.message.callback.GroupPrincipalCallback;
import jakarta.security.auth.message.callback.PasswordValidationCallback;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.security.Principal;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;

public class ServerCallbackSupport {
    private static TSLogger logger = null;
    private static CallbackHandler callbackHandler = null;
    private static String profile = null;
    private static final String runtimeType = "ServerRuntime";
    private static MessageInfo messageInfo = null;
    private static Subject clientSubject = null;
    private static Subject serverSubject = null;
    private static String user = System.getProperty("j2eelogin.name");
    private static String passwd = System.getProperty("j2eelogin.password");

    public ServerCallbackSupport(TSLogger tsLogger, CallbackHandler cbkHandler, String profile) {
        logger = tsLogger;
        callbackHandler = cbkHandler;
        ServerCallbackSupport.profile = profile;
    }

    public ServerCallbackSupport(TSLogger tsLogger, CallbackHandler cbkHandler, String profile, MessageInfo msgInfo, Subject clientSubj, Subject serverSubj) {
        logger = tsLogger;
        callbackHandler = cbkHandler;
        ServerCallbackSupport.profile = profile;
        messageInfo = msgInfo;
        clientSubject = clientSubj;
        serverSubject = serverSubj;
    }

    public boolean verify() {
        try {
            this.CallerPrincipalCallbackSupport();
            this.GroupPrincipalCallbackSupport();
            this.PasswordValidationCallbackSupport();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean verifyCPCCallback() {
        boolean bval = this.CallerPrincipalCallbackSupport();
        this.logMsg("verifyCPCCallback returning " + Boolean.toString(bval));
        return bval;
    }

    public boolean verifyGPCCallback() {
        boolean bval = this.GroupPrincipalCallbackSupport();
        this.logMsg("verifyGPCCallback returning " + Boolean.toString(bval));
        return bval;
    }

    public boolean verifyPVCCallback() {
        boolean bval = this.PasswordValidationCallbackSupport();
        this.logMsg("verifyPVCCallback returning " + Boolean.toString(bval));
        return bval;
    }

    private boolean CallerPrincipalCallbackSupport() {
        boolean bval = false;
        HttpServletRequest request = null;
        try {
            request = (HttpServletRequest)messageInfo.getRequestMessage();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (callbackHandler != null) {
            try {
                CallerPrincipalCallback callerPrincipalCallback = null;
                if (profile.equals("HttpServlet")) {
                    Principal principal = null;
                    if (messageInfo != null) {
                        HttpServletRequest req = (HttpServletRequest)messageInfo.getRequestMessage();
                        String username = this.getServletUsername(req);
                        String principalName = this.getPrincipalNameFromSubject(clientSubject);
                        String nameToLog = null;
                        boolean bIsMandatory = this.isServletAuthMandatory(messageInfo);
                        if (bIsMandatory) {
                            this.logMsg("CallerPrincipalCallbackSupport() Authentication mandatory");
                            if (username != null) {
                                this.logMsg("CallerPrincipalCallbackSupport() auth mandatory, username != null");
                                callerPrincipalCallback = new CallerPrincipalCallback(clientSubject, username);
                                nameToLog = username;
                            } else if (principalName != null) {
                                this.logMsg("CallerPrincipalCallbackSupport() auth mandatory, principalName != null");
                                callerPrincipalCallback = new CallerPrincipalCallback(clientSubject, principalName);
                                nameToLog = principalName;
                            } else {
                                this.logMsg("CallerPrincipalCallbackSupport() auth mandatory, username and principalName both == null");
                            }
                        } else {
                            this.logMsg("CallerPrincipalCallbackSupport() Authentication NOT mandatory");
                            callerPrincipalCallback = new CallerPrincipalCallback(clientSubject, (Principal)null);
                        }
                        String cpcbkName = callerPrincipalCallback.getName();
                        Principal cpcbkPrin = callerPrincipalCallback.getPrincipal();
                        Subject cpcbkSubj = callerPrincipalCallback.getSubject();
                        String msg = "CallerPrincipalCallback called for profile=" + profile;
                        if (request != null) {
                            String servletPath = request.getContextPath() + request.getServletPath();
                            msg = msg + " for servletPath=" + servletPath;
                        } else {
                            msg = msg + " messageInfo contained null request";
                        }
                        this.logMsg(msg);
                        msg = clientSubject == null ? msg + " subject=null" : msg + " subject=non-null";
                        msg = msg + " principal set = " + nameToLog;
                        this.logMsg(msg);
                    } else {
                        callerPrincipalCallback = new CallerPrincipalCallback(clientSubject, principal);
                    }
                } else {
                    this.logMsg("WARNING:  ServerCallbackSupport.CallerPrincipalCallbackSupport() - profile != servlet.");
                    Subject subject = new Subject();
                    callerPrincipalCallback = new CallerPrincipalCallback(subject, (Principal)null);
                }
                Callback[] callbacks = new Callback[]{callerPrincipalCallback};
                callbackHandler.handle(callbacks);
                this.logMsg("CallbackHandler supports CallerPrincipalCallback");
                bval = true;
            }
            catch (UnsupportedCallbackException usce) {
                this.logMsg("CallbackHandler failed to support CallerPrincipalCallback :" + usce.getMessage());
                usce.printStackTrace();
            }
            catch (Exception ex) {
                String servletPath = "";
                servletPath = request != null ? request.getContextPath() + request.getServletPath() : "WARNING:  can't determine servletpath";
                this.logMsg("CPC Exception failure for servletPath=" + servletPath);
                ex.printStackTrace();
            }
        } else {
            String msg = "CallerPrincipalCallback has a null callbackHandler";
            msg = msg + "  profile=" + profile;
            if (profile.equals("HttpServlet") && messageInfo != null) {
                if (request != null) {
                    String servletPath = request.getContextPath() + request.getServletPath();
                    msg = msg + " for servletPath=" + servletPath;
                } else {
                    msg = msg + " messageInfo contained null request";
                }
                this.logMsg(msg);
                msg = clientSubject == null ? msg + " subject=null" : msg + " subject=non-null";
                String principalConcatString = this.getPrincipalNameFromSubject(clientSubject);
                msg = msg + " principal set = " + principalConcatString;
            }
            this.logMsg(msg);
        }
        return bval;
    }

    private String getServletUsername(HttpServletRequest req) {
        String username = null;
        String authorization = req.getHeader("authorization");
        BASE64Decoder decoder = new BASE64Decoder();
        if (authorization != null && authorization.startsWith("Basic ")) {
            try {
                String authStr = authorization.substring(6).trim();
                String value = new String(decoder.decodeBuffer(authStr));
                this.logMsg("decoded (request) authorization string of: " + value);
                if (value != null) {
                    username = value.substring(0, value.indexOf(":"));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return username;
    }

    private String getServletContext(MessageInfo mInfo, String profile) {
        HttpServletRequest req;
        String sContext = "";
        if (profile.equals("HttpServlet") && mInfo != null && (req = (HttpServletRequest)mInfo.getRequestMessage()) != null) {
            sContext = req.getContextPath() + req.getServletPath();
        }
        logger.log(Level.INFO, "getServletContext() returning " + sContext);
        return sContext;
    }

    private boolean isServletAuthMandatory(MessageInfo msgInfo) {
        boolean bval = false;
        Map map = msgInfo.getMap();
        HttpServletRequest request = (HttpServletRequest)msgInfo.getRequestMessage();
        String servletName = request.getServletPath();
        String strKey = "jakarta.security.auth.message.MessagePolicy.isMandatory";
        if (map != null) {
            String keyVal = (String)map.get(strKey);
            String msg = "isServletAuthMandatory() called with attrs: ";
            msg = msg + " layer=HttpServlet";
            msg = msg + " servletName=" + servletName;
            msg = msg + " key=" + strKey;
            if (keyVal == null) {
                msg = msg + " value=NULL";
                bval = false;
            } else if (Boolean.valueOf(keyVal).booleanValue()) {
                msg = msg + " value=Valid";
                bval = true;
            } else {
                msg = msg + " value=false";
                bval = false;
            }
            logger.log(Level.FINE, msg);
        } else {
            String msg = "FAILURE:  No map in MessageInfo thus no key=" + strKey;
            logger.log(Level.SEVERE, msg);
        }
        return bval;
    }

    public String getPrincipalNameFromSubject(Subject sub) {
        Principal principal2 = null;
        if (sub == null) {
            return null;
        }
        String concatPrincipalName = "";
        Set<Principal> principalSet = sub.getPrincipals();
        for (Principal principal2 : principalSet) {
            concatPrincipalName = concatPrincipalName + principal2.getName();
        }
        return concatPrincipalName;
    }

    private boolean GroupPrincipalCallbackSupport() {
        boolean bval = false;
        boolean isAuthMandatory = false;
        String strServletContext = "";
        String principalName = "";
        if (callbackHandler != null) {
            try {
                Subject subject = new Subject();
                String[] strArray = new String[]{"Administrator"};
                GroupPrincipalCallback groupPrincipalCallback = new GroupPrincipalCallback(subject, strArray);
                CallerPrincipalCallback callerPrincipalCallback = null;
                if (profile.equals("HttpServlet")) {
                    if (messageInfo != null) {
                        HttpServletRequest req = (HttpServletRequest)messageInfo.getRequestMessage();
                        String username = this.getServletUsername(req);
                        principalName = this.getPrincipalNameFromSubject(clientSubject);
                        strServletContext = req.getServletPath();
                        boolean bIsMandatory = this.isServletAuthMandatory(messageInfo);
                        if (bIsMandatory) {
                            isAuthMandatory = true;
                            this.debug("GroupPrincipalCallbackSupport() Authentication mandatory");
                            if (username != null) {
                                this.debug("GroupPrincipalCallbackSupport() auth mandatory, username != null");
                                callerPrincipalCallback = new CallerPrincipalCallback(clientSubject, username);
                            } else if (principalName != null) {
                                this.debug("GroupPrincipalCallbackSupport() auth mandatory, principalName != null");
                                callerPrincipalCallback = new CallerPrincipalCallback(clientSubject, principalName);
                            } else {
                                this.logMsg("GroupPrincipalCallbackSupport() auth mandatory, username and principalName both == null");
                            }
                        } else {
                            this.debug("GroupPrincipalCallbackSupport() Authentication NOT mandatory");
                            callerPrincipalCallback = new CallerPrincipalCallback(subject, (Principal)null);
                        }
                    } else {
                        this.debug("GroupPrincipalCallbackSupport(): messageInfo == null, using null principal");
                        callerPrincipalCallback = new CallerPrincipalCallback(clientSubject, (Principal)null);
                    }
                } else {
                    this.debug("WARNING:  ServerCallbackSupport.CallerPrincipalCallbackSupport() - profile != servlet.");
                    callerPrincipalCallback = new CallerPrincipalCallback(subject, (Principal)null);
                }
                Callback[] callbacks = new Callback[]{groupPrincipalCallback, callerPrincipalCallback};
                callbackHandler.handle(callbacks);
                String theMessage = "GroupPrincipalCallbackSupport():";
                theMessage = theMessage + " successfully called callbackHandler.handle(callbacks)";
                theMessage = theMessage + " for servlet: " + strServletContext;
                theMessage = theMessage + " with isServletAuthMandatory = " + isAuthMandatory;
                this.logMsg(theMessage);
                this.logMsg("CallbackHandler supports GroupPrincipalCallback");
                bval = true;
            }
            catch (UnsupportedCallbackException usce) {
                this.logMsg("CallbackHandler failed to support GroupPrincipalCallback :" + usce.getMessage());
                usce.printStackTrace();
            }
            catch (IOException ioe) {
                this.logMsg("CallbackHandler failed to support GroupPrincipalCallback :" + ioe.getMessage());
                ioe.printStackTrace();
            }
        }
        return bval;
    }

    private boolean PasswordValidationCallbackSupport() {
        boolean bval = false;
        if (callbackHandler != null) {
            try {
                Subject subject = new Subject();
                String username = user;
                char[] password = passwd.toCharArray();
                PasswordValidationCallback passwordValidationCallback = new PasswordValidationCallback(subject, username, password);
                CallerPrincipalCallback cpc = new CallerPrincipalCallback(subject, (Principal)null);
                Callback[] callbacks = new Callback[]{passwordValidationCallback, cpc};
                callbackHandler.handle(callbacks);
                Subject returnedSubject = passwordValidationCallback.getSubject();
                boolean result = passwordValidationCallback.getResult();
                String userName = passwordValidationCallback.getUsername();
                char[] returnedPassword = passwordValidationCallback.getPassword();
                passwordValidationCallback.clearPassword();
                this.logMsg("PasswordValidation callback returned result =" + result);
                this.logMsg("CallbackHandler supports PasswordValidationCallback");
                bval = result;
            }
            catch (UnsupportedCallbackException usce) {
                this.logMsg("CallbackHandler failed to support PasswordValidationCallback :" + usce.getMessage());
                usce.printStackTrace();
            }
            catch (IOException ioe) {
                this.logMsg("CallbackHandler failed to support PasswordValidationCallback :" + ioe.getMessage());
                ioe.printStackTrace();
            }
        }
        return bval;
    }

    public void logMsg(String str) {
        if (logger != null) {
            logger.log(Level.INFO, "In " + profile + " : " + runtimeType + " " + str);
        } else {
            System.out.println("*** TSLogger Not Initialized properly ***");
            System.out.println("*** TSSVLogMessage : ***" + str);
        }
    }

    public void debug(String str) {
        System.out.println(str);
    }
}

