/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb.ee.sec.bmp.secpropagation;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.porting.TSLoginContext;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.tests.ejb.ee.sec.bmp.common.Test;
import com.sun.ts.tests.ejb.ee.sec.bmp.common.TestHome;
import java.util.Properties;

public class Client
extends EETest {
    private static final String ejbname = "java:comp/env/ejb/Test";
    private TestHome ejbhome = null;
    private Test ejbref = null;
    private static final String emp_secrole_ref = "EMP";
    private static final String admin_secrole_ref = "ADMIN";
    private static final String mgr_secrole_ref = "MGR";
    private static final String UserNameProp = "user";
    private static final String UserPasswordProp = "password";
    private String username = "";
    private String password = "";
    private boolean newTable = true;
    private Properties props = null;
    private TSNamingContext nctx = null;
    private TSLoginContext lc = null;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.props = p;
        try {
            this.username = this.props.getProperty(UserNameProp);
            this.password = this.props.getProperty(UserPasswordProp);
            this.nctx = new TSNamingContext();
            this.lc = new TSLoginContext();
            this.lc.login(this.username, this.password);
            this.ejbhome = (TestHome)this.nctx.lookup(ejbname, TestHome.class);
        }
        catch (Exception e) {
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    public void test1() throws EETest.Fault {
        this.logMsg("Starting Caller authorization test");
        try {
            this.ejbref = this.ejbhome.create(this.props, this.newTable, 1, "coffee-1", 1.0f);
            if (!this.ejbref.EjbIsAuthz(this.props)) {
                throw new EETest.Fault("Caller authorization test failed");
            }
            this.logMsg("Caller authorization test passed");
        }
        catch (Exception e) {
            throw new EETest.Fault("Caller authorization test failed: ", e);
        }
    }

    public void test3() throws EETest.Fault {
        this.logMsg("Starting Security role reference positive test");
        try {
            this.ejbref = this.ejbhome.create(this.props, this.newTable, 1, "coffee-1", 1.0f);
            if (!this.ejbref.EjbSecRoleRef(emp_secrole_ref, this.props)) {
                throw new EETest.Fault("Security role reference positive test failed");
            }
            this.logMsg("Security role reference positive test passed");
        }
        catch (Exception e) {
            throw new EETest.Fault("Security role reference positive test failed: ", e);
        }
    }

    public void test4() throws EETest.Fault {
        this.logMsg("Starting Security role reference negative test");
        try {
            this.ejbref = this.ejbhome.create(this.props, this.newTable, 1, "coffee-1", 1.0f);
            if (!this.ejbref.EjbSecRoleRef1(mgr_secrole_ref, this.props)) {
                throw new EETest.Fault("Security role reference negative test failed");
            }
            this.logMsg("Security role reference negative test passed");
        }
        catch (Exception e) {
            throw new EETest.Fault("Security role reference negative test failed: ", e);
        }
    }

    public void test5() throws EETest.Fault {
        this.logMsg("Starting Security role reference scope test");
        try {
            this.ejbref = this.ejbhome.create(this.props, this.newTable, 1, "coffee-1", 1.0f);
            if (!this.ejbref.EjbSecRoleRefScope(emp_secrole_ref, this.props)) {
                throw new EETest.Fault("Security role reference scope test failed");
            }
            this.logMsg("Security role reference scope test passed");
        }
        catch (Exception e) {
            throw new EETest.Fault("Security role reference scope test failed: ", e);
        }
    }

    public void test2() throws EETest.Fault {
        this.logMsg("Starting Overloaded security role references test");
        try {
            this.ejbref = this.ejbhome.create(this.props, this.newTable, 1, "coffee-1", 1.0f);
            if (!this.ejbref.EjbOverloadedSecRoleRefs(emp_secrole_ref, mgr_secrole_ref, this.props)) {
                throw new EETest.Fault("Overloaded security role references test failed");
            }
            this.logMsg("Overloaded security role references test passed");
        }
        catch (Exception e) {
            throw new EETest.Fault("Overloaded security role references test failed", e);
        }
    }

    public void test6() throws EETest.Fault {
        this.logMsg("Starting No caller authorization test");
        try {
            this.ejbref = this.ejbhome.create(this.props, this.newTable, 1, "coffee-1", 1.0f);
            if (!this.ejbref.EjbNotAuthz(this.props)) {
                throw new EETest.Fault("No caller authorization test failed");
            }
            this.logMsg("No authorization test passed");
        }
        catch (Exception e) {
            throw new EETest.Fault("No caller authorization test failed:", e);
        }
    }

    public void test7() throws EETest.Fault {
        this.logMsg("Starting unchecked test1");
        try {
            this.ejbref = this.ejbhome.create(this.props, this.newTable, 1, "coffee-1", 1.0f);
            if (!this.ejbref.checktest1(this.props)) {
                this.logErr("unchecked test returned false");
                throw new EETest.Fault("unchecked test1 failed");
            }
            this.logMsg("unchecked test1 passed.");
        }
        catch (Exception e) {
            throw new EETest.Fault("unchecked test1 failed", e);
        }
    }

    public void test8() throws EETest.Fault {
        this.logMsg("Starting exclude-list test1");
        try {
            this.ejbref = this.ejbhome.create(this.props, this.newTable, 1, "coffee-1", 1.0f);
            if (!this.ejbref.excludetest1(this.props)) {
                this.logErr("excludetest1 returned false");
                throw new EETest.Fault("exclude test failed");
            }
            this.logMsg("exclude-list test1 passed");
        }
        catch (Exception e) {
            throw new EETest.Fault("exclude-list test1 failed:", e);
        }
    }

    public void cleanup() throws EETest.Fault {
        try {
            if (this.ejbref != null) {
                this.ejbref.remove();
            }
        }
        catch (Exception e) {
            this.logErr("Cleanup failed: ", e);
        }
        this.logMsg("cleanup ok");
    }
}

