/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.core20.appclient.jmscontextqueuetests;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.common.JmsTool;
import com.sun.ts.tests.jms.core20.appclient.jmscontextqueuetests.MyCompletionListener;
import com.sun.ts.tests.jms.core20.appclient.jmscontextqueuetests.MyCompletionListener2;
import com.sun.ts.tests.jms.core20.appclient.jmscontextqueuetests.MyExceptionListener;
import com.sun.ts.tests.jms.core20.appclient.jmscontextqueuetests.MyMessageListener;
import com.sun.ts.tests.jms.core20.appclient.jmscontextqueuetests.MyMessageListener2;
import jakarta.jms.BytesMessage;
import jakarta.jms.CompletionListener;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.ExceptionListener;
import jakarta.jms.IllegalStateRuntimeException;
import jakarta.jms.InvalidClientIDRuntimeException;
import jakarta.jms.InvalidDestinationRuntimeException;
import jakarta.jms.JMSConsumer;
import jakarta.jms.JMSContext;
import jakarta.jms.JMSProducer;
import jakarta.jms.JMSRuntimeException;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.MessageFormatRuntimeException;
import jakarta.jms.MessageListener;
import jakarta.jms.ObjectMessage;
import jakarta.jms.Queue;
import jakarta.jms.StreamMessage;
import jakarta.jms.TextMessage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;

public class Client
extends ServiceEETest {
    private static final String testName = "com.sun.ts.tests.jms.core20.appclient.jmscontextqueuetests.Client";
    private static final String testDir = System.getProperty("user.dir");
    private static final long serialVersionUID = 1L;
    private transient JmsTool tool = null;
    private transient ConnectionFactory cf = null;
    private transient Queue queue = null;
    private transient Destination destination = null;
    private transient JMSContext context = null;
    private transient JMSContext context2 = null;
    private transient JMSContext contextToSendMsg = null;
    private transient JMSContext contextToCreateMsg = null;
    private transient JMSConsumer consumer = null;
    private transient JMSProducer producer = null;
    private Properties props = null;
    long timeout;
    String user;
    String password;
    String mode;
    private static final int numMessages = 3;
    private static final int iterations = 5;
    ArrayList queues = null;
    ArrayList connections = null;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    private String printSessionMode(int sessionMode) {
        switch (sessionMode) {
            case 0: {
                return "SESSION_TRANSACTED";
            }
            case 1: {
                return "AUTO_ACKNOWLEDGE";
            }
            case 2: {
                return "CLIENT_ACKNOWLEDGE";
            }
            case 3: {
                return "DUPS_OK_ACKNOWLEDGE";
            }
        }
        return "UNEXPECTED_SESSIONMODE";
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        try {
            this.timeout = Long.parseLong(p.getProperty("jms_timeout"));
            this.user = p.getProperty("user");
            this.password = p.getProperty("password");
            this.mode = p.getProperty("platform.mode");
            if (this.timeout < 1L) {
                throw new Exception("'jms_timeout' (milliseconds) in ts.jte must be > 0");
            }
            if (this.user == null) {
                throw new Exception("'user' in ts.jte must not be null ");
            }
            if (this.password == null) {
                throw new Exception("'password' in ts.jte must not be null ");
            }
            if (this.mode == null) {
                throw new Exception("'platform.mode' in ts.jte must not be null");
            }
            this.queues = new ArrayList(3);
            this.connections = new ArrayList(5);
            TestUtil.logMsg((String)"Setup JmsTool for COMMON_Q setup");
            this.tool = new JmsTool(13, this.user, this.password, this.mode);
            this.cf = this.tool.getConnectionFactory();
            this.destination = this.tool.getDefaultDestination();
            this.queue = (Queue)this.destination;
            this.tool.getDefaultConnection().close();
            TestUtil.logMsg((String)"Create JMSContext with AUTO_ACKNOWLEDGE");
            this.context = this.cf.createContext(this.user, this.password, 1);
            this.contextToSendMsg = this.cf.createContext(this.user, this.password, 1);
            this.contextToCreateMsg = this.cf.createContext(this.user, this.password, 1);
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e));
            throw new EETest.Fault("setup failed!", e);
        }
    }

    public void cleanup() throws EETest.Fault {
        try {
            TestUtil.logMsg((String)"Close JMSContext objects");
            if (this.context != null) {
                this.context.close();
                this.context = null;
            }
            if (this.contextToSendMsg != null) {
                this.contextToSendMsg.close();
                this.contextToSendMsg = null;
            }
            if (this.contextToCreateMsg != null) {
                this.contextToCreateMsg.close();
                this.contextToCreateMsg = null;
            }
            TestUtil.logMsg((String)"Close JMSConsumer objects");
            if (this.consumer != null) {
                this.consumer.close();
                this.consumer = null;
            }
            TestUtil.logMsg((String)"Flush any messages left on Queue");
            this.tool.flushDestination();
            this.tool.closeAllResources();
            this.producer = null;
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e));
            throw new EETest.Fault("cleanup failed!", e);
        }
    }

    public void setGetClientIDTest() throws EETest.Fault {
        boolean pass = true;
        try {
            String clientid = "myclientid";
            TestUtil.logMsg((String)("Calling setClientID(" + clientid + ")"));
            this.context.setClientID(clientid);
            TestUtil.logMsg((String)("Calling getClientID and expect " + clientid + " to be returned"));
            String cid = this.context.getClientID();
            if (!cid.equals(clientid)) {
                TestUtil.logErr((String)("getClientID() returned " + cid + ", expected " + clientid));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e));
            throw new EETest.Fault("setGetClientIDTest");
        }
        if (!pass) {
            throw new EETest.Fault("setGetClientIDTest failed");
        }
    }

    public void setClientIDLateTest() throws EETest.Fault {
        boolean pass = true;
        try {
            String message = "This is my message.";
            TestUtil.logMsg((String)"Creating JMSConsumer");
            this.consumer = this.context.createConsumer(this.destination);
            TestUtil.logMsg((String)"Creating JMSProducer");
            this.producer = this.context.createProducer();
            TestUtil.logMsg((String)"Creating TextMessage");
            TextMessage expTextMessage = this.context.createTextMessage(message);
            TestUtil.logMsg((String)"Set some values in TextMessage");
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "setClientIDLateTest");
            TestUtil.logMsg((String)"Sending TestMessage");
            this.producer.send(this.destination, (Message)expTextMessage);
            TestUtil.logMsg((String)"Receive TextMessage");
            TextMessage actTextMessage = (TextMessage)this.consumer.receive(this.timeout);
            if (actTextMessage != null) {
                TestUtil.logMsg((String)("actTextMessage=" + actTextMessage.getText()));
            }
            TestUtil.logTrace((String)"Attempt to set Client ID too late (expect IllegalStateRuntimeException)");
            try {
                this.context.setClientID("setClientIDLateTest");
                pass = false;
                TestUtil.logErr((String)"IllegalStateRuntimeException was not thrown");
            }
            catch (IllegalStateRuntimeException is) {
                TestUtil.logMsg((String)"IllegalStateRuntimeException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught unexpected exception: " + e));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("setClientIDLateTest", e);
        }
        if (!pass) {
            throw new EETest.Fault("setClientIDLateTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGetChangeClientIDTest() throws EETest.Fault {
        boolean pass = true;
        String lookup = "MyTopicConnectionFactory";
        try {
            TestUtil.logMsg((String)"Create second JMSContext with AUTO_ACKNOWLEDGE");
            this.context2 = this.cf.createContext(this.user, this.password, 1);
            TestUtil.logMsg((String)"Setting clientID!");
            this.context.setClientID("ctstest");
            TestUtil.logMsg((String)"Getting clientID!");
            String clientid = this.context.getClientID();
            if (!clientid.equals("ctstest")) {
                TestUtil.logErr((String)("getClientID() returned " + clientid + ", expected ctstest"));
                pass = false;
            } else {
                TestUtil.logMsg((String)"setClientID/getClientID correct");
            }
            TestUtil.logMsg((String)"Resetting clientID! (expect IllegalStateRuntimeException)");
            this.context.setClientID("changeIt");
            TestUtil.logErr((String)"No exception was thrown on ClientID reset");
            pass = false;
        }
        catch (IllegalStateRuntimeException e) {
            TestUtil.logMsg((String)"IllegalStateRuntimeException thrown as expected");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Incorrect exception received: " + e));
            pass = false;
        }
        try {
            TestUtil.logMsg((String)"Set clientID on second context to value of clientID on first context (expect InvalidClientIDRuntimeException)");
            this.context2.setClientID("ctstest");
            TestUtil.logErr((String)"No exception was thrown on ClientID that already exists");
            pass = false;
        }
        catch (InvalidClientIDRuntimeException e) {
            TestUtil.logMsg((String)"InvalidClientIDRuntimeException thrown as expected");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Incorrect exception received: " + e));
            pass = false;
        }
        finally {
            try {
                if (this.context2 != null) {
                    this.context2.close();
                    this.context2 = null;
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught exception in finally block: " + e));
                throw new EETest.Fault("setGetChangeClientIDTest", e);
            }
        }
        if (!pass) {
            throw new EETest.Fault("setGetChangeClientIDTest");
        }
    }

    public void setGetExceptionListenerTest() throws EETest.Fault {
        boolean pass = true;
        try {
            MyExceptionListener expExceptionListener = new MyExceptionListener();
            TestUtil.logMsg((String)("Calling setExceptionListener(" + expExceptionListener + ")"));
            this.context.setExceptionListener((ExceptionListener)expExceptionListener);
            TestUtil.logMsg((String)("Calling getExceptionListener and expect " + expExceptionListener + " to be returned"));
            MyExceptionListener actExceptionListener = (MyExceptionListener)this.context.getExceptionListener();
            if (!actExceptionListener.equals(expExceptionListener)) {
                TestUtil.logErr((String)("getExceptionListener() returned " + actExceptionListener + ", expected " + expExceptionListener));
                pass = false;
            }
            TestUtil.logMsg((String)"Calling setExceptionListener(null)");
            this.context.setExceptionListener(null);
            if (this.context.getExceptionListener() != null) {
                TestUtil.logErr((String)("getExceptionListener() returned " + this.context.getExceptionListener() + ", expected null"));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("setGetExceptionListenerTest");
        }
        if (!pass) {
            throw new EETest.Fault("setGetExceptionListenerTest failed");
        }
    }

    public void setGetAsyncTest() throws EETest.Fault {
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"Creating JMSProducer");
            this.producer = this.context.createProducer();
            MyCompletionListener expCompletionListener = new MyCompletionListener();
            TestUtil.logMsg((String)("Calling JMSProducer.setAsync(" + expCompletionListener + ")"));
            this.producer.setAsync((CompletionListener)expCompletionListener);
            TestUtil.logMsg((String)("Calling JMSProducer.getAsync() and expect " + expCompletionListener + " to be returned"));
            MyCompletionListener actCompletionListener = (MyCompletionListener)this.producer.getAsync();
            if (!actCompletionListener.equals(expCompletionListener)) {
                TestUtil.logErr((String)("getAsync() returned " + actCompletionListener + ", expected " + expCompletionListener));
                pass = false;
            }
            TestUtil.logMsg((String)"Calling JMSProducer.setAsync(null)");
            this.producer.setAsync(null);
            TestUtil.logMsg((String)"Calling JMSProducer.getAsync() and expect NULL to be returned");
            if (this.producer.getAsync() != null) {
                TestUtil.logErr((String)("getAsync() returned " + this.producer.getAsync() + ", expected null"));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("setGetAsyncTest");
        }
        if (!pass) {
            throw new EETest.Fault("setGetAsyncTest failed");
        }
    }

    public void startStopTest() throws EETest.Fault {
        boolean pass = true;
        try {
            TextMessage tempMsg = null;
            TestUtil.logMsg((String)"Create JMSConsumer");
            this.consumer = this.context.createConsumer(this.destination);
            TestUtil.logMsg((String)"Call stop() to stop delivery of incoming messages");
            this.context.stop();
            TestUtil.logMsg((String)"Creating JMSProducer");
            this.producer = this.context.createProducer();
            TestUtil.logMsg((String)"Send 3 messages to Queue");
            for (int i = 1; i <= 3; ++i) {
                tempMsg = this.context.createTextMessage("Message " + i);
                tempMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "startStopTest" + i);
                this.producer.send(this.destination, (Message)tempMsg);
                TestUtil.logMsg((String)("Message " + i + " sent"));
            }
            TestUtil.logMsg((String)"Try consuming a message on a STOPPED connection");
            tempMsg = (TextMessage)this.consumer.receive(this.timeout);
            if (tempMsg != null) {
                TestUtil.logErr((String)"Received a message on a STOPPED connection");
                TestUtil.logErr((String)("Message is: " + tempMsg.getText()));
                pass = false;
            }
            TestUtil.logMsg((String)"Call start() to start delivery of incoming messages");
            this.context.start();
            TestUtil.logMsg((String)"Consume all the messages in the Queue on a STARTED connection");
            for (int msgCount = 1; msgCount <= 3; ++msgCount) {
                tempMsg = (TextMessage)this.consumer.receive(this.timeout);
                if (tempMsg == null) {
                    TestUtil.logErr((String)"JMSConsumer.receive() returned NULL");
                    TestUtil.logErr((String)("Message " + msgCount + " missing from Queue"));
                    pass = false;
                    continue;
                }
                if (!tempMsg.getText().equals("Message " + msgCount)) {
                    TestUtil.logErr((String)("Received [" + tempMsg.getText() + "] expected [Message " + msgCount + "]"));
                    pass = false;
                    continue;
                }
                TestUtil.logMsg((String)("Received message: " + tempMsg.getText()));
            }
            TestUtil.logMsg((String)"Queue should now be empty");
            TestUtil.logMsg((String)"Try consuming one more message should return NULL");
            tempMsg = (TextMessage)this.consumer.receive(this.timeout);
            if (tempMsg != null) {
                TestUtil.logErr((String)"JMSConsumer.receive() did not return NULL");
                TestUtil.logErr((String)"JMSConsumer.receive() returned a message (unexpected)");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("startStopTest");
        }
        if (!pass) {
            throw new EETest.Fault("startStopTest failed");
        }
    }

    public void createContextTest() throws EETest.Fault {
        boolean pass = true;
        try {
            JMSContext newContext = null;
            int[] expSessionMode = new int[]{0, 1, 2, 3};
            for (int i = 0; i < expSessionMode.length; ++i) {
                TestUtil.logMsg((String)("Creating context with session mode (" + this.printSessionMode(expSessionMode[i]) + ")"));
                TestUtil.logMsg((String)"Call API QueueConnectionFactory.createContext(int)");
                newContext = this.context.createContext(expSessionMode[i]);
                TestUtil.logMsg((String)"Now call API JMSContext.getSessionMode()");
                TestUtil.logMsg((String)("Calling getSessionMode and expect " + this.printSessionMode(expSessionMode[i]) + " to be returned"));
                int actSessionMode = newContext.getSessionMode();
                if (actSessionMode != expSessionMode[i]) {
                    TestUtil.logErr((String)("getSessionMode() returned " + this.printSessionMode(actSessionMode) + ", expected " + this.printSessionMode(expSessionMode[i])));
                    pass = false;
                }
                newContext.close();
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("createContextTest");
        }
        if (!pass) {
            throw new EETest.Fault("createContextTest failed");
        }
    }

    public void sendAndRecvCLTest1() throws EETest.Fault {
        boolean pass = true;
        String message = "Where are you!";
        boolean bool = true;
        byte bValue = 127;
        short nShort = 10;
        int nInt = 5;
        long nLong = 333L;
        float nFloat = 1.0f;
        double nDouble = 100.0;
        String testString = "test";
        try {
            TestUtil.logMsg((String)"Creating TextMessage");
            TextMessage expTextMessage = this.context.createTextMessage(message);
            TestUtil.logMsg((String)"Set some values in TextMessage");
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "sendAndRecvCLTest1");
            MyCompletionListener listener = new MyCompletionListener();
            TestUtil.logMsg((String)"Creating JMSProducer");
            this.producer = this.context.createProducer();
            TestUtil.logMsg((String)"Set primitive property types on JMSProducer");
            this.producer.setProperty("TESTBOOLEAN", bool);
            this.producer.setProperty("TESTBYTE", bValue);
            this.producer.setProperty("TESTDOUBLE", nDouble);
            this.producer.setProperty("TESTFLOAT", nFloat);
            this.producer.setProperty("TESTINT", nInt);
            this.producer.setProperty("TESTLONG", nLong);
            this.producer.setProperty("TESTSHORT", nShort);
            this.producer.setProperty("TESTSTRING", "test");
            TestUtil.logMsg((String)"Set Object property types on JMSProducer");
            this.producer.setProperty("OBJTESTBOOLEAN", (Object)bool);
            this.producer.setProperty("OBJTESTBYTE", (Object)bValue);
            this.producer.setProperty("OBJTESTDOUBLE", (Object)nDouble);
            this.producer.setProperty("OBJTESTFLOAT", (Object)Float.valueOf(nFloat));
            this.producer.setProperty("OBJTESTINT", (Object)nInt);
            this.producer.setProperty("OBJTESTLONG", (Object)nLong);
            this.producer.setProperty("OBJTESTSHORT", (Object)nShort);
            this.producer.setProperty("OBJTESTSTRING", "test");
            TestUtil.logMsg((String)"Calling JMSProducer.setAsync(CompletionListener)");
            this.producer.setAsync((CompletionListener)listener);
            TestUtil.logMsg((String)"Calling JMSProducer.send(Destination,Message)");
            this.producer.send(this.destination, (Message)expTextMessage);
            TestUtil.logMsg((String)"Poll listener until we receive TextMessage");
            for (int i = 0; !listener.isComplete() && i < 60; ++i) {
                TestUtil.logMsg((String)("Loop " + i + ": sleep 2 seconds waiting for messages to arrive at listener"));
                TestUtil.sleepSec((int)2);
            }
            TextMessage actTextMessage = null;
            if (listener.isComplete()) {
                actTextMessage = (TextMessage)listener.getMessage();
            }
            if (actTextMessage == null) {
                throw new EETest.Fault("Did not receive TextMessage");
            }
            TestUtil.logMsg((String)"Check the value in TextMessage");
            if (actTextMessage.getText().equals(expTextMessage.getText())) {
                TestUtil.logMsg((String)"TextMessage is correct");
            } else {
                TestUtil.logErr((String)("TextMessage is incorrect expected " + expTextMessage.getText() + ", received " + actTextMessage.getText()));
                pass = false;
            }
            TestUtil.logMsg((String)"Retrieve and verify that TextMessage message properties were set correctly");
            if (actTextMessage.getBooleanProperty("TESTBOOLEAN") == bool) {
                TestUtil.logMsg((String)"Pass: getBooleanProperty returned correct value");
            } else {
                TestUtil.logMsg((String)"Fail: incorrect value returned from getBooleanProperty");
                pass = false;
            }
            if (actTextMessage.getByteProperty("TESTBYTE") == bValue) {
                TestUtil.logMsg((String)"Pass: getByteProperty returned correct value");
            } else {
                TestUtil.logMsg((String)"Fail: incorrect value returned from getByteProperty");
                pass = false;
            }
            if (actTextMessage.getLongProperty("TESTLONG") == nLong) {
                TestUtil.logMsg((String)"Pass: getLongProperty returned correct value");
            } else {
                TestUtil.logMsg((String)"Fail: incorrect value returned from getLongProperty");
                pass = false;
            }
            if (actTextMessage.getStringProperty("TESTSTRING").equals(testString)) {
                TestUtil.logMsg((String)"Pass: getStringProperty returned correct value");
            } else {
                TestUtil.logMsg((String)"Fail: incorrect value returned from getStringProperty");
                pass = false;
            }
            if (actTextMessage.getDoubleProperty("TESTDOUBLE") == nDouble) {
                TestUtil.logMsg((String)"Pass: getDoubleProperty returned correct value");
            } else {
                TestUtil.logMsg((String)"Fail: incorrect value returned from getDoubleProperty");
                pass = false;
            }
            if (actTextMessage.getFloatProperty("TESTFLOAT") == nFloat) {
                TestUtil.logMsg((String)"Pass: getFloatProperty returned correct value");
            } else {
                TestUtil.logMsg((String)"Fail: incorrect value returned from getFloatProperty");
                pass = false;
            }
            if (actTextMessage.getIntProperty("TESTINT") == nInt) {
                TestUtil.logMsg((String)"Pass: getIntProperty returned correct value");
            } else {
                TestUtil.logMsg((String)"Fail: incorrect value returned from getIntProperty");
                pass = false;
            }
            if (actTextMessage.getShortProperty("TESTSHORT") == nShort) {
                TestUtil.logMsg((String)"Pass: getShortProperty returned correct value");
            } else {
                TestUtil.logMsg((String)"Fail: incorrect value returned from getShortProperty");
                pass = false;
            }
            if ((Boolean)actTextMessage.getObjectProperty("OBJTESTBOOLEAN") == bool) {
                TestUtil.logMsg((String)"Pass: getObjectProperty returned correct Boolean value");
            } else {
                TestUtil.logMsg((String)"Fail: incorrect Boolean value returned from getObjectProperty");
                pass = false;
            }
            if ((Byte)actTextMessage.getObjectProperty("OBJTESTBYTE") == bValue) {
                TestUtil.logMsg((String)"Pass: getObjectProperty returned correct Byte value");
            } else {
                TestUtil.logMsg((String)"Fail: incorrect Byte value returned from getObjectProperty");
                pass = false;
            }
            if ((Long)actTextMessage.getObjectProperty("OBJTESTLONG") == nLong) {
                TestUtil.logMsg((String)"Pass: getObjectProperty returned correct Long value");
            } else {
                TestUtil.logMsg((String)"Fail: incorrect Long value returned from getObjectProperty");
                pass = false;
            }
            if (((String)actTextMessage.getObjectProperty("OBJTESTSTRING")).equals(testString)) {
                TestUtil.logMsg((String)"Pass: getObjectProperty returned correct String value");
            } else {
                TestUtil.logMsg((String)"Fail: incorrect String value returned from getObjectProperty");
                pass = false;
            }
            if ((Double)actTextMessage.getObjectProperty("OBJTESTDOUBLE") == nDouble) {
                TestUtil.logMsg((String)"Pass: getObjectProperty returned correct Double value");
            } else {
                TestUtil.logMsg((String)"Fail: incorrect Double value returned from getObjectProperty");
                pass = false;
            }
            if (((Float)actTextMessage.getObjectProperty("OBJTESTFLOAT")).floatValue() == nFloat) {
                TestUtil.logMsg((String)"Pass: getObjectProperty returned correct Float value");
            } else {
                TestUtil.logMsg((String)"Fail: incorrect Float value returned from getObjectProperty");
                pass = false;
            }
            if ((Integer)actTextMessage.getObjectProperty("OBJTESTINT") == nInt) {
                TestUtil.logMsg((String)"Pass: getObjectProperty returned correct Integer value");
            } else {
                TestUtil.logMsg((String)"Fail: incorrect Integer value returned from getObjectProperty");
                pass = false;
            }
            if ((Short)actTextMessage.getObjectProperty("OBJTESTSHORT") == nShort) {
                TestUtil.logMsg((String)"Pass: getObjectProperty returned correct Short value");
            } else {
                TestUtil.logMsg((String)"Fail: incorrect Short value returned from getObjectProperty");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("sendAndRecvCLTest1", e);
        }
        if (!pass) {
            throw new EETest.Fault("sendAndRecvCLTest1 failed");
        }
    }

    public void sendAndRecvCLTest2() throws EETest.Fault {
        boolean pass = true;
        String message = "Where are you!";
        try {
            TestUtil.logMsg((String)"Creating TextMessage");
            TextMessage expTextMessage = this.context.createTextMessage(message);
            TestUtil.logMsg((String)"Set some values in TextMessage");
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "sendAndRecvCLTest2");
            MyCompletionListener listener = new MyCompletionListener();
            TestUtil.logMsg((String)"Creating JMSProducer");
            this.producer = this.context.createProducer();
            TestUtil.logMsg((String)"Calling JMSProducer.setAsync(CompletionListener)");
            this.producer.setAsync((CompletionListener)listener);
            TestUtil.logMsg((String)"Set delivery mode, priority, and time to live");
            this.producer.setDeliveryMode(2);
            this.producer.setPriority(4);
            this.producer.setTimeToLive(0L);
            TestUtil.logMsg((String)"Calling JMSProducer.send(Destination,Message)");
            this.producer.send(this.destination, (Message)expTextMessage);
            TestUtil.logMsg((String)"Poll listener until we receive TextMessage");
            for (int i = 0; !listener.isComplete() && i < 60; ++i) {
                TestUtil.logMsg((String)("Loop " + i + ": sleep 2 seconds waiting for messages to arrive at listener"));
                TestUtil.sleepSec((int)2);
            }
            TextMessage actTextMessage = null;
            if (listener.isComplete()) {
                actTextMessage = (TextMessage)listener.getMessage();
            }
            if (actTextMessage == null) {
                throw new EETest.Fault("Did not receive TextMessage");
            }
            TestUtil.logMsg((String)"Check the values in TextMessage, deliverymode, priority, time to live");
            if (!actTextMessage.getText().equals(expTextMessage.getText()) || actTextMessage.getJMSDeliveryMode() != 2 || actTextMessage.getJMSPriority() != 4 || actTextMessage.getJMSExpiration() != 0L) {
                TestUtil.logErr((String)"Didn't get the right message.");
                TestUtil.logErr((String)("text=" + actTextMessage.getText() + ", expected " + expTextMessage.getText()));
                TestUtil.logErr((String)("DeliveryMode=" + actTextMessage.getJMSDeliveryMode() + ", expected " + expTextMessage.getJMSDeliveryMode()));
                TestUtil.logErr((String)("Priority=" + actTextMessage.getJMSPriority() + ", expected " + expTextMessage.getJMSPriority()));
                TestUtil.logErr((String)("TimeToLive=" + actTextMessage.getJMSExpiration() + ", expected " + expTextMessage.getJMSExpiration()));
                pass = false;
            } else {
                TestUtil.logMsg((String)"TextMessage is correct");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("sendAndRecvCLTest2", e);
        }
        if (!pass) {
            throw new EETest.Fault("sendAndRecvCLTest2 failed");
        }
    }

    public void sendAndRecvMsgOfEachTypeCLTest() throws EETest.Fault {
        boolean pass = true;
        String message = "Where are you!";
        try {
            TestUtil.logMsg((String)"Send and receive Message");
            Message msg = this.context.createMessage();
            TestUtil.logMsg((String)"Set some values in Message");
            msg.setStringProperty("COM_SUN_JMS_TESTNAME", "sendAndRecvMsgOfEachTypeCLTest");
            msg.setBooleanProperty("booleanProperty", true);
            MyCompletionListener2 listener = new MyCompletionListener2();
            this.producer = this.context.createProducer();
            this.producer.setAsync((CompletionListener)listener);
            this.producer.send(this.destination, msg);
            TestUtil.logMsg((String)"Poll listener until we receive Message");
            for (int i = 0; !listener.isComplete() && i < 15; ++i) {
                TestUtil.logMsg((String)("Loop " + i + ": sleep 2 seconds waiting for message to arrive at listener"));
                TestUtil.sleepSec((int)2);
            }
            Message actMessage = null;
            if (listener.isComplete()) {
                actMessage = listener.getMessage();
            }
            if (actMessage == null) {
                TestUtil.logErr((String)"Did not receive Message");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Check the values in Message");
                if (actMessage.getBooleanProperty("booleanProperty")) {
                    TestUtil.logMsg((String)"booleanproperty is correct");
                } else {
                    TestUtil.logMsg((String)"booleanproperty is incorrect");
                    pass = false;
                }
            }
            TestUtil.logMsg((String)"Send and receive BytesMessage");
            BytesMessage bMsg = this.context.createBytesMessage();
            TestUtil.logMsg((String)"Set some values in BytesMessage");
            bMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "sendAndRecvMsgOfEachTypeCLTest");
            bMsg.writeByte((byte)1);
            bMsg.writeInt(22);
            bMsg.reset();
            listener = new MyCompletionListener2();
            this.producer = this.context.createProducer();
            this.producer.setAsync((CompletionListener)listener);
            this.producer.send(this.destination, (Message)bMsg);
            TestUtil.logMsg((String)"Poll listener until we receive BytesMessage");
            for (int i = 0; !listener.isComplete() && i < 15; ++i) {
                TestUtil.logMsg((String)("Loop " + i + ": sleep 2 seconds waiting for message to arrive at listener"));
                TestUtil.sleepSec((int)2);
            }
            BytesMessage bMsgRecv = null;
            if (listener.isComplete()) {
                bMsgRecv = (BytesMessage)listener.getMessage();
            }
            if (bMsgRecv == null) {
                TestUtil.logErr((String)"Did not receive BytesMessage");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Check the values in BytesMessage");
                if (bMsgRecv.readByte() == 1) {
                    TestUtil.logMsg((String)"bytevalue is correct");
                } else {
                    TestUtil.logMsg((String)"bytevalue is incorrect");
                    pass = false;
                }
                if (bMsgRecv.readInt() == 22) {
                    TestUtil.logMsg((String)"intvalue is correct");
                } else {
                    TestUtil.logMsg((String)"intvalue is incorrect");
                    pass = false;
                }
            }
            TestUtil.logMsg((String)"Send and receive MapMessage");
            MapMessage mMsg = this.context.createMapMessage();
            TestUtil.logMsg((String)"Set some values in MapMessage");
            mMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "sendAndRecvMsgOfEachTypeCLTest");
            mMsg.setBoolean("booleanvalue", true);
            mMsg.setInt("intvalue", 10);
            listener = new MyCompletionListener2();
            this.producer = this.context.createProducer();
            this.producer.setAsync((CompletionListener)listener);
            this.producer.send(this.destination, (Message)mMsg);
            TestUtil.logMsg((String)"Poll listener until we receive MapMessage");
            for (int i = 0; !listener.isComplete() && i < 15; ++i) {
                TestUtil.logMsg((String)("Loop " + i + ": sleep 2 seconds waiting for message to arrive at listener"));
                TestUtil.sleepSec((int)2);
            }
            MapMessage mMsgRecv = null;
            if (listener.isComplete()) {
                mMsgRecv = (MapMessage)listener.getMessage();
            }
            if (mMsgRecv == null) {
                TestUtil.logErr((String)"Did not receive MapMessage");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Check the values in MapMessage");
                Enumeration list = mMsgRecv.getMapNames();
                String name = null;
                while (list.hasMoreElements()) {
                    name = (String)list.nextElement();
                    if (name.equals("booleanvalue")) {
                        if (mMsgRecv.getBoolean(name)) {
                            TestUtil.logMsg((String)"booleanvalue is correct");
                            continue;
                        }
                        TestUtil.logErr((String)"booleanvalue is incorrect");
                        pass = false;
                        continue;
                    }
                    if (name.equals("intvalue")) {
                        if (mMsgRecv.getInt(name) == 10) {
                            TestUtil.logMsg((String)"intvalue is correct");
                            continue;
                        }
                        TestUtil.logErr((String)"intvalue is incorrect");
                        pass = false;
                        continue;
                    }
                    TestUtil.logErr((String)("Unexpected name of [" + name + "] in MapMessage"));
                    pass = false;
                }
            }
            TestUtil.logMsg((String)"Send and receive ObjectMessage");
            StringBuffer sb1 = new StringBuffer("This is a StringBuffer");
            TestUtil.logMsg((String)"Set some values in ObjectMessage");
            ObjectMessage oMsg = this.context.createObjectMessage();
            oMsg.setObject((Serializable)sb1);
            oMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "sendAndRecvMsgOfEachTypeCLTest");
            listener = new MyCompletionListener2();
            this.producer = this.context.createProducer();
            this.producer.setAsync((CompletionListener)listener);
            this.producer.send(this.destination, (Message)oMsg);
            TestUtil.logMsg((String)"Poll listener until we receive ObjectMessage");
            for (int i = 0; !listener.isComplete() && i < 15; ++i) {
                TestUtil.logMsg((String)("Loop " + i + ": sleep 2 seconds waiting for message to arrive at listener"));
                TestUtil.sleepSec((int)2);
            }
            ObjectMessage oMsgRecv = null;
            if (listener.isComplete()) {
                oMsgRecv = (ObjectMessage)listener.getMessage();
            }
            if (oMsgRecv == null) {
                TestUtil.logErr((String)"Did not receive ObjectMessage");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Check the values in ObjectMessage");
                StringBuffer sb2 = (StringBuffer)oMsgRecv.getObject();
                if (sb2.toString().equals(sb1.toString())) {
                    TestUtil.logMsg((String)"objectvalue is correct");
                } else {
                    TestUtil.logErr((String)"objectvalue is incorrect");
                    pass = false;
                }
            }
            TestUtil.logMsg((String)"Send and receive StreamMessage");
            StreamMessage sMsg = this.context.createStreamMessage();
            TestUtil.logMsg((String)"Set some values in StreamMessage");
            sMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "sendAndRecvMsgOfEachTypeCLTest");
            sMsg.writeBoolean(true);
            sMsg.writeInt(22);
            sMsg.reset();
            listener = new MyCompletionListener2();
            this.producer = this.context.createProducer();
            this.producer.setAsync((CompletionListener)listener);
            this.producer.send(this.destination, (Message)sMsg);
            TestUtil.logMsg((String)"Poll listener until we receive StreamMessage");
            for (int i = 0; !listener.isComplete() && i < 15; ++i) {
                TestUtil.logMsg((String)("Loop " + i + ": sleep 2 seconds waiting for message to arrive at listener"));
                TestUtil.sleepSec((int)2);
            }
            StreamMessage sMsgRecv = null;
            if (listener.isComplete()) {
                sMsgRecv = (StreamMessage)listener.getMessage();
            }
            if (sMsgRecv == null) {
                TestUtil.logErr((String)"Did not receive StreamMessage");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Check the values in StreamMessage");
                if (sMsgRecv.readBoolean()) {
                    TestUtil.logMsg((String)"booleanvalue is correct");
                } else {
                    TestUtil.logMsg((String)"booleanvalue is incorrect");
                    pass = false;
                }
                if (sMsgRecv.readInt() == 22) {
                    TestUtil.logMsg((String)"intvalue is correct");
                } else {
                    TestUtil.logMsg((String)"intvalue is incorrect");
                    pass = false;
                }
            }
            TestUtil.logMsg((String)"Send and receive TextMessage");
            TextMessage expTextMessage = this.context.createTextMessage(message);
            TestUtil.logMsg((String)"Set some values in TextMessage");
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "sendAndRecvMsgOfEachTypeCLTest");
            TestUtil.logMsg((String)"Calling JMSProducer.send(Destination,Message)");
            listener = new MyCompletionListener2();
            this.producer = this.context.createProducer();
            this.producer.setAsync((CompletionListener)listener);
            this.producer.send(this.destination, (Message)expTextMessage);
            TestUtil.logMsg((String)"Poll listener until we receive TextMessage");
            for (int i = 0; !listener.isComplete() && i < 15; ++i) {
                TestUtil.logMsg((String)("Loop " + i + ": sleep 2 seconds waiting for message to arrive at listener"));
                TestUtil.sleepSec((int)2);
            }
            TextMessage actTextMessage = null;
            if (listener.isComplete()) {
                actTextMessage = (TextMessage)listener.getMessage();
            }
            if (actTextMessage == null) {
                throw new EETest.Fault("Did not receive TextMessage");
            }
            TestUtil.logMsg((String)"Check the values in TextMessage");
            if (!actTextMessage.getText().equals(expTextMessage.getText())) {
                TestUtil.logErr((String)"Didn't get the right message.");
                TestUtil.logErr((String)("text=" + actTextMessage.getText() + ", expected " + expTextMessage.getText()));
                pass = false;
            } else {
                TestUtil.logMsg((String)"TextMessage is correct");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("sendAndRecvMsgOfEachTypeCLTest", e);
        }
        if (!pass) {
            throw new EETest.Fault("sendAndRecvMsgOfEachTypeCLTest failed");
        }
    }

    public void sendAndRecvMsgOfEachTypeMLTest() throws EETest.Fault {
        boolean pass = true;
        String message = "Where are you!";
        try {
            TestUtil.logMsg((String)"Send and receive Message");
            Message msg = this.context.createMessage();
            TestUtil.logMsg((String)"Set some values in Message");
            msg.setStringProperty("COM_SUN_JMS_TESTNAME", "sendAndRecvMsgOfEachTypeMLTest");
            msg.setBooleanProperty("booleanProperty", true);
            MyMessageListener2 listener = new MyMessageListener2();
            this.consumer = this.context.createConsumer(this.destination);
            this.consumer.setMessageListener((MessageListener)listener);
            this.producer = this.contextToSendMsg.createProducer();
            this.producer.send(this.destination, msg);
            TestUtil.logMsg((String)"Poll listener until we receive Message");
            for (int i = 0; !listener.isComplete() && i < 15; ++i) {
                TestUtil.logMsg((String)("Loop " + i + ": sleep 2 seconds waiting for message to arrive at listener"));
                TestUtil.sleepSec((int)2);
            }
            Message actMessage = null;
            if (listener.isComplete()) {
                actMessage = listener.getMessage();
            }
            if (actMessage == null) {
                TestUtil.logErr((String)"Did not receive Message");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Check the values in Message");
                if (actMessage.getBooleanProperty("booleanProperty")) {
                    TestUtil.logMsg((String)"booleanproperty is correct");
                } else {
                    TestUtil.logMsg((String)"booleanproperty is incorrect");
                    pass = false;
                }
            }
            TestUtil.logMsg((String)"Send and receive BytesMessage");
            BytesMessage bMsg = this.contextToCreateMsg.createBytesMessage();
            TestUtil.logMsg((String)"Set some values in BytesMessage");
            bMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "sendAndRecvMsgOfEachTypeMLTest");
            bMsg.writeByte((byte)1);
            bMsg.writeInt(22);
            listener = new MyMessageListener2();
            this.consumer.setMessageListener((MessageListener)listener);
            this.producer = this.contextToSendMsg.createProducer();
            this.producer.send(this.destination, (Message)bMsg);
            TestUtil.logMsg((String)"Poll listener until we receive BytesMessage");
            for (int i = 0; !listener.isComplete() && i < 15; ++i) {
                TestUtil.logMsg((String)("Loop " + i + ": sleep 2 seconds waiting for message to arrive at listener"));
                TestUtil.sleepSec((int)2);
            }
            BytesMessage bMsgRecv = null;
            if (listener.isComplete()) {
                bMsgRecv = (BytesMessage)listener.getMessage();
            }
            if (bMsgRecv == null) {
                TestUtil.logErr((String)"Did not receive BytesMessage");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Check the values in BytesMessage");
                if (bMsgRecv.readByte() == 1) {
                    TestUtil.logMsg((String)"bytevalue is correct");
                } else {
                    TestUtil.logMsg((String)"bytevalue is incorrect");
                    pass = false;
                }
                if (bMsgRecv.readInt() == 22) {
                    TestUtil.logMsg((String)"intvalue is correct");
                } else {
                    TestUtil.logMsg((String)"intvalue is incorrect");
                    pass = false;
                }
            }
            TestUtil.logMsg((String)"Send and receive MapMessage");
            MapMessage mMsg = this.contextToCreateMsg.createMapMessage();
            TestUtil.logMsg((String)"Set some values in MapMessage");
            mMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "sendAndRecvMsgOfEachTypeMLTest");
            mMsg.setBoolean("booleanvalue", true);
            mMsg.setInt("intvalue", 10);
            listener = new MyMessageListener2();
            this.consumer.setMessageListener((MessageListener)listener);
            this.producer = this.contextToSendMsg.createProducer();
            this.producer.send(this.destination, (Message)mMsg);
            TestUtil.logMsg((String)"Poll listener until we receive MapMessage");
            for (int i = 0; !listener.isComplete() && i < 15; ++i) {
                TestUtil.logMsg((String)("Loop " + i + ": sleep 2 seconds waiting for message to arrive at listener"));
                TestUtil.sleepSec((int)2);
            }
            MapMessage mMsgRecv = null;
            if (listener.isComplete()) {
                mMsgRecv = (MapMessage)listener.getMessage();
            }
            if (mMsgRecv == null) {
                TestUtil.logErr((String)"Did not receive MapMessage");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Check the values in MapMessage");
                Enumeration list = mMsgRecv.getMapNames();
                String name = null;
                while (list.hasMoreElements()) {
                    name = (String)list.nextElement();
                    if (name.equals("booleanvalue")) {
                        if (mMsgRecv.getBoolean(name)) {
                            TestUtil.logMsg((String)"booleanvalue is correct");
                            continue;
                        }
                        TestUtil.logErr((String)"booleanvalue is incorrect");
                        pass = false;
                        continue;
                    }
                    if (name.equals("intvalue")) {
                        if (mMsgRecv.getInt(name) == 10) {
                            TestUtil.logMsg((String)"intvalue is correct");
                            continue;
                        }
                        TestUtil.logErr((String)"intvalue is incorrect");
                        pass = false;
                        continue;
                    }
                    TestUtil.logErr((String)("Unexpected name of [" + name + "] in MapMessage"));
                    pass = false;
                }
            }
            TestUtil.logMsg((String)"Send and receive ObjectMessage");
            StringBuffer sb1 = new StringBuffer("This is a StringBuffer");
            TestUtil.logMsg((String)"Set some values in ObjectMessage");
            ObjectMessage oMsg = this.contextToCreateMsg.createObjectMessage();
            oMsg.setObject((Serializable)sb1);
            oMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "sendAndRecvMsgOfEachTypeMLTest");
            listener = new MyMessageListener2();
            this.consumer.setMessageListener((MessageListener)listener);
            this.producer = this.contextToSendMsg.createProducer();
            this.producer.send(this.destination, (Message)oMsg);
            TestUtil.logMsg((String)"Poll listener until we receive ObjectMessage");
            for (int i = 0; !listener.isComplete() && i < 15; ++i) {
                TestUtil.logMsg((String)("Loop " + i + ": sleep 2 seconds waiting for message to arrive at listener"));
                TestUtil.sleepSec((int)2);
            }
            ObjectMessage oMsgRecv = null;
            if (listener.isComplete()) {
                oMsgRecv = (ObjectMessage)listener.getMessage();
            }
            if (oMsgRecv == null) {
                TestUtil.logErr((String)"Did not receive ObjectMessage");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Check the values in ObjectMessage");
                StringBuffer sb2 = (StringBuffer)oMsgRecv.getObject();
                if (sb2.toString().equals(sb1.toString())) {
                    TestUtil.logMsg((String)"objectvalue is correct");
                } else {
                    TestUtil.logErr((String)"objectvalue is incorrect");
                    pass = false;
                }
            }
            TestUtil.logMsg((String)"Send and receive StreamMessage");
            StreamMessage sMsg = this.contextToCreateMsg.createStreamMessage();
            TestUtil.logMsg((String)"Set some values in StreamMessage");
            sMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "sendAndRecvMsgOfEachTypeMLTest");
            sMsg.writeBoolean(true);
            sMsg.writeInt(22);
            listener = new MyMessageListener2();
            this.consumer.setMessageListener((MessageListener)listener);
            this.producer = this.contextToSendMsg.createProducer();
            this.producer.send(this.destination, (Message)sMsg);
            TestUtil.logMsg((String)"Poll listener until we receive StreamMessage");
            for (int i = 0; !listener.isComplete() && i < 15; ++i) {
                TestUtil.logMsg((String)("Loop " + i + ": sleep 2 seconds waiting for message to arrive at listener"));
                TestUtil.sleepSec((int)2);
            }
            StreamMessage sMsgRecv = null;
            if (listener.isComplete()) {
                sMsgRecv = (StreamMessage)listener.getMessage();
            }
            if (sMsgRecv == null) {
                TestUtil.logErr((String)"Did not receive StreamMessage");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Check the values in StreamMessage");
                if (sMsgRecv.readBoolean()) {
                    TestUtil.logMsg((String)"booleanvalue is correct");
                } else {
                    TestUtil.logMsg((String)"booleanvalue is incorrect");
                    pass = false;
                }
                if (sMsgRecv.readInt() == 22) {
                    TestUtil.logMsg((String)"intvalue is correct");
                } else {
                    TestUtil.logMsg((String)"intvalue is incorrect");
                    pass = false;
                }
            }
            TestUtil.logMsg((String)"Send and receive TextMessage");
            TextMessage expTextMessage = this.contextToCreateMsg.createTextMessage(message);
            TestUtil.logMsg((String)"Set some values in TextMessage");
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "sendAndRecvMsgOfEachTypeMLTest");
            TestUtil.logMsg((String)"Calling JMSProducer.send(Destination,Message)");
            listener = new MyMessageListener2();
            this.consumer.setMessageListener((MessageListener)listener);
            this.producer = this.contextToSendMsg.createProducer();
            this.producer.send(this.destination, (Message)expTextMessage);
            TestUtil.logMsg((String)"Poll listener until we receive TextMessage");
            for (int i = 0; !listener.isComplete() && i < 15; ++i) {
                TestUtil.logMsg((String)("Loop " + i + ": sleep 2 seconds waiting for message to arrive at listener"));
                TestUtil.sleepSec((int)2);
            }
            TextMessage actTextMessage = null;
            if (listener.isComplete()) {
                actTextMessage = (TextMessage)listener.getMessage();
            }
            if (actTextMessage == null) {
                throw new EETest.Fault("Did not receive TextMessage");
            }
            TestUtil.logMsg((String)"Check the values in TextMessage");
            if (!actTextMessage.getText().equals(expTextMessage.getText())) {
                TestUtil.logErr((String)"Didn't get the right message.");
                TestUtil.logErr((String)("text=" + actTextMessage.getText() + ", expected " + expTextMessage.getText()));
                pass = false;
            } else {
                TestUtil.logMsg((String)"TextMessage is correct");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("sendAndRecvMsgOfEachTypeMLTest", e);
        }
        if (!pass) {
            throw new EETest.Fault("sendAndRecvMsgOfEachTypeMLTest failed");
        }
    }

    public void messageOrderCLQueueTest() throws EETest.Fault {
        boolean pass = true;
        try {
            int i;
            String[] text = new String[3];
            TestUtil.logMsg((String)"Creating MyCompletionListener");
            MyCompletionListener listener = new MyCompletionListener(3);
            TestUtil.logMsg((String)"Creating JMSProducer");
            this.producer = this.context.createProducer();
            TestUtil.logMsg((String)"Calling JMSProducer.setAsync(CompletionListener)");
            this.producer.setAsync((CompletionListener)listener);
            TestUtil.logMsg((String)"Sending 3 asynchronous messages to queue");
            for (i = 0; i < 3; ++i) {
                text[i] = "message order test " + i;
                TextMessage sentTextMessage = this.context.createTextMessage();
                sentTextMessage.setText(text[i]);
                sentTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "messageOrderCLQueueTest" + i);
                TestUtil.logMsg((String)("Sending TextMessage: " + sentTextMessage.getText()));
                this.producer.send(this.destination, (Message)sentTextMessage);
            }
            TestUtil.logMsg((String)"Poll listener until we receive all 3 TextMessage's from CompletionListener");
            for (i = 0; !listener.gotAllMsgs() && i < 60; ++i) {
                TestUtil.logMsg((String)("Loop " + i + ": sleep 2 seconds waiting for messages to arrive at listener"));
                TestUtil.sleepSec((int)2);
            }
            for (i = 0; i < 3; ++i) {
                TextMessage actTextMessage = null;
                if (listener.haveMsg(i)) {
                    actTextMessage = (TextMessage)listener.getMessage(i);
                }
                if (actTextMessage == null) {
                    TestUtil.logMsg((String)("Did not receive TextMessage " + i + " (unexpected)"));
                    pass = false;
                    continue;
                }
                TestUtil.logMsg((String)("Received message: " + actTextMessage.getText()));
                if (actTextMessage.getText().equals(text[i])) continue;
                TestUtil.logMsg((String)("Received message: " + actTextMessage.getText()));
                TestUtil.logMsg((String)("Should have received: " + text[i]));
                TestUtil.logErr((String)"Received wrong message (wrong order)");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("messageOrderCLQueueTest", e);
        }
        if (!pass) {
            throw new EETest.Fault("messageOrderCLQueueTest failed");
        }
    }

    public void commitRollbackTest() throws EETest.Fault {
        boolean pass = true;
        try {
            int i;
            TextMessage tempMsg = null;
            this.context.close();
            TestUtil.logMsg((String)"Create transacted JMSContext, JMSConsumer and JMSProducer");
            this.context = this.cf.createContext(this.user, this.password, 0);
            this.producer = this.context.createProducer();
            this.consumer = this.context.createConsumer(this.destination);
            TestUtil.logMsg((String)"Send 3 messages to Queue and call rollback()");
            for (i = 1; i <= 3; ++i) {
                tempMsg = this.context.createTextMessage("Message " + i);
                tempMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "commitRollbackTest" + i);
                this.producer.send(this.destination, (Message)tempMsg);
                TestUtil.logMsg((String)("Message " + i + " sent"));
            }
            TestUtil.logMsg((String)"Calling rollback() to rollback the sent messages");
            this.context.rollback();
            TestUtil.logMsg((String)"Should not consume any messages in Queue since rollback() was called");
            tempMsg = (TextMessage)this.consumer.receive(this.timeout);
            if (tempMsg != null) {
                TestUtil.logErr((String)("Received message " + tempMsg.getText() + ", expected NULL (NO MESSAGES)"));
                pass = false;
            } else {
                TestUtil.logMsg((String)"Received no messages (CORRECT)");
            }
            TestUtil.logMsg((String)"Send 3 messages to Queue and call commit()");
            for (i = 1; i <= 3; ++i) {
                tempMsg = this.context.createTextMessage("Message " + i);
                tempMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "commitRollbackTest" + i);
                this.producer.send(this.destination, (Message)tempMsg);
                TestUtil.logMsg((String)("Message " + i + " sent"));
            }
            TestUtil.logMsg((String)"Calling commit() to commit the sent messages");
            this.context.commit();
            TestUtil.logMsg((String)"Should consume all messages in Queue since commit() was called");
            for (int msgCount = 1; msgCount <= 3; ++msgCount) {
                tempMsg = (TextMessage)this.consumer.receive(this.timeout);
                if (tempMsg == null) {
                    TestUtil.logErr((String)"JMSConsumer.receive() returned NULL");
                    TestUtil.logErr((String)("Message " + msgCount + " missing from Queue"));
                    pass = false;
                    continue;
                }
                if (!tempMsg.getText().equals("Message " + msgCount)) {
                    TestUtil.logErr((String)("Received [" + tempMsg.getText() + "] expected [Message " + msgCount + "]"));
                    pass = false;
                    continue;
                }
                TestUtil.logMsg((String)("Received message: " + tempMsg.getText()));
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("commitRollbackTest");
        }
        if (!pass) {
            throw new EETest.Fault("commitRollbackTest failed");
        }
    }

    public void recoverAckTest() throws EETest.Fault {
        boolean pass = true;
        TextMessage textMessage = null;
        try {
            int i;
            TestUtil.logMsg((String)"Close JMSContext created in setup() method");
            this.context.close();
            TestUtil.logMsg((String)"Close JMSContext with CLIENT_ACKNOWLEDGE and create comsumer/producer");
            this.context = this.cf.createContext(this.user, this.password, 2);
            this.consumer = this.context.createConsumer(this.destination);
            this.producer = this.context.createProducer();
            TestUtil.logMsg((String)"Send 3 messages");
            for (i = 0; i < 3; ++i) {
                String message = "text message " + i;
                textMessage = this.context.createTextMessage(message);
                textMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "recoverAckTest" + i);
                this.producer.send(this.destination, (Message)textMessage);
                TestUtil.logMsg((String)("Sent message " + i));
            }
            TestUtil.logMsg((String)"Receive 3 messages but do not acknowledge");
            for (i = 0; i < 3; ++i) {
                TestUtil.logMsg((String)("Receiving message " + i));
                textMessage = (TextMessage)this.consumer.receive(this.timeout);
                if (textMessage == null) {
                    pass = false;
                    TestUtil.logErr((String)("Did not receive message " + i));
                    continue;
                }
                TestUtil.logMsg((String)("Received message " + i));
            }
            TestUtil.logMsg((String)"Call JMSContext.recover()");
            this.context.recover();
            TestUtil.logMsg((String)"Receive 3 messages again then acknowledge");
            for (i = 0; i < 3; ++i) {
                TestUtil.logMsg((String)("Receiving message " + i));
                textMessage = (TextMessage)this.consumer.receive(this.timeout);
                if (textMessage == null) {
                    pass = false;
                    TestUtil.logErr((String)("Did not receive message " + i));
                    continue;
                }
                TestUtil.logMsg((String)("Received message " + i));
            }
            TestUtil.logMsg((String)"Acknowledge all messages by calling JMSContext.acknowledge()");
            this.context.acknowledge();
            TestUtil.logMsg((String)"Now try receiving a message (should get NONE)");
            textMessage = (TextMessage)this.consumer.receive(this.timeout);
            if (textMessage != null) {
                TestUtil.logErr((String)("Received message " + textMessage.getText() + " (Expected NONE)"));
                pass = false;
            } else {
                TestUtil.logMsg((String)"Received no message (Correct)");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"recoverAckTest failed: ", (Throwable)e);
            throw new EETest.Fault("recoverAckTest failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("recoverAckTest failed!!!");
        }
    }

    public void invalidDestinationRuntimeExceptionTests() throws EETest.Fault {
        boolean pass;
        block10: {
            pass = true;
            Destination invalidDestination = null;
            Object invalidQueue = null;
            String message = "Where are you!";
            HashMap<String, Object> mapMsgSend = new HashMap<String, Object>();
            mapMsgSend.put("StringValue", "sendAndRecvTest7");
            mapMsgSend.put("BooleanValue", true);
            mapMsgSend.put("IntValue", 10);
            try {
                TestUtil.logMsg((String)"Creating JMSConsumer");
                this.consumer = this.context.createConsumer(this.destination);
                TestUtil.logMsg((String)"Creating JMSProducer");
                this.producer = this.context.createProducer();
                TestUtil.logMsg((String)"Creating TextMessage");
                TextMessage expTextMessage = this.context.createTextMessage(message);
                TestUtil.logMsg((String)"Set some values in TextMessage");
                expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "invalidDestinationRuntimeExceptionTests");
                MyCompletionListener listener = new MyCompletionListener();
                TestUtil.logMsg((String)"Testing JMSProducer.send(Destination, Message) for InvalidDestinationRuntimeException");
                try {
                    TestUtil.logMsg((String)"Calling JMSProducer.setAsync(CompletionListener)");
                    this.producer.setAsync((CompletionListener)listener);
                    TestUtil.logMsg((String)"Calling JMSProducer.send(Destination, Message) -> expect InvalidDestinationRuntimeException");
                    this.producer.send(invalidDestination, (Message)expTextMessage);
                    TestUtil.logMsg((String)"Poll listener until we receive exception");
                    Exception exception = null;
                    for (int i = 0; i < 30 && !listener.isComplete(); ++i) {
                        TestUtil.sleepSec((int)2);
                    }
                    if (listener.isComplete()) {
                        exception = listener.getException();
                    }
                    if (exception == null) {
                        pass = false;
                        TestUtil.logErr((String)"Didn't throw and exception");
                        break block10;
                    }
                    TestUtil.logMsg((String)"Check the value in Exception");
                    if (exception instanceof InvalidDestinationRuntimeException) {
                        TestUtil.logMsg((String)"Exception is expected InvalidDestinationRuntimeException");
                        break block10;
                    }
                    TestUtil.logErr((String)("Exception is incorrect expected InvalidDestinationRuntimeException, received " + exception.getCause()));
                    pass = false;
                }
                catch (InvalidDestinationRuntimeException e) {
                    TestUtil.logMsg((String)"Got InvalidDestinationRuntimeException as expected.");
                }
                catch (Exception e) {
                    TestUtil.logErr((String)("Expected InvalidDestinationRuntimeException, received " + e));
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught unexpected exception: " + e));
                throw new EETest.Fault("invalidDestinationRuntimeExceptionTests", e);
            }
        }
        if (!pass) {
            throw new EETest.Fault("invalidDestinationRuntimeExceptionTests failed");
        }
    }

    public void messageFormatRuntimeExceptionTests() throws EETest.Fault {
        boolean pass;
        block10: {
            pass = true;
            try {
                TestUtil.logMsg((String)"Creating JMSConsumer");
                this.consumer = this.context.createConsumer(this.destination);
                TestUtil.logMsg((String)"Creating JMSProducer");
                this.producer = this.context.createProducer();
                MyCompletionListener listener = new MyCompletionListener();
                TestUtil.logMsg((String)"Testing JMSProducer.send(Destination, Message) for MessageFormatRuntimeException");
                try {
                    TestUtil.logMsg((String)"Calling JMSProducer.setAsync(CompletionListener)");
                    this.producer.setAsync((CompletionListener)listener);
                    TestUtil.logMsg((String)"Calling JMSProducer.send(Destination, Message) -> expect MessageFormatRuntimeException");
                    this.producer.send(this.destination, (Message)null);
                    TestUtil.logMsg((String)"Poll listener until we receive exception");
                    Exception exception = null;
                    for (int i = 0; i < 30 && !listener.isComplete(); ++i) {
                        TestUtil.sleepSec((int)2);
                    }
                    if (listener.isComplete()) {
                        exception = listener.getException();
                    }
                    if (exception == null) {
                        pass = false;
                        TestUtil.logErr((String)"Didn't throw and exception");
                        break block10;
                    }
                    TestUtil.logMsg((String)"Check the value in Exception");
                    if (exception instanceof MessageFormatRuntimeException) {
                        TestUtil.logMsg((String)"Exception is expected MessageFormatRuntimeException");
                        break block10;
                    }
                    TestUtil.logErr((String)("Exception is incorrect expected MessageFormatRuntimeException, received " + exception.getCause()));
                    pass = false;
                }
                catch (MessageFormatRuntimeException e) {
                    TestUtil.logMsg((String)"Got MessageFormatRuntimeException as expected.");
                }
                catch (Exception e) {
                    TestUtil.logErr((String)("Expected MessageFormatRuntimeException, received " + e));
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught unexpected exception: " + e));
                throw new EETest.Fault("messageFormatRuntimeExceptionTests", e);
            }
        }
        if (!pass) {
            throw new EETest.Fault("messageFormatRuntimeExceptionTests failed");
        }
    }

    public void jMSRuntimeExceptionTests() throws EETest.Fault {
        boolean pass;
        block19: {
            pass = true;
            String message = "Where are you!";
            try {
                int i;
                Exception exception;
                TestUtil.logMsg((String)"Creating JMSConsumer");
                this.consumer = this.context.createConsumer(this.destination);
                TestUtil.logMsg((String)"Creating JMSProducer");
                this.producer = this.context.createProducer();
                MyCompletionListener listener = new MyCompletionListener();
                TestUtil.logMsg((String)"Creating TextMessage");
                TextMessage expTextMessage = this.context.createTextMessage(message);
                TestUtil.logMsg((String)"Set some values in TextMessage");
                expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "jMSRuntimeExceptionTests");
                try {
                    TestUtil.logMsg((String)"Set completion listener");
                    this.producer.setAsync((CompletionListener)listener);
                    TestUtil.logMsg((String)"Try and set an invalid delivbery mode of -1 on send");
                    this.producer.setDeliveryMode(-1);
                    this.producer.send(this.destination, (Message)expTextMessage);
                    TestUtil.logMsg((String)"Poll listener until we receive exception");
                    exception = null;
                    for (i = 0; i < 30 && !listener.isComplete(); ++i) {
                        TestUtil.sleepSec((int)2);
                    }
                    if (listener.isComplete()) {
                        exception = listener.getException();
                    }
                    if (exception == null) {
                        pass = false;
                        TestUtil.logErr((String)"Didn't throw and exception");
                    } else {
                        TestUtil.logMsg((String)"Check the value in Exception");
                        if (exception instanceof JMSRuntimeException) {
                            TestUtil.logMsg((String)"Exception is expected JMSRuntimeException");
                        } else {
                            TestUtil.logErr((String)("Exception is incorrect expected JMSRuntimeException, received " + exception.getCause()));
                            pass = false;
                        }
                    }
                }
                catch (JMSRuntimeException e) {
                    TestUtil.logMsg((String)"Caught expected JMSRuntimeException");
                }
                catch (Exception e) {
                    TestUtil.logErr((String)("Expected JMSRuntimeException, received " + e));
                    pass = false;
                }
                try {
                    TestUtil.logMsg((String)"Set completion listener");
                    this.producer.setAsync((CompletionListener)listener);
                    listener.setComplete(false);
                    TestUtil.logMsg((String)"Try and set an invalid priority of -1 on send");
                    this.producer.setDeliveryMode(1);
                    this.producer.setPriority(-1);
                    this.producer.send(this.destination, (Message)expTextMessage);
                    TestUtil.logMsg((String)"Poll listener until we receive exception");
                    exception = null;
                    for (i = 0; i < 30 && !listener.isComplete(); ++i) {
                        TestUtil.sleepSec((int)2);
                    }
                    if (listener.isComplete()) {
                        listener.setComplete(false);
                        exception = listener.getException();
                    }
                    if (exception == null) {
                        pass = false;
                        TestUtil.logErr((String)"Didn't throw and exception");
                        break block19;
                    }
                    TestUtil.logMsg((String)"Check the value in Exception");
                    if (exception instanceof JMSRuntimeException) {
                        TestUtil.logMsg((String)"Exception is expected JMSRuntimeException");
                        break block19;
                    }
                    TestUtil.logErr((String)("Exception is incorrect expected JMSRuntimeException, received " + exception.getCause()));
                    pass = false;
                }
                catch (JMSRuntimeException e) {
                    TestUtil.logMsg((String)"Caught expected JMSRuntimeException");
                }
                catch (Exception e) {
                    TestUtil.logErr((String)("Expected JMSRuntimeException, received " + e));
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught unexpected exception: " + e));
                TestUtil.printStackTrace((Throwable)e);
                throw new EETest.Fault("jMSRuntimeExceptionTests", e);
            }
        }
        if (!pass) {
            throw new EETest.Fault("jMSRuntimeExceptionTests failed");
        }
    }

    public void illegalStateRuntimeExceptionTests() throws EETest.Fault {
        boolean pass = true;
        try {
            int i;
            Object actTextMessage;
            Object listener;
            TextMessage expTextMessage;
            TestUtil.logMsg((String)"Creating JMSProducer/JMSConsumer");
            this.producer = this.contextToSendMsg.createProducer();
            this.consumer = this.context.createConsumer(this.destination);
            TestUtil.logMsg((String)"-----------------------------------------------------");
            TestUtil.logMsg((String)"CompletionListener IllegalStateRuntimeException Tests");
            TestUtil.logMsg((String)"-----------------------------------------------------");
            TestUtil.logMsg((String)"Testing JMSContext.commit() from CompletionListener (expect IllegalStateRuntimeException)");
            try {
                TestUtil.logMsg((String)"Creating TextMessage");
                expTextMessage = this.context.createTextMessage("Call commit method");
                TestUtil.logMsg((String)"Set some values in TextMessage");
                expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "illegalStateRuntimeExceptionTests");
                TestUtil.logMsg((String)"Send async message specifying CompletionListener to recieve async message");
                TestUtil.logMsg((String)"CompletionListener will call JMSContext.commit() (expect IllegalStateRuntimeException)");
                listener = new MyCompletionListener(this.context);
                this.producer.setAsync((CompletionListener)listener);
                this.producer.send(this.destination, (Message)expTextMessage);
                actTextMessage = null;
                TestUtil.logMsg((String)"Poll listener until we receive exception");
                for (i = 0; i < 30 && !((MyCompletionListener)listener).isComplete(); ++i) {
                    TestUtil.sleepSec((int)2);
                }
                TestUtil.logMsg((String)"Check if we got correct exception from JMSContext.commit()");
                if (((MyCompletionListener)listener).gotException()) {
                    if (((MyCompletionListener)listener).gotCorrectException()) {
                        TestUtil.logMsg((String)"Got correct IllegalStateRuntimeException");
                    } else {
                        TestUtil.logErr((String)("Expected IllegalStateRuntimeException, received: " + ((MyCompletionListener)listener).getException()));
                        pass = false;
                    }
                } else {
                    TestUtil.logErr((String)"Expected IllegalStateRuntimeException, got no exception");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Expected IllegalStateRuntimeException, received " + e));
                pass = false;
            }
            TestUtil.logMsg((String)"Testing JMSContext.rollback() from CompletionListener (expect IllegalStateRuntimeException)");
            try {
                TestUtil.logMsg((String)"Creating TextMessage");
                expTextMessage = this.context.createTextMessage("Call rollback method");
                TestUtil.logMsg((String)"Set some values in TextMessage");
                expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "illegalStateRuntimeExceptionTests");
                TestUtil.logMsg((String)"Send async message specifying CompletionListener to recieve async message");
                TestUtil.logMsg((String)"CompletionListener will call JMSContext.rollback() (expect IllegalStateRuntimeException)");
                listener = new MyCompletionListener(this.contextToSendMsg);
                this.producer.setAsync((CompletionListener)listener);
                ((MyCompletionListener)listener).setComplete(false);
                this.producer.send(this.destination, (Message)expTextMessage);
                actTextMessage = null;
                TestUtil.logMsg((String)"Poll listener until we receive exception");
                for (i = 0; i < 30 && !((MyCompletionListener)listener).isComplete(); ++i) {
                    TestUtil.sleepSec((int)2);
                }
                TestUtil.logMsg((String)"Check if we got correct exception from JMSContext.rollback()");
                if (((MyCompletionListener)listener).gotException()) {
                    if (((MyCompletionListener)listener).gotCorrectException()) {
                        TestUtil.logMsg((String)"Got correct IllegalStateRuntimeException");
                    } else {
                        TestUtil.logErr((String)("Expected IllegalStateRuntimeException, received: " + ((MyCompletionListener)listener).getException()));
                        pass = false;
                    }
                } else {
                    TestUtil.logErr((String)"Expected IllegalStateRuntimeException, got no exception");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Expected IllegalStateRuntimeException, received " + e));
                pass = false;
            }
            TestUtil.logMsg((String)"Testing JMSContext.stop() from CompletionListener is allowed (expect no exception)");
            try {
                TestUtil.logMsg((String)"Creating TextMessage");
                expTextMessage = this.context.createTextMessage("Call stop method");
                TestUtil.logMsg((String)"Set some values in TextMessage");
                expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "illegalStateRuntimeExceptionTests");
                TestUtil.logMsg((String)"Send async message specifying CompletionListener to recieve async message");
                TestUtil.logMsg((String)"CompletionListener will call JMSContext.stop() (expect no exception)");
                listener = new MyCompletionListener(this.contextToSendMsg);
                this.producer.setAsync((CompletionListener)listener);
                ((MyCompletionListener)listener).setComplete(false);
                this.producer.send(this.destination, (Message)expTextMessage);
                actTextMessage = null;
                TestUtil.logMsg((String)"Poll listener until we receive exception");
                for (i = 0; i < 30 && !((MyCompletionListener)listener).isComplete(); ++i) {
                    TestUtil.sleepSec((int)2);
                }
                TestUtil.logMsg((String)"Check if we got correct exception from JMSContext.stop() (expect no exception)");
                if (((MyCompletionListener)listener).gotException()) {
                    TestUtil.logErr((String)"Got exception calling JMSContext.stop() (expected no exception)");
                    TestUtil.logErr((String)("Exception was: " + ((MyCompletionListener)listener).getException()));
                    pass = false;
                } else {
                    TestUtil.logErr((String)"Got no exception (Correct)");
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Expected IllegalStateRuntimeException, received " + e));
                pass = false;
            }
            try {
                this.cleanup();
            }
            catch (Exception e) {
                TestUtil.logMsg((String)("Caught exception calling cleanup: " + e));
            }
            try {
                this.context = this.cf.createContext(this.user, this.password, 1);
                this.contextToSendMsg = this.cf.createContext(this.user, this.password, 1);
                this.producer = this.contextToSendMsg.createProducer();
                this.consumer = this.context.createConsumer(this.destination);
            }
            catch (Exception e) {
                TestUtil.logMsg((String)("Caught exception creating JMSContext: " + e));
            }
            TestUtil.logMsg((String)"Testing JMSContext.close() from CompletionListener (expect IllegalStateRuntimeException)");
            try {
                TestUtil.logMsg((String)"Creating TextMessage");
                expTextMessage = this.context.createTextMessage("Call close method");
                TestUtil.logMsg((String)"Set some values in TextMessage");
                expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "illegalStateRuntimeExceptionTests");
                TestUtil.logMsg((String)"Send async message specifying CompletionListener to recieve async message");
                TestUtil.logMsg((String)"CompletionListener will call JMSContext.close() (expect IllegalStateRuntimeException)");
                listener = new MyCompletionListener(this.contextToSendMsg);
                this.producer.setAsync((CompletionListener)listener);
                ((MyCompletionListener)listener).setComplete(false);
                this.producer.send(this.destination, (Message)expTextMessage);
                actTextMessage = null;
                TestUtil.logMsg((String)"Poll listener until we receive exception");
                for (i = 0; i < 30 && !((MyCompletionListener)listener).isComplete(); ++i) {
                    TestUtil.sleepSec((int)2);
                }
                TestUtil.logMsg((String)"Check if we got correct exception from JMSContext.close()");
                if (((MyCompletionListener)listener).gotException()) {
                    if (((MyCompletionListener)listener).gotCorrectException()) {
                        TestUtil.logMsg((String)"Got correct IllegalStateRuntimeException");
                    } else {
                        TestUtil.logErr((String)("Expected IllegalStateRuntimeException, received: " + ((MyCompletionListener)listener).getException()));
                        pass = false;
                    }
                } else {
                    TestUtil.logErr((String)"Expected IllegalStateRuntimeException, got no exception");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Expected IllegalStateRuntimeException, received " + e));
                pass = false;
            }
            try {
                this.cleanup();
            }
            catch (Exception e) {
                TestUtil.logMsg((String)("Caught exception calling cleanup: " + e));
            }
            try {
                this.context = this.cf.createContext(this.user, this.password, 1);
                this.contextToSendMsg = this.cf.createContext(this.user, this.password, 1);
                this.producer = this.contextToSendMsg.createProducer();
                this.consumer = this.context.createConsumer(this.destination);
            }
            catch (Exception e) {
                TestUtil.logMsg((String)("Caught exception creating JMSContext: " + e));
            }
            TestUtil.logMsg((String)"--------------------------------------------------");
            TestUtil.logMsg((String)"MessageListener IllegalStateRuntimeException Tests");
            TestUtil.logMsg((String)"--------------------------------------------------");
            TestUtil.logMsg((String)"Testing JMSContext.stop() from MessageListener (expect IllegalStateRuntimeException)");
            try {
                TestUtil.logMsg((String)"Creating TextMessage");
                expTextMessage = this.context.createTextMessage("Call stop method");
                TestUtil.logMsg((String)"Set some values in TextMessage");
                expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "illegalStateRuntimeExceptionTests");
                TestUtil.logMsg((String)"Set MessageListener to receive async message");
                TestUtil.logMsg((String)"MessageListener will call JMSContext.stop() (expect IllegalStateRuntimeException)");
                listener = new MyMessageListener(this.context);
                this.consumer.setMessageListener((MessageListener)listener);
                ((MyMessageListener)listener).setComplete(false);
                this.producer.send(this.destination, (Message)expTextMessage);
                actTextMessage = null;
                TestUtil.logMsg((String)"Poll listener until we receive exception");
                for (i = 0; i < 30 && !((MyMessageListener)listener).isComplete(); ++i) {
                    TestUtil.sleepSec((int)2);
                }
                TestUtil.logMsg((String)"Check if we got correct exception from JMSContext.stop()");
                if (((MyMessageListener)listener).gotException()) {
                    if (((MyMessageListener)listener).gotCorrectException()) {
                        TestUtil.logMsg((String)"Got correct IllegalStateRuntimeException");
                    } else {
                        TestUtil.logErr((String)("Expected IllegalStateRuntimeException, received: " + ((MyMessageListener)listener).getException()));
                        pass = false;
                    }
                } else {
                    TestUtil.logErr((String)"Expected IllegalStateRuntimeException, got no exception");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Expected IllegalStateRuntimeException, received " + e));
                pass = false;
            }
            try {
                this.cleanup();
            }
            catch (Exception e) {
                TestUtil.logMsg((String)("Caught exception calling cleanup: " + e));
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e));
            throw new EETest.Fault("illegalStateRuntimeExceptionTests", e);
        }
        if (!pass) {
            throw new EETest.Fault("illegalStateRuntimeExceptionTests failed");
        }
    }
}

