/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jacc.web.providerContracts;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.porting.TSURL;
import com.sun.ts.lib.util.BASE64Encoder;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jacc.util.LogFileProcessor;
import com.sun.ts.tests.jacc.util.LogRecordEntry;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collection;
import java.util.Properties;

public class Client
extends ServiceEETest {
    private Properties props = null;
    private String contextId = "jacc_ctx";
    private String hostname = null;
    private int portnum = 0;
    private String pageBase = "/jacc_web_providerContracts_web";
    private String securedPage = "/secured.jsp";
    private String accessToAllPage = "/AccessToAll.jsp";
    private String anyAuthUserPage = "/anyauthuser.jsp";
    private String authusername = "";
    private String authpassword = "";
    private TSNamingContext nctx = null;
    LogFileProcessor logProcessor = null;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.props = p;
        boolean pass = true;
        try {
            this.hostname = p.getProperty("webServerHost");
            this.portnum = Integer.parseInt(p.getProperty("webServerPort"));
            this.authusername = p.getProperty("authuser");
            this.authpassword = p.getProperty("authpassword");
            this.nctx = new TSNamingContext();
            this.logProcessor = new LogFileProcessor(this.props);
            this.logProcessor.fetchLogs(this.contextId);
        }
        catch (Exception e) {
            this.logErr("Error: got exception: ", e);
        }
    }

    public void cleanup() throws EETest.Fault {
    }

    public void WildCardAuthConstraint() throws EETest.Fault {
        TSURL ctsurl = new TSURL();
        String url = ctsurl.getURLString("http", this.hostname, this.portnum, this.pageBase + this.accessToAllPage);
        try {
            String line;
            String header;
            URL newURL = new URL(url);
            String authData = this.authusername + ":" + this.authpassword;
            TestUtil.logMsg((String)("authData : " + authData));
            BASE64Encoder encoder = new BASE64Encoder();
            String encodedAuthData = encoder.encode(authData.getBytes());
            TestUtil.logMsg((String)("encoded authData : " + encodedAuthData));
            URLConnection urlConn = newURL.openConnection();
            urlConn.setRequestProperty("Authorization", "Basic " + encodedAuthData.trim());
            InputStream content = urlConn.getInputStream();
            String cookies = null;
            int i = 0;
            while ((header = urlConn.getHeaderField(i)) != null) {
                if (header.indexOf("JSESSIONIDSSO") != -1 || header.indexOf("JSESSIONID") != -1) {
                    cookies = this.addCookies(header, cookies);
                }
                ++i;
            }
            TestUtil.logMsg((String)("cookies received = " + cookies));
            BufferedReader in = new BufferedReader(new InputStreamReader(content));
            String output = "";
            while ((line = in.readLine()) != null) {
                output = output + line;
                TestUtil.logMsg((String)line);
            }
            String stringToSearch = this.authusername;
            if (output.indexOf(stringToSearch) == -1) {
                throw new EETest.Fault("AccessToAll.jsp: getRemoteUser(): - did not find \"" + stringToSearch + "\" in log.");
            }
            TestUtil.logMsg((String)"User javajoe accessed  AccessToAll.jsp");
            stringToSearch = "USR_IN_ROLE_ADM";
            if (output.indexOf(stringToSearch) == -1) {
                throw new EETest.Fault("AccessToAll.jsp: getRemoteUser(): - not mapped to role ADM");
            }
            TestUtil.logMsg((String)"User in Role ADM");
            stringToSearch = "USR_IN_ROLE_MGR";
            if (output.indexOf(stringToSearch) == -1) {
                throw new EETest.Fault("AccessToAll.jsp: getRemoteUser(): - not mapped to role MGR");
            }
            TestUtil.logMsg((String)"User in Role MGR");
            stringToSearch = "USR_IN_ROLE_EMP";
            if (output.indexOf(stringToSearch) == -1) {
                throw new EETest.Fault("AccessToAll.jsp: getRemoteUser(): - not mapped to role EMP");
            }
            TestUtil.logMsg((String)"User in Role EMP");
            stringToSearch = "USR_NOT_IN_ROLE_VP";
            if (output.indexOf(stringToSearch) == -1) {
                throw new EETest.Fault("AccessToAll.jsp: getRemoteUser(): - mapped to role VP");
            }
            TestUtil.logMsg((String)"User not in Role VP");
            stringToSearch = "USR_IN_ROLE_STARSTAR";
            if (output.indexOf(stringToSearch) != -1) {
                throw new EETest.Fault("anyauthuser.jsp: getRemoteUser() - incorrectly mapped to role named '**'");
            }
            TestUtil.logMsg((String)"User is correctly not in any Role named '**'");
        }
        catch (Exception e) {
            throw new EETest.Fault("Test WildCardAuthConstraint : FAILED", e);
        }
    }

    public void PermissionsToRole() throws EETest.Fault {
        TSURL ctsurl = new TSURL();
        String url = ctsurl.getURLString("http", this.hostname, this.portnum, this.pageBase + this.securedPage);
        try {
            String line;
            String header;
            URL newURL = new URL(url);
            String authData = this.authusername + ":" + this.authpassword;
            TestUtil.logMsg((String)("authData : " + authData));
            BASE64Encoder encoder = new BASE64Encoder();
            String encodedAuthData = encoder.encode(authData.getBytes());
            TestUtil.logMsg((String)("encoded authData : " + encodedAuthData));
            URLConnection urlConn = newURL.openConnection();
            urlConn.setRequestProperty("Authorization", "Basic " + encodedAuthData.trim());
            InputStream content = urlConn.getInputStream();
            String cookies = null;
            int i = 0;
            while ((header = urlConn.getHeaderField(i)) != null) {
                if (header.indexOf("JSESSIONIDSSO") != -1 || header.indexOf("JSESSIONID") != -1) {
                    cookies = this.addCookies(header, cookies);
                }
                ++i;
            }
            TestUtil.logMsg((String)("cookies received = " + cookies));
            BufferedReader in = new BufferedReader(new InputStreamReader(content));
            String output = "";
            while ((line = in.readLine()) != null) {
                output = output + line;
            }
            String stringToSearch = this.authusername;
            if (output.indexOf(stringToSearch) == -1) {
                throw new EETest.Fault("PermissionToRole: getRemoteUser(): - did not find \"" + stringToSearch + "\" in log.");
            }
            TestUtil.logMsg((String)"User javajoe accessed secured.jsp");
        }
        catch (Exception e) {
            throw new EETest.Fault("Test PermissionToRole : FAILED", e);
        }
    }

    public void anyAuthUserWebResPermAddedToRole() throws EETest.Fault {
        boolean bSuccess = false;
        try {
            String servletPath = this.pageBase + this.anyAuthUserPage;
            this.invokeServlet(servletPath, "POST");
            String searchStr = "MSG_TAG :: WebResourcePermission :: **";
            Collection col = this.logProcessor.getMsgTagRecordCollection();
            TestUtil.logMsg((String)("col.size() = " + col.size()));
            for (LogRecordEntry recordEntry : col) {
                String msg = recordEntry.getMessage();
                if (msg == null || !msg.startsWith(searchStr) || msg.indexOf("anyauthuser") <= 0) continue;
                bSuccess = true;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new EETest.Fault("Test anyAuthUserWebResPermAddedToRole : FAILED", ex);
        }
        if (!bSuccess) {
            throw new EETest.Fault("Test anyAuthUserWebResPermAddedToRole : FAILED");
        }
        TestUtil.logMsg((String)"Test anyAuthUserWebResPermAddedToRole Passed.");
    }

    private int invokeServlet(String sContext, String requestMethod) {
        int code = 200;
        TSURL ctsurl = new TSURL();
        if (!sContext.startsWith("/")) {
            sContext = "/" + sContext;
        }
        String url = ctsurl.getURLString("http", this.hostname, this.portnum, sContext);
        try {
            URL newURL = new URL(url);
            String authData = this.authusername + ":" + this.authpassword;
            TestUtil.logMsg((String)("authData : " + authData));
            BASE64Encoder encoder = new BASE64Encoder();
            String encodedAuthData = encoder.encode(authData.getBytes());
            TestUtil.logMsg((String)("encoded authData : " + encodedAuthData));
            HttpURLConnection conn = (HttpURLConnection)newURL.openConnection();
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setRequestProperty("Authorization", "Basic " + encodedAuthData.trim());
            conn.setRequestMethod(requestMethod);
            conn.connect();
            TestUtil.logMsg((String)("called HttpURLConnection.connect() for url: " + url));
            code = conn.getResponseCode();
            TestUtil.logMsg((String)("Got response code of: " + code));
            String str = conn.getResponseMessage();
            TestUtil.logMsg((String)("Got response string of: " + str));
        }
        catch (Exception e) {
            TestUtil.logMsg((String)("Abnormal return status encountered while invoking " + sContext));
            TestUtil.logMsg((String)("Exception Message was:  " + e.getMessage()));
            e.printStackTrace();
        }
        return code;
    }

    public String addCookies(String cookieHeader, String cookies) {
        String cookie;
        if (cookieHeader == null) {
            return null;
        }
        int j = cookieHeader.indexOf(";");
        if (j != -1) {
            String cValue = cookieHeader.substring(0, j);
            cookie = cValue.trim();
        } else {
            cookie = cookieHeader.trim();
        }
        cookies = cookies == null ? cookie : cookies + ";" + cookie;
        return cookies;
    }
}

