/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.tck.artifacts.chunkartifacts;

import com.ibm.jbatch.tck.artifacts.chunktypes.NumbersRecord;
import com.ibm.jbatch.tck.artifacts.reusable.MyParentException;
import com.sun.ts.lib.util.TestUtil;
import jakarta.batch.api.BatchProperty;
import jakarta.batch.api.chunk.ItemProcessor;
import jakarta.batch.runtime.context.StepContext;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.Properties;

@Named(value="retryProcessor")
public class RetryProcessor
implements ItemProcessor {
    @Inject
    StepContext stepCtx;
    @Inject
    @BatchProperty(name="forced.fail.count.process")
    String forcedFailCountProp;
    @Inject
    @BatchProperty(name="rollback")
    String rollbackProp;
    private static final int STATE_NORMAL = 0;
    private static final int STATE_RETRY = 1;
    private static final int STATE_SKIP = 2;
    private static final int STATE_EXCEPTION = 3;
    private int testState = 0;
    int failitem = 0;
    int count = 1;
    int forcedFailCount;
    boolean isInited = false;
    boolean rollback;
    int failindex = 0;

    public NumbersRecord processItem(Object record) throws Exception {
        int item = ((NumbersRecord)record).getItem();
        int quantity = ((NumbersRecord)record).getQuantity();
        TestUtil.logMsg((String)("Processing item: " + item + "...<br>"));
        TestUtil.logMsg((String)("Processing quantity: " + quantity + "...<p>"));
        if (!this.isInited) {
            this.forcedFailCount = Integer.parseInt(this.forcedFailCountProp);
            this.rollback = Boolean.parseBoolean(this.rollbackProp);
            this.isInited = true;
        }
        if (this.forcedFailCount != 0 && this.count >= this.forcedFailCount && this.testState == 0) {
            this.failindex = this.count;
            this.testState = 1;
            TestUtil.logMsg((String)"Fail on purpose in NumbersRecord.processItem<p>");
            throw new MyParentException("Fail on purpose in NumbersRecord.processItem()");
        }
        if (this.forcedFailCount != 0 && this.count >= this.forcedFailCount && this.testState == 3) {
            this.failindex = this.count;
            this.testState = 2;
            this.forcedFailCount = 0;
            TestUtil.logMsg((String)"Test skip -- Fail on purpose NumbersRecord.readItem<p>");
            throw new MyParentException("Test skip -- Fail on purpose in NumbersRecord.readItem()");
        }
        if (this.testState == 1) {
            if (((Properties)this.stepCtx.getTransientUserData()).getProperty("retry.process.exception.invoked") != "true") {
                TestUtil.logMsg((String)"onRetryProcessException not invoked<p>");
                throw new Exception("onRetryProcessException not invoked");
            }
            TestUtil.logMsg((String)"onRetryProcessException was invoked<p>");
            if (((Properties)this.stepCtx.getTransientUserData()).getProperty("retry.process.exception.match") != "true") {
                TestUtil.logMsg((String)"retryable exception does not match<p>");
                throw new Exception("retryable exception does not match");
            }
            TestUtil.logMsg((String)"retryable exception matches<p>");
            this.testState = 3;
        } else if (this.testState == 2) {
            if (((Properties)this.stepCtx.getTransientUserData()).getProperty("skip.process.item.invoked") != "true") {
                TestUtil.logMsg((String)"onSkipProcessItem not invoked<p>");
                throw new Exception("onSkipProcessItem not invoked");
            }
            TestUtil.logMsg((String)"onSkipProcessItem was invoked<p>");
            if (((Properties)this.stepCtx.getTransientUserData()).getProperty("skip.process.item.match") != "true") {
                TestUtil.logMsg((String)"skippable exception does not match<p>");
                throw new Exception("skippable exception does not match");
            }
            TestUtil.logMsg((String)"skippable exception matches<p>");
            this.testState = 0;
        }
        TestUtil.logMsg((String)("Process [item: " + item + " -- new quantity: " + ++quantity + "]<p>"));
        ++this.count;
        return new NumbersRecord(item, quantity);
    }
}

