/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.tck.tests.jslxml;

import com.ibm.jbatch.tck.artifacts.common.StatusConstants;
import com.ibm.jbatch.tck.utils.AssertionUtils;
import com.ibm.jbatch.tck.utils.JobOperatorBridge;
import com.ibm.jbatch.tck.utils.TCKJobExecutionWrapper;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.util.TestUtil;
import jakarta.batch.operations.JobStartException;
import jakarta.batch.runtime.BatchStatus;
import java.util.Properties;
import java.util.logging.Logger;

public class DeciderTests
extends ServiceEETest
implements StatusConstants {
    private static final Logger logger = Logger.getLogger(DeciderTests.class.getName());
    private static JobOperatorBridge jobOp = null;
    private static final String FORCE_STOP_EXITSTATUS = "STEP_COMPLETE_BUT_FORCE_JOB_STOPPED_STATUS";
    private static final String FORCE_FAIL_EXITSTATUS = "STEP_COMPLETE_BUT_FORCE_JOB_FAILED_STATUS";

    public static void setup(String[] args, Properties props) throws EETest.Fault {
        String METHOD = "setup";
        TestUtil.logTrace((String)METHOD);
        try {
            jobOp = new JobOperatorBridge();
        }
        catch (Exception e) {
            DeciderTests.handleException(METHOD, e);
        }
    }

    public static void setUp() throws EETest.Fault {
        jobOp = new JobOperatorBridge();
    }

    public void cleanup() {
    }

    public void testDeciderEndNormal() throws EETest.Fault {
        String METHOD = "testDeciderEndNormal";
        TestUtil.logTrace((String)METHOD);
        try {
            TestUtil.logMsg((String)"Build job parameters for EndSpecial exit status");
            Properties jobParameters = new Properties();
            TestUtil.logMsg((String)"Set job parameters property action with value EndNormal");
            jobParameters.setProperty("action", "EndNormal");
            TestUtil.logMsg((String)"Set job parameters property actualValue with value 21");
            jobParameters.setProperty("actualValue", "21");
            TestUtil.logMsg((String)"Set job parameters property SpecialExitStatus with value EndSpecial");
            jobParameters.setProperty("SpecialExitStatus", "EndSpecial");
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("job_decider_incompleterun", jobParameters);
            TestUtil.logMsg((String)"Expected JobExecution getExitStatus()=EndNormal");
            TestUtil.logMsg((String)("Actual JobExecution getExitStatus()=" + jobExec.getExitStatus()));
            TestUtil.logMsg((String)"Expected JobExecution getStatus()=COMPLETED");
            TestUtil.logMsg((String)("Actual JobExecution getStatus()=" + jobExec.getBatchStatus()));
            AssertionUtils.assertObjEquals("EndNormal", jobExec.getExitStatus());
            AssertionUtils.assertObjEquals(BatchStatus.COMPLETED, jobExec.getBatchStatus());
        }
        catch (Exception e) {
            DeciderTests.handleException(METHOD, e);
        }
    }

    public void testDeciderEndSpecial() throws EETest.Fault {
        String METHOD = "testDeciderEndSpecial";
        TestUtil.logTrace((String)METHOD);
        try {
            TestUtil.logMsg((String)"Build job parameters for EndSpecial exit status");
            Properties jobParameters = new Properties();
            jobParameters.setProperty("action", "EndNormal");
            TestUtil.logMsg((String)"Set job parameters property action with value EndNormal");
            TestUtil.logMsg((String)"Set job parameters property actualValue with value 25");
            jobParameters.setProperty("actualValue", "25");
            TestUtil.logMsg((String)"Set job parameters property SpecialExitStatus with value EndSpecial");
            jobParameters.setProperty("SpecialExitStatus", "EndSpecial");
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("job_decider_incompleterun", jobParameters);
            TestUtil.logMsg((String)"Expected JobExecution getExitStatus()=EndSpecial");
            TestUtil.logMsg((String)("Actual JobExecution getExitStatus()=" + jobExec.getExitStatus()));
            TestUtil.logMsg((String)"Expected JobExecution getBatchStatus()=COMPLETED");
            TestUtil.logMsg((String)("Actual JobExecution getBatchStatus()=" + jobExec.getBatchStatus()));
            AssertionUtils.assertObjEquals("EndSpecial", jobExec.getExitStatus());
            AssertionUtils.assertObjEquals(BatchStatus.COMPLETED, jobExec.getBatchStatus());
        }
        catch (Exception e) {
            DeciderTests.handleException(METHOD, e);
        }
    }

    public void testDeciderStopNormal() throws EETest.Fault {
        String METHOD = " testDeciderStopNormal";
        TestUtil.logTrace((String)METHOD);
        try {
            TestUtil.logMsg((String)"Build job parameters for StopSpecial exit status");
            Properties jobParameters = new Properties();
            TestUtil.logMsg((String)"Set job parameters property action with value StopNormal");
            jobParameters.setProperty("action", "StopNormal");
            TestUtil.logMsg((String)"Set job parameters property actualValue with value 21");
            jobParameters.setProperty("actualValue", "21");
            TestUtil.logMsg((String)"Set job parameters property SpecialExitStatus with value StopSpecial");
            jobParameters.setProperty("SpecialExitStatus", "StopSpecial");
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("job_decider_incompleterun", jobParameters);
            TestUtil.logMsg((String)"Expected JobExecution getExitStatus()=StopNormal");
            TestUtil.logMsg((String)("Actual JobExecution getExitStatus()=" + jobExec.getExitStatus()));
            TestUtil.logMsg((String)"Expected JobExecution getBatchStatus()=STOPPED");
            TestUtil.logMsg((String)("Actual JobExecution getBatchStatus()=" + jobExec.getBatchStatus()));
            AssertionUtils.assertObjEquals("StopNormal", jobExec.getExitStatus());
            AssertionUtils.assertObjEquals(BatchStatus.STOPPED, jobExec.getBatchStatus());
        }
        catch (Exception e) {
            DeciderTests.handleException(METHOD, e);
        }
    }

    public void testDeciderStopSpecial() throws EETest.Fault {
        String METHOD = "testDeciderStopSpecial";
        TestUtil.logTrace((String)METHOD);
        try {
            TestUtil.logMsg((String)"Build job parameters for StopSpecial exit status");
            Properties jobParameters = new Properties();
            TestUtil.logMsg((String)"Set job parameters property action with value StopNormal");
            jobParameters.setProperty("action", "StopNormal");
            TestUtil.logMsg((String)"Set job parameters property actualValue with value 25");
            jobParameters.setProperty("actualValue", "25");
            TestUtil.logMsg((String)"Set job parameters property SpecialExitStatus with value StopSpecial");
            jobParameters.setProperty("SpecialExitStatus", "StopSpecial");
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("job_decider_incompleterun", jobParameters);
            TestUtil.logMsg((String)"Expected JobExecution getExitStatus()=StopSpecial");
            TestUtil.logMsg((String)("Actual JobExecution getExitStatus()=" + jobExec.getExitStatus()));
            TestUtil.logMsg((String)"Expected JobExecution getBatchStatus()=STOPPED");
            TestUtil.logMsg((String)("Actual JobExecution getBatchStatus()=" + jobExec.getBatchStatus()));
            AssertionUtils.assertObjEquals("StopSpecial", jobExec.getExitStatus());
            AssertionUtils.assertObjEquals(BatchStatus.STOPPED, jobExec.getBatchStatus());
        }
        catch (Exception e) {
            DeciderTests.handleException(METHOD, e);
        }
    }

    public void testDeciderFailNormal() throws EETest.Fault {
        String METHOD = "testDeciderFailNormal";
        TestUtil.logTrace((String)METHOD);
        try {
            TestUtil.logMsg((String)"Build job parameters for FailSpecial exit status");
            Properties jobParameters = new Properties();
            TestUtil.logMsg((String)"Set job parameters property action with value FailNormal");
            jobParameters.setProperty("action", "FailNormal");
            TestUtil.logMsg((String)"Set job parameters property actualValue with value 21");
            jobParameters.setProperty("actualValue", "21");
            TestUtil.logMsg((String)"Set job parameters property SpecialExitStatus with value FailSpecial");
            jobParameters.setProperty("SpecialExitStatus", "FailSpecial");
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("job_decider_incompleterun", jobParameters);
            TestUtil.logMsg((String)"Expected JobExecution getExitStatus()=FailNormal");
            TestUtil.logMsg((String)("Actual JobExecution getExitStatus()=" + jobExec.getExitStatus()));
            TestUtil.logMsg((String)"Expected JobExecution getBatchStatus()=FAILED");
            TestUtil.logMsg((String)("Actual JobExecution getBatchStatus()=" + jobExec.getBatchStatus()));
            AssertionUtils.assertObjEquals("FailNormal", jobExec.getExitStatus());
            AssertionUtils.assertObjEquals(BatchStatus.FAILED, jobExec.getBatchStatus());
        }
        catch (Exception e) {
            DeciderTests.handleException(METHOD, e);
        }
    }

    public void testDeciderFailSpecial() throws EETest.Fault {
        String METHOD = "testDeciderFailSpecial";
        TestUtil.logTrace((String)METHOD);
        try {
            TestUtil.logMsg((String)"Build job parameters for FailSpecial exit status");
            Properties jobParameters = new Properties();
            TestUtil.logMsg((String)"Set job parameters property action with value FailNormal");
            jobParameters.setProperty("action", "FailNormal");
            TestUtil.logMsg((String)"Set job parameters property actualValue with value 25");
            jobParameters.setProperty("actualValue", "25");
            TestUtil.logMsg((String)"Set job parameters property SpecialExitStatus with value FailSpecial");
            jobParameters.setProperty("SpecialExitStatus", "FailSpecial");
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("job_decider_incompleterun", jobParameters);
            TestUtil.logMsg((String)"Expected JobExecution getExitStatus()=FailSpecial");
            TestUtil.logMsg((String)("Actual JobExecution getExitStatus()=" + jobExec.getExitStatus()));
            TestUtil.logMsg((String)"Expected JobExecution getBatchStatus()=FAILED");
            TestUtil.logMsg((String)("Actual JobExecution getBatchStatus()=" + jobExec.getBatchStatus()));
            AssertionUtils.assertObjEquals("FailSpecial", jobExec.getExitStatus());
            AssertionUtils.assertObjEquals(BatchStatus.FAILED, jobExec.getBatchStatus());
        }
        catch (Exception e) {
            DeciderTests.handleException(METHOD, e);
        }
    }

    public void testDeciderNextNormal() throws EETest.Fault {
        String METHOD = "testDeciderNextNormal";
        TestUtil.logTrace((String)METHOD);
        try {
            TestUtil.logMsg((String)"Build job parameters for NextSpecial exit status");
            Properties jobParameters = new Properties();
            TestUtil.logMsg((String)"Set job parameters property action with value NextNormal");
            jobParameters.setProperty("action", "NextNormal");
            TestUtil.logMsg((String)"Set job parameters property actualValue with value 21");
            jobParameters.setProperty("actualValue", "21");
            TestUtil.logMsg((String)"Set job parameters property SpecialExitStatus with value NextSpecial");
            jobParameters.setProperty("SpecialExitStatus", "NextSpecial");
            TestUtil.logMsg((String)"Create single job listener deciderTestJobListener and get JSL");
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("job_decider_completerun", jobParameters);
            TestUtil.logMsg((String)"Expected JobExecution getExitStatus()=JOB:ES:Good");
            TestUtil.logMsg((String)("Actual JobExecution getExitStatus()=" + jobExec.getExitStatus()));
            TestUtil.logMsg((String)"Expected JobExecution getBatchStatus()=COMPLETED");
            TestUtil.logMsg((String)("Actual JobExecution getBatchStatus()=" + jobExec.getBatchStatus()));
            AssertionUtils.assertObjEquals("JOB:ES:Good", jobExec.getExitStatus());
            AssertionUtils.assertObjEquals(BatchStatus.COMPLETED, jobExec.getBatchStatus());
        }
        catch (Exception e) {
            DeciderTests.handleException(METHOD, e);
        }
    }

    public void testDeciderNextSpecial() throws EETest.Fault {
        String METHOD = "testDeciderNextSpecial";
        TestUtil.logTrace((String)METHOD);
        try {
            TestUtil.logMsg((String)"Build job parameters for NextSpecial exit status");
            Properties jobParameters = new Properties();
            TestUtil.logMsg((String)"Set job parameters property action with value NextNormal");
            jobParameters.setProperty("action", "NextNormal");
            TestUtil.logMsg((String)"Set job parameters property actualValue with value 25");
            jobParameters.setProperty("actualValue", "25");
            TestUtil.logMsg((String)"Set job parameters property SpecialExitStatus with value NextSpecial");
            jobParameters.setProperty("SpecialExitStatus", "NextSpecial");
            TestUtil.logMsg((String)"Create single job listener deciderTestJobListener and get JSL");
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("job_decider_completerun", jobParameters);
            TestUtil.logMsg((String)"Expected JobExecution getExitStatus()=JOB:ES:Good");
            TestUtil.logMsg((String)("Actual JobExecution getExitStatus()=" + jobExec.getExitStatus()));
            TestUtil.logMsg((String)"Expected JobExecution getBatchStatus()=COMPLETED");
            TestUtil.logMsg((String)("Actual JobExecution getBatchStatus()=" + jobExec.getBatchStatus()));
            AssertionUtils.assertObjEquals("JOB:ES:Good", jobExec.getExitStatus());
            AssertionUtils.assertObjEquals(BatchStatus.COMPLETED, jobExec.getBatchStatus());
        }
        catch (Exception e) {
            DeciderTests.handleException(METHOD, e);
        }
    }

    public void testDeciderExitStatusIsSetOnJobContext() throws EETest.Fault {
        String METHOD = "testDeciderExitStatusIsSetOnJobContext";
        TestUtil.logTrace((String)METHOD);
        try {
            TestUtil.logMsg((String)"Build job parameters.");
            Properties jobParameters = new Properties();
            jobParameters.setProperty("step.complete.but.force.job.stopped.status", FORCE_STOP_EXITSTATUS);
            jobParameters.setProperty("step.complete.but.force.job.failed.status", FORCE_FAIL_EXITSTATUS);
            jobParameters.setProperty("allow.start.if.complete", "true");
            jobParameters.setProperty("stop.job.after.this.step", "None");
            jobParameters.setProperty("fail.job.after.this.step", "step1");
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("decider_transitions_on_restart", jobParameters);
            AssertionUtils.assertObjEquals(BatchStatus.FAILED, jobExec.getBatchStatus());
            AssertionUtils.assertObjEquals("1:STEP_COMPLETE_BUT_FORCE_JOB_FAILED_STATUS", jobExec.getExitStatus());
        }
        catch (Exception e) {
            DeciderTests.handleException(METHOD, e);
        }
    }

    public void testDeciderCannotbeFirstElementOnStart() throws EETest.Fault {
        String METHOD = "testDeciderCannotbeFirstElementOnStart";
        TestUtil.logTrace((String)METHOD);
        try {
            boolean seenException = false;
            TCKJobExecutionWrapper jobExec = null;
            try {
                jobExec = jobOp.startJobAndWaitForResult("decider_as_first_job_element_fails");
            }
            catch (JobStartException e) {
                TestUtil.logMsg((String)("Caught JobStartException:  " + e.getLocalizedMessage()));
                seenException = true;
            }
            if (!seenException) {
                TestUtil.logMsg((String)("Didn't catch JobStartException, Job Batch Status = " + jobExec.getBatchStatus()));
                AssertionUtils.assertWithMessage("Job should have failed because of decision as first execution element.", BatchStatus.FAILED, jobExec.getBatchStatus());
            }
        }
        catch (Exception e) {
            DeciderTests.handleException(METHOD, e);
        }
    }

    public void testDeciderTransitionFromStepAndAllowRestart() throws EETest.Fault {
        String METHOD = "testDeciderTransitionFromStepAndAllowRestart";
        TestUtil.logTrace((String)METHOD);
        try {
            TestUtil.logMsg((String)"Build job parameters.");
            Properties jobParameters = new Properties();
            jobParameters.setProperty("step.complete.but.force.job.stopped.status", FORCE_STOP_EXITSTATUS);
            jobParameters.setProperty("step.complete.but.force.job.failed.status", FORCE_FAIL_EXITSTATUS);
            jobParameters.setProperty("allow.start.if.complete", "true");
            jobParameters.setProperty("stop.job.after.this.step", "step1");
            jobParameters.setProperty("fail.job.after.this.step", "None");
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("decider_transitions_on_restart", jobParameters);
            AssertionUtils.assertObjEquals(BatchStatus.STOPPED, jobExec.getBatchStatus());
            AssertionUtils.assertObjEquals("1:STEP_COMPLETE_BUT_FORCE_JOB_STOPPED_STATUS", jobExec.getExitStatus());
            Properties restartJobParameters = new Properties(jobParameters);
            restartJobParameters.setProperty("stop.job.after.this.step", "None");
            TestUtil.logMsg((String)"Invoke restartJobAndWaitForResult");
            TCKJobExecutionWrapper jobExec2 = jobOp.restartJobAndWaitForResult(jobExec.getExecutionId(), restartJobParameters);
            AssertionUtils.assertObjEquals("3:flow1step2_CONTINUE", jobExec2.getExitStatus());
            AssertionUtils.assertObjEquals(BatchStatus.COMPLETED, jobExec2.getBatchStatus());
        }
        catch (Exception e) {
            DeciderTests.handleException(METHOD, e);
        }
    }

    public void testDeciderTransitionFromStepWithinFlowAndAllowRestart() throws EETest.Fault {
        String METHOD = "testDeciderTransitionFromStepWithinFlowAndAllowRestart";
        TestUtil.logTrace((String)METHOD);
        try {
            TestUtil.logMsg((String)"Build job parameters.");
            Properties jobParameters = new Properties();
            jobParameters.setProperty("step.complete.but.force.job.stopped.status", FORCE_STOP_EXITSTATUS);
            jobParameters.setProperty("step.complete.but.force.job.failed.status", FORCE_FAIL_EXITSTATUS);
            jobParameters.setProperty("allow.start.if.complete", "true");
            jobParameters.setProperty("stop.job.after.this.step", "flow1step1");
            jobParameters.setProperty("fail.job.after.this.step", "None");
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("decider_transitions_on_restart", jobParameters);
            AssertionUtils.assertObjEquals(BatchStatus.STOPPED, jobExec.getBatchStatus());
            AssertionUtils.assertObjEquals("2:STEP_COMPLETE_BUT_FORCE_JOB_STOPPED_STATUS", jobExec.getExitStatus());
            Properties restartJobParameters = new Properties(jobParameters);
            restartJobParameters.setProperty("stop.job.after.this.step", "None");
            TestUtil.logMsg((String)"Invoke restartJobAndWaitForResult");
            TCKJobExecutionWrapper jobExec2 = jobOp.restartJobAndWaitForResult(jobExec.getExecutionId(), restartJobParameters);
            AssertionUtils.assertObjEquals("3:flow1step2_CONTINUE", jobExec2.getExitStatus());
            AssertionUtils.assertObjEquals(BatchStatus.COMPLETED, jobExec2.getBatchStatus());
        }
        catch (Exception e) {
            DeciderTests.handleException(METHOD, e);
        }
    }

    public void testDeciderTransitionFromFlowAndAllowRestart() throws EETest.Fault {
        String METHOD = "testDeciderTransitionFromFlowAndAllowRestart";
        TestUtil.logTrace((String)METHOD);
        try {
            TestUtil.logMsg((String)"Build job parameters.");
            Properties jobParameters = new Properties();
            jobParameters.setProperty("step.complete.but.force.job.stopped.status", FORCE_STOP_EXITSTATUS);
            jobParameters.setProperty("step.complete.but.force.job.failed.status", FORCE_FAIL_EXITSTATUS);
            jobParameters.setProperty("allow.start.if.complete", "true");
            jobParameters.setProperty("stop.job.after.this.step", "flow1step2");
            jobParameters.setProperty("fail.job.after.this.step", "None");
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("decider_transitions_on_restart", jobParameters);
            AssertionUtils.assertObjEquals(BatchStatus.STOPPED, jobExec.getBatchStatus());
            AssertionUtils.assertObjEquals("3:STEP_COMPLETE_BUT_FORCE_JOB_STOPPED_STATUS", jobExec.getExitStatus());
            Properties restartJobParameters = new Properties(jobParameters);
            restartJobParameters.setProperty("stop.job.after.this.step", "None");
            TestUtil.logMsg((String)"Invoke restartJobAndWaitForResult");
            TCKJobExecutionWrapper jobExec2 = jobOp.restartJobAndWaitForResult(jobExec.getExecutionId(), restartJobParameters);
            AssertionUtils.assertObjEquals("3:flow1step2_CONTINUE", jobExec2.getExitStatus());
            AssertionUtils.assertObjEquals(BatchStatus.COMPLETED, jobExec2.getBatchStatus());
        }
        catch (Exception e) {
            DeciderTests.handleException(METHOD, e);
        }
    }

    public void testDeciderTransitionFromSplitAndAllowRestart() throws EETest.Fault {
        String METHOD = "testDeciderTransitionFromSplitAndAllowRestart";
        TestUtil.logTrace((String)METHOD);
        try {
            TestUtil.logMsg((String)"Build job parameters.");
            Properties jobParameters = new Properties();
            jobParameters.setProperty("step.complete.but.force.job.stopped.status", FORCE_STOP_EXITSTATUS);
            jobParameters.setProperty("step.complete.but.force.job.failed.status", FORCE_FAIL_EXITSTATUS);
            jobParameters.setProperty("allow.start.if.complete", "true");
            jobParameters.setProperty("stop.job.after.this.step", "split1flow1step2");
            jobParameters.setProperty("stop.job.after.this.step2", "split1flow2step2");
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("decider_transitions_from_split_on_restart", jobParameters);
            AssertionUtils.assertObjEquals(BatchStatus.STOPPED, jobExec.getBatchStatus());
            AssertionUtils.assertObjEquals("4:STEP_COMPLETE_BUT_FORCE_JOB_STOPPED_STATUS", jobExec.getExitStatus());
            Properties restartJobParameters = new Properties(jobParameters);
            restartJobParameters.setProperty("stop.job.after.this.step", "None");
            jobParameters.setProperty("stop.job.after.this.step2", "None");
            TestUtil.logMsg((String)"Invoke restartJobAndWaitForResult");
            TCKJobExecutionWrapper jobExec2 = jobOp.restartJobAndWaitForResult(jobExec.getExecutionId(), restartJobParameters);
            AssertionUtils.assertObjEquals("4:split1flow2step2_CONTINUE", jobExec2.getExitStatus());
            AssertionUtils.assertObjEquals(BatchStatus.COMPLETED, jobExec2.getBatchStatus());
        }
        catch (Exception e) {
            DeciderTests.handleException(METHOD, e);
        }
    }

    public void testDeciderTransitionFromStepAndAllowRestartFalse() throws EETest.Fault {
        String METHOD = "testDeciderTransitionFromStepAndAllowRestartFalse";
        TestUtil.logTrace((String)METHOD);
        try {
            TestUtil.logMsg((String)"Build job parameters.");
            Properties jobParameters = new Properties();
            jobParameters.setProperty("step.complete.but.force.job.stopped.status", FORCE_STOP_EXITSTATUS);
            jobParameters.setProperty("step.complete.but.force.job.failed.status", FORCE_FAIL_EXITSTATUS);
            jobParameters.setProperty("allow.start.if.complete", "false");
            jobParameters.setProperty("stop.job.after.this.step", "step1");
            jobParameters.setProperty("fail.job.after.this.step", "None");
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("decider_transitions_on_restart", jobParameters);
            AssertionUtils.assertObjEquals(BatchStatus.STOPPED, jobExec.getBatchStatus());
            AssertionUtils.assertObjEquals("1:STEP_COMPLETE_BUT_FORCE_JOB_STOPPED_STATUS", jobExec.getExitStatus());
            Properties restartJobParameters = new Properties(jobParameters);
            restartJobParameters.setProperty("stop.job.after.this.step", "None");
            restartJobParameters.setProperty("is.restart", "true");
            TestUtil.logMsg((String)"Invoke restartJobAndWaitForResult");
            TCKJobExecutionWrapper jobExec2 = jobOp.restartJobAndWaitForResult(jobExec.getExecutionId(), restartJobParameters);
            AssertionUtils.assertObjEquals("3:flow1step2_CONTINUE", jobExec2.getExitStatus());
            AssertionUtils.assertObjEquals(BatchStatus.COMPLETED, jobExec2.getBatchStatus());
        }
        catch (Exception e) {
            DeciderTests.handleException(METHOD, e);
        }
    }

    public void testDeciderTransitionFromStepWithinFlowAndAllowRestartFalse() throws EETest.Fault {
        String METHOD = "testDeciderTransitionFromStepWithinFlowAndAllowRestartFalse";
        TestUtil.logTrace((String)METHOD);
        try {
            TestUtil.logMsg((String)"Build job parameters.");
            Properties jobParameters = new Properties();
            jobParameters.setProperty("step.complete.but.force.job.stopped.status", FORCE_STOP_EXITSTATUS);
            jobParameters.setProperty("step.complete.but.force.job.failed.status", FORCE_FAIL_EXITSTATUS);
            jobParameters.setProperty("allow.start.if.complete", "false");
            jobParameters.setProperty("stop.job.after.this.step", "flow1step1");
            jobParameters.setProperty("fail.job.after.this.step", "None");
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("decider_transitions_on_restart", jobParameters);
            AssertionUtils.assertObjEquals(BatchStatus.STOPPED, jobExec.getBatchStatus());
            AssertionUtils.assertObjEquals("2:STEP_COMPLETE_BUT_FORCE_JOB_STOPPED_STATUS", jobExec.getExitStatus());
            Properties restartJobParameters = new Properties(jobParameters);
            restartJobParameters.setProperty("stop.job.after.this.step", "None");
            restartJobParameters.setProperty("is.restart", "true");
            TestUtil.logMsg((String)"Invoke restartJobAndWaitForResult");
            TCKJobExecutionWrapper jobExec2 = jobOp.restartJobAndWaitForResult(jobExec.getExecutionId(), restartJobParameters);
            AssertionUtils.assertObjEquals("3:flow1step2_CONTINUE", jobExec2.getExitStatus());
            AssertionUtils.assertObjEquals(BatchStatus.COMPLETED, jobExec2.getBatchStatus());
        }
        catch (Exception e) {
            DeciderTests.handleException(METHOD, e);
        }
    }

    public void testDeciderTransitionFromFlowAndAllowRestartFalse() throws EETest.Fault {
        String METHOD = "testDeciderTransitionFromFlowAndAllowRestartFalse";
        TestUtil.logTrace((String)METHOD);
        try {
            TestUtil.logMsg((String)"Build job parameters.");
            Properties jobParameters = new Properties();
            jobParameters.setProperty("step.complete.but.force.job.stopped.status", FORCE_STOP_EXITSTATUS);
            jobParameters.setProperty("step.complete.but.force.job.failed.status", FORCE_FAIL_EXITSTATUS);
            jobParameters.setProperty("allow.start.if.complete", "false");
            jobParameters.setProperty("stop.job.after.this.step", "flow1step2");
            jobParameters.setProperty("fail.job.after.this.step", "None");
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("decider_transitions_on_restart", jobParameters);
            AssertionUtils.assertObjEquals(BatchStatus.STOPPED, jobExec.getBatchStatus());
            AssertionUtils.assertObjEquals("3:STEP_COMPLETE_BUT_FORCE_JOB_STOPPED_STATUS", jobExec.getExitStatus());
            Properties restartJobParameters = new Properties(jobParameters);
            restartJobParameters.setProperty("stop.job.after.this.step", "None");
            restartJobParameters.setProperty("is.restart", "true");
            TestUtil.logMsg((String)"Invoke restartJobAndWaitForResult");
            TCKJobExecutionWrapper jobExec2 = jobOp.restartJobAndWaitForResult(jobExec.getExecutionId(), restartJobParameters);
            AssertionUtils.assertObjEquals("3:flow1step2_CONTINUE", jobExec2.getExitStatus());
            AssertionUtils.assertObjEquals(BatchStatus.COMPLETED, jobExec2.getBatchStatus());
        }
        catch (Exception e) {
            DeciderTests.handleException(METHOD, e);
        }
    }

    public void testDeciderTransitionFromSplitAndAllowRestartFalse() throws EETest.Fault {
        String METHOD = "testDeciderTransitionFromSplitAndAllowRestartFalse";
        TestUtil.logTrace((String)METHOD);
        try {
            TestUtil.logMsg((String)"Build job parameters.");
            Properties jobParameters = new Properties();
            jobParameters.setProperty("step.complete.but.force.job.stopped.status", FORCE_STOP_EXITSTATUS);
            jobParameters.setProperty("step.complete.but.force.job.failed.status", FORCE_FAIL_EXITSTATUS);
            jobParameters.setProperty("allow.start.if.complete", "false");
            jobParameters.setProperty("stop.job.after.this.step", "split1flow1step2");
            jobParameters.setProperty("stop.job.after.this.step2", "split1flow2step2");
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("decider_transitions_from_split_on_restart", jobParameters);
            AssertionUtils.assertObjEquals(BatchStatus.STOPPED, jobExec.getBatchStatus());
            AssertionUtils.assertObjEquals("4:STEP_COMPLETE_BUT_FORCE_JOB_STOPPED_STATUS", jobExec.getExitStatus());
            Properties restartJobParameters = new Properties(jobParameters);
            restartJobParameters.setProperty("stop.job.after.this.step", "None");
            restartJobParameters.setProperty("is.restart", "true");
            TestUtil.logMsg((String)"Invoke restartJobAndWaitForResult");
            TCKJobExecutionWrapper jobExec2 = jobOp.restartJobAndWaitForResult(jobExec.getExecutionId(), restartJobParameters);
            AssertionUtils.assertObjEquals("4:split1flow2step2_CONTINUE", jobExec2.getExitStatus());
            AssertionUtils.assertObjEquals(BatchStatus.COMPLETED, jobExec2.getBatchStatus());
        }
        catch (Exception e) {
            DeciderTests.handleException(METHOD, e);
        }
    }

    private static void handleException(String methodName, Exception e) throws EETest.Fault {
        TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
        TestUtil.printStackTrace((Throwable)e);
        throw new EETest.Fault(methodName + " failed", e);
    }
}

