/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.tck.tests.jslxml;

import com.ibm.jbatch.tck.utils.AssertionUtils;
import com.ibm.jbatch.tck.utils.JobOperatorBridge;
import com.ibm.jbatch.tck.utils.TCKJobExecutionWrapper;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.util.TestUtil;
import jakarta.batch.runtime.BatchStatus;
import jakarta.batch.runtime.Metric;
import jakarta.batch.runtime.StepExecution;
import java.util.Date;
import java.util.List;
import java.util.Properties;

public class MetricsTests
extends ServiceEETest {
    private static JobOperatorBridge jobOp = null;

    public static void setup(String[] args, Properties props) throws EETest.Fault {
        String METHOD = "setup";
        TestUtil.logTrace((String)METHOD);
        try {
            jobOp = new JobOperatorBridge();
        }
        catch (Exception e) {
            MetricsTests.handleException(METHOD, e);
        }
    }

    public static void setUp() throws EETest.Fault {
        jobOp = new JobOperatorBridge();
    }

    public void cleanup() {
    }

    public void testMetricsInApp() throws EETest.Fault {
        String METHOD = "testMetricsInApp";
        TestUtil.logTrace((String)METHOD);
        try {
            TestUtil.logMsg((String)"Create job parameters for execution #1:");
            Properties jobParams = new Properties();
            TestUtil.logMsg((String)"execution.number=1");
            TestUtil.logMsg((String)"readrecord.fail=40");
            TestUtil.logMsg((String)"app.arraysize=30");
            TestUtil.logMsg((String)"app.chunksize=7");
            TestUtil.logMsg((String)"app.commitinterval=10");
            TestUtil.logMsg((String)"numberOfSkips=0");
            TestUtil.logMsg((String)"ReadProcessWrite=READ");
            jobParams.put("execution.number", "1");
            jobParams.put("readrecord.fail", "40");
            jobParams.put("app.arraysize", "30");
            jobParams.put("app.chunksize", "7");
            jobParams.put("app.commitinterval", "10");
            jobParams.put("numberOfSkips", "0");
            jobParams.put("ReadProcessWrite", "READ");
            jobParams.put("app.writepoints", "0,7,14,21,28,30");
            jobParams.put("app.next.writepoints", "7,14,21,28,30");
            TestUtil.logMsg((String)"Locate job XML file: testChunkMetrics.xml");
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult for execution #1");
            TCKJobExecutionWrapper execution1 = jobOp.startJobAndWaitForResult("testChunkMetrics", jobParams);
            TestUtil.logMsg((String)("execution #1 JobExecution getBatchStatus()=" + execution1.getBatchStatus() + ""));
            TestUtil.logMsg((String)("execution #1 JobExecution getExitStatus()=" + execution1.getExitStatus() + ""));
            AssertionUtils.assertWithMessage("Testing execution #1", BatchStatus.COMPLETED, execution1.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing metrics", "GOOD READ METRICS RESULT", execution1.getExitStatus());
        }
        catch (Exception e) {
            MetricsTests.handleException(METHOD, e);
        }
    }

    public void testMetricsSkipRead() throws EETest.Fault {
        String METHOD = "testMetricsSkipRead";
        TestUtil.logTrace((String)METHOD);
        try {
            TestUtil.logMsg((String)"Create job parameters for execution #1:");
            Properties jobParams = new Properties();
            TestUtil.logMsg((String)"execution.number=1");
            TestUtil.logMsg((String)"readrecord.fail=1,3");
            TestUtil.logMsg((String)"app.arraysize=30");
            TestUtil.logMsg((String)"numberOfSkips=2");
            TestUtil.logMsg((String)"ReadProcessWrite=READ_SKIP");
            jobParams.put("execution.number", "1");
            jobParams.put("readrecord.fail", "1,3,4,12");
            jobParams.put("app.arraysize", "30");
            jobParams.put("numberOfSkips", "4");
            jobParams.put("ReadProcessWrite", "READ_SKIP");
            TestUtil.logMsg((String)"Locate job XML file: testMetricsSkipCount.xml");
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult for execution #1");
            TCKJobExecutionWrapper execution1 = jobOp.startJobAndWaitForResult("testMetricsSkipCount", jobParams);
            TestUtil.logMsg((String)("execution #1 JobExecution getBatchStatus()=" + execution1.getBatchStatus() + ""));
            TestUtil.logMsg((String)("execution #1 JobExecution getExitStatus()=" + execution1.getExitStatus() + ""));
            AssertionUtils.assertWithMessage("Testing execution #1", BatchStatus.COMPLETED, execution1.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #1", "GOOD READ METRICS RESULT", execution1.getExitStatus());
            List<StepExecution> stepExecutions = jobOp.getStepExecutions(execution1.getExecutionId());
            StepExecution step = null;
            String stepNameTest = "step1";
            for (StepExecution stepEx : stepExecutions) {
                if (!stepNameTest.equals(stepEx.getStepName())) continue;
                step = stepEx;
            }
            TestUtil.logMsg((String)("execution #1 JobExecution getBatchStatus()=" + execution1.getBatchStatus() + ""));
            AssertionUtils.assertWithMessage("Testing execution #1", BatchStatus.COMPLETED, execution1.getBatchStatus());
            Metric[] metrics = step.getMetrics();
            TestUtil.logMsg((String)"Testing the read count for execution #1");
            for (int i = 0; i < metrics.length; ++i) {
                if (!metrics[i].getType().equals((Object)Metric.MetricType.READ_SKIP_COUNT)) continue;
                TestUtil.logMsg((String)("AJM: in test, found metric: " + metrics[i].getType() + ""));
                AssertionUtils.assertWithMessage("Testing the read skip count for execution #1", 4L, metrics[i].getValue());
            }
        }
        catch (Exception e) {
            MetricsTests.handleException(METHOD, e);
        }
    }

    public void testMetricsSkipWrite() throws EETest.Fault {
        String METHOD = "testMetricsSkipWrite";
        TestUtil.logTrace((String)METHOD);
        try {
            TestUtil.logMsg((String)"Create job parameters for execution #1:");
            Properties jobParams = new Properties();
            TestUtil.logMsg((String)"execution.number=1");
            TestUtil.logMsg((String)"readrecord.fail=1,3");
            TestUtil.logMsg((String)"app.arraysize=30");
            TestUtil.logMsg((String)"numberOfSkips=2");
            TestUtil.logMsg((String)"ReadProcessWrite=WRITE_SKIP");
            jobParams.put("execution.number", "1");
            jobParams.put("writerecord.fail", "1,3,4");
            jobParams.put("app.arraysize", "30");
            jobParams.put("numberOfSkips", "3");
            jobParams.put("ReadProcessWrite", "WRITE_SKIP");
            TestUtil.logMsg((String)"Locate job XML file: testMetricsSkipWriteCount.xml");
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult for execution #1");
            TCKJobExecutionWrapper execution1 = jobOp.startJobAndWaitForResult("testMetricsSkipWriteCount", jobParams);
            TestUtil.logMsg((String)("execution #1 JobExecution getBatchStatus()=" + execution1.getBatchStatus() + ""));
            TestUtil.logMsg((String)("execution #1 JobExecution getExitStatus()=" + execution1.getExitStatus() + ""));
            AssertionUtils.assertWithMessage("Testing execution #1", BatchStatus.COMPLETED, execution1.getBatchStatus());
            List<StepExecution> stepExecutions = jobOp.getStepExecutions(execution1.getExecutionId());
            StepExecution step = null;
            String stepNameTest = "step1";
            for (StepExecution stepEx : stepExecutions) {
                if (!stepNameTest.equals(stepEx.getStepName())) continue;
                step = stepEx;
            }
            TestUtil.logMsg((String)("execution #1 JobExecution getBatchStatus()=" + execution1.getBatchStatus() + ""));
            AssertionUtils.assertWithMessage("Testing execution #1", BatchStatus.COMPLETED, execution1.getBatchStatus());
            Metric[] metrics = step.getMetrics();
            TestUtil.logMsg((String)"Testing the write skip count for execution #1");
            for (int i = 0; i < metrics.length; ++i) {
                if (!metrics[i].getType().equals((Object)Metric.MetricType.WRITE_SKIP_COUNT)) continue;
                TestUtil.logMsg((String)("AJM: in test, found metric: " + metrics[i].getType() + ""));
                AssertionUtils.assertWithMessage("Testing the write skip count for execution #1", 3L, metrics[i].getValue());
            }
        }
        catch (Exception e) {
            MetricsTests.handleException(METHOD, e);
        }
    }

    public void testMetricsSkipProcess() throws EETest.Fault {
        String METHOD = "testMetricsSkipProcess";
        TestUtil.logTrace((String)METHOD);
        try {
            TestUtil.logMsg((String)"Create job parameters for execution #1:");
            Properties jobParams = new Properties();
            TestUtil.logMsg((String)"execution.number=1");
            TestUtil.logMsg((String)"readrecord.fail=7,13");
            TestUtil.logMsg((String)"app.arraysize=30");
            TestUtil.logMsg((String)"numberOfSkips=2");
            TestUtil.logMsg((String)"ReadProcessWrite=PROCESS");
            jobParams.put("execution.number", "1");
            jobParams.put("processrecord.fail", "7,13");
            jobParams.put("app.arraysize", "30");
            jobParams.put("numberOfSkips", "2");
            jobParams.put("ReadProcessWrite", "PROCESS");
            TestUtil.logMsg((String)"Locate job XML file: testMetricsSkipCount.xml");
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult for execution #1");
            TCKJobExecutionWrapper execution1 = jobOp.startJobAndWaitForResult("testMetricsSkipCount", jobParams);
            TestUtil.logMsg((String)("execution #1 JobExecution getBatchStatus()=" + execution1.getBatchStatus() + ""));
            TestUtil.logMsg((String)("execution #1 JobExecution getExitStatus()=" + execution1.getExitStatus() + ""));
            AssertionUtils.assertWithMessage("Testing execution #1", BatchStatus.COMPLETED, execution1.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #1", "GOOD PROCESS METRICS RESULT", execution1.getExitStatus());
            List<StepExecution> stepExecutions = jobOp.getStepExecutions(execution1.getExecutionId());
            StepExecution step = null;
            String stepNameTest = "step1";
            for (StepExecution stepEx : stepExecutions) {
                if (!stepNameTest.equals(stepEx.getStepName())) continue;
                step = stepEx;
            }
            TestUtil.logMsg((String)("execution #1 JobExecution getBatchStatus()=" + execution1.getBatchStatus() + ""));
            AssertionUtils.assertWithMessage("Testing execution #1", BatchStatus.COMPLETED, execution1.getBatchStatus());
            Metric[] metrics = step.getMetrics();
            TestUtil.logMsg((String)"Testing the read count for execution #1");
            for (int i = 0; i < metrics.length; ++i) {
                if (!metrics[i].getType().equals((Object)Metric.MetricType.PROCESS_SKIP_COUNT)) continue;
                TestUtil.logMsg((String)("AJM: in test, found metric: " + metrics[i].getType() + ""));
                AssertionUtils.assertWithMessage("Testing the read count for execution #1", 2L, metrics[i].getValue());
            }
        }
        catch (Exception e) {
            MetricsTests.handleException(METHOD, e);
        }
    }

    public void testReadMetric() throws EETest.Fault {
        String METHOD = "testReadMetric";
        TestUtil.logTrace((String)METHOD);
        try {
            TestUtil.logMsg((String)"Create job parameters for execution #1:");
            Properties jobParams = new Properties();
            TestUtil.logMsg((String)"execution.number=1");
            TestUtil.logMsg((String)"readrecord.fail=40");
            TestUtil.logMsg((String)"app.arraysize=30");
            TestUtil.logMsg((String)"app.chunksize=7");
            TestUtil.logMsg((String)"app.commitinterval=10");
            TestUtil.logMsg((String)"numberOfSkips=0");
            TestUtil.logMsg((String)"ReadProcessWrite=READ");
            jobParams.put("execution.number", "1");
            jobParams.put("readrecord.fail", "-1");
            jobParams.put("app.arraysize", "30");
            TestUtil.logMsg((String)"Locate job XML file: testChunkMetrics.xml");
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult for execution #1");
            TCKJobExecutionWrapper execution1 = jobOp.startJobAndWaitForResult("testMetricCount", jobParams);
            TestUtil.logMsg((String)("execution #1 JobExecution getBatchStatus()=" + execution1.getBatchStatus() + ""));
            TestUtil.logMsg((String)("execution #1 JobExecution getExitStatus()=" + execution1.getExitStatus() + ""));
            List<StepExecution> stepExecutions = jobOp.getStepExecutions(execution1.getExecutionId());
            StepExecution step = null;
            String stepNameTest = "step1Metric";
            for (StepExecution stepEx : stepExecutions) {
                if (!stepNameTest.equals(stepEx.getStepName())) continue;
                step = stepEx;
            }
            TestUtil.logMsg((String)("execution #1 JobExecution getBatchStatus()=" + execution1.getBatchStatus() + ""));
            AssertionUtils.assertWithMessage("Testing execution #1", BatchStatus.COMPLETED, execution1.getBatchStatus());
            Metric[] metrics = step.getMetrics();
            TestUtil.logMsg((String)"Testing the read count for execution #1");
            for (int i = 0; i < metrics.length; ++i) {
                if (!metrics[i].getType().equals((Object)Metric.MetricType.READ_COUNT)) continue;
                TestUtil.logMsg((String)("AJM: in test, found metric: " + metrics[i].getType() + ""));
                AssertionUtils.assertWithMessage("Testing the read count for execution #1", 9L, metrics[i].getValue());
            }
        }
        catch (Exception e) {
            MetricsTests.handleException(METHOD, e);
        }
    }

    public void testWriteMetric() throws EETest.Fault {
        String METHOD = "testWriteMetric";
        TestUtil.logTrace((String)METHOD);
        try {
            TestUtil.logMsg((String)"Create job parameters for execution #1:");
            Properties jobParams = new Properties();
            TestUtil.logMsg((String)"Locate job XML file: testChunkMetrics.xml");
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult for execution #1");
            TCKJobExecutionWrapper execution1 = jobOp.startJobAndWaitForResult("testMetricCount", jobParams);
            TestUtil.logMsg((String)("execution #1 JobExecution getBatchStatus()=" + execution1.getBatchStatus() + ""));
            TestUtil.logMsg((String)("execution #1 JobExecution getExitStatus()=" + execution1.getExitStatus() + ""));
            List<StepExecution> stepExecutions = jobOp.getStepExecutions(execution1.getExecutionId());
            StepExecution step = null;
            String stepNameTest = "step1Metric";
            for (StepExecution stepEx : stepExecutions) {
                if (!stepNameTest.equals(stepEx.getStepName())) continue;
                step = stepEx;
            }
            TestUtil.logMsg((String)("execution #1 JobExecution getBatchStatus()=" + execution1.getBatchStatus() + ""));
            AssertionUtils.assertWithMessage("Testing execution #1", BatchStatus.COMPLETED, execution1.getBatchStatus());
            Metric[] metrics = step.getMetrics();
            TestUtil.logMsg((String)"Testing the read count for execution #1");
            for (int i = 0; i < metrics.length; ++i) {
                if (!metrics[i].getType().equals((Object)Metric.MetricType.WRITE_COUNT)) continue;
                TestUtil.logMsg((String)("AJM: in test, found metric: " + metrics[i].getType() + ""));
                AssertionUtils.assertWithMessage("Testing the write count for execution #1", 9L, metrics[i].getValue());
            }
        }
        catch (Exception e) {
            MetricsTests.handleException(METHOD, e);
        }
    }

    public void testMetricsFilterCount() throws EETest.Fault {
        String METHOD = "testMetricsFilterCount";
        TestUtil.logTrace((String)METHOD);
        try {
            TestUtil.logMsg((String)"Create job parameters for execution #1:");
            Properties jobParams = new Properties();
            jobParams.put("app.processFilterItem", "3");
            TestUtil.logMsg((String)"app.processFilterItem=3");
            TestUtil.logMsg((String)"Locate job XML file: testMetricsFilterCount.xml");
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult for execution #1");
            TCKJobExecutionWrapper execution1 = jobOp.startJobAndWaitForResult("testMetricsFilterCount", jobParams);
            TestUtil.logMsg((String)("Obtaining StepExecutions for execution id: " + execution1.getExecutionId() + ""));
            List<StepExecution> stepExecutions = jobOp.getStepExecutions(execution1.getExecutionId());
            Object tempstep = null;
            StepExecution step = null;
            String stepNameTest = "step1FM";
            for (StepExecution stepEx : stepExecutions) {
                if (!stepNameTest.equals(stepEx.getStepName())) continue;
                step = stepEx;
            }
            TestUtil.logMsg((String)("execution #1 JobExecution getBatchStatus()=" + execution1.getBatchStatus() + ""));
            AssertionUtils.assertWithMessage("Testing execution #1", BatchStatus.COMPLETED, execution1.getBatchStatus());
            Metric[] metrics = step.getMetrics();
            TestUtil.logMsg((String)"Testing the filter count for execution #1");
            for (int i = 0; i < metrics.length; ++i) {
                if (!metrics[i].getType().equals((Object)Metric.MetricType.FILTER_COUNT)) continue;
                AssertionUtils.assertWithMessage("Testing the filter count for execution #1", 1L, metrics[i].getValue());
            }
        }
        catch (Exception e) {
            MetricsTests.handleException(METHOD, e);
        }
    }

    public void testMetricsCommitCount() throws EETest.Fault {
        String METHOD = "testMetricsCommitCount";
        TestUtil.logTrace((String)METHOD);
        try {
            TestUtil.logMsg((String)"Create job parameters for execution #1:");
            Properties jobParams = new Properties();
            jobParams.put("app.processFilterItem", "3");
            TestUtil.logMsg((String)"app.processFilterItem=3");
            TestUtil.logMsg((String)"Locate job XML file: testMetricsCommitCount.xml");
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult for execution #1");
            TCKJobExecutionWrapper execution1 = jobOp.startJobAndWaitForResult("testMetricsCommitCount", jobParams);
            TestUtil.logMsg((String)("Obtaining StepExecutions for execution id: " + execution1.getExecutionId() + ""));
            List<StepExecution> stepExecutions = jobOp.getStepExecutions(execution1.getExecutionId());
            Object tempstep = null;
            StepExecution step = null;
            String stepNameTest = "step1CCM";
            for (StepExecution stepEx : stepExecutions) {
                if (!stepNameTest.equals(stepEx.getStepName())) continue;
                step = stepEx;
            }
            TestUtil.logMsg((String)("execution #1 JobExecution getBatchStatus()=" + execution1.getBatchStatus() + ""));
            AssertionUtils.assertWithMessage("Testing execution #1", BatchStatus.COMPLETED, execution1.getBatchStatus());
            Metric[] metrics = step.getMetrics();
            TestUtil.logMsg((String)"Testing the commit count for execution #1");
            for (int i = 0; i < metrics.length; ++i) {
                if (!metrics[i].getType().equals((Object)Metric.MetricType.COMMIT_COUNT)) continue;
                AssertionUtils.assertWithMessage("Testing the commit count for execution #1", 4L, metrics[i].getValue());
            }
        }
        catch (Exception e) {
            MetricsTests.handleException(METHOD, e);
        }
    }

    public void testMetricsStepTimestamps() throws EETest.Fault {
        String METHOD = "testMetricsStepTimestamps";
        TestUtil.logTrace((String)METHOD);
        try {
            TestUtil.logMsg((String)"Create job parameters for execution #1:");
            Properties jobParams = new Properties();
            jobParams.put("app.processFilterItem", "3");
            TestUtil.logMsg((String)"app.processFilterItem=3");
            TestUtil.logMsg((String)"Locate job XML file: testMetricsCommitCount.xml");
            long time = System.currentTimeMillis();
            Date ts = new Date(time);
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult for execution #1");
            TCKJobExecutionWrapper execution1 = jobOp.startJobAndWaitForResult("testMetricsCommitCount", jobParams);
            TestUtil.logMsg((String)("Obtaining StepExecutions for execution id: " + execution1.getExecutionId() + ""));
            List<StepExecution> stepExecutions = jobOp.getStepExecutions(execution1.getExecutionId());
            Object tempstep = null;
            StepExecution step = null;
            String stepNameTest = "step1CCM";
            for (StepExecution stepEx : stepExecutions) {
                if (!stepNameTest.equals(stepEx.getStepName())) continue;
                step = stepEx;
            }
            TestUtil.logMsg((String)("execution #1 JobExecution getBatchStatus()=" + execution1.getBatchStatus() + ""));
            AssertionUtils.assertWithMessage("Testing execution #1", BatchStatus.COMPLETED, execution1.getBatchStatus());
            TestUtil.logMsg((String)("AJM: testcase start time: " + ts + ""));
            TestUtil.logMsg((String)("AJM: step start time: " + step.getStartTime() + ""));
            TestUtil.logMsg((String)("AJM: step end time: " + step.getEndTime() + ""));
            AssertionUtils.assertWithMessage("Start time of test occurs approximately before start time of step", MetricsTests.roughlyOrdered(ts, step.getStartTime()));
            AssertionUtils.assertWithMessage("Start time of step occurs approximately before end time of step", MetricsTests.roughlyOrdered(step.getStartTime(), step.getEndTime()));
        }
        catch (Exception e) {
            MetricsTests.handleException(METHOD, e);
        }
    }

    public void testMetricsJobExecutionTimestamps() throws EETest.Fault {
        String METHOD = "testMetricsJobExecutionTimestamps";
        TestUtil.logTrace((String)METHOD);
        try {
            TestUtil.logMsg((String)"Create job parameters for execution #1:");
            Properties jobParams = new Properties();
            jobParams.put("app.processFilterItem", "3");
            TestUtil.logMsg((String)"app.processFilterItem=3");
            TestUtil.logMsg((String)"Locate job XML file: testMetricsCommitCount.xml");
            long time = System.currentTimeMillis();
            Date ts = new Date(time);
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult for execution #1");
            TCKJobExecutionWrapper execution1 = jobOp.startJobAndWaitForResult("testMetricsCommitCount", jobParams);
            TestUtil.logMsg((String)("execution #1 JobExecution getBatchStatus()=" + execution1.getBatchStatus() + ""));
            AssertionUtils.assertWithMessage("Testing execution #1", BatchStatus.COMPLETED, execution1.getBatchStatus());
            TestUtil.logMsg((String)("AJM: testcase start time: " + ts + ""));
            TestUtil.logMsg((String)("AJM: job create time: " + execution1.getCreateTime() + ""));
            TestUtil.logMsg((String)("AJM: job start time: " + execution1.getStartTime() + ""));
            TestUtil.logMsg((String)("AJM: job last updated time: " + execution1.getLastUpdatedTime() + ""));
            TestUtil.logMsg((String)("AJM: job end time: " + execution1.getEndTime() + ""));
            AssertionUtils.assertWithMessage("Start time of test occurs approximately before create time of job", MetricsTests.roughlyOrdered(ts, execution1.getCreateTime()));
            AssertionUtils.assertWithMessage("Create time of job occurs approximately before start time of job", MetricsTests.roughlyOrdered(execution1.getCreateTime(), execution1.getStartTime()));
            AssertionUtils.assertWithMessage("Start time of job occurs approximately before end time of job", MetricsTests.roughlyOrdered(execution1.getStartTime(), execution1.getEndTime()));
            AssertionUtils.assertWithMessage("Start time of job occurs approximately before Last Updated time of job", MetricsTests.roughlyOrdered(execution1.getStartTime(), execution1.getLastUpdatedTime()));
        }
        catch (Exception e) {
            MetricsTests.handleException(METHOD, e);
        }
    }

    private static void handleException(String methodName, Exception e) throws EETest.Fault {
        TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
        TestUtil.printStackTrace((Throwable)e);
        throw new EETest.Fault(methodName + " failed", e);
    }

    private static boolean roughlyOrdered(Date d1, Date d2) {
        long time1 = d1.getTime();
        long time2 = d2.getTime();
        long diff = time2 - time1;
        return diff >= -1000L;
    }
}

