/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.tck.tests.jslxml;

import com.ibm.jbatch.tck.utils.AssertionUtils;
import com.ibm.jbatch.tck.utils.JobOperatorBridge;
import com.ibm.jbatch.tck.utils.TCKJobExecutionWrapper;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.util.TestUtil;
import jakarta.batch.runtime.BatchStatus;
import jakarta.batch.runtime.JobExecution;
import jakarta.batch.runtime.StepExecution;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;

public class ParallelExecutionTests
extends ServiceEETest {
    private static final Logger logger = Logger.getLogger(ParallelExecutionTests.class.getName());
    private static final String TIME_TO_SLEEP_BEFORE_ISSUING_STOP = "1900";
    private static JobOperatorBridge jobOp = null;

    public static void setup(String[] args, Properties props) throws EETest.Fault {
        String METHOD = "setup";
        TestUtil.logTrace((String)METHOD);
        try {
            jobOp = new JobOperatorBridge();
        }
        catch (Exception e) {
            ParallelExecutionTests.handleException(METHOD, e);
        }
    }

    public static void setUp() throws EETest.Fault {
        jobOp = new JobOperatorBridge();
    }

    public static void cleanup() throws EETest.Fault {
    }

    private void begin(String str) {
        TestUtil.logMsg((String)("Begin test method: " + str + ""));
    }

    public void testInvokeJobWithOnePartitionedStep() throws EETest.Fault {
        String METHOD = "testInvokeJobWithOnePartitionedStep";
        TestUtil.logTrace((String)METHOD);
        this.begin(METHOD);
        try {
            TestUtil.logMsg((String)"Locate job XML file: job_partitioned_1step.xml");
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult");
            TCKJobExecutionWrapper jobExecution = jobOp.startJobAndWaitForResult("job_partitioned_1step");
            TestUtil.logMsg((String)("JobExecution getBatchStatus()=" + jobExecution.getBatchStatus()));
            AssertionUtils.assertObjEquals(BatchStatus.COMPLETED, jobExecution.getBatchStatus());
        }
        catch (Exception e) {
            ParallelExecutionTests.handleException(METHOD, e);
        }
    }

    public void testInvokeJobWithOnePartitionedStepExitStatus() throws EETest.Fault {
        String METHOD = "testInvokeJobWithOnePartitionedStepExitStatus";
        TestUtil.logTrace((String)METHOD);
        this.begin(METHOD);
        String DEFAULT_SLEEP_TIME = "2000";
        try {
            Properties jobParameters = new Properties();
            String sleepTime = System.getProperty("ParallelExecutionTests.testInvokeJobWithOnePartitionedStepExitStatus.sleep", DEFAULT_SLEEP_TIME);
            jobParameters.put("sleep.time", sleepTime);
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult");
            TCKJobExecutionWrapper jobExecution = jobOp.startJobAndWaitForResult("job_partitioned_1step_exitStatusTest", jobParameters);
            TestUtil.logMsg((String)("JobExecution getBatchStatus()=" + jobExecution.getBatchStatus()));
            AssertionUtils.assertObjEquals(BatchStatus.COMPLETED, jobExecution.getBatchStatus());
            List<StepExecution> stepExecutions = jobOp.getStepExecutions(jobExecution.getExecutionId());
            AssertionUtils.assertObjEquals(1, stepExecutions.size());
            for (StepExecution stepEx : stepExecutions) {
                AssertionUtils.assertObjEquals("STEP EXIT STATUS: 10", stepEx.getExitStatus());
                AssertionUtils.assertObjEquals(BatchStatus.COMPLETED, stepEx.getBatchStatus());
            }
            AssertionUtils.assertObjEquals("JOB EXIT STATUS: 10", jobExecution.getExitStatus());
            AssertionUtils.assertObjEquals(BatchStatus.COMPLETED, jobExecution.getBatchStatus());
        }
        catch (Exception e) {
            ParallelExecutionTests.handleException(METHOD, e);
        }
    }

    public void testStopRunningPartitionedStep() throws EETest.Fault {
        String METHOD = "testStopRunningPartitionedStep";
        TestUtil.logTrace((String)METHOD);
        this.begin(METHOD);
        try {
            TestUtil.logMsg((String)"Locate job XML file: job_batchlet_longrunning_partitioned.xml");
            TestUtil.logMsg((String)"Create job parameters");
            Properties overrideJobParams = new Properties();
            TestUtil.logMsg((String)"run.indefinitely=true");
            overrideJobParams.setProperty("run.indefinitely", "true");
            TestUtil.logMsg((String)"Invoke startJobWithoutWaitingForResult");
            TCKJobExecutionWrapper jobExecution = jobOp.startJobWithoutWaitingForResult("job_batchlet_longrunning_partitioned", overrideJobParams);
            int sleepTime = Integer.parseInt(System.getProperty("ParallelExecutionTests.testStopRunningPartitionedStep.sleep", TIME_TO_SLEEP_BEFORE_ISSUING_STOP));
            TestUtil.logMsg((String)"Sleep for 1900");
            Thread.sleep(sleepTime);
            TestUtil.logMsg((String)"Invoke stopJobAndWaitForResult");
            jobOp.stopJobAndWaitForResult(jobExecution);
            JobExecution jobExec2 = jobOp.getJobExecution(jobExecution.getExecutionId());
            TestUtil.logMsg((String)("JobExecution getBatchStatus()=" + jobExec2.getBatchStatus() + ""));
            AssertionUtils.assertObjEquals(BatchStatus.STOPPED, jobExec2.getBatchStatus());
        }
        catch (Exception e) {
            ParallelExecutionTests.handleException(METHOD, e);
        }
    }

    public void testStopRestartRunningPartitionedStep() throws EETest.Fault {
        String METHOD = "testStopRestartRunningPartitionedStep";
        TestUtil.logTrace((String)METHOD);
        this.begin(METHOD);
        try {
            TestUtil.logMsg((String)"Locate job XML file: job_batchlet_longrunning_partitioned.xml");
            TestUtil.logMsg((String)"Create job parameters");
            Properties jobParams = new Properties();
            TestUtil.logMsg((String)"run.indefinitely=true");
            jobParams.setProperty("run.indefinitely", "true");
            TestUtil.logMsg((String)"Invoke startJobWithoutWaitingForResult");
            TCKJobExecutionWrapper origJobExecution = jobOp.startJobWithoutWaitingForResult("job_batchlet_longrunning_partitioned", jobParams);
            int sleepTime = Integer.parseInt(System.getProperty("ParallelExecutionTests.testStopRestartRunningPartitionedStep.sleep", TIME_TO_SLEEP_BEFORE_ISSUING_STOP));
            TestUtil.logMsg((String)"Sleep for 1900");
            Thread.sleep(sleepTime);
            TestUtil.logMsg((String)"Invoke stopJobAndWaitForResult");
            jobOp.stopJobAndWaitForResult(origJobExecution);
            JobExecution jobExec2 = jobOp.getJobExecution(origJobExecution.getExecutionId());
            TestUtil.logMsg((String)("JobExecution getBatchStatus()=" + jobExec2.getBatchStatus() + ""));
            AssertionUtils.assertObjEquals(BatchStatus.STOPPED, jobExec2.getBatchStatus());
            TestUtil.logMsg((String)"Create restart job parameters");
            Properties restartJobParams = new Properties();
            TestUtil.logMsg((String)"run.indefinitely=true");
            restartJobParams.setProperty("run.indefinitely", "false");
            TestUtil.logMsg((String)"Invoke restartJobAndWaitForResult");
            TCKJobExecutionWrapper restartedJobExec = jobOp.restartJobAndWaitForResult(origJobExecution.getExecutionId(), restartJobParams);
            TestUtil.logMsg((String)("JobExecution getBatchStatus()=" + restartedJobExec.getBatchStatus() + ""));
            AssertionUtils.assertObjEquals(BatchStatus.COMPLETED, restartedJobExec.getBatchStatus());
        }
        catch (Exception e) {
            ParallelExecutionTests.handleException(METHOD, e);
        }
    }

    public void testInvokeJobSimpleSplit() throws EETest.Fault {
        String METHOD = "testInvokeJobSimpleSplit";
        TestUtil.logTrace((String)METHOD);
        this.begin(METHOD);
        try {
            TestUtil.logMsg((String)"Locate job XML file: job_split_batchlet_4steps.xml");
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult");
            TCKJobExecutionWrapper execution = jobOp.startJobAndWaitForResult("job_split_batchlet_4steps");
            TestUtil.logMsg((String)("JobExecution getBatchStatus()=" + execution.getBatchStatus()));
            AssertionUtils.assertObjEquals(BatchStatus.COMPLETED, execution.getBatchStatus());
            AssertionUtils.assertObjEquals("COMPLETED", execution.getExitStatus());
        }
        catch (Exception e) {
            ParallelExecutionTests.handleException(METHOD, e);
        }
    }

    public void testPartitionedPlanCollectorAnalyzerReducerComplete() throws EETest.Fault {
        String METHOD = "testPartitionedPlanCollectorAnalyzerReducerComplete";
        TestUtil.logTrace((String)METHOD);
        this.begin(METHOD);
        try {
            TestUtil.logMsg((String)"Locate job XML file: job_partitioned_artifacts.xml");
            TestUtil.logMsg((String)"Create Job parameters for Execution #1");
            Properties jobParams = new Properties();
            TestUtil.logMsg((String)"numPartitionsProp=3");
            jobParams.setProperty("numPartitionsProp", "3");
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult");
            TCKJobExecutionWrapper execution = jobOp.startJobAndWaitForResult("job_partitioned_artifacts", jobParams);
            TestUtil.logMsg((String)("Execution exit status = " + execution.getExitStatus()));
            AssertionUtils.assertObjEquals("nullBeginCACACABeforeAfter", execution.getExitStatus());
            TestUtil.logMsg((String)("Execution status = " + execution.getBatchStatus()));
            AssertionUtils.assertObjEquals(BatchStatus.COMPLETED, execution.getBatchStatus());
        }
        catch (Exception e) {
            ParallelExecutionTests.handleException(METHOD, e);
        }
    }

    public void testZeroBasedPartitionedPlanCollectorAnalyzerReducerRollback() throws EETest.Fault {
        String METHOD = "testZeroBasedPartitionedPlanCollectorAnalyzerReducerRollback";
        TestUtil.logTrace((String)METHOD);
        this.begin(METHOD);
        try {
            TestUtil.logMsg((String)"Locate job XML file: job_partitioned_artifacts.xml");
            TestUtil.logMsg((String)"Create Job parameters for Execution #1");
            Properties jobParams = new Properties();
            TestUtil.logMsg((String)"numPartitionsProp=3");
            TestUtil.logMsg((String)"failThisPartition=0");
            jobParams.setProperty("numPartitionsProp", "3");
            jobParams.setProperty("failThisPartition", "0");
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult");
            TCKJobExecutionWrapper execution = jobOp.startJobAndWaitForResult("job_partitioned_artifacts", jobParams);
            TestUtil.logMsg((String)("Execution exit status = " + execution.getExitStatus()));
            AssertionUtils.assertObjEquals("nullBeginCACACARollbackAfter", execution.getExitStatus());
            TestUtil.logMsg((String)("Execution status = " + execution.getBatchStatus()));
            AssertionUtils.assertObjEquals(BatchStatus.FAILED, execution.getBatchStatus());
        }
        catch (Exception e) {
            ParallelExecutionTests.handleException(METHOD, e);
        }
    }

    public void testPartitionedCollectorAnalyzerReducerChunkRestartItemCount10() throws EETest.Fault {
        String METHOD = "testPartitionedCollectorAnalyzerReducerChunkRestartItemCount10";
        TestUtil.logTrace((String)METHOD);
        try {
            TestUtil.logMsg((String)"Create job parameters for execution #1:");
            Properties jobParams = new Properties();
            TestUtil.logMsg((String)"readrecord.fail=23");
            TestUtil.logMsg((String)"app.arraysize=30");
            TestUtil.logMsg((String)"app.writepoints=0,5,10,15,20,25,30");
            TestUtil.logMsg((String)"app.next.writepoints=0,5,10,15,20,25,30");
            jobParams.put("readrecord.fail", "23");
            jobParams.put("app.arraysize", "30");
            jobParams.put("app.writepoints", "0,10,20,30");
            jobParams.put("app.next.writepoints", "20,30");
            TestUtil.logMsg((String)"Locate job XML file: chunkrestartPartitionedCheckpt10.xml");
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult for execution #1");
            TCKJobExecutionWrapper execution1 = jobOp.startJobAndWaitForResult("chunkrestartPartitionedCheckpt10", jobParams);
            TestUtil.logMsg((String)("execution #1 JobExecution getBatchStatus()=" + execution1.getBatchStatus() + ""));
            TestUtil.logMsg((String)("execution #1 JobExecution getExitStatus()=" + execution1.getExitStatus() + ""));
            AssertionUtils.assertWithMessage("Testing execution #1", BatchStatus.FAILED, execution1.getBatchStatus());
            int CA_PAIRS = 8;
            String CA = "CA";
            String expectedExitStatus = "null";
            expectedExitStatus = expectedExitStatus + "Begin";
            for (int i = 0; i < CA_PAIRS; ++i) {
                expectedExitStatus = expectedExitStatus + CA;
            }
            expectedExitStatus = expectedExitStatus + "Rollback";
            expectedExitStatus = expectedExitStatus + "After";
            AssertionUtils.assertWithMessage("Testing execution #1", expectedExitStatus, execution1.getExitStatus());
            long execution1Id = execution1.getExecutionId();
            long execution1InstanceId = execution1.getInstanceId();
            TestUtil.logMsg((String)("Invoke restartJobAndWaitForResult with execution id: " + execution1Id + ""));
            TCKJobExecutionWrapper execution2 = jobOp.restartJobAndWaitForResult(execution1Id, jobParams);
            TestUtil.logMsg((String)("execution #2 JobExecution getBatchStatus()=" + execution2.getBatchStatus() + ""));
            TestUtil.logMsg((String)("execution #2 JobExecution getExitStatus()=" + execution2.getExitStatus() + ""));
            TestUtil.logMsg((String)("execution #2 Job instance id=" + execution2.getInstanceId() + ""));
            TestUtil.logMsg((String)("execution #2 Job execution id=" + execution2.getExecutionId() + ""));
            int CA_PAIRS2 = 4;
            String CA2 = "CA";
            String expectedExitStatus2 = "null";
            expectedExitStatus2 = expectedExitStatus2 + "Begin";
            for (int i = 0; i < CA_PAIRS2; ++i) {
                expectedExitStatus2 = expectedExitStatus2 + CA2;
            }
            expectedExitStatus2 = expectedExitStatus2 + "Before";
            expectedExitStatus2 = expectedExitStatus2 + "After";
            AssertionUtils.assertWithMessage("Testing execution #2 exit status", expectedExitStatus2, execution2.getExitStatus());
            AssertionUtils.assertWithMessage("Testing execution #2 batch status", BatchStatus.COMPLETED, execution2.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #2 instance ID", execution1InstanceId, execution2.getInstanceId());
        }
        catch (Exception e) {
            ParallelExecutionTests.handleException(METHOD, e);
        }
    }

    public void testPartitionedMapperOverrideFalseOnRestart() throws EETest.Fault {
        String METHOD = "testPartitionedMapperOverrideFalse";
        TestUtil.logTrace((String)METHOD);
        this.begin(METHOD);
        try {
            TestUtil.logMsg((String)"Locate job XML file: job_partitioned_artifacts.xml");
            TestUtil.logMsg((String)"Create Job parameters for Execution #1");
            Properties jobParams = new Properties();
            TestUtil.logMsg((String)"numPartitionsProp=3");
            TestUtil.logMsg((String)"failThisPartition=0");
            jobParams.setProperty("numPartitionsProp", "3");
            jobParams.setProperty("failThisPartition", "0");
            jobParams.setProperty("partitionsOverride", "false");
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult");
            TCKJobExecutionWrapper execution = jobOp.startJobAndWaitForResult("job_partitioned_artifacts", jobParams);
            TestUtil.logMsg((String)("Execution exit status = " + execution.getExitStatus()));
            AssertionUtils.assertObjEquals("nullBeginCACACARollbackAfter", execution.getExitStatus());
            TestUtil.logMsg((String)("Execution status = " + execution.getBatchStatus()));
            AssertionUtils.assertObjEquals(BatchStatus.FAILED, execution.getBatchStatus());
            TestUtil.logMsg((String)"Set restart job parameters");
            jobParams.setProperty("numPartitionsProp", "7");
            jobParams.setProperty("failThisPartition", "5");
            jobParams.setProperty("partitionsOverride", "false");
            TCKJobExecutionWrapper execution2 = jobOp.restartJobAndWaitForResult(execution.getExecutionId(), jobParams);
            TestUtil.logMsg((String)("Execution exit status = " + execution2.getExitStatus()));
            AssertionUtils.assertObjEquals("nullBeginCABeforeAfter", execution2.getExitStatus());
        }
        catch (Exception e) {
            ParallelExecutionTests.handleException(METHOD, e);
        }
    }

    public void testPartitionedMapperOverrideTrueDiffPartitionNumOnRestart() throws EETest.Fault {
        String METHOD = "testPartitionedMapperOverrideFalse";
        TestUtil.logTrace((String)METHOD);
        this.begin(METHOD);
        try {
            TestUtil.logMsg((String)"Locate job XML file: job_partitioned_artifacts.xml");
            TestUtil.logMsg((String)"Create Job parameters for Execution #1");
            Properties jobParams = new Properties();
            TestUtil.logMsg((String)"numPartitionsProp=3");
            TestUtil.logMsg((String)"failThisPartition=0");
            jobParams.setProperty("numPartitionsProp", "2");
            jobParams.setProperty("failThisPartition", "0");
            jobParams.setProperty("partitionsOverride", "false");
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult");
            TCKJobExecutionWrapper execution = jobOp.startJobAndWaitForResult("job_partitioned_artifacts", jobParams);
            TestUtil.logMsg((String)("Execution exit status = " + execution.getExitStatus()));
            AssertionUtils.assertObjEquals("nullBeginCACARollbackAfter", execution.getExitStatus());
            TestUtil.logMsg((String)("Execution status = " + execution.getBatchStatus()));
            AssertionUtils.assertObjEquals(BatchStatus.FAILED, execution.getBatchStatus());
            TestUtil.logMsg((String)"Set restart job parameters");
            jobParams.setProperty("numPartitionsProp", "4");
            jobParams.setProperty("failThisPartition", "3");
            jobParams.setProperty("partitionsOverride", "true");
            TCKJobExecutionWrapper execution2 = jobOp.restartJobAndWaitForResult(execution.getExecutionId(), jobParams);
            TestUtil.logMsg((String)("Execution exit status = " + execution2.getExitStatus()));
            AssertionUtils.assertObjEquals("nullBeginCACACACARollbackAfter", execution2.getExitStatus());
        }
        catch (Exception e) {
            ParallelExecutionTests.handleException(METHOD, e);
        }
    }

    public void testPartitionedMapperOverrideTrueSamePartitionNumOnRestart() throws EETest.Fault {
        String METHOD = "testPartitionedMapperOverrideFalse";
        TestUtil.logTrace((String)METHOD);
        this.begin(METHOD);
        try {
            TestUtil.logMsg((String)"Locate job XML file: job_partitioned_artifacts.xml");
            TestUtil.logMsg((String)"Create Job parameters for Execution #1");
            Properties jobParams = new Properties();
            TestUtil.logMsg((String)"numPartitionsProp=3");
            TestUtil.logMsg((String)"failThisPartition=0");
            jobParams.setProperty("numPartitionsProp", "3");
            jobParams.setProperty("failThisPartition", "0");
            jobParams.setProperty("partitionsOverride", "false");
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult");
            TCKJobExecutionWrapper execution = jobOp.startJobAndWaitForResult("job_partitioned_artifacts", jobParams);
            TestUtil.logMsg((String)("Execution exit status = " + execution.getExitStatus()));
            AssertionUtils.assertObjEquals("nullBeginCACACARollbackAfter", execution.getExitStatus());
            TestUtil.logMsg((String)("Execution status = " + execution.getBatchStatus()));
            AssertionUtils.assertObjEquals(BatchStatus.FAILED, execution.getBatchStatus());
            TestUtil.logMsg((String)"Set restart job parameters");
            jobParams.setProperty("numPartitionsProp", "3");
            jobParams.setProperty("failThisPartition", "1");
            jobParams.setProperty("partitionsOverride", "true");
            TCKJobExecutionWrapper execution2 = jobOp.restartJobAndWaitForResult(execution.getExecutionId(), jobParams);
            TestUtil.logMsg((String)("Execution exit status = " + execution2.getExitStatus()));
            AssertionUtils.assertObjEquals("nullBeginCACACARollbackAfter", execution2.getExitStatus());
        }
        catch (Exception e) {
            ParallelExecutionTests.handleException(METHOD, e);
        }
    }

    private static void handleException(String methodName, Exception e) throws EETest.Fault {
        TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
        TestUtil.printStackTrace((Throwable)e);
        throw new EETest.Fault(methodName + " failed", e);
    }
}

