/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.tck.tests.jslxml;

import com.ibm.jbatch.tck.utils.AssertionUtils;
import com.ibm.jbatch.tck.utils.JobOperatorBridge;
import com.ibm.jbatch.tck.utils.TCKJobExecutionWrapper;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.util.TestUtil;
import jakarta.batch.operations.JobStartException;
import jakarta.batch.runtime.BatchStatus;
import java.util.Properties;

public class SplitTransitioningTests
extends ServiceEETest {
    private JobOperatorBridge jobOp = null;

    public void testSplitTransitionToStep() throws EETest.Fault {
        String METHOD = "testSplitTransitionToStep";
        TestUtil.logTrace((String)METHOD);
        try {
            TestUtil.logMsg((String)"starting job");
            TCKJobExecutionWrapper jobExec = this.jobOp.startJobAndWaitForResult("split_transition_to_step", null);
            TestUtil.logMsg((String)("Job Status = " + jobExec.getBatchStatus()));
            AssertionUtils.assertWithMessage("Split transitioned to step", "step1", jobExec.getExitStatus());
            AssertionUtils.assertWithMessage("Job completed", BatchStatus.COMPLETED, jobExec.getBatchStatus());
            TestUtil.logMsg((String)"job completed");
        }
        catch (Exception e) {
            SplitTransitioningTests.handleException(METHOD, e);
        }
    }

    public void testSplitTransitionToStepOutOfScope() throws EETest.Fault {
        String METHOD = "testSplitTransitionToStepOutOfScope";
        TestUtil.logTrace((String)METHOD);
        try {
            TestUtil.logMsg((String)"starting job");
            boolean seenException = false;
            TCKJobExecutionWrapper jobExec = null;
            try {
                jobExec = this.jobOp.startJobAndWaitForResult("split_transition_to_step_out_of_scope", null);
            }
            catch (JobStartException e) {
                TestUtil.logMsg((String)("Caught JobStartException:  " + e.getLocalizedMessage()));
                seenException = true;
            }
            if (!seenException) {
                TestUtil.logMsg((String)("Didn't catch JobstartException, Job Batch Status = " + jobExec.getBatchStatus()));
                AssertionUtils.assertWithMessage("Job should have failed because of out of scope execution elements.", BatchStatus.FAILED, jobExec.getBatchStatus());
            }
        }
        catch (Exception e) {
            SplitTransitioningTests.handleException(METHOD, e);
        }
    }

    public void testSplitTransitionToDecision() throws EETest.Fault {
        String METHOD = "testSplitTransitionToDecision";
        TestUtil.logTrace((String)METHOD);
        try {
            String exitStatus = "ThatsAllFolks";
            TestUtil.logMsg((String)"starting job");
            TCKJobExecutionWrapper jobExec = this.jobOp.startJobAndWaitForResult("split_transition_to_decision", null);
            TestUtil.logMsg((String)("Job Status = " + jobExec.getBatchStatus()));
            AssertionUtils.assertWithMessage("Job Exit Status is from decider", exitStatus, jobExec.getExitStatus());
            AssertionUtils.assertWithMessage("Job completed", BatchStatus.COMPLETED, jobExec.getBatchStatus());
            TestUtil.logMsg((String)"job completed");
        }
        catch (Exception e) {
            SplitTransitioningTests.handleException(METHOD, e);
        }
    }

    private static void handleException(String methodName, Exception e) throws EETest.Fault {
        TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
        TestUtil.printStackTrace((Throwable)e);
        throw new EETest.Fault(methodName + " failed", e);
    }

    public void cleanup() {
    }

    public void setup(String[] args, Properties props) throws EETest.Fault {
        String METHOD = "setup";
        TestUtil.logTrace((String)METHOD);
        try {
            this.jobOp = new JobOperatorBridge();
        }
        catch (Exception e) {
            SplitTransitioningTests.handleException(METHOD, e);
        }
    }

    public void beforeTest() throws ClassNotFoundException {
        this.jobOp = new JobOperatorBridge();
    }

    public void afterTest() {
        this.jobOp = null;
    }
}

