/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaxws.common;

import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Modules {
    private static final Logger logger = Logger.getLogger(Modules.class.getName());
    private static Method GET_MODULE;
    private static Method ADD_READS;
    private static Method GET_NAME;
    private static Method CAN_READ;
    private static boolean initializationFailed;

    public static void ensureReadable(Class<?> sourceClass, Class<?> targetClass) {
        if (initializationFailed) {
            return;
        }
        Object targetModule = Modules.getModule(targetClass);
        Object sourceModule = Modules.getModule(sourceClass);
        if (!Modules.canRead(sourceModule, targetModule)) {
            logger.log(Level.FINE, "Adding module [{0}] to module [{1}]'s reads", new Object[]{Modules.getName(targetModule), Modules.getName(sourceModule)});
            Modules.addReads(sourceModule, targetModule);
        }
    }

    private static void addReads(Object sourceModule, Object targetModule) {
        if (sourceModule == null) {
            return;
        }
        try {
            ADD_READS.invoke(sourceModule, targetModule);
        }
        catch (Exception e) {
            throw new InternalError(e.getMessage());
        }
    }

    private static Object getModule(Class<?> targetClass) {
        if (targetClass == null) {
            return null;
        }
        try {
            return GET_MODULE.invoke(targetClass, new Object[0]);
        }
        catch (Exception e) {
            throw new InternalError(e.getMessage());
        }
    }

    private static Object getName(Object module) {
        if (module == null) {
            return "<anonymous-module>";
        }
        try {
            return GET_NAME.invoke(module, new Object[0]);
        }
        catch (Exception e) {
            throw new InternalError(e.getMessage());
        }
    }

    private static boolean canRead(Object sourceModule, Object targetModule) {
        if (sourceModule == null) {
            return true;
        }
        try {
            return (Boolean)CAN_READ.invoke(sourceModule, targetModule);
        }
        catch (Exception e) {
            throw new InternalError(e.getMessage());
        }
    }

    static {
        try {
            Class<?> moduleClass = Class.forName("java.lang.reflect.Module");
            GET_MODULE = Class.class.getMethod("getModule", new Class[0]);
            GET_NAME = moduleClass.getMethod("getName", new Class[0]);
            ADD_READS = moduleClass.getMethod("addReads", moduleClass);
            CAN_READ = moduleClass.getMethod("canRead", moduleClass);
        }
        catch (Throwable t) {
            logger.log(Level.INFO, "Error during initialization of [{0}]. Probably not Jigsaw runtime.", Modules.class.getName());
            initializationFailed = true;
        }
    }
}

