/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.connector.deployment;

import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.connector.whitebox.TSConnection;
import com.sun.ts.tests.common.connector.whitebox.TSDataSource;
import com.sun.ts.tests.connector.util.DBSupport;
import jakarta.ejb.CreateException;
import jakarta.ejb.SessionBean;
import jakarta.ejb.SessionContext;
import java.util.Properties;

public class DeploymentEJB
implements SessionBean {
    private TSNamingContext context = null;
    private Properties p = null;
    private boolean result = false;
    private transient TSConnection con;
    private DBSupport dbutil = null;
    private TSDataSource ds = null;
    private String whitebox_tx = null;
    private String uname = null;
    private String password = null;

    public void ejbCreate(Properties props) throws CreateException {
        this.p = props;
        try {
            this.context = new TSNamingContext();
            TestUtil.logTrace((String)"ejbCreate");
            TestUtil.init((Properties)props);
            System.out.println("Inside ejbCreate of DeploymentEJB!");
            this.whitebox_tx = this.p.getProperty("whitebox-embed");
            System.out.println("whitebox value is " + this.whitebox_tx);
            this.uname = this.p.getProperty("rauser1");
            this.password = this.p.getProperty("rapassword1");
            this.ds = (TSDataSource)this.context.lookup(this.whitebox_tx);
            TestUtil.logTrace((String)("ds: " + this.ds));
            System.out.println("TSDataSource lookup OK!");
            TestUtil.logTrace((String)"TSDataSource lookup OK!");
            this.dbutil = new DBSupport();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"init failed", (Throwable)e);
        }
    }

    public boolean testRarInEar() {
        System.out.println("Inside testRarInEar - Deployment EJB");
        Object hr = null;
        try {
            TSNamingContext ic = new TSNamingContext();
            TestUtil.logMsg((String)"Got the EJB!!");
            this.con = this.ds.getConnection();
            this.result = true;
            TestUtil.logMsg((String)"Got connection from the DataSource.");
        }
        catch (Exception e) {
            TestUtil.logMsg((String)"Exception caught on creating connection in Deployment EJB.");
        }
        TestUtil.logMsg((String)"Checking for Connection Validity.");
        try {
            this.dbutil.insertIntoTable(this.con);
            TestUtil.logMsg((String)"Values inserted into table!");
        }
        catch (Exception sqle) {
            TestUtil.printStackTrace((Throwable)sqle);
            TestUtil.logMsg((String)"Exception inserting into table.");
        }
        try {
            this.dbutil.dropTable(this.con);
            TestUtil.logMsg((String)"Table has been dropped!");
        }
        catch (Exception sqle) {
            TestUtil.printStackTrace((Throwable)sqle);
            TestUtil.logMsg((String)"Exception dropping table.");
        }
        return this.result;
    }

    public void setSessionContext(SessionContext sc) {
        try {
            TestUtil.logTrace((String)"setSessionContext");
        }
        catch (Exception sqle) {
            TestUtil.printStackTrace((Throwable)sqle);
            sqle.getMessage();
        }
    }

    public void ejbRemove() {
        TestUtil.logTrace((String)"ejbRemove");
        try {
            if (this.con != null) {
                this.con.close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void ejbActivate() {
    }

    public void ejbPassivate() {
    }
}

