/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb.ee.pm.ejbql.order_by;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.ejb.ee.pm.ejbql.schema.AliasHome;
import com.sun.ts.tests.ejb.ee.pm.ejbql.schema.CustomerHome;
import com.sun.ts.tests.ejb.ee.pm.ejbql.schema.OrderHome;
import com.sun.ts.tests.ejb.ee.pm.ejbql.schema.ProductHome;
import com.sun.ts.tests.ejb.ee.pm.ejbql.schema.Schema;
import com.sun.ts.tests.ejb.ee.pm.ejbql.schema.Util;
import java.util.Arrays;
import java.util.Collection;
import java.util.Properties;

public class Client
extends EETest {
    private CustomerHome customerHome = null;
    private OrderHome orderHome = null;
    private AliasHome aliasHome = null;
    private ProductHome productHome = null;
    private Properties props = null;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
        try {
            Schema.setup(p);
            this.customerHome = Schema.customerHome;
            this.orderHome = Schema.orderHome;
            this.aliasHome = Schema.aliasHome;
            this.productHome = Schema.productHome;
        }
        catch (Exception e) {
            TestUtil.logMsg((String)("Exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    public void orderByTest1() throws EETest.Fault {
        boolean pass = true;
        String[] expectedPKs = null;
        Collection o = null;
        try {
            TestUtil.logMsg((String)"Find Orders for Kellie A. Sanborn ordered by Total Price");
            o = this.orderHome.findOrdersByPrice("Kellie A. Sanborn");
            expectedPKs = new String[]{"15", "16"};
            if (!Util.checkEJBs(o, 2, expectedPKs)) {
                TestUtil.logErr((String)"UnSuccessfully found all orders for Kellie A. Sanborn");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Successfully found all orders for Kellie A. Sanborn");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception orderByTest1: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("orderByTest1 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("orderByTest1 failed");
        }
    }

    public void orderByTest2() throws EETest.Fault {
        boolean pass = false;
        Collection p = null;
        Object[] expectedPartNumbers = new Long[]{new Long(0L), new Long(123456789L), new Long(219876543L), new Long(234567891L), new Long(321987654L), new Long(345678912L), new Long(432198765L), new Long(456789123L), new Long(543219876L), new Long(567891234L), new Long(654321987L), new Long(678912345L), new Long(765432198L), new Long(789123456L), new Long(876543219L), new Long(891234567L), new Long(912345678L), new Long(987654321L)};
        try {
            TestUtil.logMsg((String)"Select all part numbers in ascending order");
            p = this.productHome.selectProductsByPartNumber();
            Object[] result = p.toArray(new Long[p.size()]);
            TestUtil.logMsg((String)"Compare results of part numbers");
            pass = Arrays.equals(expectedPartNumbers, result);
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception orderByTest2: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("orderByTest2 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("orderByTest2 failed");
        }
    }

    public void orderByTest3() throws EETest.Fault {
        boolean pass = false;
        Collection o = null;
        Object[] expectedBalances = new Double[]{new Double(500.0), new Double(750.0), new Double(1000.0), new Double(1400.0), new Double(1500.0), new Double(2000.0), new Double(2500.0), new Double(4400.0), new Double(5000.0), new Double(5500.0), new Double(7000.0), new Double(8000.0), new Double(13000.0), new Double(15000.0), new Double(23000.0)};
        try {
            TestUtil.logMsg((String)"Find credit card balances in ascending order");
            o = this.orderHome.selectCreditCardBalances();
            Object[] result = o.toArray(new Double[o.size()]);
            TestUtil.logMsg((String)"Compare results of credit card balances received");
            pass = Arrays.equals(expectedBalances, result);
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception orderByTest3: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("orderByTest3 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("orderByTest3 failed");
        }
    }

    public void orderByTest4() throws EETest.Fault {
        boolean pass = true;
        Collection p = null;
        String[] expectedPKs = null;
        try {
            TestUtil.logMsg((String)"Obtain a list of orders with the highest total price");
            p = this.productHome.findProductsByHighestQuantity();
            expectedPKs = new String[18];
            for (int i = 0; i < 18; ++i) {
                expectedPKs[i] = Integer.toString(i + 1);
            }
            if (!Util.checkEJBs(p, 4, expectedPKs)) {
                TestUtil.logErr((String)"UnSuccessfully returned all product with highest quantity");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Successfully found all products and returned result set in descending order");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception orderByTest4: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("orderByTest4 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("orderByTest4 failed");
        }
    }

    public void orderByTest5() throws EETest.Fault {
        boolean pass = true;
        Collection a = null;
        String[] expectedPKs = null;
        try {
            TestUtil.logMsg((String)"Obtain a list of aliases orderedy by alias name and alias id");
            a = this.aliasHome.findCustomerAliasesByOrder();
            expectedPKs = new String[]{"5", "1", "2", "6", "11", "24", "10", "21", "3", "19", "20", "27", "26", "23", "28", "9", "7", "8", "22", "17", "29", "12", "18", "13", "14", "25", "4"};
            if (!Util.checkEJBs(a, 3, expectedPKs)) {
                TestUtil.logErr((String)"UnSuccessfully returned expected aliases");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Successfully found all aliases");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception orderByTest5: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("orderByTest5 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("orderByTest5 failed");
        }
    }

    public void cleanup() throws EETest.Fault {
        TestUtil.logMsg((String)"cleanup ok");
    }
}

