/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.assembly.util.shared.resref.single;

import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.assembly.util.shared.resref.single.ByteArrayDataSource;
import jakarta.activation.DataHandler;
import jakarta.jms.QueueConnectionFactory;
import jakarta.jms.TopicConnectionFactory;
import jakarta.mail.Address;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Session;
import jakarta.mail.Transport;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeMessage;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.sql.Connection;
import java.util.Date;
import java.util.Properties;
import javax.sql.DataSource;

public class TestCode {
    private static final String prefix = "java:comp/env/";
    protected static final String dbLookup = "java:comp/env/jdbc/DB1";
    protected static final String mailLookup = "java:comp/env/mail/MailSession";
    protected static final String urlLookup = "java:comp/env/url/URL";
    protected static final String queueLookup = "java:comp/env/jms/myQueueConnectionFactory";
    protected static final String topicLookup = "java:comp/env/jms/myTopicConnectionFactory";
    protected static final String mailer = "JavaMailer";
    protected static final String subject = "Test message";
    protected static final String htmlContents = "This is a test message";

    public static boolean testDatasource(TSNamingContext nctx) {
        try {
            TestUtil.logTrace((String)"[TestCode] looking up java:comp/env/jdbc/DB1");
            DataSource ds = (DataSource)nctx.lookup(dbLookup);
            TestUtil.logTrace((String)"[TestCode] get a new DB connection...");
            Connection connection = ds.getConnection();
            connection.close();
        }
        catch (Exception e) {
            TestUtil.logErr((String)("RestTest: Caught exception: " + e), (Throwable)e);
            return false;
        }
        return true;
    }

    public static boolean testSession(TSNamingContext nctx) {
        String recipient = TestCode.getRecipient();
        if (null == recipient) {
            TestUtil.logErr((String)"RestTest: Aborting testSession() [setup]");
            return false;
        }
        try {
            TestUtil.logTrace((String)"[TestCode] looking up java:comp/env/mail/MailSession");
            Session session = (Session)nctx.lookup(mailLookup);
            TestUtil.logTrace((String)("[TestCode] sendind mail to " + recipient));
            Transport.send((Message)TestCode.compose(session, recipient));
        }
        catch (Exception e) {
            TestUtil.logErr((String)("RestTest: Caught exception: " + e));
            TestUtil.printStackTrace((Throwable)e);
            return false;
        }
        return true;
    }

    public static boolean testURL(TSNamingContext nctx) {
        try {
            TestUtil.logTrace((String)"[TestCode] looking up java:comp/env/url/URL");
            URL myUrl = (URL)nctx.lookup(urlLookup);
            TestUtil.logTrace((String)"[TestCode] get a new URL connection...");
            URLConnection urlConnection = myUrl.openConnection();
            Properties props = TestUtil.getResponseProperties((URLConnection)urlConnection);
            String resRef = props.getProperty("resourceref");
            if (null == resRef || !resRef.equals("true")) {
                TestUtil.logErr((String)"ResRef: Invalid connection!");
                return false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("RestTest: Caught exception: " + e));
            TestUtil.printStackTrace((Throwable)e);
            return false;
        }
        return true;
    }

    public static boolean testQueue(TSNamingContext nctx) {
        try {
            TestUtil.logTrace((String)"[TestCode] looking up java:comp/env/jms/myQueueConnectionFactory");
            QueueConnectionFactory queueFact = (QueueConnectionFactory)nctx.lookup(queueLookup);
        }
        catch (Exception e) {
            TestUtil.logErr((String)("RestTest: Caught exception: " + e));
            TestUtil.printStackTrace((Throwable)e);
            return false;
        }
        return true;
    }

    public static boolean testTopic(TSNamingContext nctx) {
        try {
            TestUtil.logTrace((String)"[TestCode] looking up java:comp/env/jms/myTopicConnectionFactory");
            TopicConnectionFactory topicFact = (TopicConnectionFactory)nctx.lookup(topicLookup);
        }
        catch (Exception e) {
            TestUtil.logErr((String)("RestTest: Caught exception: " + e));
            TestUtil.printStackTrace((Throwable)e);
            return false;
        }
        return true;
    }

    public static boolean testAll(TSNamingContext nctx) {
        boolean pass = true;
        try {
            pass &= TestCode.testDatasource(nctx);
            pass &= TestCode.testSession(nctx);
            pass &= TestCode.testURL(nctx);
            pass &= TestCode.testQueue(nctx);
        }
        catch (Exception e) {
            TestUtil.logErr((String)("ResRef: Caught exception in testAll: " + e));
            TestUtil.printStackTrace((Throwable)e);
            return false;
        }
        return pass &= TestCode.testTopic(nctx);
    }

    public static boolean testAllButDataSource(TSNamingContext nctx) {
        boolean pass = true;
        try {
            pass &= TestCode.testSession(nctx);
            pass &= TestCode.testURL(nctx);
            pass &= TestCode.testQueue(nctx);
        }
        catch (Exception e) {
            TestUtil.logErr((String)("ResRef: Caught exception in testAllButDataSource: " + e));
            TestUtil.printStackTrace((Throwable)e);
            return false;
        }
        return pass &= TestCode.testTopic(nctx);
    }

    protected static String getRecipient() {
        String recipient;
        try {
            recipient = TestUtil.getProperty((String)"mailuser1");
            if ("" == recipient || null == recipient) {
                TestUtil.logErr((String)("[TestCode] 'mailuser1' property is " + (null == recipient ? "null" : "empty")));
                return null;
            }
            TestUtil.logTrace((String)("[TestCode] Sending mail to:" + recipient));
        }
        catch (Exception e) {
            TestUtil.logErr((String)("[TestCode] setupMail() failed: " + e), (Throwable)e);
            return null;
        }
        return recipient;
    }

    protected static Message compose(Session session, String recipient) throws Exception {
        MimeMessage msg;
        try {
            msg = new MimeMessage(session);
            msg.setFrom();
            msg.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)recipient, (boolean)false));
            msg.setSubject(subject);
            TestCode.collect(subject, htmlContents, (Message)msg);
            msg.setHeader("X-Mailer", mailer);
            msg.setSentDate(new Date());
        }
        catch (Exception e) {
            TestUtil.logErr((String)("[TestCode] Caught exception in compose(): " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("compose() failed due to " + e);
        }
        return msg;
    }

    protected static void collect(String subject, String htmlContents, Message msg) throws MessagingException, IOException {
        StringBuffer sb = new StringBuffer();
        sb.append("<HTML>\n");
        sb.append("<HEAD>\n");
        sb.append("<TITLE>\n");
        sb.append(subject + "\n");
        sb.append("</TITLE>\n");
        sb.append("</HEAD>\n");
        sb.append("<BODY>\n");
        sb.append("<H1>" + subject + "</H1>\n");
        sb.append(htmlContents);
        sb.append("</BODY>\n");
        sb.append("</HTML>\n");
        msg.setDataHandler(new DataHandler((jakarta.activation.DataSource)new ByteArrayDataSource(sb.toString(), "text/html")));
    }
}

