/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jsonb.defaultmapping.classes;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.tests.jsonb.defaultmapping.classes.model.StringContainerAccessorsWithoutMatchingField;
import com.sun.ts.tests.jsonb.defaultmapping.classes.model.StringContainerFinalField;
import com.sun.ts.tests.jsonb.defaultmapping.classes.model.StringContainerFinalPublicField;
import com.sun.ts.tests.jsonb.defaultmapping.classes.model.StringContainerNoAccessorsPackagePrivateField;
import com.sun.ts.tests.jsonb.defaultmapping.classes.model.StringContainerNoAccessorsPrivateField;
import com.sun.ts.tests.jsonb.defaultmapping.classes.model.StringContainerNoAccessorsProtectedField;
import com.sun.ts.tests.jsonb.defaultmapping.classes.model.StringContainerNoAccessorsPublicField;
import com.sun.ts.tests.jsonb.defaultmapping.classes.model.StringContainerPackagePrivateAccessors;
import com.sun.ts.tests.jsonb.defaultmapping.classes.model.StringContainerPackagePrivateConstructor;
import com.sun.ts.tests.jsonb.defaultmapping.classes.model.StringContainerPrivateAccessors;
import com.sun.ts.tests.jsonb.defaultmapping.classes.model.StringContainerPrivateAccessorsPublicField;
import com.sun.ts.tests.jsonb.defaultmapping.classes.model.StringContainerPrivateConstructor;
import com.sun.ts.tests.jsonb.defaultmapping.classes.model.StringContainerProtectedAccessors;
import com.sun.ts.tests.jsonb.defaultmapping.classes.model.StringContainerProtectedConstructor;
import com.sun.ts.tests.jsonb.defaultmapping.classes.model.StringContainerProtectedStaticNestedClass;
import com.sun.ts.tests.jsonb.defaultmapping.classes.model.StringContainerPublicAccessors;
import com.sun.ts.tests.jsonb.defaultmapping.classes.model.StringContainerPublicAccessorsPublicField;
import com.sun.ts.tests.jsonb.defaultmapping.classes.model.StringContainerPublicConstructor;
import com.sun.ts.tests.jsonb.defaultmapping.classes.model.StringContainerPublicStaticNestedClass;
import com.sun.ts.tests.jsonb.defaultmapping.classes.model.StringContainerStaticField;
import com.sun.ts.tests.jsonb.defaultmapping.classes.model.StringContainerTransientField;
import jakarta.json.bind.Jsonb;
import jakarta.json.bind.JsonbBuilder;
import jakarta.json.bind.JsonbException;
import java.lang.reflect.Field;
import java.util.Properties;

public class ClassesMappingTest
extends ServiceEETest {
    private static final long serialVersionUID = 10L;
    private final Jsonb jsonb = JsonbBuilder.create();

    public static void main(String[] args) {
        ClassesMappingTest t = new ClassesMappingTest();
        Status s = t.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.logMsg("setup ok");
    }

    public void cleanup() throws EETest.Fault {
        this.logMsg("cleanup ok");
    }

    public Status testPublicConstructorAccess() throws EETest.Fault {
        try {
            String jsonString = this.jsonb.toJson((Object)new StringContainerPublicConstructor());
            if (!jsonString.matches("\\{\\s*\"instance\"\\s*:\\s*\"Test String\"\\s*\\}")) {
                throw new EETest.Fault("Failed to get attribute value when marshalling a class with a public constructor.");
            }
        }
        catch (JsonbException x) {
            throw new EETest.Fault("An exception is not expected when marshalling a class with a public constructor.");
        }
        try {
            this.jsonb.fromJson("{ \"instance\" : \"Test String\" }", StringContainerPublicConstructor.class);
            return Status.passed((String)"OK");
        }
        catch (JsonbException x) {
            throw new EETest.Fault("An exception is not expected when unmarshalling a class with a public constructor.");
        }
    }

    public Status testProtectedConstructorAccess() throws EETest.Fault {
        try {
            String jsonString = this.jsonb.toJson((Object)StringContainerProtectedConstructor.getClassInstance());
            if (!jsonString.matches("\\{\\s*\"instance\"\\s*:\\s*\"Test String\"\\s*\\}")) {
                throw new EETest.Fault("Failed to get attribute value when marshalling a class with a protected constructor.");
            }
        }
        catch (JsonbException x) {
            throw new EETest.Fault("An exception is not expected when marshalling a class with a protected constructor.");
        }
        try {
            this.jsonb.fromJson("{ \"instance\" : \"Test String\" }", StringContainerProtectedConstructor.class);
            return Status.passed((String)"OK");
        }
        catch (JsonbException x) {
            throw new EETest.Fault("An exception is not expected when unmarshalling a class with a protected constructor.");
        }
    }

    public Status testPrivateConstructorAccess() throws EETest.Fault {
        try {
            String jsonString = this.jsonb.toJson((Object)StringContainerPrivateConstructor.getClassInstance());
            if (!jsonString.matches("\\{\\s*\"instance\"\\s*:\\s*\"Test String\"\\s*\\}")) {
                throw new EETest.Fault("Failed to get attribute value when marshalling a class with a private constructor.");
            }
        }
        catch (JsonbException x) {
            throw new EETest.Fault("An exception is not expected when marshalling a class with a private constructor.");
        }
        try {
            this.jsonb.fromJson("{ \"instance\" : \"Test String\" }", StringContainerPrivateConstructor.class);
            throw new EETest.Fault("An exception is expected when unmarshalling a class with a private constructor.");
        }
        catch (JsonbException x) {
            return Status.passed((String)"OK");
        }
    }

    public Status testPackagePrivateConstructorAccess() throws EETest.Fault {
        try {
            String jsonString = this.jsonb.toJson((Object)StringContainerPackagePrivateConstructor.getClassInstance());
            if (!jsonString.matches("\\{\\s*\"instance\"\\s*:\\s*\"Test String\"\\s*\\}")) {
                throw new EETest.Fault("Failed to get attribute value when marshalling a class with a package private constructor.");
            }
        }
        catch (JsonbException x) {
            throw new EETest.Fault("An exception is not expected when marshalling a class with a package private constructor.");
        }
        try {
            this.jsonb.fromJson("{ \"instance\" : \"Test String\" }", StringContainerPackagePrivateConstructor.class);
            throw new EETest.Fault("An exception is expected when unmarshalling a class with a package private constructor.");
        }
        catch (JsonbException x) {
            return Status.passed((String)"OK");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Status testPublicAccessors() throws EETest.Fault {
        String jsonString = this.jsonb.toJson((Object)new StringContainerPublicAccessors());
        if (!jsonString.matches("\\{\\s*\"instance\"\\s*:\\s*\"Test String\"\\s*\\}")) {
            throw new EETest.Fault("Failed to get attribute value using public getter.");
        }
        try {
            StringContainerPublicAccessors unmarshalledObject = (StringContainerPublicAccessors)this.jsonb.fromJson("{ \"instance\" : \"New Test String\" }", StringContainerPublicAccessors.class);
            Field instanceField = StringContainerPublicAccessors.class.getDeclaredField("instance");
            instanceField.setAccessible(true);
            try {
                if (!instanceField.get(unmarshalledObject).equals("New Test String")) {
                    throw new EETest.Fault("Failed to set attribute value using public setter.");
                }
            }
            finally {
                instanceField.setAccessible(false);
            }
        }
        catch (Exception x) {
            throw new EETest.Fault(x.getMessage(), x);
        }
        return Status.passed((String)"OK");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Status testProtectedAccessors() throws EETest.Fault {
        String jsonString = this.jsonb.toJson((Object)new StringContainerProtectedAccessors());
        if (!jsonString.matches("\\{\\s*\\}")) {
            throw new EETest.Fault("Failed to ignore attribute value using protected getter.");
        }
        try {
            StringContainerProtectedAccessors unmarshalledObject = (StringContainerProtectedAccessors)this.jsonb.fromJson("{ \"instance\" : \"New Test String\" }", StringContainerProtectedAccessors.class);
            Field instanceField = StringContainerProtectedAccessors.class.getDeclaredField("instance");
            instanceField.setAccessible(true);
            try {
                if (!instanceField.get(unmarshalledObject).equals("Test String")) {
                    throw new EETest.Fault("Failed to ignore setting attribute value using protected setter.");
                }
            }
            finally {
                instanceField.setAccessible(false);
            }
        }
        catch (Exception x) {
            throw new EETest.Fault(x.getMessage(), x);
        }
        return Status.passed((String)"OK");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Status testPrivateAccessors() throws EETest.Fault {
        String jsonString = this.jsonb.toJson((Object)new StringContainerPrivateAccessors());
        if (!jsonString.matches("\\{\\s*\\}")) {
            throw new EETest.Fault("Failed to ignore private value using private getter.");
        }
        try {
            StringContainerPrivateAccessors unmarshalledObject = (StringContainerPrivateAccessors)this.jsonb.fromJson("{ \"instance\" : \"New Test String\" }", StringContainerPrivateAccessors.class);
            Field instanceField = StringContainerPrivateAccessors.class.getDeclaredField("instance");
            instanceField.setAccessible(true);
            try {
                if (!instanceField.get(unmarshalledObject).equals("Test String")) {
                    throw new EETest.Fault("Failed to ignore setting attribute value using private setter.");
                }
            }
            finally {
                instanceField.setAccessible(false);
            }
        }
        catch (Exception x) {
            throw new EETest.Fault(x.getMessage(), x);
        }
        return Status.passed((String)"OK");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Status testPackagePrivateAccessors() throws EETest.Fault {
        String jsonString = this.jsonb.toJson((Object)new StringContainerPackagePrivateAccessors());
        if (!jsonString.matches("\\{\\s*\\}")) {
            throw new EETest.Fault("Failed to ignore private value using package private getter.");
        }
        try {
            StringContainerPackagePrivateAccessors unmarshalledObject = (StringContainerPackagePrivateAccessors)this.jsonb.fromJson("{ \"instance\" : \"New Test String\" }", StringContainerPackagePrivateAccessors.class);
            Field instanceField = StringContainerPackagePrivateAccessors.class.getDeclaredField("instance");
            instanceField.setAccessible(true);
            try {
                if (!instanceField.get(unmarshalledObject).equals("Test String")) {
                    throw new EETest.Fault("Failed to ignore setting attribute value using package private setter.");
                }
            }
            finally {
                instanceField.setAccessible(false);
            }
        }
        catch (Exception x) {
            throw new EETest.Fault(x.getMessage(), x);
        }
        return Status.passed((String)"OK");
    }

    public Status testPublicAccessorsPublicField() throws EETest.Fault {
        String jsonString = this.jsonb.toJson((Object)new StringContainerPublicAccessorsPublicField());
        if (!jsonString.matches("\\{\\s*\"instance\"\\s*:\\s*\"Getter String\"\\s*\\}")) {
            throw new EETest.Fault("Failed to get attribute value using public getter.");
        }
        StringContainerPublicAccessorsPublicField unmarshalledObject = (StringContainerPublicAccessorsPublicField)this.jsonb.fromJson("{ \"instance\" : \"New Test String\" }", StringContainerPublicAccessorsPublicField.class);
        if (!unmarshalledObject.instance.equals("Setter String")) {
            throw new EETest.Fault("Failed to set attribute value using public setter.");
        }
        return Status.passed((String)"OK");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Status testPrivateAccessorsPublicField() throws EETest.Fault {
        String jsonString = this.jsonb.toJson((Object)new StringContainerPrivateAccessorsPublicField());
        if (!jsonString.matches("\\{\\s*\\}")) {
            throw new EETest.Fault("Failed to ignore public value using private getter.");
        }
        try {
            StringContainerPrivateAccessorsPublicField unmarshalledObject = (StringContainerPrivateAccessorsPublicField)this.jsonb.fromJson("{ \"instance\" : \"New Test String\" }", StringContainerPrivateAccessorsPublicField.class);
            Field instanceField = StringContainerPrivateAccessorsPublicField.class.getDeclaredField("instance");
            instanceField.setAccessible(true);
            try {
                if (!instanceField.get(unmarshalledObject).equals("Test String")) {
                    throw new EETest.Fault("Failed to ignore setting public value using private setter.");
                }
            }
            finally {
                instanceField.setAccessible(false);
            }
        }
        catch (Exception x) {
            throw new EETest.Fault(x.getMessage(), x);
        }
        return Status.passed((String)"OK");
    }

    public Status testNoAccessorsPublicField() throws EETest.Fault {
        String jsonString = this.jsonb.toJson((Object)new StringContainerNoAccessorsPublicField());
        if (!jsonString.matches("\\{\\s*\"instance\"\\s*:\\s*\"Test String\"\\s*\\}")) {
            throw new EETest.Fault("Failed to get public field value.");
        }
        StringContainerNoAccessorsPublicField unmarshalledObject = (StringContainerNoAccessorsPublicField)this.jsonb.fromJson("{ \"instance\" : \"New Test String\" }", StringContainerNoAccessorsPublicField.class);
        if (!unmarshalledObject.instance.equals("New Test String")) {
            throw new EETest.Fault("Failed to set public field value.");
        }
        return Status.passed((String)"OK");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Status testNoAccessorsProtectedField() throws EETest.Fault {
        String jsonString = this.jsonb.toJson((Object)new StringContainerNoAccessorsProtectedField());
        if (!jsonString.matches("\\{\\s*\\}")) {
            throw new EETest.Fault("Failed to ignore getting protected field value.");
        }
        try {
            StringContainerNoAccessorsProtectedField unmarshalledObject = (StringContainerNoAccessorsProtectedField)this.jsonb.fromJson("{ \"instance\" : \"New Test String\" }", StringContainerNoAccessorsProtectedField.class);
            Field instanceField = StringContainerNoAccessorsProtectedField.class.getDeclaredField("instance");
            instanceField.setAccessible(true);
            try {
                if (!instanceField.get(unmarshalledObject).equals("Test String")) {
                    throw new EETest.Fault("Failed to ignore setting protected field value.");
                }
            }
            finally {
                instanceField.setAccessible(false);
            }
        }
        catch (Exception x) {
            throw new EETest.Fault(x.getMessage(), x);
        }
        return Status.passed((String)"OK");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Status testNoAccessorsPrivateField() throws EETest.Fault {
        String jsonString = this.jsonb.toJson((Object)new StringContainerNoAccessorsPrivateField());
        if (!jsonString.matches("\\{\\s*\\}")) {
            throw new EETest.Fault("Failed to ignore getting private field value.");
        }
        try {
            StringContainerNoAccessorsPrivateField unmarshalledObject = (StringContainerNoAccessorsPrivateField)this.jsonb.fromJson("{ \"instance\" : \"New Test String\" }", StringContainerNoAccessorsPrivateField.class);
            Field instanceField = StringContainerNoAccessorsPrivateField.class.getDeclaredField("instance");
            instanceField.setAccessible(true);
            try {
                if (!instanceField.get(unmarshalledObject).equals("Test String")) {
                    throw new EETest.Fault("Failed to ignore setting private field value.");
                }
            }
            finally {
                instanceField.setAccessible(false);
            }
        }
        catch (Exception x) {
            throw new EETest.Fault(x.getMessage(), x);
        }
        return Status.passed((String)"OK");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Status testNoAccessorsPackagePrivateField() throws EETest.Fault {
        String jsonString = this.jsonb.toJson((Object)new StringContainerNoAccessorsPackagePrivateField());
        if (!jsonString.matches("\\{\\s*\\}")) {
            throw new EETest.Fault("Failed to ignore getting package private field value.");
        }
        try {
            StringContainerNoAccessorsPackagePrivateField unmarshalledObject = (StringContainerNoAccessorsPackagePrivateField)this.jsonb.fromJson("{ \"instance\" : \"New Test String\" }", StringContainerNoAccessorsPackagePrivateField.class);
            Field instanceField = StringContainerNoAccessorsPackagePrivateField.class.getDeclaredField("instance");
            instanceField.setAccessible(true);
            try {
                if (!instanceField.get(unmarshalledObject).equals("Test String")) {
                    throw new EETest.Fault("Failed to ignore setting package private field value.");
                }
            }
            finally {
                instanceField.setAccessible(false);
            }
        }
        catch (Exception x) {
            throw new EETest.Fault(x.getMessage(), x);
        }
        return Status.passed((String)"OK");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Status testTransientField() throws EETest.Fault {
        String jsonString = this.jsonb.toJson((Object)new StringContainerTransientField());
        if (!jsonString.matches("\\{\\s*\\}")) {
            throw new EETest.Fault("Failed to ignore getting transient field value.");
        }
        try {
            StringContainerTransientField unmarshalledObject = (StringContainerTransientField)this.jsonb.fromJson("{ \"instance\" : \"New Test String\" }", StringContainerTransientField.class);
            Field instanceField = StringContainerTransientField.class.getDeclaredField("instance");
            instanceField.setAccessible(true);
            try {
                if (!instanceField.get(unmarshalledObject).equals("Test String")) {
                    throw new EETest.Fault("Failed to ignore setting transient field value.");
                }
            }
            finally {
                instanceField.setAccessible(false);
            }
        }
        catch (Exception x) {
            throw new EETest.Fault(x.getMessage(), x);
        }
        return Status.passed((String)"OK");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Status testStaticField() throws EETest.Fault {
        String jsonString = this.jsonb.toJson((Object)new StringContainerStaticField());
        if (!jsonString.matches("\\{\\s*\\}")) {
            throw new EETest.Fault("Failed to ignore getting static field value.");
        }
        try {
            StringContainerStaticField unmarshalledObject = (StringContainerStaticField)this.jsonb.fromJson("{ \"instance\" : \"New Test String\" }", StringContainerStaticField.class);
            Field instanceField = StringContainerStaticField.class.getDeclaredField("instance");
            instanceField.setAccessible(true);
            try {
                if (!instanceField.get(unmarshalledObject).equals("Test String")) {
                    throw new EETest.Fault("Failed to ignore setting static field value.");
                }
            }
            finally {
                instanceField.setAccessible(false);
            }
        }
        catch (Exception x) {
            throw new EETest.Fault(x.getMessage(), x);
        }
        return Status.passed((String)"OK");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Status testFinalField() throws EETest.Fault {
        String jsonString = this.jsonb.toJson((Object)new StringContainerFinalField());
        if (!jsonString.matches("\\{\\s*\"instance\"\\s*:\\s*\"Test String\"\\s*\\}")) {
            throw new EETest.Fault("Failed to get final field value.");
        }
        try {
            StringContainerFinalField unmarshalledObject = (StringContainerFinalField)this.jsonb.fromJson("{ \"instance\" : \"New Test String\" }", StringContainerFinalField.class);
            Field instanceField = StringContainerFinalField.class.getDeclaredField("instance");
            instanceField.setAccessible(true);
            try {
                if (!instanceField.get(unmarshalledObject).equals("Test String")) {
                    throw new EETest.Fault("Failed to ignore setting final field value.");
                }
            }
            finally {
                instanceField.setAccessible(false);
            }
        }
        catch (Exception x) {
            throw new EETest.Fault(x.getMessage(), x);
        }
        return Status.passed((String)"OK");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Status testFinalPublicField() throws EETest.Fault {
        String jsonString = this.jsonb.toJson((Object)new StringContainerFinalPublicField());
        if (!jsonString.matches("\\{\\s*\"instance\"\\s*:\\s*\"Test String\"\\s*\\}")) {
            throw new EETest.Fault("Failed to get final public field value.");
        }
        try {
            StringContainerFinalPublicField unmarshalledObject = (StringContainerFinalPublicField)this.jsonb.fromJson("{ \"instance\" : \"New Test String\" }", StringContainerFinalPublicField.class);
            Field instanceField = StringContainerFinalPublicField.class.getDeclaredField("instance");
            instanceField.setAccessible(true);
            try {
                if (!instanceField.get(unmarshalledObject).equals("Test String")) {
                    throw new EETest.Fault("Failed to ignore setting final public field value.");
                }
            }
            finally {
                instanceField.setAccessible(false);
            }
        }
        catch (Exception x) {
            throw new EETest.Fault(x.getMessage(), x);
        }
        return Status.passed((String)"OK");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Status testAccessorsWithoutCorrespondingField() throws EETest.Fault {
        String jsonString = this.jsonb.toJson((Object)new StringContainerAccessorsWithoutMatchingField());
        if (!jsonString.matches("\\{\\s*\"instance\"\\s*:\\s*\"Test String\"\\s*\\}")) {
            throw new EETest.Fault("Failed to get value from getter without corresponding field.");
        }
        try {
            StringContainerAccessorsWithoutMatchingField unmarshalledObject = (StringContainerAccessorsWithoutMatchingField)this.jsonb.fromJson("{ \"instance\" : \"New Test String\" }", StringContainerAccessorsWithoutMatchingField.class);
            Field instanceField = StringContainerAccessorsWithoutMatchingField.class.getDeclaredField("field");
            instanceField.setAccessible(true);
            try {
                if (!instanceField.get(unmarshalledObject).equals("New Test String")) {
                    throw new EETest.Fault("Failed to set value using setter without corresponding field.");
                }
            }
            finally {
                instanceField.setAccessible(false);
            }
        }
        catch (Exception x) {
            throw new EETest.Fault(x.getMessage(), x);
        }
        return Status.passed((String)"OK");
    }

    public Status testDeserialisationOfNonExistentField() throws EETest.Fault {
        try {
            StringContainerPublicAccessors unmarshalledObject = (StringContainerPublicAccessors)this.jsonb.fromJson("{ \"field\" : \"New Test String\" }", StringContainerPublicAccessors.class);
            Field instanceField = StringContainerPublicAccessors.class.getDeclaredField("instance");
            instanceField.setAccessible(true);
            try {
                if (!instanceField.get(unmarshalledObject).equals("Test String")) {
                    throw new EETest.Fault("Failed to ignore setting value to non existent field.");
                }
            }
            finally {
                instanceField.setAccessible(false);
            }
        }
        catch (Exception x) {
            throw new EETest.Fault(x.getMessage(), x);
        }
        return Status.passed((String)"OK");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Status testPublicStaticNestedClass() throws EETest.Fault {
        String jsonString = this.jsonb.toJson((Object)new StringContainerPublicStaticNestedClass());
        if (!jsonString.matches("\\{\\s*\"nestedClass\"\\s*:\\s*\\{\\s*\"instance\"\\s*:\\s*\"Test String\"\\s*\\}\\s*\\}")) {
            throw new EETest.Fault("Failed to get attribute value from public nested class.");
        }
        try {
            StringContainerPublicStaticNestedClass unmarshalledObject = (StringContainerPublicStaticNestedClass)this.jsonb.fromJson("{ \"nestedClass\" : { \"instance\" : \"New Test String\" } }", StringContainerPublicStaticNestedClass.class);
            Field instanceField = StringContainerPublicStaticNestedClass.NestedClass.class.getDeclaredField("instance");
            instanceField.setAccessible(true);
            try {
                if (!instanceField.get(unmarshalledObject.nestedClass).equals("New Test String")) {
                    throw new EETest.Fault("Failed to set attribute value to public nested class.");
                }
            }
            finally {
                instanceField.setAccessible(false);
            }
        }
        catch (Exception x) {
            throw new EETest.Fault(x.getMessage(), x);
        }
        return Status.passed((String)"OK");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Status testProtectedStaticNestedClass() throws EETest.Fault {
        String jsonString = this.jsonb.toJson((Object)new StringContainerProtectedStaticNestedClass());
        if (!jsonString.matches("\\{\\s*\"nestedClass\"\\s*:\\s*\\{\\s*\"instance\"\\s*:\\s*\"Test String\"\\s*\\}\\s*\\}")) {
            throw new EETest.Fault("Failed to get attribute value from protected nested class.");
        }
        try {
            StringContainerProtectedStaticNestedClass unmarshalledObject = (StringContainerProtectedStaticNestedClass)this.jsonb.fromJson("{ \"nestedClass\" : { \"instance\" : \"New Test String\" } }", StringContainerProtectedStaticNestedClass.class);
            Class<?> nestedClass = StringContainerProtectedStaticNestedClass.class.getDeclaredClasses()[0];
            Field instanceField = nestedClass.getDeclaredField("instance");
            instanceField.setAccessible(true);
            try {
                if (!instanceField.get(unmarshalledObject.nestedClass).equals("New Test String")) {
                    throw new EETest.Fault("Failed to set attribute value to protected nested class.");
                }
            }
            finally {
                instanceField.setAccessible(false);
            }
        }
        catch (Exception x) {
            throw new EETest.Fault(x.getMessage(), x);
        }
        return Status.passed((String)"OK");
    }

    public Status testAnonymousClass() throws EETest.Fault {
        Object anonymousInstance = new Object(){
            public String newInstance = "Anonymous";
        };
        String jsonString = this.jsonb.toJson(anonymousInstance);
        if (!jsonString.matches("\\{\\s*\"newInstance\"\\s*:\\s*\"Anonymous\"\\s*\\}")) {
            throw new EETest.Fault("Failed to get attribute value from anonymous class.");
        }
        return Status.passed((String)"OK");
    }
}

