/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.concurrency.api.ManagedTask;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.concurrency.api.common.RunnableTask;
import com.sun.ts.tests.concurrency.api.common.managedTaskListener.ManagedTaskListenerImpl;
import jakarta.enterprise.concurrent.ManagedExecutors;
import jakarta.enterprise.concurrent.ManagedTask;
import jakarta.enterprise.concurrent.ManagedTaskListener;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Properties;

public class Client
extends ServiceEETest
implements Serializable {
    private static final String ENV_ENTRY_JNDI_NAME = "java:comp/env/StringValue";
    private static final String ENV_ENTRY_VALUE = "something";
    private ManagedTaskListenerImpl managedTaskListener;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
        this.managedTaskListener = new ManagedTaskListenerImpl();
    }

    public void cleanup() throws EETest.Fault {
        TestUtil.logTrace((String)"cleanup");
    }

    public void GetExecutionProperties() throws EETest.Fault {
        ManagedTask managedTask;
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("key", "value");
        RunnableTask runnableTask = this.createRunnableTask();
        Runnable task = ManagedExecutors.managedTask((Runnable)runnableTask, properties, (ManagedTaskListener)this.managedTaskListener);
        boolean pass = false;
        if (task instanceof ManagedTask && (managedTask = (ManagedTask)task).getExecutionProperties().get("key") == "value") {
            pass = true;
        }
        if (!pass) {
            throw new EETest.Fault("GetExecutionProperties failed to get expected property");
        }
    }

    public void GetManagedTaskListener() throws EETest.Fault {
        ManagedTask managedTask;
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("key", "value");
        RunnableTask runnableTask = this.createRunnableTask();
        Runnable task = ManagedExecutors.managedTask((Runnable)runnableTask, properties, (ManagedTaskListener)this.managedTaskListener);
        boolean pass = false;
        if (task instanceof ManagedTask && (managedTask = (ManagedTask)task).getManagedTaskListener() == this.managedTaskListener) {
            pass = true;
        }
        if (!pass) {
            throw new EETest.Fault("GetManagedTaskListener failed to get expected managedTaskListener");
        }
    }

    private RunnableTask createRunnableTask() {
        return new RunnableTask(ENV_ENTRY_JNDI_NAME, ENV_ENTRY_VALUE, this.getClass().getName());
    }
}

