/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.common.messaging;

import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.ejb30.common.helper.TLogger;
import com.sun.ts.tests.ejb30.common.messaging.Constants;
import com.sun.ts.tests.jms.commonee.Client;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.QueueBrowser;
import jakarta.jms.QueueConnectionFactory;
import jakarta.jms.QueueReceiver;
import jakarta.jms.QueueSession;
import jakarta.jms.TextMessage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;

public abstract class ClientBase
extends Client
implements Constants {
    private String currentTestName;
    private Queue sendQ;

    protected abstract void initSendQueue();

    protected abstract void initReceiveQueue();

    protected abstract void initQueueConnectionFactory();

    protected Queue getSendQueue() {
        return this.sendQ;
    }

    protected void setSendQueue(Queue q) {
        this.sendQ = q;
    }

    protected Queue getReceiveQueue() {
        return this.rcvrQueue;
    }

    protected void setReceiveQueue(Queue q) {
        this.rcvrQueue = q;
    }

    protected QueueConnectionFactory getQueueConnectionFactory() {
        return this.qFactory;
    }

    protected void setQueueConnectionFactory(QueueConnectionFactory qf) {
        this.qFactory = qf;
    }

    protected String getCurrentTestName() {
        return this.currentTestName;
    }

    protected void setCurrentTestName(String tn) {
        this.currentTestName = tn;
    }

    protected void sendReceive() throws EETest.Fault {
        this.sendReceive(this.getCurrentTestName(), 0);
    }

    protected void sendReceiveNegative(String testname, int testnum) throws EETest.Fault {
        this.sendOnly(testname, testnum);
        if (this.checkOnResponse(testname)) {
            throw new EETest.Fault("This is a negative test that expects no response, but actually got a response.");
        }
        TLogger.log((String[])new String[]{"No response, as expected"});
    }

    protected void sendReceive(String testname, int testnum) throws EETest.Fault {
        this.sendOnly(testname, testnum);
        this.listAllQueueMessages();
        if (!this.checkOnResponse(testname)) {
            throw new EETest.Fault("checkOnResponse for " + testname + " returned false.");
        }
    }

    protected void sendOnly(String testname, int testnum) throws EETest.Fault {
        try {
            this.createTestMessage(testname, testnum);
            MessageProducer producer = this.getMessageProducer();
            producer.setTimeToLive(30000L);
            producer.send((Message)this.msg);
            TLogger.log((String[])new String[]{"**** Sent Message : " + this.msg.getText() + " ****"});
            TLogger.log((String[])new String[]{"message sent from testname: " + testname + ", testnum: " + testnum + ", using producer: " + producer});
        }
        catch (Exception e) {
            throw new EETest.Fault(e);
        }
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.props = p;
        this.setCurrentTestName(p.getProperty("testName"));
        this.initTestProperties(p);
        this.initReceiveQueue();
        try {
            this.configureQueue();
            this.configureTopic();
        }
        catch (JMSException ex) {
            throw new EETest.Fault(ex);
        }
        TLogger.log((String[])new String[]{"get the connection and start up"});
        TLogger.log((String[])new String[]{"Client: connection started, now send initialization msg!"});
    }

    protected MessageProducer getMessageProducer() throws JMSException {
        this.qSender = this.session.createSender(this.getSendQueue());
        return this.qSender;
    }

    protected void listQueueMessages(Queue queue) throws JMSException {
        QueueBrowser browser = this.session.createBrowser(queue);
        Enumeration msgs = browser.getEnumeration();
        if (!msgs.hasMoreElements()) {
            TLogger.log((String[])new String[]{"No messages in queue"});
        } else {
            while (msgs.hasMoreElements()) {
                Message tempMsg = (Message)msgs.nextElement();
                TLogger.log((String[])new String[]{"Message: " + tempMsg});
            }
        }
    }

    protected void listAllQueueMessages() {
        try {
            Queue receiveQueue;
            Queue sendQueue = this.getSendQueue();
            if (sendQueue != null) {
                TLogger.log((String[])new String[]{"Listing Send Queue Messages from " + sendQueue.getQueueName()});
                this.listQueueMessages(sendQueue);
            }
            if ((receiveQueue = this.getReceiveQueue()) != null) {
                TLogger.log((String[])new String[]{"Listing Receive Queue Messages from " + receiveQueue.getQueueName()});
                this.listQueueMessages(receiveQueue);
            }
        }
        catch (JMSException je) {
            TLogger.log((String[])new String[]{"Error Listing Queue Messages"});
            je.printStackTrace();
        }
    }

    protected void configureQueue() throws JMSException {
        this.initQueueConnectionFactory();
        this.qConnect = this.qFactory.createQueueConnection(this.jmsUser, this.jmsPassword);
        this.session = this.qConnect.createQueueSession(false, 1);
        this.qConnect.start();
        this.initSendQueue();
    }

    protected void configureTopic() throws JMSException {
    }

    protected void urlTest(URL url) throws EETest.Fault {
        this.urlTest(url, "PASSED");
    }

    protected void urlTest(URL url, String expectedFirstLine) throws EETest.Fault {
        HttpURLConnection conn = null;
        InputStream is = null;
        TLogger.log((String[])new String[]{"About to connect to url: "});
        TLogger.log((String[])new String[]{url.toString()});
        try {
            conn = (HttpURLConnection)url.openConnection();
            int code = conn.getResponseCode();
            if (code != 200) {
                throw new EETest.Fault("Unexpected return code: " + code);
            }
            is = conn.getInputStream();
            BufferedReader input = new BufferedReader(new InputStreamReader(is));
            String line = input.readLine();
            if (line != null) {
                line = line.trim();
            }
            if (!expectedFirstLine.equals(line)) {
                throw new EETest.Fault("Wrong response. Expected: " + expectedFirstLine + ", received: " + line);
            }
            TLogger.log((String[])new String[]{"Got expected response: " + line});
        }
        catch (IOException e) {
            throw new EETest.Fault(e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    private void initTestProperties(Properties p) throws EETest.Fault {
        this.jmsUser = p.getProperty("user");
        if (this.jmsUser == null) {
            TestUtil.logTrace((String)"user is null");
            throw new EETest.Fault("Error getting user");
        }
        this.jmsPassword = p.getProperty("password");
        if (this.jmsPassword == null) {
            TestUtil.logTrace((String)"passwd is null");
            throw new EETest.Fault("Error getting pwd");
        }
        String time = p.getProperty("jms_timeout");
        if (time == null) {
            TestUtil.logTrace((String)"time is null");
            throw new EETest.Fault("Error getting time");
        }
        this.hostname = p.getProperty("harness.host");
        if (this.hostname == null) {
            TestUtil.logTrace((String)"Hostname is null");
            throw new EETest.Fault("Error getting hostname");
        }
        this.traceFlag = p.getProperty("harness.log.traceflag");
        if (this.traceFlag == null) {
            TestUtil.logTrace((String)"Hostname is null");
            throw new EETest.Fault("Error getting traceflag");
        }
        this.logPort = p.getProperty("harness.log.port");
        if (this.logPort == null) {
            TestUtil.logTrace((String)"logport is null");
            throw new EETest.Fault("Error getting port");
        }
        this.timeout = Integer.parseInt(time);
    }

    @Override
    protected boolean recvMessageInternal(QueueSession session, String TestCase) throws JMSException {
        boolean retcode = false;
        TestUtil.logMsg((String)"@recvMessageInternal");
        QueueReceiver rcvr = session.createReceiver(this.rcvrQueue);
        Message msgRec = null;
        for (int i = 0; i < 10; ++i) {
            TestUtil.logMsg((String)("@recvMessageInternal trying to receive the message: " + i));
            msgRec = rcvr.receive(this.timeout);
            if (msgRec != null && msgRec.getStringProperty("TestCase") != null && msgRec.getStringProperty("TestCase").equals(TestCase)) break;
        }
        if (msgRec != null) {
            if (msgRec instanceof TextMessage) {
                TestUtil.logMsg((String)("**** Received msg text = " + ((TextMessage)msgRec).getText() + " ****"));
            }
            TestUtil.logMsg((String)("**** Received msg getStringProperty('TestCase') = " + msgRec.getStringProperty("TestCase")));
            TestUtil.logMsg((String)("**** Received msg getStringProperty('Status') = " + msgRec.getStringProperty("Status")));
            if (msgRec.getStringProperty("TestCase") == null || msgRec.getStringProperty("Status") == null) {
                TestUtil.logMsg((String)("Fail: unexpected message received from MDB_QUEUE_REPLY msgRec=" + msgRec));
            } else if (msgRec.getStringProperty("TestCase").equals(TestCase) && msgRec.getStringProperty("Status").equals("Pass")) {
                TestUtil.logMsg((String)("TestCase: " + msgRec.getStringProperty("TestCase")));
                TestUtil.logMsg((String)("Status from msg: " + msgRec.getStringProperty("Status")));
                TestUtil.logMsg((String)"Pass: we got the expected msg back! ");
                retcode = true;
            } else if (msgRec.getStringProperty("Status").equals("Fail")) {
                TestUtil.logMsg((String)("TestCase: " + msgRec.getStringProperty("TestCase")));
                TestUtil.logMsg((String)("Status from msg: " + msgRec.getStringProperty("Status")));
                TestUtil.logMsg((String)"Fail: Error(s) occurred! ");
            } else {
                TestUtil.logMsg((String)"Fail: we didnt get the expected msg back! ");
                TestUtil.logMsg((String)("TestCase:  " + msgRec.getStringProperty("TestCase")));
            }
        } else if (msgRec == null) {
            TestUtil.logMsg((String)"Fail: we didnt get any msg back! ");
        }
        return retcode;
    }
}

