/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jsonb.api.builder;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.tests.jsonb.api.model.SimpleContainer;
import jakarta.json.bind.Jsonb;
import jakarta.json.bind.JsonbBuilder;
import jakarta.json.bind.JsonbConfig;
import jakarta.json.bind.spi.JsonbProvider;
import jakarta.json.spi.JsonProvider;
import java.util.Properties;

public class JsonbBuilderTest
extends ServiceEETest {
    private static final long serialVersionUID = 10L;

    public static void main(String[] args) {
        JsonbBuilderTest t = new JsonbBuilderTest();
        Status s = t.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.logMsg("setup ok");
    }

    public void cleanup() throws EETest.Fault {
        this.logMsg("cleanup ok");
    }

    public Status testBuild() throws EETest.Fault {
        Jsonb jsonb = JsonbBuilder.newBuilder().build();
        if (jsonb == null) {
            throw new EETest.Fault("Failed to create a new Jsonb instance using JsonBuilder.build method.");
        }
        return Status.passed((String)"OK");
    }

    public void testCreate() throws EETest.Fault {
        Jsonb jsonb = JsonbBuilder.create();
        if (jsonb == null) {
            throw new EETest.Fault("Failed to create a new Jsonb instance using JsonBuilder.create method.");
        }
    }

    public void testCreateConfig() throws EETest.Fault {
        JsonbConfig jsonbConfig = new JsonbConfig().withNullValues(Boolean.valueOf(true));
        Jsonb jsonb = JsonbBuilder.create((JsonbConfig)jsonbConfig);
        String jsonString = jsonb.toJson((Object)new SimpleContainer(){
            {
                this.setInstance(null);
            }
        });
        if (!jsonString.matches("\\{\\s*\"instance\"\\s*:\\s*null\\s*}")) {
            throw new EETest.Fault("Failed to create a new Jsonb instance using JsonBuilder.create method with Config argument configured with provided configuration.");
        }
    }

    public void testNewBuilder() throws EETest.Fault {
        JsonbBuilder jsonbBuilder = JsonbBuilder.newBuilder();
        if (jsonbBuilder == null || !jsonbBuilder.getClass().equals(JsonbProvider.provider().create().getClass())) {
            throw new EETest.Fault("Failed to create a new Jsonb instance as returned by jakarta.json.bind.spi.JsonbProvider#provider method using JsonBuilder.newBuilder method.");
        }
    }

    public void testNewBuilderString() throws EETest.Fault {
        JsonbBuilder jsonbBuilder = JsonbBuilder.newBuilder((String)JsonbProvider.provider().getClass().getName());
        if (jsonbBuilder == null || !jsonbBuilder.getClass().equals(JsonbProvider.provider((String)JsonbProvider.provider().getClass().getName()).create().getClass())) {
            throw new EETest.Fault("Failed to create a new Jsonb instance as returned by jakarta.json.bind.spi.JsonbProvider#provider(String) method using JsonBuilder.newBuilder method with String argument.");
        }
    }

    public void testNewBuilderProvider() throws EETest.Fault {
        JsonbBuilder jsonbBuilder = JsonbBuilder.newBuilder((JsonbProvider)JsonbProvider.provider());
        if (jsonbBuilder == null || !jsonbBuilder.getClass().equals(JsonbProvider.provider().create().getClass())) {
            throw new EETest.Fault("Failed to create a new Jsonb instance as returned by provider#create method using JsonBuilder.newBuilder method with JsonbProvider argument.");
        }
    }

    public void testWithConfig() throws EETest.Fault {
        JsonbConfig jsonbConfig = new JsonbConfig().withNullValues(Boolean.valueOf(true));
        Jsonb jsonb = JsonbBuilder.newBuilder().withConfig(jsonbConfig).build();
        String jsonString = jsonb.toJson((Object)new SimpleContainer(){
            {
                this.setInstance(null);
            }
        });
        if (!jsonString.matches("\\{\\s*\"instance\"\\s*:\\s*null\\s*}")) {
            throw new EETest.Fault("Failed to apply configuration passed as an argument to JsonbBuilder.withConfig method.");
        }
    }

    public void testWithProvider() throws EETest.Fault {
        JsonbBuilder jsonbBuilder = JsonbBuilder.newBuilder().withProvider(JsonProvider.provider());
        if (jsonbBuilder == null) {
            throw new EETest.Fault("Failed to create a new JsonbBuilder instance using a specific JsonProvider using JsonbBuilder.withProvider method.");
        }
    }
}

