/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jsonb.customizedmapping.propertyorder;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.tests.jsonb.customizedmapping.propertyorder.model.CustomOrderContainer;
import com.sun.ts.tests.jsonb.customizedmapping.propertyorder.model.PartialOrderContainer;
import com.sun.ts.tests.jsonb.customizedmapping.propertyorder.model.RenamedPropertiesContainer;
import com.sun.ts.tests.jsonb.customizedmapping.propertyorder.model.SimpleContainer;
import com.sun.ts.tests.jsonb.customizedmapping.propertyorder.model.SimpleOrderContainer;
import jakarta.json.bind.Jsonb;
import jakarta.json.bind.JsonbBuilder;
import jakarta.json.bind.JsonbConfig;
import java.util.Properties;

public class PropertyOrderCustomizationTest
extends ServiceEETest {
    private static final long serialVersionUID = 10L;
    private final Jsonb jsonb = JsonbBuilder.create();

    public static void main(String[] args) {
        PropertyOrderCustomizationTest t = new PropertyOrderCustomizationTest();
        Status s = t.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.logMsg("setup ok");
    }

    public void cleanup() throws EETest.Fault {
        this.logMsg("cleanup ok");
    }

    public Status testAnyPropertyOrderStrategy() throws EETest.Fault {
        JsonbConfig config = new JsonbConfig();
        config.setProperty("jsonb.property-order-strategy", (Object)"ANY");
        Jsonb jsonb = JsonbBuilder.create((JsonbConfig)config);
        String jsonString = jsonb.toJson((Object)new SimpleContainer(){
            {
                this.setStringInstance("Test String");
            }
        });
        SimpleContainer unmarshalledObject = (SimpleContainer)jsonb.fromJson(jsonString, SimpleContainer.class);
        if (!"Test String".equals(unmarshalledObject.getStringInstance()) || unmarshalledObject.getIntInstance() != 0 || unmarshalledObject.getLongInstance() != 0L) {
            throw new EETest.Fault("Failed to correctly marshal and unmarshal object using PropertyOrderStrategy.ANY.");
        }
        return Status.passed((String)"OK");
    }

    public Status testLexicographicalPropertyOrderStrategy() throws EETest.Fault {
        JsonbConfig config = new JsonbConfig();
        config.setProperty("jsonb.property-order-strategy", (Object)"LEXICOGRAPHICAL");
        Jsonb jsonb = JsonbBuilder.create((JsonbConfig)config);
        String jsonString = jsonb.toJson((Object)new SimpleOrderContainer(){
            {
                this.setStringInstance("Test String");
            }
        });
        if (!jsonString.matches("\\{\\s*\"intInstance\"\\s*\\:\\s*0\\s*,\\s*\"longInstance\"\\s*\\:\\s*0\\s*,\\s*\"stringInstance\"\\s*\\:\\s*\"Test String\"\\s*\\}")) {
            throw new EETest.Fault("Failed to correctly marshal properties in lexicographical order using PropertyOrderStrategy.LEXICOGRAPHICAL.");
        }
        SimpleOrderContainer unmarshalledObject = (SimpleOrderContainer)jsonb.fromJson("{ \"intInstance\" : 1, \"stringInstance\" : \"Test String\", \"longInstance\" : 1 }", SimpleOrderContainer.class);
        if (unmarshalledObject.getIntInstance() != 3) {
            throw new EETest.Fault("Failed to correctly unmarshal properties in order of appearance using PropertyOrderStrategy.LEXICOGRAPHICAL.");
        }
        return Status.passed((String)"OK");
    }

    public Status testReversePropertyOrderStrategy() throws EETest.Fault {
        JsonbConfig config = new JsonbConfig();
        config.setProperty("jsonb.property-order-strategy", (Object)"REVERSE");
        Jsonb jsonb = JsonbBuilder.create((JsonbConfig)config);
        String jsonString = jsonb.toJson((Object)new SimpleOrderContainer(){
            {
                this.setStringInstance("Test String");
            }
        });
        if (!jsonString.matches("\\{\\s*\"stringInstance\"\\s*\\:\\s*\"Test String\"\\s*,\\s*\"longInstance\"\\s*\\:\\s*0\\s*,\\s*\"intInstance\"\\s*\\:\\s*0\\s*\\}")) {
            throw new EETest.Fault("Failed to correctly marshal properties in reverse lexicographical order using PropertyOrderStrategy.REVERSE.");
        }
        SimpleOrderContainer unmarshalledObject = (SimpleOrderContainer)jsonb.fromJson("{ \"intInstance\" : 1, \"stringInstance\" : \"Test String\", \"longInstance\" : 1 }", SimpleOrderContainer.class);
        if (unmarshalledObject.getIntInstance() != 3) {
            throw new EETest.Fault("Failed to correctly unmarshal properties in order of appearance using PropertyOrderStrategy.REVERSE.");
        }
        return Status.passed((String)"OK");
    }

    public Status testCustomPropertyOrder() throws EETest.Fault {
        String jsonString = this.jsonb.toJson((Object)new CustomOrderContainer(){
            {
                this.setStringInstance("Test String");
            }
        });
        if (!jsonString.matches("\\{\\s*\"longInstance\"\\s*\\:\\s*0\\s*,\\s*\"intInstance\"\\s*\\:\\s*0\\s*,\\s*\"stringInstance\"\\s*\\:\\s*\"Test String\"\\s*\\}")) {
            throw new EETest.Fault("Failed to correctly marshal properties in custom order using JsonbPropertyOrder annotation.");
        }
        CustomOrderContainer unmarshalledObject = (CustomOrderContainer)this.jsonb.fromJson("{ \"intInstance\" : 1, \"stringInstance\" : \"Test String\", \"longInstance\" : 0 }", CustomOrderContainer.class);
        if (unmarshalledObject.getIntInstance() != 3) {
            throw new EETest.Fault("Failed to correctly unmarshal properties in order of appearance using JsonbPropertyOrder annotation.");
        }
        return Status.passed((String)"OK");
    }

    public Status testCustomPropertyOrderStrategyOverride() throws EETest.Fault {
        JsonbConfig config = new JsonbConfig();
        config.setProperty("jsonb.property-order-strategy", (Object)"REVERSE");
        Jsonb jsonb = JsonbBuilder.create((JsonbConfig)config);
        String jsonString = jsonb.toJson((Object)new CustomOrderContainer(){
            {
                this.setStringInstance("Test String");
            }
        });
        if (!jsonString.matches("\\{\\s*\"longInstance\"\\s*\\:\\s*0\\s*,\\s*\"intInstance\"\\s*\\:\\s*0\\s*,\\s*\"stringInstance\"\\s*\\:\\s*\"Test String\"\\s*\\}")) {
            throw new EETest.Fault("Failed to correctly marshal properties in custom order using JsonbPropertyOrder annotation.");
        }
        CustomOrderContainer unmarshalledObject = (CustomOrderContainer)jsonb.fromJson("{ \"intInstance\" : 1, \"stringInstance\" : \"Test String\", \"longInstance\" : 0 }", CustomOrderContainer.class);
        if (unmarshalledObject.getIntInstance() != 3) {
            throw new EETest.Fault("Failed to correctly unmarshal properties in order of appearance using JsonbPropertyOrder annotation and PropertyOrderStrategy.REVERSE.");
        }
        return Status.passed((String)"OK");
    }

    public void testCustomPartialPropertyOrder() throws EETest.Fault {
        String jsonString = this.jsonb.toJson((Object)new PartialOrderContainer(){
            {
                this.setStringInstance("Test String");
            }
        });
        if (!jsonString.matches("\\{\\s*\"longInstance\"\\s*\\:\\s*0\\s*,\\s*\"intInstance\"\\s*\\:\\s*0\\s*,\\s*\"stringInstance\"\\s*\\:\\s*\"Test String\".*\\}")) {
            System.out.append("Got JSON: ").println(jsonString);
            throw new EETest.Fault("Failed to correctly marshal properties in custom order using JsonbPropertyOrder annotation.");
        }
        if (!(jsonString.contains("anotherIntInstance") && jsonString.contains("anIntInstance") && jsonString.contains("yetAnotherIntInstance"))) {
            System.out.append("Got JSON: ").println(jsonString);
            throw new EETest.Fault("Did not marshall all expected properties");
        }
        PartialOrderContainer unmarshalledObject = (PartialOrderContainer)this.jsonb.fromJson("{ \"anIntInstance\" : 100, \"yetAnotherIntInstance\":100, \"anotherIntInstance\": 100, \"intInstance\" : 1, \"stringInstance\" : \"Test String\", \"longInstance\" : 0 }", PartialOrderContainer.class);
        if (unmarshalledObject.getIntInstance() != 3) {
            System.out.append("Got Int instance: ").println(unmarshalledObject.getIntInstance());
            throw new EETest.Fault("Failed to correctly unmarshal properties in order of appearance using JsonbPropertyOrder annotation.");
        }
        if (unmarshalledObject.getAnotherIntInstance() != 100) {
            System.out.append("Got AnotherInt instance: ").println(unmarshalledObject.getAnotherIntInstance());
            throw new EETest.Fault("Failed to correctly unmarshal properties in order of appearance using JsonbPropertyOrder annotation.");
        }
        if (unmarshalledObject.getYetAnotherIntInstance() != 100) {
            System.out.append("Got YetAnotherInt instance: ").println(unmarshalledObject.getYetAnotherIntInstance());
            throw new EETest.Fault("Failed to correctly unmarshal properties in order of appearance using JsonbPropertyOrder annotation.");
        }
        if (unmarshalledObject.getAnIntInstance() != 100) {
            System.out.append("Got AnInt instance: ").println(unmarshalledObject.getAnIntInstance());
            throw new EETest.Fault("Failed to correctly unmarshal properties in order of appearance using JsonbPropertyOrder annotation.");
        }
    }

    public void testCustomPartialPropertyOrderStrategyOverride() throws EETest.Fault {
        JsonbConfig config = new JsonbConfig();
        config.setProperty("jsonb.property-order-strategy", (Object)"REVERSE");
        Jsonb jsonb = JsonbBuilder.create((JsonbConfig)config);
        String jsonString = jsonb.toJson((Object)new PartialOrderContainer(){
            {
                this.setStringInstance("Test String");
            }
        });
        if (!jsonString.matches("\\{\\s*\"longInstance\"\\s*\\:\\s*0\\s*,\\s*\"intInstance\"\\s*\\:\\s*0\\s*,\\s*\"stringInstance\"\\s*\\:\\s*\"Test String\".*\\}")) {
            System.out.append("Got JSON: ").println(jsonString);
            throw new EETest.Fault("Failed to correctly marshal properties in custom order using JsonbPropertyOrder annotation.");
        }
        if (!(jsonString.contains("anotherIntInstance") && jsonString.contains("anIntInstance") && jsonString.contains("yetAnotherIntInstance"))) {
            System.out.append("Got JSON: ").println(jsonString);
            throw new EETest.Fault("Did not marshall all expected properties");
        }
        PartialOrderContainer unmarshalledObject = (PartialOrderContainer)jsonb.fromJson("{ \"anIntInstance\" : 100, \"yetAnotherIntInstance\":100, \"anotherIntInstance\": 100, \"intInstance\" : 1, \"stringInstance\" : \"Test String\", \"longInstance\" : 0 }", PartialOrderContainer.class);
        if (unmarshalledObject.getIntInstance() != 3) {
            System.out.append("Got Int instance: ").println(unmarshalledObject.getIntInstance());
            throw new EETest.Fault("Failed to correctly unmarshal properties in order of appearance using JsonbPropertyOrder annotation and PropertyOrderStrategy.REVERSE.");
        }
        if (unmarshalledObject.getAnotherIntInstance() != 100) {
            System.out.append("Got AnotherInt instance: ").println(unmarshalledObject.getAnotherIntInstance());
            throw new EETest.Fault("Failed to correctly unmarshal properties in order of appearance using JsonbPropertyOrder annotation.");
        }
        if (unmarshalledObject.getYetAnotherIntInstance() != 100) {
            System.out.append("Got YetAnotherInt instance: ").println(unmarshalledObject.getYetAnotherIntInstance());
            throw new EETest.Fault("Failed to correctly unmarshal properties in order of appearance using JsonbPropertyOrder annotation.");
        }
        if (unmarshalledObject.getAnIntInstance() != 100) {
            System.out.append("Got AnInt instance: ").println(unmarshalledObject.getAnIntInstance());
            throw new EETest.Fault("Failed to correctly unmarshal properties in order of appearance using JsonbPropertyOrder annotation.");
        }
    }

    public Status testLexicographicalPropertyOrderRenamedProperties() throws EETest.Fault {
        JsonbConfig config = new JsonbConfig();
        config.setProperty("jsonb.property-order-strategy", (Object)"LEXICOGRAPHICAL");
        Jsonb jsonb = JsonbBuilder.create((JsonbConfig)config);
        String jsonString = jsonb.toJson((Object)new RenamedPropertiesContainer(){
            {
                this.setStringInstance("Test String");
                this.setLongInstance(1L);
            }
        });
        if (!jsonString.matches("\\{\\s*\"first\"\\s*\\:\\s*0\\s*,\\s*\"second\"\\s*\\:\\s*\"Test String\"\\s*,\\s*\"third\"\\s*\\:\\s*1\\s*\\}")) {
            throw new EETest.Fault("Failed to correctly marshal renamed properties in lexicographical order using PropertyOrderStrategy.LEXICOGRAPHICAL.");
        }
        RenamedPropertiesContainer unmarshalledObject = (RenamedPropertiesContainer)jsonb.fromJson("{ \"first\" : 1, \"second\" : \"Test String\", \"third\" : 1 }", RenamedPropertiesContainer.class);
        if (unmarshalledObject.getIntInstance() != 3) {
            throw new EETest.Fault("Failed to correctly unmarshal renamed properties in order of appearance using PropertyOrderStrategy.LEXICOGRAPHICAL.");
        }
        return Status.passed((String)"OK");
    }
}

