/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jsonp.api.jsonparsereventtests;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.tests.jsonp.common.JSONP_Util;
import jakarta.json.stream.JsonParser;
import java.util.Properties;

public class Client
extends ServiceEETest {
    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.logMsg("setup ok");
    }

    public void cleanup() throws EETest.Fault {
        this.logMsg("cleanup ok");
    }

    public void jsonValueOfTest() throws EETest.Fault {
        String[] eventTypeStrings;
        boolean pass = true;
        for (String eventTypeString : eventTypeStrings = new String[]{"END_ARRAY", "END_OBJECT", "KEY_NAME", "START_ARRAY", "START_OBJECT", "VALUE_FALSE", "VALUE_NULL", "VALUE_NUMBER", "VALUE_STRING", "VALUE_TRUE"}) {
            try {
                this.logMsg("Testing enum value for string constant name " + eventTypeString);
                JsonParser.Event eventType = JsonParser.Event.valueOf((String)eventTypeString);
                this.logMsg("Got enum type " + eventType + " for enum string constant named " + eventTypeString);
            }
            catch (Exception e) {
                this.logErr("Caught unexpected exception: " + e);
                pass = false;
            }
        }
        this.logMsg("Testing negative test case for NullPointerException");
        try {
            JsonParser.Event.valueOf(null);
            this.logErr("did not get expected NullPointerException");
            pass = false;
        }
        catch (NullPointerException e) {
            this.logMsg("Got expected NullPointerException");
        }
        catch (Exception e) {
            this.logErr("Got unexpected exception " + e);
            pass = false;
        }
        this.logMsg("Testing negative test case for IllegalArgumentException");
        try {
            JsonParser.Event.valueOf((String)"INVALID");
            this.logErr("did not get expected IllegalArgumentException");
            pass = false;
        }
        catch (IllegalArgumentException e) {
            this.logMsg("Got expected IllegalArgumentException");
        }
        catch (Exception e) {
            this.logErr("Got unexpected exception " + e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault("jsonValueOfTest Failed");
        }
    }

    public void jsonValuesTest() throws EETest.Fault {
        JsonParser.Event[] values;
        boolean pass = true;
        this.logMsg("Testing API method JsonParser.Event.values() to return array of enums.");
        for (JsonParser.Event eventType : values = JsonParser.Event.values()) {
            String eventString = JSONP_Util.getEventTypeString(eventType);
            if (eventString == null) {
                this.logErr("Got no value for enum " + eventType);
                pass = false;
                continue;
            }
            this.logMsg("Got " + eventString + " for enum " + eventType);
        }
        if (!pass) {
            throw new EETest.Fault("jsonValuesTest Failed");
        }
    }
}

