/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.common;

import com.sun.ts.tests.jms.common.MessageTestImpl;
import jakarta.jms.JMSException;
import jakarta.jms.MapMessage;
import jakarta.jms.MessageFormatException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;

public class MapMessageTestImpl
extends MessageTestImpl
implements MapMessage {
    private HashMap htable;

    public MapMessageTestImpl() {
        this.init();
    }

    private void init() {
        this.htable = new HashMap();
    }

    public boolean getBoolean(String name) throws JMSException {
        boolean ret = false;
        Object value = this.htable.get(name);
        if (value instanceof Boolean) {
            ret = (Boolean)value;
        } else if (value instanceof String) {
            ret = Boolean.valueOf((String)value);
        } else {
            throw new MessageFormatException("type conversion is invalid");
        }
        return ret;
    }

    public byte getByte(String name) throws JMSException {
        byte ret = 0;
        Object value = this.htable.get(name);
        if (value instanceof Byte) {
            ret = (Byte)value;
        } else if (value instanceof String) {
            ret = Byte.valueOf((String)value);
        } else {
            throw new MessageFormatException("type conversion is invalid");
        }
        return ret;
    }

    public short getShort(String name) throws JMSException {
        short ret = 0;
        Object value = this.htable.get(name);
        if (value instanceof Byte) {
            ret = ((Byte)value).byteValue();
        } else if (value instanceof Short) {
            ret = (Short)value;
        } else if (value instanceof String) {
            ret = Short.valueOf((String)value);
        } else {
            throw new MessageFormatException("type conversion is invalid");
        }
        return ret;
    }

    public char getChar(String name) throws JMSException {
        char ret = '\u0000';
        Object value = this.htable.get(name);
        if (value instanceof Character) {
            ret = ((Character)value).charValue();
        } else if (value instanceof String) {
            ret = ((String)value).charAt(0);
        } else {
            throw new MessageFormatException("type conversion is invalid");
        }
        return ret;
    }

    public int getInt(String name) throws JMSException {
        int ret = 0;
        Object value = this.htable.get(name);
        if (value instanceof Byte) {
            ret = ((Byte)value).byteValue();
        } else if (value instanceof Short) {
            ret = ((Short)value).shortValue();
        } else if (value instanceof Integer) {
            ret = (Integer)value;
        } else if (value instanceof String) {
            ret = Integer.valueOf((String)value);
        } else {
            throw new MessageFormatException("type conversion is invalid");
        }
        return ret;
    }

    public long getLong(String name) throws JMSException {
        long ret = 0L;
        Object value = this.htable.get(name);
        if (value instanceof Byte) {
            ret = ((Byte)value).byteValue();
        } else if (value instanceof Short) {
            ret = ((Short)value).shortValue();
        } else if (value instanceof Integer) {
            ret = ((Integer)value).intValue();
        } else if (value instanceof Long) {
            ret = (Long)value;
        } else if (value instanceof String) {
            ret = Long.valueOf((String)value);
        } else {
            throw new MessageFormatException("type conversion is invalid");
        }
        return ret;
    }

    public float getFloat(String name) throws JMSException {
        float ret = 0.0f;
        Object value = this.htable.get(name);
        if (value instanceof Float) {
            ret = ((Float)value).floatValue();
        } else if (value instanceof String) {
            ret = Float.valueOf((String)value).floatValue();
        } else {
            throw new MessageFormatException("type conversion is invalid");
        }
        return ret;
    }

    public double getDouble(String name) throws JMSException {
        double ret = 0.0;
        Object value = this.htable.get(name);
        if (value instanceof Float) {
            ret = ((Float)value).floatValue();
        } else if (value instanceof Double) {
            ret = (Double)value;
        } else if (value instanceof String) {
            ret = Double.valueOf((String)value);
        } else {
            throw new MessageFormatException("type conversion is invalid");
        }
        return ret;
    }

    public String getString(String name) throws JMSException {
        String ret = null;
        Object value = this.htable.get(name);
        if (!(value instanceof Boolean || value instanceof Byte || value instanceof Short || value instanceof Character || value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double || value instanceof String)) {
            throw new MessageFormatException("invalid type");
        }
        ret = String.valueOf(value);
        return ret;
    }

    public byte[] getBytes(String name) throws JMSException {
        byte[] ret = null;
        Object value = this.htable.get(name);
        if (!(value instanceof byte[])) {
            throw new MessageFormatException("invalid type");
        }
        ret = (byte[])value;
        return ret;
    }

    public Object getObject(String name) throws JMSException {
        return this.htable.get(name);
    }

    public Enumeration getMapNames() throws JMSException {
        Vector v = new Vector(this.htable.keySet());
        return v.elements();
    }

    public void setBoolean(String name, boolean value) throws JMSException {
        try {
            this.htable.put(name, value);
        }
        catch (NullPointerException e) {
            JMSException jmsEx = new JMSException("NullPointerException");
            jmsEx.setLinkedException((Exception)e);
            throw jmsEx;
        }
    }

    public void setByte(String name, byte value) throws JMSException {
        try {
            this.htable.put(name, value);
        }
        catch (NullPointerException e) {
            JMSException jmsEx = new JMSException("NullPointerException");
            jmsEx.setLinkedException((Exception)e);
            throw jmsEx;
        }
    }

    public void setShort(String name, short value) throws JMSException {
        try {
            this.htable.put(name, value);
        }
        catch (NullPointerException e) {
            JMSException jmsEx = new JMSException("NullPointerException");
            jmsEx.setLinkedException((Exception)e);
            throw jmsEx;
        }
    }

    public void setChar(String name, char value) throws JMSException {
        try {
            this.htable.put(name, Character.valueOf(value));
        }
        catch (NullPointerException e) {
            JMSException jmsEx = new JMSException("NullPointerException");
            jmsEx.setLinkedException((Exception)e);
            throw jmsEx;
        }
    }

    public void setInt(String name, int value) throws JMSException {
        try {
            this.htable.put(name, value);
        }
        catch (NullPointerException e) {
            JMSException jmsEx = new JMSException("NullPointerException");
            jmsEx.setLinkedException((Exception)e);
            throw jmsEx;
        }
    }

    public void setLong(String name, long value) throws JMSException {
        try {
            this.htable.put(name, value);
        }
        catch (NullPointerException e) {
            JMSException jmsEx = new JMSException("NullPointerException");
            jmsEx.setLinkedException((Exception)e);
            throw jmsEx;
        }
    }

    public void setFloat(String name, float value) throws JMSException {
        try {
            this.htable.put(name, Float.valueOf(value));
        }
        catch (NullPointerException e) {
            JMSException jmsEx = new JMSException("NullPointerException");
            jmsEx.setLinkedException((Exception)e);
            throw jmsEx;
        }
    }

    public void setDouble(String name, double value) throws JMSException {
        try {
            this.htable.put(name, value);
        }
        catch (NullPointerException e) {
            JMSException jmsEx = new JMSException("NullPointerException");
            jmsEx.setLinkedException((Exception)e);
            throw jmsEx;
        }
    }

    public void setString(String name, String value) throws JMSException {
        try {
            this.htable.put(name, value);
        }
        catch (NullPointerException e) {
            JMSException jmsEx = new JMSException("NullPointerException");
            jmsEx.setLinkedException((Exception)e);
            throw jmsEx;
        }
    }

    public void setBytes(String name, byte[] value) throws JMSException {
        try {
            this.htable.put(name, value);
        }
        catch (NullPointerException e) {
            JMSException jmsEx = new JMSException("NullPointerException");
            jmsEx.setLinkedException((Exception)e);
            throw jmsEx;
        }
    }

    public void setBytes(String name, byte[] value, int offset, int length) throws JMSException {
        try {
            byte[] newValue = (byte[])this.htable.get(name);
            System.arraycopy(value, 0, newValue, offset, length);
            this.htable.put(name, newValue);
        }
        catch (NullPointerException e) {
            JMSException jmsEx = new JMSException("NullPointerException");
            jmsEx.setLinkedException((Exception)e);
            throw jmsEx;
        }
    }

    public void setObject(String name, Object value) throws JMSException {
        try {
            if (!(value instanceof Boolean || value instanceof Byte || value instanceof Short || value instanceof Character || value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double || value instanceof String || value instanceof byte[])) {
                throw new MessageFormatException("invalid type");
            }
            this.htable.put(name, value);
        }
        catch (NullPointerException e) {
            JMSException jmsEx = new JMSException("NullPointerException");
            jmsEx.setLinkedException((Exception)e);
            throw jmsEx;
        }
    }

    public boolean itemExists(String name) throws JMSException {
        return this.htable.containsKey(name);
    }
}

