/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.common.interceptor;

import com.sun.ts.tests.ejb30.common.calc.CalculatorException;
import com.sun.ts.tests.ejb30.common.helper.TLogger;
import com.sun.ts.tests.ejb30.common.interceptor.Constants;
import jakarta.ejb.EJBContext;
import jakarta.interceptor.InvocationContext;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class AroundInvokeTestImpl
implements Constants,
Serializable {
    public static final String EJBCONTEXT_NAME = "java:comp/env/ejbContext";
    protected Object bean;
    protected Principal beanPrincipal;

    public AroundInvokeTestImpl() {
    }

    public AroundInvokeTestImpl(Object bean, Principal princ) {
        this.bean = bean;
        this.beanPrincipal = princ;
    }

    protected static String getTestName(InvocationContext ctx) {
        Object[] params;
        Method meth = ctx.getMethod();
        String methName = meth.getName();
        if ("onMessage".equals(methName) && (params = ctx.getParameters()).length == 1 && params[0] instanceof Message) {
            Message msg = (Message)params[0];
            try {
                methName = msg.getStringProperty("COM_SUN_JMS_TESTNAME");
            }
            catch (JMSException e) {
                throw new IllegalStateException("Failed to get test name from message: " + msg);
            }
        }
        return methName;
    }

    public Object intercept(InvocationContext ctx) throws CalculatorException {
        Object result;
        block42: {
            int orderInChain = 1;
            result = null;
            String methName = AroundInvokeTestImpl.getTestName(ctx);
            if ("getBeanTest".equals(methName)) {
                this.getBeanTest(ctx);
            } else if ("getMethodTest".equals(methName)) {
                this.getMethodTest(ctx);
            } else if ("getParametersTest".equals(methName)) {
                this.getParametersTest(ctx);
            } else if ("getParametersEmptyTest".equals(methName)) {
                this.getParametersEmptyTest(ctx);
            } else if ("setParametersTest".equals(methName)) {
                this.setParametersTest(ctx);
            } else if ("getContextDataTest".equals(methName)) {
                this.putContextData(ctx);
            } else if ("exceptionTest".equals(methName)) {
                this.exceptionTest(ctx);
            } else if (!"suppressExceptionTest".equals(methName)) {
                if ("txRollbackOnlyTest".equals(methName)) {
                    this.txRollbackOnlyTest(ctx);
                } else if (!"txRollbackOnlyAfterTest".equals(methName)) {
                    if ("orderTest".equals(methName)) {
                        this.checkOrder0(ctx, orderInChain);
                    } else if ("sameInvocationContextTest".equals(methName)) {
                        this.checkInvocationContext0(ctx, orderInChain);
                    } else if ("runtimeExceptionTest".equals(methName)) {
                        this.runtimeExceptionTest(ctx);
                    } else if (!"runtimeExceptionAfterTest".equals(methName)) {
                        if ("sameSecContextTest".equals(methName)) {
                            this.sameSecContextTest(ctx);
                        } else if ("methodLevelInterceptorMixedTest".equals(methName) || "methodLevelClassLevelInterceptorMixedTest".equals(methName) || "repeatedInterceptors".equals(methName) || "interceptorOrderingOverride".equals(methName)) {
                            this.methodLevelInterceptorMixedTest(ctx);
                        }
                    }
                }
            }
            try {
                result = ctx.proceed();
            }
            catch (CalculatorException e) {
                if ("suppressExceptionTest".equals(methName)) {
                    break block42;
                }
                throw e;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
            finally {
                if ("getContextDataTest".equals(methName)) {
                    this.getContextDataTest(ctx);
                } else if ("txRollbackOnlyAfterTest".equals(methName)) {
                    this.txRollbackOnlyAfterTest(ctx);
                } else if ("runtimeExceptionAfterTest".equals(methName)) {
                    this.runtimeExceptionAfterTest(ctx);
                }
            }
        }
        return result;
    }

    protected void checkOrder0(InvocationContext ctx, int orderInChain) throws CalculatorException {
        AroundInvokeTestImpl.checkOrder(ctx, orderInChain);
    }

    protected void checkInvocationContext0(InvocationContext ctx, int orderInChain) throws CalculatorException {
        AroundInvokeTestImpl.checkInvocationContext(ctx, orderInChain);
    }

    public static Object intercept2(InvocationContext ctx, int orderInChain) throws CalculatorException {
        Object result = null;
        String methName = AroundInvokeTestImpl.getTestName(ctx);
        if ("orderTest".equals(methName)) {
            AroundInvokeTestImpl.checkOrder(ctx, orderInChain);
        } else if ("sameInvocationContextTest".equals(methName)) {
            AroundInvokeTestImpl.checkInvocationContext(ctx, orderInChain);
        }
        try {
            result = ctx.proceed();
        }
        catch (CalculatorException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        return result;
    }

    public static void checkInvocationContext(InvocationContext ctx, int orderInChain) throws CalculatorException {
        Map map = ctx.getContextData();
        Object obj = map.get("same.invocationcontext");
        if (obj == null) {
            map.put("same.invocationcontext", ctx);
        } else if (obj == ctx) {
            TLogger.log((String[])new String[]{"same instance of InvocationContext is used in this interceptor."});
        } else {
            throw new CalculatorException("The following InvocationContext are expected to be the same instance " + ctx + ", " + obj);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void checkOrder(InvocationContext ctx, int num) throws CalculatorException {
        Map map = ctx.getContextData();
        Object obj = map.get("interceptor.order");
        if (num == 1) {
            if (obj != null) throw new CalculatorException("Expected null for key interceptor.order, actual " + obj);
            Integer order = new Integer(1);
            map.put("interceptor.order", order);
            TLogger.log((String[])new String[]{"order of current interceptor: 1"});
            return;
        } else {
            if (num <= 1) return;
            if (obj == null) {
                throw new CalculatorException("Illegal state of InvocationContext: keyed data is null.");
            }
            int order = (Integer)obj;
            if (order != num - 1) throw new CalculatorException("Expected order of previous interceptor " + (num - 1) + ", actual " + order);
            int currentOrder = AroundInvokeTestImpl.incrementOrder(map);
            TLogger.log((String[])new String[]{"order of current interceptor: " + currentOrder});
        }
    }

    public static int incrementOrder(Map<String, Object> map) {
        Object obj = map.get("interceptor.order");
        int order = (Integer)obj;
        Integer newOrder = new Integer(order + 1);
        map.put("interceptor.order", newOrder);
        return order + 1;
    }

    protected void sameSecContextTest(InvocationContext ctx) throws CalculatorException {
        EJBContext ejbContext = AroundInvokeTestImpl.getEJBContext();
        Principal princ = ejbContext.getCallerPrincipal();
        if (princ == null) {
            throw new CalculatorException("In AroundInvokeTestImpl, caller principal is null.");
        }
        if (this.bean != null) {
            if (this.beanPrincipal != null) {
                if (!princ.equals(this.beanPrincipal)) {
                    throw new CalculatorException("Principal in interceptor is not the same as in bean.");
                }
                TLogger.log((String[])new String[]{"sameSecContextTest passed: interceptor has the same Principal as bean method."});
            } else {
                throw new CalculatorException("In AroundInvokeTestImpl, bean is not null, but beanPrincipal is null.");
            }
        }
    }

    protected void txRollbackOnlyTest(InvocationContext ctx) throws CalculatorException {
        EJBContext con = AroundInvokeTestImpl.getEJBContext();
        con.setRollbackOnly();
    }

    protected void txRollbackOnlyAfterTest(InvocationContext ctx) throws CalculatorException {
        EJBContext con = AroundInvokeTestImpl.getEJBContext();
        con.setRollbackOnly();
        if (!con.getRollbackOnly()) {
            throw new CalculatorException("tx was set rollback only in interceptor, but subsequent EJBContext.getRollbackOnly() returns false.");
        }
    }

    protected void runtimeExceptionTest(InvocationContext ctx) throws CalculatorException {
        throw new RuntimeException("From AroundInvoke method to mark tx rollback only.");
    }

    protected void runtimeExceptionAfterTest(InvocationContext ctx) throws CalculatorException {
        throw new RuntimeException("From AroundInvoke method to mark tx rollback only.");
    }

    protected void exceptionTest(InvocationContext ctx) throws CalculatorException {
        TLogger.log((String[])new String[]{"about to throw CalculatorException"});
        throw new CalculatorException("Expected CalculatorException from exceptionTest");
    }

    protected void suppressExceptionTest(InvocationContext ctx) throws CalculatorException {
    }

    protected void getBeanTest(InvocationContext ctx) throws CalculatorException {
        Object bean = ctx.getTarget();
        if (this.bean == null) {
            if (bean == null) {
                throw new CalculatorException("InvocationContext.getBean() returned null.");
            }
            return;
        }
        if (this.bean != bean) {
            throw new CalculatorException("Expected " + this.bean + ", actual " + bean);
        }
        TLogger.log((String[])new String[]{"getBeanTest passed"});
    }

    protected void getParametersTest(InvocationContext ctx) throws CalculatorException {
        Object[] params = ctx.getParameters();
        String errorMsg = null;
        if (params == null) {
            errorMsg = ", actual null";
        } else if (params.length != 1) {
            errorMsg = ", actual " + Arrays.asList(params).toString();
        } else if (!"old param value".equals(params[0])) {
            errorMsg = ", actual " + params[0];
        }
        if (errorMsg != null) {
            throw new CalculatorException("Expected old param value" + errorMsg);
        }
    }

    protected void getParametersEmptyTest(InvocationContext ctx) throws CalculatorException {
        Object[] params = ctx.getParameters();
        if (params != null && params.length != 0) {
            throw new CalculatorException("Expected null or empty array, actual " + Arrays.asList(params).toString());
        }
    }

    protected void setParametersTest(InvocationContext ctx) throws CalculatorException {
        Object[] params = new Object[]{"new param value"};
        ctx.setParameters(params);
    }

    protected void putContextData(InvocationContext ctx) throws CalculatorException {
        Map map = ctx.getContextData();
        map.put("msg.key", "from bean class intercept()");
        String logmsg = "put into InvocationContext data: msg.key=from bean class intercept()";
        TLogger.log((String[])new String[]{logmsg});
    }

    protected void getContextDataTest(InvocationContext ctx) throws CalculatorException {
        Map map = ctx.getContextData();
        String msg = (String)map.get("msg.key");
        if (!"from bean class intercept()".equals(msg)) {
            throw new CalculatorException("Expected InvocationContext data for key msg.key: from bean class intercept(), actual " + msg);
        }
        String passed = "getContextDataTest for InvocationContext passed.";
        TLogger.log((String[])new String[]{passed});
    }

    protected void getMethodTest(InvocationContext ctx) throws CalculatorException {
        Method meth = ctx.getMethod();
        if (this.bean == null) {
            if (meth == null) {
                throw new CalculatorException("InvocationContext.getMethod() returned null.");
            }
            return;
        }
        Method expectedMeth = null;
        try {
            expectedMeth = this.bean.getClass().getMethod("getMethodTest", null);
        }
        catch (NoSuchMethodException e) {
            throw new CalculatorException("Failed to get method getMethodTest from bean " + this.bean, (Throwable)e);
        }
        if (!meth.equals(expectedMeth)) {
            throw new CalculatorException("Expected " + expectedMeth + ", actual " + meth);
        }
        String passed = "getMethodTest for InvocationContext passed.";
        TLogger.log((String[])new String[]{passed});
    }

    protected static EJBContext getEJBContext() {
        EJBContext ec = null;
        try {
            InitialContext ic = new InitialContext();
            Object ob = ic.lookup(EJBCONTEXT_NAME);
            ec = (EJBContext)ob;
        }
        catch (NamingException e) {
            throw new IllegalStateException("Make sure SessionContext or MessageDrivenContext with name java:comp/env/ejbContext is injected into AroundInvoke bean.", e);
        }
        return ec;
    }

    protected void methodLevelInterceptorMixedTest(InvocationContext ctx) throws CalculatorException {
        Object[] params = ctx.getParameters();
        if (params == null || params.length == 0) {
            throw new CalculatorException("Expecting method params to have 1 ArrayList<String> element, but actual is null or empty: " + params);
        }
        ArrayList alist = (ArrayList)params[0];
        String fullClassName = this.getClass().getName();
        alist.add(fullClassName.substring(fullClassName.lastIndexOf(".") + 1));
    }
}

