/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.core.nestedembedding;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jpa.common.PMClientBase;
import com.sun.ts.tests.jpa.core.nestedembedding.A;
import com.sun.ts.tests.jpa.core.nestedembedding.Address;
import com.sun.ts.tests.jpa.core.nestedembedding.B;
import com.sun.ts.tests.jpa.core.nestedembedding.ZipCode;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;

public class Client
extends PMClientBase {
    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
        try {
            super.setup(args, p);
            this.removeTestData();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception: ", (Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void NE1XMTest1() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        try {
            TestUtil.logTrace((String)"New instances");
            ZipCode z1 = new ZipCode("01801", "1234");
            ZipCode z2 = new ZipCode("01803", "1234");
            Address addr1 = new Address("1 Network Drive", "Burlington", "MA");
            Address addr2 = new Address("Some Address", "Boston", "MA");
            addr1.setZipCode(z1);
            addr2.setZipCode(z2);
            B b1 = new B("1", "b1", 1);
            b1.setAddress(addr1);
            B b2 = new B("2", "b2", 1);
            b2.setAddress(addr2);
            B b3 = new B("3", "b3", 1);
            b3.setAddress(addr1);
            B b4 = new B("4", "b4", 1);
            b4.setAddress(addr2);
            Vector<B> v1 = new Vector<B>();
            v1.add(b1);
            v1.add(b2);
            v1.add(b3);
            v1.add(b4);
            A aRef = new A("1", "bean1", 1, v1);
            this.getEntityManager().persist((Object)aRef);
            this.getEntityManager().flush();
            this.clearCache();
            Collection newCol = aRef.getBCol();
            this.dumpCollectionDataB(newCol);
            if (newCol.contains(b1) && newCol.contains(b2) && newCol.contains(b3) && newCol.contains(b4)) {
                B newB = this.getBFromCollection(newCol, b1);
                if (newB != null) {
                    if (newB.getAddress().getStreet().equals("1 Network Drive") && newB.getAddress().getCity().equals("Burlington") && newB.getAddress().getState().equals("MA") && newB.getAddress().getZipCode().getZip().equals("01801") && newB.getAddress().getZipCode().getPlusFour().equals("1234")) {
                        pass = true;
                        TestUtil.logTrace((String)"verified nested embedded class contents ");
                    } else {
                        TestUtil.logErr((String)("Expected address:" + addr1.toString()));
                        TestUtil.logErr((String)("actual address:" + newB.getAddress().toString()));
                    }
                } else {
                    TestUtil.logErr((String)"b not found in Collection");
                }
            } else {
                TestUtil.logErr((String)"Collection did not contain all entries:");
                if (newCol.contains(b1)) {
                    TestUtil.logTrace((String)"found b1");
                } else {
                    TestUtil.logErr((String)"b1 NOT FOUND");
                }
                if (newCol.contains(b2)) {
                    TestUtil.logTrace((String)"found b2");
                } else {
                    TestUtil.logErr((String)"b2 NOT FOUND");
                }
                if (newCol.contains(b3)) {
                    TestUtil.logTrace((String)"found b3");
                } else {
                    TestUtil.logErr((String)"b3 NOT FOUND");
                }
                if (newCol.contains(b4)) {
                    TestUtil.logTrace((String)"found b4");
                } else {
                    TestUtil.logErr((String)"b4 NOT FOUND");
                }
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new EETest.Fault("cascadeAll1XMTest1 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void NE1XMTest2() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        try {
            TestUtil.logTrace((String)"New instances");
            ZipCode z1 = new ZipCode("01801", "1234");
            ZipCode z2 = new ZipCode("01803", "1234");
            Address addr1 = new Address("1 Network Drive", "Burlington", "MA");
            Address addr2 = new Address("Some Address", "Boston", "MA");
            addr1.setZipCode(z1);
            addr2.setZipCode(z2);
            B b1 = new B("1", "b1", 1);
            b1.setAddress(addr1);
            B b2 = new B("2", "b2", 1);
            b2.setAddress(addr2);
            Vector<B> v1 = new Vector<B>();
            v1.add(b1);
            v1.add(b2);
            A aRef = new A("1", "bean1", 1, v1);
            this.getEntityManager().persist((Object)aRef);
            this.getEntityManager().flush();
            this.clearCache();
            A newA = this.findA("1");
            if (newA != null) {
                Collection newCol = aRef.getBCol();
                B newB = (B)this.getEntityManager().createQuery("Select b from B b where b.address.zipcode.zip='01801'").getSingleResult();
                if (newB != null) {
                    TestUtil.logTrace((String)("newB:" + newB.toString()));
                    if (newCol.contains(newB)) {
                        TestUtil.logTrace((String)"b contains the searched embeddable Address");
                        pass = true;
                    } else {
                        TestUtil.logErr((String)("Expected:" + newCol.toString() + ", actual:" + newB.toString()));
                    }
                } else {
                    TestUtil.logErr((String)"newB is null");
                }
            } else {
                TestUtil.logErr((String)"newA is null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new EETest.Fault("NE1XMTest2 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void NE1XMTest3() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        try {
            TestUtil.logTrace((String)"New instances");
            ZipCode z1 = new ZipCode("01801", "1234");
            ZipCode z2 = new ZipCode("01803", "1234");
            Address addr1 = new Address("1 Network Drive", "Burlington", "MA");
            Address addr2 = new Address("Some Address", "Boston", "MA");
            addr1.setZipCode(z1);
            addr2.setZipCode(z2);
            B b1 = new B("1", "b1", 1);
            b1.setAddress(addr1);
            B b2 = new B("2", "b2", 1);
            b2.setAddress(addr2);
            Vector<B> v1 = new Vector<B>();
            v1.add(b1);
            v1.add(b2);
            A aRef = new A("1", "bean1", 1, v1);
            this.getEntityManager().persist((Object)aRef);
            this.getEntityManager().flush();
            this.clearCache();
            A newA = this.findA("1");
            if (newA != null) {
                Collection newCol = aRef.getBCol();
                B newB = (B)this.getEntityManager().createQuery("Select b from B b where b.address.street='1 Network Drive'").getSingleResult();
                if (newB != null) {
                    if (newCol.contains(newB)) {
                        TestUtil.logTrace((String)"b contains the searched embeddable Address");
                        pass = true;
                    } else {
                        TestUtil.logErr((String)("Expected:" + newCol.toString() + ", actual:" + newB.toString()));
                    }
                } else {
                    TestUtil.logErr((String)"newB is null");
                }
            } else {
                TestUtil.logErr((String)"newA is null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new EETest.Fault("NE1XMTest3 failed");
        }
    }

    private void createA(A a) {
        TestUtil.logTrace((String)"Entered createA method");
        this.getEntityTransaction().begin();
        this.getEntityManager().persist((Object)a);
        this.getEntityTransaction().commit();
    }

    private A findA(String id) {
        return (A)this.getEntityManager().find(A.class, (Object)id);
    }

    private void createB(B b) {
        TestUtil.logTrace((String)"Entered createB method");
        this.getEntityTransaction().begin();
        this.getEntityManager().persist((Object)b);
        this.getEntityTransaction().commit();
    }

    private B findB(String id) {
        return (B)this.getEntityManager().find(B.class, (Object)id);
    }

    private List findByName(String name) {
        TestUtil.logTrace((String)"Entered findByName method");
        return this.getEntityManager().createQuery("select a from A a where a.name = :name").setParameter("name", (Object)name).getResultList();
    }

    private boolean getInstanceStatus(Object o) {
        TestUtil.logTrace((String)"Entered getInstanceStatus method");
        return this.getEntityManager().contains(o);
    }

    private void dumpCollectionDataA(Collection c) {
        TestUtil.logTrace((String)"collection Data");
        TestUtil.logTrace((String)"---------------");
        TestUtil.logTrace((String)("- size=" + c.size()));
        Iterator i = c.iterator();
        int elem = 1;
        while (i.hasNext()) {
            A v = (A)i.next();
            TestUtil.logTrace((String)("- Element #" + elem++));
            TestUtil.logTrace((String)("  id=" + v.getAId() + ", name=" + v.getAName() + ", value=" + v.getAValue()));
        }
    }

    private void dumpCollectionDataB(Collection c) {
        TestUtil.logTrace((String)"collection Data");
        TestUtil.logTrace((String)"---------------");
        TestUtil.logTrace((String)("- size=" + c.size()));
        Iterator i = c.iterator();
        int elem = 1;
        while (i.hasNext()) {
            B v = (B)i.next();
            TestUtil.logTrace((String)("- Element #" + elem++));
            TestUtil.logTrace((String)("  id=" + v.getBId() + ", name=" + v.getBName() + ", value=" + v.getBValue()));
        }
    }

    public B getBFromCollection(Collection c, B b) {
        TestUtil.logTrace((String)"getBFromCollection");
        B resultB = null;
        if (c.size() != 0) {
            for (B newB : c) {
                if (newB.getBId().equals(b.getBId()) && newB.getBName().equals(b.getBName()) && newB.getBValue() == b.getBValue()) {
                    TestUtil.logTrace((String)"Found B in Collection");
                    resultB = newB;
                    return resultB;
                }
                TestUtil.logTrace((String)"b not found in Collection");
            }
        }
        return resultB;
    }

    @Override
    public void cleanup() throws EETest.Fault {
        TestUtil.logTrace((String)"Cleanup data");
        this.removeTestData();
        TestUtil.logTrace((String)"cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        TestUtil.logTrace((String)"removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM ANE_1XM_BI_BTOB").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM BNE_1XM_BI_BTOB").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

