/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.core.callback.inheritance;

import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jpa.core.callback.common.EntityCallbackClientBase;
import com.sun.ts.tests.jpa.core.callback.inheritance.PricedPartProduct;
import com.sun.ts.tests.jpa.core.callback.inheritance.PricedPartProduct_2;
import com.sun.ts.tests.jpa.core.callback.inheritance.Product;
import jakarta.persistence.Query;
import java.util.List;
import java.util.Properties;

public class Client
extends EntityCallbackClientBase {
    private PricedPartProduct p1;
    private PricedPartProduct_2 p2;

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
        try {
            super.setup(args, p);
            this.removeTestData();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception: ", (Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    private PricedPartProduct_2 newPricedPartProduct_2(String testName) {
        PricedPartProduct_2 product = new PricedPartProduct_2();
        product.setTestName(testName);
        product.setId(testName);
        product.setName(testName);
        product.setPartNumber(1L);
        product.setPrice(1.0);
        product.setQuantity(1);
        return product;
    }

    private PricedPartProduct newPricedPartProduct(String testName) {
        PricedPartProduct product = new PricedPartProduct();
        product.setTestName(testName);
        product.setId(testName);
        product.setName(testName);
        product.setPartNumber(1L);
        product.setPrice(1.0);
        product.setQuantity(1);
        return product;
    }

    public void prePersistTest() throws EETest.Fault {
        String testName = "prePersistTest";
        try {
            this.getEntityTransaction().begin();
            this.p1 = this.newPricedPartProduct("prePersistTest");
            this.getEntityManager().persist((Object)this.p1);
            if (!this.p1.isPrePersistCalled()) {
                String reason = "PricedPartProduct: prePersist was not called.";
                throw new EETest.Fault(reason);
            }
            String reason = "PricedPartProduct: prePersist was called.";
            TestUtil.logTrace((String)reason);
            this.getEntityTransaction().rollback();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception caught during prePersistTest", (Throwable)e);
            throw new EETest.Fault(e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Exception caught while rolling back TX", (Throwable)re);
            }
        }
    }

    public void prePersistTest2() throws EETest.Fault {
        String testName = "prePersistTest2";
        try {
            this.getEntityTransaction().begin();
            this.p2 = this.newPricedPartProduct_2("prePersistTest2");
            this.getEntityManager().persist((Object)this.p2);
            if (!this.p2.isPrePersistCalled()) {
                String reason = "PricedPartProduct_2: prePersist was not called.";
                throw new EETest.Fault(reason);
            }
            String reason = "PricedPartProduct_2: prePersist was called.";
            TestUtil.logTrace((String)reason);
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception caught during prePersistTest", (Throwable)e);
            throw new EETest.Fault(e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Exception caught while rolling back TX", (Throwable)re);
            }
        }
    }

    public void preRemoveTest() throws EETest.Fault {
        String testName = "preRemoveTest";
        try {
            this.getEntityTransaction().begin();
            this.p1 = this.newPricedPartProduct("preRemoveTest");
            this.getEntityManager().persist((Object)this.p1);
            this.getEntityManager().remove((Object)this.p1);
            if (!this.p1.isPreRemoveCalled()) {
                String reason = "PricedPartProduct: preRemove was not called.";
                throw new EETest.Fault(reason);
            }
            String reason = "PricedPartProduct: preRemove was called.";
            TestUtil.logTrace((String)reason);
            this.p1 = null;
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception caught during prePersistTest", (Throwable)e);
            throw new EETest.Fault(e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Exception caught while rolling back TX", (Throwable)re);
            }
        }
    }

    public void preRemoveTest2() throws EETest.Fault {
        String testName = "preRemoveTest2";
        try {
            this.getEntityTransaction().begin();
            this.p2 = this.newPricedPartProduct_2("preRemoveTest2");
            this.getEntityManager().persist((Object)this.p2);
            this.getEntityManager().remove((Object)this.p2);
            if (!this.p2.isPreRemoveCalled()) {
                String reason = "PricedPartProduct: preRemove was not called.";
                throw new EETest.Fault(reason);
            }
            String reason = "PricedPartProduct: preRemove was called.";
            TestUtil.logTrace((String)reason);
            this.p2 = null;
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception caught during prePersistTest", (Throwable)e);
            throw new EETest.Fault(e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Exception caught while rolling back TX", (Throwable)re);
            }
        }
    }

    public void preUpdateTest() throws EETest.Fault {
        String testName = "preUpdateTest";
        try {
            this.getEntityTransaction().begin();
            this.p1 = this.newPricedPartProduct("preUpdateTest");
            this.getEntityManager().persist((Object)this.p1);
            this.getEntityManager().flush();
            this.p1.setPrice(2.0);
            this.getEntityManager().persist((Object)this.p1);
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception caught during preUpdateTest", (Throwable)e);
            throw new EETest.Fault(e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Exception caught while rolling back TX", (Throwable)re);
            }
        }
    }

    public void preUpdateTest2() throws EETest.Fault {
        String testName = "preUpdateTest2";
        try {
            this.getEntityTransaction().begin();
            this.p2 = this.newPricedPartProduct_2("preUpdateTest2");
            this.getEntityManager().persist((Object)this.p2);
            this.getEntityManager().flush();
            this.p2.setPrice(2.0);
            this.getEntityManager().persist((Object)this.p2);
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception caught during preUpdateTest2", (Throwable)e);
            throw new EETest.Fault(e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Exception caught while rolling back TX", (Throwable)re);
            }
        }
    }

    public void postLoadTest() throws EETest.Fault {
        String testName = "postLoadTest";
        try {
            this.getEntityTransaction().begin();
            this.p1 = this.newPricedPartProduct("postLoadTest");
            this.getEntityManager().persist((Object)this.p1);
            this.getEntityManager().flush();
            this.getEntityManager().refresh((Object)this.p1);
            Query q = this.getEntityManager().createQuery("select distinct p from PricedPartProduct p");
            List results = q.getResultList();
            TestUtil.logTrace((String)results.toString());
            if (!this.p1.isPostLoadCalled()) {
                String reason = "PricedPartProduct: postLoad was not called even after the query result was returned.";
                throw new EETest.Fault(reason);
            }
            String reason = "PricedPartProduct: postLoad was called after the query result was returned.";
            TestUtil.logTrace((String)reason);
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception caught during postLoadTest", (Throwable)e);
            throw new EETest.Fault(e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Exception caught while rolling back TX", (Throwable)re);
            }
        }
    }

    public void postLoadTest2() throws EETest.Fault {
        String testName = "postLoadTest2";
        try {
            this.getEntityTransaction().begin();
            this.p2 = this.newPricedPartProduct_2("postLoadTest2");
            this.getEntityManager().persist((Object)this.p2);
            this.getEntityManager().flush();
            this.getEntityManager().refresh((Object)this.p2);
            Query q = this.getEntityManager().createQuery("select p.id from PricedPartProduct_2 p");
            List results = q.getResultList();
            TestUtil.logTrace((String)results.toString());
            if (!this.p2.isPostLoadCalled()) {
                String reason = "PricedPartProduct_2: postLoad was not called even after the query result was returned.";
                throw new EETest.Fault(reason);
            }
            String reason = "PricedPartProduct_2: postLoad was called after the query result was returned.";
            TestUtil.logTrace((String)reason);
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception caught during postLoadTest", (Throwable)e);
            throw new EETest.Fault(e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Exception caught while rolling back TX", (Throwable)re);
            }
        }
    }

    public void findProductTest() throws EETest.Fault {
        String testName = "findProductTest";
        try {
            this.getEntityTransaction().begin();
            this.p1 = this.newPricedPartProduct("findProductTest");
            this.getEntityManager().persist((Object)this.p1);
            this.getEntityManager().flush();
            Object o = this.getEntityManager().find(Product.class, (Object)"findProductTest");
            TestUtil.logTrace((String)"finding object using Product.class and id 'findProductTest'");
            if (o instanceof PricedPartProduct) {
                TestUtil.logTrace((String)("Found object of type " + PricedPartProduct.class));
            } else if (o instanceof Product) {
                TestUtil.logTrace((String)("Found object of type " + Product.class));
            } else {
                TestUtil.logTrace((String)("The object found is neither " + PricedPartProduct.class + ", nor " + Product.class));
            }
            Object oo = this.getEntityManager().find(PricedPartProduct.class, (Object)"findProductTest");
            TestUtil.logTrace((String)"finding object using PricedPartProduct.class and id 'findProductTest'");
            if (oo instanceof PricedPartProduct) {
                TestUtil.logTrace((String)("Found object of type " + PricedPartProduct.class));
            } else if (oo instanceof Product) {
                TestUtil.logTrace((String)("Found object of type " + Product.class));
            } else {
                TestUtil.logTrace((String)("The object found is neither " + PricedPartProduct.class + ", nor " + Product.class));
            }
            if (o == oo) {
                TestUtil.logTrace((String)"The two entities are identical");
            } else if (o.equals(oo)) {
                TestUtil.logTrace((String)"The two entities are equal");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception caught during findProductTest", (Throwable)e);
            throw new EETest.Fault(e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Exception caught while rolling back TX", (Throwable)re);
            }
        }
    }

    @Override
    public void cleanup() throws EETest.Fault {
        TestUtil.logTrace((String)"cleanup");
        this.removeTestData();
        TestUtil.logTrace((String)"cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        TestUtil.logTrace((String)"removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM PRICED_PRODUCT_TABLE").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM PRODUCT_TABLE").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

