/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb.ee.bb.entity.cmp20.complexpktest;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.ejb.ee.bb.entity.cmp20.complexpktest.ComplexPK;
import com.sun.ts.tests.ejb.ee.bb.entity.cmp20.complexpktest.LineItem;
import com.sun.ts.tests.ejb.ee.bb.entity.cmp20.complexpktest.LineItemHome;
import com.sun.ts.tests.ejb.ee.bb.entity.cmp20.complexpktest.TestBean;
import com.sun.ts.tests.ejb.ee.bb.entity.cmp20.complexpktest.TestBeanHome;
import jakarta.ejb.FinderException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import javax.rmi.PortableRemoteObject;

public class Client
extends EETest {
    private static final String testBean = "java:comp/env/ejb/TestBean";
    private static final String lineItemBean = "java:comp/env/ejb/LineItem";
    private TestBean beanRef = null;
    private Properties props = new Properties();
    private TestBeanHome beanHome = null;
    private LineItemHome liHome = null;
    private TSNamingContext nctx = null;
    private boolean setupOK = false;
    private static final int NUMEJBS = 4;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.props = p;
        try {
            this.logMsg("Obtain naming context");
            this.nctx = new TSNamingContext();
            this.logMsg("Looking up home interface for EJB: java:comp/env/ejb/TestBean");
            this.beanHome = (TestBeanHome)this.nctx.lookup(testBean, TestBeanHome.class);
            this.logMsg("Looking up home interface for EJB: java:comp/env/ejb/LineItem");
            this.liHome = (LineItemHome)this.nctx.lookup(lineItemBean, LineItemHome.class);
            this.setupOK = true;
            this.logMsg("Setup ok");
        }
        catch (Exception e) {
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    public void test1() throws EETest.Fault {
        boolean pass = false;
        TestBean[] beanRef = new TestBean[4];
        TestBean testRef1 = null;
        TestBean testRef2 = null;
        try {
            TestUtil.logMsg((String)"Create EJB instance test1");
            beanRef[0] = this.beanHome.create(1, "Hazelnut", 1.0, 1, "USA");
            beanRef[0].initLogging(this.props);
            beanRef[1] = this.beanHome.create(1, "Villacreme", 1.25, 2, "Columbia");
            beanRef[1].initLogging(this.props);
            beanRef[2] = this.beanHome.create(1, "MochoJava", 1.5, 3, "Brazil");
            beanRef[2].initLogging(this.props);
            beanRef[3] = this.beanHome.create(2, "Hazelnut", 1.75, 4, "USA");
            beanRef[3].initLogging(this.props);
            testRef1 = this.beanHome.findByPrimaryKey(new ComplexPK(1, "Hazelnut"));
            testRef2 = this.beanHome.findByPrimaryKey(new ComplexPK(1, "Villacreme"));
            if (testRef1.isIdentical(beanRef[0]) && testRef2.isIdentical(beanRef[1])) {
                pass = true;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception test1: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("test1 failed", e);
        }
        finally {
            try {
                for (int i = 0; i < 4; ++i) {
                    beanRef[i].remove();
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
        if (!pass) {
            throw new EETest.Fault("test1 failed");
        }
    }

    public void test2() throws EETest.Fault {
        boolean pass = false;
        TestBean[] beanRef = new TestBean[3];
        LineItem[] lineItemRef = new LineItem[5];
        int expectedResult = 3;
        int result = 0;
        try {
            TestUtil.logMsg((String)"Create LineItem instance data");
            lineItemRef[0] = this.liHome.create("1", 1);
            lineItemRef[1] = this.liHome.create("2", 2);
            lineItemRef[2] = this.liHome.create("3", 5);
            lineItemRef[3] = this.liHome.create("4", 1);
            lineItemRef[4] = this.liHome.create("5", 3);
            TestUtil.logMsg((String)"Create EJB instance data");
            beanRef[0] = this.beanHome.create(1, "Hazelnut", 1.0, 1, "USA");
            beanRef[0].addLineItem(lineItemRef[0]);
            beanRef[0].addLineItem(lineItemRef[3]);
            beanRef[0].initLogging(this.props);
            beanRef[1] = this.beanHome.create(1, "Villacreme", 1.25, 2, "Columbia");
            beanRef[1].addLineItem(lineItemRef[1]);
            beanRef[1].initLogging(this.props);
            beanRef[2] = this.beanHome.create(1, "MochoJava", 1.5, 3, "Brazil");
            beanRef[2].addLineItem(lineItemRef[2]);
            beanRef[2].addLineItem(lineItemRef[4]);
            beanRef[2].initLogging(this.props);
            TestUtil.logMsg((String)"Count the number of brandNames available");
            result = this.liHome.selectCountByBrandName();
            pass = result == expectedResult;
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception test2: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("test2 failed", e);
        }
        finally {
            try {
                TestUtil.logTrace((String)"Removing Bean Instances");
                for (int i = 0; i < 3; ++i) {
                    beanRef[i].remove();
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Exception caught removing bean instance data" + e), (Throwable)e);
            }
        }
        if (!pass) {
            throw new EETest.Fault("test2 failed");
        }
    }

    public void test3() throws EETest.Fault {
        boolean pass = true;
        TestBean[] beanRef = new TestBean[4];
        TestBean[] testRef = new TestBean[4];
        try {
            TestUtil.logMsg((String)"Create EJB instance test3");
            beanRef[0] = this.beanHome.create(1, "Hazelnut", 1.0, 1, "USA");
            beanRef[0].initLogging(this.props);
            beanRef[1] = this.beanHome.create(1, "Villacreme", 1.25, 2, "Columbia");
            beanRef[1].initLogging(this.props);
            beanRef[2] = this.beanHome.create(1, "MochoJava", 1.5, 3, "Brazil");
            beanRef[2].initLogging(this.props);
            beanRef[3] = this.beanHome.create(2, "Hazelnut", 1.75, 4, "USA");
            beanRef[3].initLogging(this.props);
            Collection c = this.beanHome.findByName("Hazelnut");
            TestUtil.logMsg((String)"Check if we found the correct EJB references");
            TestUtil.logMsg((String)("Number of EJB references returned = " + c.size()));
            Iterator i = c.iterator();
            int j = 0;
            while (i.hasNext()) {
                testRef[j++] = (TestBean)PortableRemoteObject.narrow(i.next(), TestBean.class);
            }
            if (c.size() != 2) {
                TestUtil.logErr((String)("findByName returned " + c.size() + " references, expected 2 references"));
                pass = false;
            } else {
                for (int k = 0; k < c.size(); ++k) {
                    boolean found = false;
                    for (int l = 0; l < 4; ++l) {
                        if (!beanRef[l].isIdentical(testRef[k])) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        TestUtil.logErr((String)("findByName returned incorrect reference for k=" + k));
                        pass = false;
                        continue;
                    }
                    TestUtil.logMsg((String)("findByName returned correct reference for k=" + k));
                }
                if (testRef[0].isIdentical(testRef[1])) {
                    TestUtil.logErr((String)"findByName returned references not all unique");
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception test3: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("test3 failed", e);
        }
        finally {
            try {
                for (int i = 0; i < 4; ++i) {
                    beanRef[i].remove();
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
        if (!pass) {
            throw new EETest.Fault("test3 failed");
        }
    }

    public void test4() throws EETest.Fault {
        boolean pass = true;
        TestBean[] beanRef = new TestBean[4];
        TestBean[] testRef = new TestBean[4];
        try {
            TestUtil.logMsg((String)"Create EJB instance test4");
            beanRef[0] = this.beanHome.create(1, "Hazelnut", 1.0, 1, "USA");
            beanRef[0].initLogging(this.props);
            beanRef[1] = this.beanHome.create(1, "Villacreme", 1.25, 2, "Columbia");
            beanRef[1].initLogging(this.props);
            beanRef[2] = this.beanHome.create(1, "MochoJava", 1.5, 3, "Brazil");
            beanRef[2].initLogging(this.props);
            beanRef[3] = this.beanHome.create(2, "Hazelnut", 1.75, 4, "USA");
            beanRef[3].initLogging(this.props);
            Collection c = this.beanHome.findById(new Integer(1));
            TestUtil.logMsg((String)"Check if we found the correct EJB references");
            TestUtil.logMsg((String)("Number of EJB references returned = " + c.size()));
            Iterator i = c.iterator();
            int j = 0;
            while (i.hasNext()) {
                testRef[j++] = (TestBean)PortableRemoteObject.narrow(i.next(), TestBean.class);
            }
            if (c.size() != 3) {
                TestUtil.logErr((String)("findById returned " + c.size() + " references, expected 3 references"));
                pass = false;
            } else {
                for (int k = 0; k < c.size(); ++k) {
                    boolean found = false;
                    for (int l = 0; l < 4; ++l) {
                        if (!beanRef[l].isIdentical(testRef[k])) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        TestUtil.logErr((String)("findById returned incorrect reference for k=" + k));
                        pass = false;
                        continue;
                    }
                    TestUtil.logMsg((String)("findById returned correct reference for k=" + k));
                }
                if (testRef[0].isIdentical(testRef[1]) || testRef[1].isIdentical(testRef[2]) || testRef[0].isIdentical(testRef[2])) {
                    TestUtil.logErr((String)"findById returned references not all unique");
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception test4: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("test4 failed", e);
        }
        finally {
            try {
                for (int i = 0; i < 4; ++i) {
                    beanRef[i].remove();
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
        if (!pass) {
            throw new EETest.Fault("test4 failed");
        }
    }

    public void test5() throws EETest.Fault {
        boolean pass = true;
        TestBean[] beanRef = new TestBean[4];
        TestBean testRef = null;
        try {
            TestUtil.logMsg((String)"Create EJB instance test5");
            beanRef[0] = this.beanHome.create(1, "Hazelnut", 1.0, 1, "USA");
            beanRef[0].initLogging(this.props);
            beanRef[1] = this.beanHome.create(1, "Villacreme", 1.25, 2, "Columbia");
            beanRef[1].initLogging(this.props);
            beanRef[2] = this.beanHome.create(1, "MochoJava", 1.5, 3, "Brazil");
            beanRef[2].initLogging(this.props);
            beanRef[3] = this.beanHome.create(2, "Hazelnut", 1.75, 4, "USA");
            beanRef[3].initLogging(this.props);
            Collection c = this.beanHome.findByPrice(1.25);
            TestUtil.logMsg((String)"Check if we found the correct EJB references");
            TestUtil.logMsg((String)("Number of EJB references returned = " + c.size()));
            if (c.size() != 1) {
                TestUtil.logErr((String)("findByPrice returned " + c.size() + " references, expected 1 reference"));
                pass = false;
            } else {
                TestUtil.logMsg((String)"Check if we found the correct EJB reference");
                Iterator i = c.iterator();
                testRef = (TestBean)PortableRemoteObject.narrow(i.next(), TestBean.class);
                if (beanRef[1].isIdentical(testRef)) {
                    TestUtil.logMsg((String)"findByPrice returned correct reference");
                    pass = true;
                } else {
                    TestUtil.logErr((String)"findByPrice returned incorrect reference");
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception test5: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("test5 failed", e);
        }
        finally {
            try {
                for (int i = 0; i < 4; ++i) {
                    beanRef[i].remove();
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
        if (!pass) {
            throw new EETest.Fault("test5 failed");
        }
    }

    public void test6() throws EETest.Fault {
        boolean pass = false;
        TestBean[] beanRef = new TestBean[4];
        TestBean testRef = null;
        try {
            TestUtil.logMsg((String)"Create EJB instance test6");
            beanRef[0] = this.beanHome.create(1, "Hazelnut", 1.0, 1, "USA");
            beanRef[0].initLogging(this.props);
            beanRef[1] = this.beanHome.create(1, "Villacreme", 1.25, 2, "Columbia");
            beanRef[1].initLogging(this.props);
            beanRef[2] = this.beanHome.create(1, "MochoJava", 1.5, 3, "Brazil");
            beanRef[2].initLogging(this.props);
            beanRef[3] = this.beanHome.create(2, "Hazelnut", 1.75, 4, "USA");
            beanRef[3].initLogging(this.props);
            testRef = this.beanHome.findByPrimaryKey(new ComplexPK(1, "foo"));
            TestUtil.logErr((String)"No finder exception occurred");
            pass = false;
        }
        catch (FinderException fe) {
            TestUtil.logMsg((String)("Caught FinderException as expected: " + (Object)((Object)fe)));
            pass = true;
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("test6 failed", e);
        }
        finally {
            try {
                for (int i = 0; i < 4; ++i) {
                    beanRef[i].remove();
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
        if (!pass) {
            throw new EETest.Fault("test6 failed");
        }
    }

    public void test7() throws EETest.Fault {
        boolean pass = true;
        TestBean[] beanRef = new TestBean[4];
        TestBean[] testRef = new TestBean[4];
        try {
            TestUtil.logMsg((String)"Create EJB instance test7");
            beanRef[0] = this.beanHome.create(1, "Hazelnut", 1.0, 1, "USA");
            beanRef[0].initLogging(this.props);
            beanRef[1] = this.beanHome.create(1, "Villacreme", 1.25, 2, "Columbia");
            beanRef[1].initLogging(this.props);
            beanRef[2] = this.beanHome.create(1, "MochoJava", 1.5, 3, "Brazil");
            beanRef[2].initLogging(this.props);
            beanRef[3] = this.beanHome.create(2, "Hazelnut", 1.75, 4, "USA");
            beanRef[3].initLogging(this.props);
            Collection c = this.beanHome.findByProduct();
            TestUtil.logMsg((String)"Check if we found the correct EJB references");
            TestUtil.logMsg((String)("Number of EJB references returned = " + c.size()));
            Iterator i = c.iterator();
            int j = 0;
            while (i.hasNext()) {
                testRef[j++] = (TestBean)PortableRemoteObject.narrow(i.next(), TestBean.class);
            }
            if (c.size() != 4) {
                TestUtil.logErr((String)("findByProduct returned " + c.size() + " references, expected 4 references"));
                pass = false;
            } else {
                for (int k = 0; k < c.size(); ++k) {
                    boolean found = false;
                    for (int l = 0; l < 4; ++l) {
                        if (!beanRef[l].isIdentical(testRef[k])) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        TestUtil.logErr((String)("findByProduct returned incorrect reference for k=" + k));
                        pass = false;
                        continue;
                    }
                    TestUtil.logMsg((String)("findByProduct returned correct reference for k=" + k));
                }
                if (testRef[0].isIdentical(testRef[1]) || testRef[1].isIdentical(testRef[2]) || testRef[2].isIdentical(testRef[3]) || testRef[0].isIdentical(testRef[2]) || testRef[0].isIdentical(testRef[3]) || testRef[1].isIdentical(testRef[3])) {
                    TestUtil.logErr((String)"findByProduct returned references not all unique");
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception test7: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("test7 failed", e);
        }
        finally {
            try {
                for (int i = 0; i < 4; ++i) {
                    beanRef[i].remove();
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
        if (!pass) {
            throw new EETest.Fault("test7 failed");
        }
    }

    public void test8() throws EETest.Fault {
        boolean pass = true;
        TestBean[] beanRef = new TestBean[4];
        TestBean[] testRef = new TestBean[4];
        try {
            TestUtil.logMsg((String)"Create EJB instance test8");
            beanRef[0] = this.beanHome.create(1, "Hazelnut", 1.0, 1, "USA");
            beanRef[0].initLogging(this.props);
            beanRef[1] = this.beanHome.create(1, "Villacreme", 1.25, 2, "Columbia");
            beanRef[1].initLogging(this.props);
            beanRef[2] = this.beanHome.create(1, "MochoJava", 1.5, 3, "Brazil");
            beanRef[2].initLogging(this.props);
            beanRef[3] = this.beanHome.create(2, "Hazelnut", 1.75, 4, "USA");
            beanRef[3].initLogging(this.props);
            Collection c = this.beanHome.findByType();
            TestUtil.logMsg((String)"Check if we found the correct EJB references");
            TestUtil.logMsg((String)("Number of EJB references returned = " + c.size()));
            Iterator i = c.iterator();
            int j = 0;
            while (i.hasNext()) {
                testRef[j++] = (TestBean)PortableRemoteObject.narrow(i.next(), TestBean.class);
            }
            if (c.size() != 4) {
                TestUtil.logErr((String)("findByType returned " + c.size() + " references, expected 4 references"));
                pass = false;
            } else {
                for (int k = 0; k < c.size(); ++k) {
                    boolean found = false;
                    for (int l = 0; l < 4; ++l) {
                        if (!beanRef[l].isIdentical(testRef[k])) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        TestUtil.logErr((String)("findByType returned incorrect reference for k=" + k));
                        pass = false;
                        continue;
                    }
                    TestUtil.logMsg((String)("findByType returned correct reference for k=" + k));
                }
                if (testRef[0].isIdentical(testRef[1]) || testRef[1].isIdentical(testRef[2]) || testRef[2].isIdentical(testRef[3]) || testRef[0].isIdentical(testRef[2]) || testRef[0].isIdentical(testRef[3]) || testRef[1].isIdentical(testRef[3])) {
                    TestUtil.logErr((String)"findByType returned references not all unique");
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception test8: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("test8 failed", e);
        }
        finally {
            try {
                for (int i = 0; i < 4; ++i) {
                    beanRef[i].remove();
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
        if (!pass) {
            throw new EETest.Fault("test8 failed");
        }
    }

    public void cleanup() throws EETest.Fault {
        this.logMsg("cleanup ok");
    }
}

