/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.concurrency.common;

import jakarta.enterprise.concurrent.LastExecution;
import jakarta.enterprise.concurrent.Trigger;
import java.util.Date;

public class CommonTriggers {

    public static class TriggerFixedRate
    implements Trigger {
        private Date startTime;
        private long delta;
        private int executionCount = 0;
        private static final int executionCountLimit = 10;

        public TriggerFixedRate(Date startTime, long delta) {
            this.startTime = startTime;
            this.delta = delta;
        }

        public Date getNextRunTime(LastExecution lastExecutionInfo, Date taskScheduledTime) {
            ++this.executionCount;
            if (this.executionCount > 10) {
                return null;
            }
            if (lastExecutionInfo == null) {
                return new Date(this.startTime.getTime() + this.delta);
            }
            return new Date(lastExecutionInfo.getScheduledStart().getTime() + this.delta);
        }

        public boolean skipRun(LastExecution lastExecutionInfo, Date scheduledRunTime) {
            return false;
        }
    }

    public static class OnceTriggerDelaySkip
    implements Trigger {
        private long delay;

        public OnceTriggerDelaySkip(long argDelay) {
            this.delay = argDelay;
        }

        public Date getNextRunTime(LastExecution lastExecutionInfo, Date taskScheduledTime) {
            if (lastExecutionInfo != null) {
                return null;
            }
            return new Date(new Date().getTime() + this.delay);
        }

        public boolean skipRun(LastExecution lastExecutionInfo, Date scheduledRunTime) {
            return true;
        }
    }

    public static class OnceTrigger
    implements Trigger {
        public Date getNextRunTime(LastExecution lastExecutionInfo, Date taskScheduledTime) {
            if (lastExecutionInfo != null) {
                return null;
            }
            return new Date();
        }

        public boolean skipRun(LastExecution lastExecutionInfo, Date scheduledRunTime) {
            return false;
        }
    }
}

