/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jsonp.api.mergetests;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jsonp.api.common.SimpleValues;
import com.sun.ts.tests.jsonp.api.common.TestResult;
import com.sun.ts.tests.jsonp.api.mergetests.MergeCommon;
import jakarta.json.JsonObject;
import jakarta.json.JsonValue;

public class MergeAddValue
extends MergeCommon {
    MergeAddValue() {
    }

    TestResult test() {
        TestResult result = new TestResult("RFC 7396: Add non existing values");
        TestUtil.logMsg((String)"Testing RFC 7396: Add non existing values");
        this.testStringOnEmptyObject(result);
        this.testStringOnsimpleObject(result);
        this.testIntOnEmptyObject(result);
        this.testIntOnsimpleObject(result);
        this.testBoolOnEmptyObject(result);
        this.testBoolOnsimpleObject(result);
        this.testObjectOnEmptyObject(result);
        this.testObjectOnsimpleObject(result);
        return result;
    }

    private void testStringOnEmptyObject(TestResult result) {
        TestUtil.logMsg((String)" - for String on empty JSON object");
        JsonObject in = SimpleValues.createEmptyObject();
        JsonObject patch = SimpleValues.createSimpleObjectStr();
        JsonObject check = SimpleValues.createSimpleObjectStr();
        this.simpleMerge(result, (JsonValue)in, (JsonValue)patch, (JsonValue)check);
        this.simpleDiff(result, (JsonValue)in, (JsonValue)check, (JsonValue)patch);
    }

    private void testStringOnsimpleObject(TestResult result) {
        TestUtil.logMsg((String)" - for String on simple JSON object");
        JsonObject in = SimpleValues.createSimpleObject();
        JsonObject patch = SimpleValues.createSimpleObjectStr();
        JsonObject check = SimpleValues.createSimpleObjectWithStr();
        this.simpleMerge(result, (JsonValue)in, (JsonValue)patch, (JsonValue)check);
        this.simpleDiff(result, (JsonValue)in, (JsonValue)check, (JsonValue)patch);
    }

    private void testIntOnEmptyObject(TestResult result) {
        TestUtil.logMsg((String)" - for int on empty JSON object");
        JsonObject in = SimpleValues.createEmptyObject();
        JsonObject patch = SimpleValues.createSimpleObjectInt();
        JsonObject check = SimpleValues.createSimpleObjectInt();
        this.simpleMerge(result, (JsonValue)in, (JsonValue)patch, (JsonValue)check);
        this.simpleDiff(result, (JsonValue)in, (JsonValue)check, (JsonValue)patch);
    }

    private void testIntOnsimpleObject(TestResult result) {
        TestUtil.logMsg((String)" - for int on simple JSON object");
        JsonObject in = SimpleValues.createSimpleObject();
        JsonObject patch = SimpleValues.createSimpleObjectInt();
        JsonObject check = SimpleValues.createSimpleObjectWithInt();
        this.simpleMerge(result, (JsonValue)in, (JsonValue)patch, (JsonValue)check);
        this.simpleDiff(result, (JsonValue)in, (JsonValue)check, (JsonValue)patch);
    }

    private void testBoolOnEmptyObject(TestResult result) {
        TestUtil.logMsg((String)" - for boolean on empty JSON object");
        JsonObject in = SimpleValues.createEmptyObject();
        JsonObject patch = SimpleValues.createSimpleObjectBool();
        JsonObject check = SimpleValues.createSimpleObjectBool();
        this.simpleMerge(result, (JsonValue)in, (JsonValue)patch, (JsonValue)check);
        this.simpleDiff(result, (JsonValue)in, (JsonValue)check, (JsonValue)patch);
    }

    private void testBoolOnsimpleObject(TestResult result) {
        TestUtil.logMsg((String)" - for boolean on simple JSON object");
        JsonObject in = SimpleValues.createSimpleObject();
        JsonObject patch = SimpleValues.createSimpleObjectBool();
        JsonObject check = SimpleValues.createSimpleObjectWithBool();
        this.simpleMerge(result, (JsonValue)in, (JsonValue)patch, (JsonValue)check);
        this.simpleDiff(result, (JsonValue)in, (JsonValue)check, (JsonValue)patch);
    }

    private void testObjectOnEmptyObject(TestResult result) {
        TestUtil.logMsg((String)" - for JsonObject on empty JSON object");
        JsonObject in = SimpleValues.createEmptyObject();
        JsonObject patch = SimpleValues.createSimpleObjectObject();
        JsonObject check = SimpleValues.createSimpleObjectObject();
        this.simpleMerge(result, (JsonValue)in, (JsonValue)patch, (JsonValue)check);
        this.simpleDiff(result, (JsonValue)in, (JsonValue)check, (JsonValue)patch);
    }

    private void testObjectOnsimpleObject(TestResult result) {
        TestUtil.logMsg((String)" - for JsonObject on compound JSON object");
        JsonObject in = SimpleValues.createCompoundObject();
        JsonObject patch = SimpleValues.createSimpleObjectObject();
        JsonObject check = SimpleValues.createCompoundObjectWithObject();
        this.simpleMerge(result, (JsonValue)in, (JsonValue)patch, (JsonValue)check);
        this.simpleDiff(result, (JsonValue)in, (JsonValue)check, (JsonValue)patch);
    }
}

