/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb.ee.deploy.entity.cmp11.method.sec.style1;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.porting.TSLoginContext;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.ejb.ee.deploy.entity.cmp11.method.sec.style1.TestBean;
import com.sun.ts.tests.ejb.ee.deploy.entity.cmp11.method.sec.style1.TestBeanHome;
import java.rmi.RemoteException;
import java.util.Properties;

public class Client
extends EETest {
    private static final String prefix = "java:comp/env/ejb/";
    private static final String bean1Lookup = "java:comp/env/ejb/TestBean1";
    private static final String bean2Lookup = "java:comp/env/ejb/TestBean2";
    private static final String userPropName = "user";
    private static final String pwdPropName = "password";
    private TSNamingContext nctx = null;
    private Properties props = null;
    private String user;
    private String password;
    private TestBeanHome beanHome;
    private TestBean bean;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties props) throws EETest.Fault {
        try {
            this.props = props;
            TestUtil.logTrace((String)"[Client] Getting TS Naming Context...");
            this.nctx = new TSNamingContext();
            TestUtil.logTrace((String)"[Client] Getting user/password info...");
            this.user = props.getProperty(userPropName);
            this.password = props.getProperty(pwdPropName);
            TestUtil.logTrace((String)("[Client] Log in as " + this.user + " / " + this.password));
            TSLoginContext lc = new TSLoginContext();
            lc.login(this.user, this.password);
        }
        catch (Exception e) {
            TestUtil.logErr((String)("[Client] Caught exception: " + e));
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    public void testStyle1Positive() throws EETest.Fault {
        try {
            this.bean = null;
            TestUtil.logTrace((String)"[Client] Looking up java:comp/env/ejb/TestBean1");
            this.beanHome = (TestBeanHome)this.nctx.lookup(bean1Lookup, TestBeanHome.class);
            this.bean = this.beanHome.create(this.props, 1, "cappucino", 11.0f);
            TestUtil.logTrace((String)"[Client] Calling test1()...");
            boolean pass = this.bean.test1();
            if (!pass) {
                throw new EETest.Fault("Style1 positive test failed.");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("[Client] Unexpected exception: " + e));
            throw new EETest.Fault("Style1 positive test failed: ", e);
        }
        finally {
            try {
                if (null != this.bean) {
                    TestUtil.logTrace((String)"[Client] Removing bean...");
                    this.bean.remove();
                }
            }
            catch (Exception e) {
                TestUtil.logMsg((String)("[Client] Ignoring Exception on bean remove: " + e));
            }
        }
    }

    public void testStyle1Negative() throws EETest.Fault {
        try {
            TestUtil.logTrace((String)"[Client] Looking up java:comp/env/ejb/TestBean2");
            this.beanHome = (TestBeanHome)this.nctx.lookup(bean2Lookup, TestBeanHome.class);
            this.bean = this.beanHome.create(this.props, 2, "mocha", 11.0f);
            TestUtil.logTrace((String)"[Client] Calling test1()...");
            boolean pass = this.bean.test1();
            throw new EETest.Fault("Style1 negative test failed: We were allowed to can test1 method!");
        }
        catch (RemoteException e) {
            TestUtil.logTrace((String)"[Client] Caught java.rmi.RemoteException as expected");
            try {
                if (null != this.bean) {
                    TestUtil.logTrace((String)"[Client] Removing bean...");
                    this.bean.remove();
                }
            }
            catch (Exception e2) {
                TestUtil.logMsg((String)("[Client] Ignoring Exception on bean remove: " + e2));
            }
        }
        catch (Exception e) {
            try {
                TestUtil.logErr((String)("[Client] Unexpected exception: " + e));
                throw new EETest.Fault("Style1 negative test failed: ", e);
            }
            catch (Throwable throwable) {
                try {
                    if (null != this.bean) {
                        TestUtil.logTrace((String)"[Client] Removing bean...");
                        this.bean.remove();
                    }
                }
                catch (Exception e3) {
                    TestUtil.logMsg((String)("[Client] Ignoring Exception on bean remove: " + e3));
                }
                throw throwable;
            }
        }
    }

    public void testStyle2Style1() throws EETest.Fault {
        try {
            TestUtil.logTrace((String)"[Client] Looking up java:comp/env/ejb/TestBean1");
            this.beanHome = (TestBeanHome)this.nctx.lookup(bean1Lookup, TestBeanHome.class);
            this.bean = this.beanHome.create(this.props, 3, "expresso", 11.0f);
            TestUtil.logTrace((String)"[Client] Calling test2()...");
            boolean pass = this.bean.test2();
            if (!pass) {
                throw new EETest.Fault("Style2 union test failed.");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("[Client] Unexpected exception: " + e));
            throw new EETest.Fault("Style2 union test failed: ", e);
        }
        finally {
            try {
                if (null != this.bean) {
                    TestUtil.logTrace((String)"[Client] Removing bean...");
                    this.bean.remove();
                }
            }
            catch (Exception e) {
                TestUtil.logMsg((String)("[Client] Ignoring Exception on bean remove: " + e));
            }
        }
    }

    public void testStyle3Style1() throws EETest.Fault {
        try {
            TestUtil.logTrace((String)"[Client] Looking up java:comp/env/ejb/TestBean1");
            this.beanHome = (TestBeanHome)this.nctx.lookup(bean1Lookup, TestBeanHome.class);
            this.bean = this.beanHome.create(this.props, 4, "cafe creme", 11.0f);
            TestUtil.logTrace((String)"[Client] Calling test3()...");
            boolean pass = this.bean.test3(1789);
            if (!pass) {
                throw new EETest.Fault("Style3 union test failed.");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("[Client] Unexpected exception: " + e));
            throw new EETest.Fault("Style3 union test failed: ", e);
        }
        finally {
            try {
                if (null != this.bean) {
                    TestUtil.logTrace((String)"[Client] Removing bean...");
                    this.bean.remove();
                }
            }
            catch (Exception e) {
                TestUtil.logMsg((String)("[Client] Ignoring Exception on bean remove: " + e));
            }
        }
    }

    public void cleanup() throws EETest.Fault {
        this.logMsg("[Client] cleanup()");
    }
}

