/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ant.taskdefs.ejb;

import com.sun.ant.taskdefs.common.DescriptorHandler;
import java.io.File;
import org.apache.tools.ant.Task;
import org.xml.sax.AttributeList;
import org.xml.sax.SAXException;

public class EJBDescriptorHandler
extends DescriptorHandler {
    private static final int STATE_LOOKING_EJBJAR = 1;
    private static final int STATE_IN_EJBJAR = 2;
    private static final int STATE_IN_BEANS = 3;
    private static final int STATE_IN_SESSION = 4;
    private static final int STATE_IN_ENTITY = 5;
    private static final int STATE_IN_MDB = 6;
    private static final String EJB_REF = "ejb-ref";
    private static final String HOME_INTERFACE = "home";
    private static final String REMOTE_INTERFACE = "remote";
    private static final String BEAN_CLASS = "ejb-class";
    private static final String PK_CLASS = "prim-key-class";
    private static final String EJB_NAME = "ejb-name";
    private static final String EJB_JAR = "ejb-jar";
    private static final String ENTERPRISE_BEANS = "enterprise-beans";
    private static final String ENTITY_BEAN = "entity";
    private static final String SESSION_BEAN = "session";
    private static final String MESSAGE_BEAN = "message-driven";
    private static final String LOCALHOME_INTERFACE = "local-home";
    private static final String LOCAL_INTERFACE = "local";
    protected boolean inEJBRef = false;

    public EJBDescriptorHandler(Task task, File srcDir) {
        super(task, srcDir);
        this.parseState = 1;
    }

    public void startDocument() throws SAXException {
        super.startDocument();
        this.inEJBRef = false;
    }

    public void startElement(String name, AttributeList attrs) throws SAXException {
        this.currentElement = name;
        this.currentText = "";
        if (name.equals(EJB_REF)) {
            this.inEJBRef = true;
        } else if (this.parseState == 1 && name.equals(EJB_JAR)) {
            this.parseState = 2;
        } else if (this.parseState == 2 && name.equals(ENTERPRISE_BEANS)) {
            this.parseState = 3;
        } else if (this.parseState == 3 && name.equals(SESSION_BEAN)) {
            this.parseState = 4;
        } else if (this.parseState == 3 && name.equals(ENTITY_BEAN)) {
            this.parseState = 5;
        } else if (this.parseState == 3 && name.equals(MESSAGE_BEAN)) {
            this.parseState = 6;
        }
    }

    public void endElement(String name) throws SAXException {
        this.processElement();
        this.currentText = "";
        this.currentElement = "";
        if (name.equals(EJB_REF)) {
            this.inEJBRef = false;
        } else if (this.parseState == 5 && name.equals(ENTITY_BEAN)) {
            this.parseState = 3;
        } else if (this.parseState == 4 && name.equals(SESSION_BEAN)) {
            this.parseState = 3;
        } else if (this.parseState == 3 && name.equals(ENTERPRISE_BEANS)) {
            this.parseState = 2;
        } else if (this.parseState == 2 && name.equals(EJB_JAR)) {
            this.parseState = 1;
        }
    }

    protected void processElement() {
        if (this.parseState != 5 && this.parseState != 4 && this.parseState != 6) {
            return;
        }
        if (this.currentElement.equals(HOME_INTERFACE) || this.currentElement.equals(REMOTE_INTERFACE) || this.currentElement.equals(BEAN_CLASS) || this.currentElement.equals(PK_CLASS) || this.currentElement.equals(LOCALHOME_INTERFACE) || this.currentElement.equals(LOCAL_INTERFACE)) {
            File classFile = null;
            String className = this.currentText.trim();
            if (!className.startsWith("java.") && !className.startsWith("javax.")) {
                className = className.replace('.', File.separatorChar);
                className = className + ".class";
                classFile = new File(this.srcDir, className);
                this.files.put(className, classFile);
            }
        }
        if (this.currentElement.equals(EJB_NAME) && this.name == null) {
            this.name = this.currentText.trim();
        }
    }
}

