/*
 * Decompiled with CFR 0.152.
 */
package jdk.incubator.http;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Flow;
import jdk.incubator.http.HttpClientImpl;
import jdk.incubator.http.HttpConnection;
import jdk.incubator.http.HttpHeaders;
import jdk.incubator.http.HttpRequest;
import jdk.incubator.http.HttpRequestImpl;
import jdk.incubator.http.internal.common.HttpHeadersImpl;
import jdk.incubator.http.internal.common.Log;
import jdk.incubator.http.internal.common.MinimalFuture;
import jdk.incubator.http.internal.common.Utils;

class Http1Request {
    final HttpClientImpl client;
    final HttpRequestImpl request;
    final HttpConnection chan;
    final ByteBuffer[] buffers;
    final HttpRequest.BodyProcessor requestProc;
    final HttpHeaders userHeaders;
    final HttpHeadersImpl systemHeaders;
    boolean streaming;
    long contentLength;
    final CompletableFuture<Void> cf;
    private boolean finished;
    private static final byte[] CRLF = new byte[]{13, 10};
    private static final byte[] EMPTY_CHUNK_BYTES = new byte[]{48, 13, 10};

    Http1Request(HttpRequestImpl httpRequestImpl, HttpClientImpl httpClientImpl, HttpConnection httpConnection) throws IOException {
        this.client = httpClientImpl;
        this.request = httpRequestImpl;
        this.chan = httpConnection;
        this.buffers = new ByteBuffer[5];
        this.requestProc = httpRequestImpl.requestProcessor;
        this.userHeaders = httpRequestImpl.getUserHeaders();
        this.systemHeaders = httpRequestImpl.getSystemHeaders();
        this.cf = new MinimalFuture<Void>();
    }

    private void logHeaders() throws IOException {
        StringBuilder stringBuilder = new StringBuilder(256);
        stringBuilder.append("REQUEST HEADERS:\n");
        Log.dumpHeaders(stringBuilder, "    ", this.systemHeaders);
        Log.dumpHeaders(stringBuilder, "    ", this.userHeaders);
        Log.logHeaders(stringBuilder.toString(), new Object[0]);
    }

    private void dummy(long l) {
    }

    private void collectHeaders0() throws IOException {
        if (Log.headers()) {
            this.logHeaders();
        }
        StringBuilder stringBuilder = new StringBuilder(256);
        this.collectHeaders1(stringBuilder, this.request, this.systemHeaders);
        this.collectHeaders1(stringBuilder, this.request, this.userHeaders);
        stringBuilder.append("\r\n");
        String string = stringBuilder.toString();
        this.buffers[1] = ByteBuffer.wrap(string.getBytes(StandardCharsets.US_ASCII));
    }

    private void collectHeaders1(StringBuilder stringBuilder, HttpRequestImpl httpRequestImpl, HttpHeaders httpHeaders) throws IOException {
        Map<String, List<String>> map = httpHeaders.map();
        Set<Map.Entry<String, List<String>>> set = map.entrySet();
        for (Map.Entry<String, List<String>> entry : set) {
            String string = entry.getKey();
            List<String> list = entry.getValue();
            for (String string2 : list) {
                stringBuilder.append(string).append(": ").append(string2).append("\r\n");
            }
        }
    }

    private String getPathAndQuery(URI uRI) {
        String string = uRI.getPath();
        String string2 = uRI.getQuery();
        if (string == null || string.equals("")) {
            string = "/";
        }
        if (string2 == null) {
            string2 = "";
        }
        if (string2.equals("")) {
            return string;
        }
        return string + "?" + string2;
    }

    private String authorityString(InetSocketAddress inetSocketAddress) {
        return inetSocketAddress.getHostString() + ":" + inetSocketAddress.getPort();
    }

    private String hostString() {
        boolean bl;
        URI uRI = this.request.uri();
        int n = uRI.getPort();
        String string = uRI.getHost();
        if (n == -1) {
            bl = true;
        } else if (this.request.secure()) {
            bl = n == 443;
        } else {
            boolean bl2 = bl = n == 80;
        }
        if (bl) {
            return string;
        }
        return string + ":" + Integer.toString(n);
    }

    private String requestURI() {
        URI uRI = this.request.uri();
        String string = this.request.method();
        if (this.request.proxy(this.client) == null && !string.equals("CONNECT") || this.request.isWebSocket()) {
            return this.getPathAndQuery(uRI);
        }
        if (this.request.secure()) {
            if (this.request.method().equals("CONNECT")) {
                return this.authorityString(this.request.authority());
            }
            return this.getPathAndQuery(uRI);
        }
        return uRI == null ? this.authorityString(this.request.authority()) : uRI.toString();
    }

    void sendHeadersOnly() throws IOException {
        this.collectHeaders();
        this.chan.write(this.buffers, 0, 2);
    }

    void sendRequest() throws IOException {
        this.collectHeaders();
        this.chan.configureMode(HttpConnection.Mode.BLOCKING);
        if (this.contentLength == 0L) {
            this.chan.write(this.buffers, 0, 2);
        } else if (this.contentLength > 0L) {
            this.writeFixedContent(true);
        } else {
            this.writeStreamedContent(true);
        }
        this.setFinished();
    }

    synchronized boolean finished() {
        return this.finished;
    }

    synchronized void setFinished() {
        this.finished = true;
    }

    private void collectHeaders() throws IOException {
        if (Log.requests() && this.request != null) {
            Log.logRequest(this.request.toString(), new Object[0]);
        }
        String string = this.requestURI();
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append(this.request.method()).append(' ').append(string).append(" HTTP/1.1\r\n");
        String string2 = stringBuilder.toString();
        this.buffers[0] = ByteBuffer.wrap(string2.getBytes(StandardCharsets.US_ASCII));
        URI uRI = this.request.uri();
        if (uRI != null) {
            this.systemHeaders.setHeader("Host", this.hostString());
        }
        this.contentLength = this.request == null ? 0L : this.requestProc.contentLength();
        if (this.contentLength == 0L) {
            this.systemHeaders.setHeader("Content-Length", "0");
            this.collectHeaders0();
        } else if (this.contentLength > 0L) {
            this.systemHeaders.setHeader("Content-Length", Integer.toString((int)this.contentLength));
            this.streaming = false;
            this.collectHeaders0();
            this.buffers[2] = this.getBuffer();
        } else {
            this.streaming = true;
            this.systemHeaders.setHeader("Transfer-encoding", "chunked");
            this.collectHeaders0();
            this.buffers[3] = this.getBuffer();
        }
    }

    private ByteBuffer getBuffer() {
        return ByteBuffer.allocate(Utils.BUFSIZE);
    }

    void continueRequest() throws IOException {
        if (this.streaming) {
            this.writeStreamedContent(false);
        } else {
            this.writeFixedContent(false);
        }
        this.setFinished();
    }

    private void waitForCompletion() throws IOException {
        try {
            this.cf.join();
        }
        catch (CompletionException completionException) {
            throw Utils.getIOException(completionException);
        }
    }

    private void writeStreamedContent(boolean bl) throws IOException {
        StreamSubscriber streamSubscriber = new StreamSubscriber(bl);
        this.requestProc.subscribe(streamSubscriber);
        this.waitForCompletion();
    }

    private void writeFixedContent(boolean bl) throws IOException {
        if (this.contentLength == 0L) {
            return;
        }
        FixedContentSubscriber fixedContentSubscriber = new FixedContentSubscriber(bl);
        this.requestProc.subscribe(fixedContentSubscriber);
        this.waitForCompletion();
    }

    private ByteBuffer CRLF_BUFFER() {
        return ByteBuffer.wrap(CRLF);
    }

    private ByteBuffer EMPTY_CHUNK_HEADER() {
        return ByteBuffer.wrap(EMPTY_CHUNK_BYTES);
    }

    private static ByteBuffer getHeader(int n) {
        String string = Integer.toHexString(n);
        byte[] byArray = string.getBytes(StandardCharsets.US_ASCII);
        byte[] byArray2 = new byte[string.length() + 2];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        byArray2[byArray.length] = CRLF[0];
        byArray2[byArray.length + 1] = CRLF[1];
        return ByteBuffer.wrap(byArray2);
    }

    class FixedContentSubscriber
    implements Flow.Subscriber<ByteBuffer> {
        volatile Flow.Subscription subscription;
        volatile boolean includeHeaders;
        volatile long contentWritten = 0L;

        FixedContentSubscriber(boolean bl) {
            this.includeHeaders = bl;
        }

        @Override
        public void onSubscribe(Flow.Subscription subscription) {
            if (this.subscription != null) {
                throw new IllegalStateException("already subscribed");
            }
            this.subscription = subscription;
            subscription.request(1L);
        }

        @Override
        public void onNext(ByteBuffer byteBuffer) {
            long l;
            int n;
            int n2;
            if (this.includeHeaders) {
                n2 = 0;
                n = 3;
                l = Http1Request.this.buffers[0].remaining() + Http1Request.this.buffers[1].remaining();
            } else {
                n2 = 2;
                n = 1;
                l = 0L;
            }
            Http1Request.this.buffers[2] = byteBuffer;
            try {
                long l2 = (long)Http1Request.this.buffers[2].remaining() + l;
                this.contentWritten += (long)Http1Request.this.buffers[2].remaining();
                Http1Request.this.chan.checkWrite(l2, Http1Request.this.buffers, n2, n);
                if (this.contentWritten > Http1Request.this.contentLength) {
                    String string = "Too many bytes in request body. Expected: " + Long.toString(Http1Request.this.contentLength) + " Sent: " + Long.toString(this.contentWritten);
                    throw new IOException(string);
                }
                this.subscription.request(1L);
            }
            catch (IOException iOException) {
                this.subscription.cancel();
                Http1Request.this.cf.completeExceptionally(iOException);
            }
        }

        @Override
        public void onError(Throwable throwable) {
            if (Http1Request.this.cf.isDone()) {
                return;
            }
            this.subscription.cancel();
            Http1Request.this.cf.completeExceptionally(throwable);
        }

        @Override
        public void onComplete() {
            if (Http1Request.this.cf.isDone()) {
                throw new IllegalStateException("subscription already completed");
            }
            if (Http1Request.this.contentLength > this.contentWritten) {
                this.subscription.cancel();
                IOException iOException = new IOException("Too few bytes returned by the processor");
                Http1Request.this.cf.completeExceptionally(iOException);
            } else {
                Http1Request.this.cf.complete(null);
            }
        }
    }

    class StreamSubscriber
    implements Flow.Subscriber<ByteBuffer> {
        volatile Flow.Subscription subscription;
        volatile boolean includeHeaders;

        StreamSubscriber(boolean bl) {
            this.includeHeaders = bl;
        }

        @Override
        public void onSubscribe(Flow.Subscription subscription) {
            if (this.subscription != null) {
                throw new IllegalStateException("already subscribed");
            }
            this.subscription = subscription;
            subscription.request(1L);
        }

        @Override
        public void onNext(ByteBuffer byteBuffer) {
            int n;
            int n2;
            if (Http1Request.this.cf.isDone()) {
                throw new IllegalStateException("subscription already completed");
            }
            if (this.includeHeaders) {
                n2 = 0;
                n = 5;
            } else {
                n2 = 2;
                n = 3;
            }
            int n3 = byteBuffer.remaining();
            Http1Request.this.buffers[3] = byteBuffer;
            Http1Request.this.buffers[2] = Http1Request.getHeader(n3);
            Http1Request.this.buffers[4] = Http1Request.this.CRLF_BUFFER();
            try {
                Http1Request.this.chan.write(Http1Request.this.buffers, n2, n);
            }
            catch (IOException iOException) {
                this.subscription.cancel();
                Http1Request.this.cf.completeExceptionally(iOException);
            }
            this.includeHeaders = false;
            this.subscription.request(1L);
        }

        @Override
        public void onError(Throwable throwable) {
            if (Http1Request.this.cf.isDone()) {
                return;
            }
            this.subscription.cancel();
            Http1Request.this.cf.completeExceptionally(throwable);
        }

        @Override
        public void onComplete() {
            if (Http1Request.this.cf.isDone()) {
                throw new IllegalStateException("subscription already completed");
            }
            Http1Request.this.buffers[3] = Http1Request.this.EMPTY_CHUNK_HEADER();
            Http1Request.this.buffers[4] = Http1Request.this.CRLF_BUFFER();
            try {
                Http1Request.this.chan.write(Http1Request.this.buffers, 3, 2);
            }
            catch (IOException iOException) {
                Http1Request.this.cf.completeExceptionally(iOException);
                return;
            }
            Http1Request.this.cf.complete(null);
        }
    }
}

