/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.lib.harness;

import com.sun.javatest.Command;
import com.sun.javatest.Status;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ExecuteTSTestSameJVMCmd
extends Command {
    public Status run(String[] args, PrintWriter log, PrintWriter ref) {
        int i;
        int repeat = 1;
        String[] executeArgs = new String[]{};
        ClassLoader loader = this.getClassLoader();
        for (i = 0; i < args.length && args[i].startsWith("-"); ++i) {
            if ((!"-loadDir".equals(args[i]) || i + 1 >= args.length) && "-repeat".equals(args[i]) && i + 1 >= args.length) continue;
        }
        if (i >= args.length) {
            return Status.failed("No executeClass specified");
        }
        String className = args[i];
        if (++i < args.length) {
            executeArgs = new String[args.length - i];
            System.arraycopy(args, i, executeArgs, 0, executeArgs.length);
        }
        Status status = null;
        System.out.println("CLASSNAME: " + className);
        try {
            Class<?> c = loader == null ? Class.forName(className) : loader.loadClass(className);
            Status prevStatus = null;
            for (int j = 0; j < repeat; ++j) {
                if (repeat > 1) {
                    log.println("iteration: " + (j + 1));
                }
                Object t = c.newInstance();
                Class[] mainArgs = new Class[]{Class.forName("[Ljava.lang.String;"), PrintWriter.class, PrintWriter.class};
                Method runMethod = c.getMethod("run", mainArgs);
                Object[] execArgs = new Object[]{executeArgs, log, ref};
                status = (Status)runMethod.invoke(t, execArgs);
                if (repeat > 1) {
                    log.println("   " + status);
                }
                if (prevStatus != null && status.getType() != prevStatus.getType()) {
                    status = Status.error("Return status type changed at repetition: " + (j + 1));
                }
                if (status.isError()) {
                    return status;
                }
                prevStatus = status;
            }
        }
        catch (ClassCastException e) {
            status = Status.failed("Can't load test: required interface not found");
        }
        catch (ClassNotFoundException e) {
            status = Status.failed("Can't load test: " + e);
        }
        catch (InstantiationException e) {
            status = Status.failed("Can't instantiate test: " + e);
        }
        catch (IllegalAccessException e) {
            status = Status.failed("Illegal access to test: " + e);
        }
        catch (VerifyError e) {
            return Status.failed("Class verification error while trying to load test class `" + className + "': " + e);
        }
        catch (LinkageError e) {
            return Status.failed("Class linking error while trying to load test class `" + className + "': " + e);
        }
        catch (NoSuchMethodException nsme) {
            return Status.failed("Unable to find 'main' method in test class '" + className + "': " + nsme);
        }
        catch (InvocationTargetException tie) {
            return Status.failed("Test Failed: " + tie);
        }
        return status;
    }
}

