/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest.model;

import com.sun.tdk.signaturetest.model.AnnotationItem;
import java.io.DataInputStream;
import java.io.IOException;

public class AnnotationItemEx
extends AnnotationItem {
    public static final String ANNOTATION_EX_PREFIX = "typeAnno";
    private int targetType;
    private int parameterIndex;
    private int boundIndex;
    private int typeIndex;
    private String path;
    private boolean tracked = true;
    public static final int TARGET_CLASS_TYPE_PARAMETER = 0;
    public static final int TARGET_METHOD_TYPE_PARAMETER = 1;
    public static final int TARGET_CLASS_EXTENDS = 16;
    public static final int TARGET_CLASS_TYPE_PARAMETER_BOUND = 17;
    public static final int TARGET_METHOD_TYPE_PARAMETER_BOUND = 18;
    public static final int TARGET_FIELD = 19;
    public static final int TARGET_METHOD_RETURN = 20;
    public static final int TARGET_METHOD_RECEIVER = 21;
    public static final int TARGET_METHOD_FORMAL_PARAMETER = 22;
    public static final int TARGET_THROWS = 23;
    public static final int TARGET_LOCAL_VARIABLE = 64;
    public static final int TARGET_RESOURCE_VARIABLE = 65;
    public static final int TARGET_EXCEPTION_PARAMETER = 66;
    public static final int TARGET_INSTANCEOF = 67;
    public static final int TARGET_NEW = 68;
    public static final int TARGET_CONSTRUCTOR_REFERENCE = 69;
    public static final int TARGET_METHOD_REFERENCE = 70;
    public static final int TARGET_CAST = 71;
    public static final int TARGET_CONSTRUCTOR_INVOCATION_TYPE_ARGUMENT = 72;
    public static final int TARGET_METHOD_INVOCATION_TYPE_ARGUMENT = 73;
    public static final int TARGET_CONSTRUCTOR_REFERENCE_TYPE_ARGUMENT = 74;
    public static final int TARGET_METHOD_REFERENCE_TYPE_ARGUMENT = 75;
    public static final String ANN_TARGET_TYPE = "target";
    public static final String ANN_TYPE_IND = "type";
    public static final String ANN_BOUND_IND = "bound";
    public static final String ANN_PARAM_IND = "param";
    public static final String ANN_PATH = "path";

    public AnnotationItemEx(int n) {
        super(n);
    }

    public AnnotationItemEx() {
    }

    public void parseBinaryDescription(DataInputStream dataInputStream) throws IllegalStateException, IOException {
        int n;
        int n2 = dataInputStream.readUnsignedByte();
        this.setTargetType(n2);
        switch (n2) {
            case 0: 
            case 1: {
                this.setParameterIndex(dataInputStream.readUnsignedByte()).setTracked(true);
                break;
            }
            case 16: {
                this.setTypeIndex(dataInputStream.readUnsignedShort()).setTracked(true);
                break;
            }
            case 17: 
            case 18: {
                this.setParameterIndex(dataInputStream.readUnsignedByte()).setBoundIndex(dataInputStream.readUnsignedByte()).setTracked(true);
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                this.setTracked(true);
                break;
            }
            case 22: {
                this.setParameterIndex(dataInputStream.readUnsignedByte()).setTracked(true);
                break;
            }
            case 23: {
                this.setTypeIndex(dataInputStream.readUnsignedShort()).setTracked(true);
                break;
            }
            case 64: 
            case 65: {
                n = dataInputStream.readUnsignedShort();
                for (int i = 0; i < n; ++i) {
                    dataInputStream.readUnsignedShort();
                    dataInputStream.readUnsignedShort();
                    dataInputStream.readUnsignedShort();
                }
                this.setTracked(false);
                break;
            }
            case 66: {
                dataInputStream.readUnsignedByte();
                this.setTracked(false);
                break;
            }
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                dataInputStream.readUnsignedShort();
                this.setTracked(false);
                break;
            }
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: {
                dataInputStream.readUnsignedShort();
                dataInputStream.readUnsignedByte();
                this.setTracked(false);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown type " + AnnotationItemEx.intToHex(n2));
            }
        }
        n = dataInputStream.readUnsignedByte();
        if (n > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < n; ++i) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append('-');
                }
                int n3 = dataInputStream.readUnsignedByte();
                stringBuffer.append(Integer.toHexString(n3));
                stringBuffer.append(':');
                int n4 = dataInputStream.readUnsignedByte();
                stringBuffer.append(Integer.toHexString(n4));
            }
            this.setPath(stringBuffer.toString());
        }
    }

    public int getTargetType() {
        return this.targetType;
    }

    public AnnotationItemEx setTargetType(int n) {
        this.targetType = n;
        return this;
    }

    public boolean getTracked() {
        return this.tracked;
    }

    public AnnotationItemEx setTracked(boolean bl) {
        this.tracked = bl;
        return this;
    }

    public String getPath() {
        return this.path;
    }

    public AnnotationItemEx setPath(String string) {
        this.path = string;
        return this;
    }

    public AnnotationItemEx addToPath(String string) {
        this.path = this.path == null ? string : this.path + "-" + string;
        return this;
    }

    public int getParameterIndex() {
        return this.parameterIndex;
    }

    public AnnotationItemEx setParameterIndex(int n) {
        this.parameterIndex = n;
        return this;
    }

    public int getBoundIndex() {
        return this.boundIndex;
    }

    public AnnotationItemEx setBoundIndex(int n) {
        this.boundIndex = n;
        return this;
    }

    public int getTypeIndex() {
        return this.typeIndex;
    }

    public AnnotationItemEx setTypeIndex(int n) {
        this.typeIndex = n;
        return this;
    }

    protected String getSpecificData() {
        StringBuffer stringBuffer = new StringBuffer();
        this.addTargetType(stringBuffer);
        switch (this.targetType) {
            case 0: 
            case 1: {
                this.addParameterInd(stringBuffer);
                break;
            }
            case 16: {
                this.addTypeInd(stringBuffer);
                break;
            }
            case 17: 
            case 18: {
                this.addParameterInd(stringBuffer);
                this.addBoundInd(stringBuffer);
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                break;
            }
            case 22: {
                this.addParameterInd(stringBuffer);
                break;
            }
            case 23: {
                this.addTypeInd(stringBuffer);
                break;
            }
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: {
                break;
            }
            default: {
                throw new IllegalStateException("Unknown type " + AnnotationItemEx.intToHex(this.targetType));
            }
        }
        this.addPath(stringBuffer);
        stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    private void addTargetType(StringBuffer stringBuffer) {
        stringBuffer.append("[target=" + AnnotationItemEx.intToHex(this.targetType) + ";");
    }

    private void addTypeInd(StringBuffer stringBuffer) {
        stringBuffer.append("type=" + this.typeIndex + ";");
    }

    private void addBoundInd(StringBuffer stringBuffer) {
        stringBuffer.append("bound=" + this.boundIndex + ";");
    }

    private void addParameterInd(StringBuffer stringBuffer) {
        stringBuffer.append("param=" + this.parameterIndex + ";");
    }

    private void addPath(StringBuffer stringBuffer) {
        if (this.path != null) {
            stringBuffer.append("path=" + this.path + ";");
        }
    }

    public static String intToHex(int n) {
        String string = Integer.toHexString(n).toUpperCase();
        if (string.length() == 1) {
            string = "0" + string;
        }
        return "0x" + string;
    }

    private String arrayToString(int[] nArray) {
        if (nArray == null) {
            return "null";
        }
        int n = nArray.length - 1;
        if (n == -1) {
            return "[]";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('[');
        int n2 = 0;
        while (true) {
            stringBuffer.append(nArray[n2]);
            if (n2 == n) {
                return stringBuffer.append(']').toString();
            }
            stringBuffer.append(",");
            ++n2;
        }
    }

    protected String getPrefix() {
        return ANNOTATION_EX_PREFIX;
    }
}

