/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.monitors;

import com.unboundid.util.NotMutable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class MonitorAttribute
implements Serializable {
    private static final long serialVersionUID = 7931725606171964572L;
    private final Class<?> dataType;
    private final Object[] values;
    private final String description;
    private final String displayName;
    private final String name;

    public MonitorAttribute(String name, String displayName, String description, Boolean value) {
        this(name, displayName, description, Boolean.class, new Object[]{value});
        Validator.ensureNotNull(value);
    }

    public MonitorAttribute(String name, String displayName, String description, Date value) {
        this(name, displayName, description, Date.class, new Object[]{value});
        Validator.ensureNotNull(value);
    }

    public MonitorAttribute(String name, String displayName, String description, Date[] values) {
        this(name, displayName, description, Date.class, values);
    }

    public MonitorAttribute(String name, String displayName, String description, Double value) {
        this(name, displayName, description, Double.class, new Object[]{value});
        Validator.ensureNotNull(value);
    }

    public MonitorAttribute(String name, String displayName, String description, Double[] values) {
        this(name, displayName, description, Double.class, values);
    }

    public MonitorAttribute(String name, String displayName, String description, Integer value) {
        this(name, displayName, description, Integer.class, new Object[]{value});
        Validator.ensureNotNull(value);
    }

    public MonitorAttribute(String name, String displayName, String description, Integer[] values) {
        this(name, displayName, description, Integer.class, values);
    }

    public MonitorAttribute(String name, String displayName, String description, Long value) {
        this(name, displayName, description, Long.class, new Object[]{value});
        Validator.ensureNotNull(value);
    }

    public MonitorAttribute(String name, String displayName, String description, Long[] values) {
        this(name, displayName, description, Long.class, values);
    }

    public MonitorAttribute(String name, String displayName, String description, String value) {
        this(name, displayName, description, String.class, new Object[]{value});
        Validator.ensureNotNull(value);
    }

    public MonitorAttribute(String name, String displayName, String description, String[] values) {
        this(name, displayName, description, String.class, values);
    }

    private MonitorAttribute(String name, String displayName, String description, Class<?> dataType, Object[] values) {
        Validator.ensureNotNull(name, displayName, dataType, values);
        Validator.ensureFalse(values.length == 0, "MonitorAttribute.values must not be empty.");
        this.name = name;
        this.displayName = displayName;
        this.description = description;
        this.dataType = dataType;
        this.values = values;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public Class<?> getDataType() {
        return this.dataType;
    }

    public boolean hasMultipleValues() {
        return this.values.length > 1;
    }

    public Object getValue() {
        return this.values[0];
    }

    public List<Object> getValues() {
        return Collections.unmodifiableList(Arrays.asList(this.values));
    }

    public Boolean getBooleanValue() throws ClassCastException {
        return (Boolean)this.values[0];
    }

    public Date getDateValue() throws ClassCastException {
        return (Date)this.values[0];
    }

    public List<Date> getDateValues() throws ClassCastException {
        return Collections.unmodifiableList(Arrays.asList((Date[])this.values));
    }

    public Double getDoubleValue() throws ClassCastException {
        return (Double)this.values[0];
    }

    public List<Double> getDoubleValues() throws ClassCastException {
        return Collections.unmodifiableList(Arrays.asList((Double[])this.values));
    }

    public Integer getIntegerValue() throws ClassCastException {
        return (Integer)this.values[0];
    }

    public List<Integer> getIntegerValues() throws ClassCastException {
        return Collections.unmodifiableList(Arrays.asList((Integer[])this.values));
    }

    public Long getLongValue() throws ClassCastException {
        return (Long)this.values[0];
    }

    public List<Long> getLongValues() throws ClassCastException {
        return Collections.unmodifiableList(Arrays.asList((Long[])this.values));
    }

    public String getStringValue() throws ClassCastException {
        return (String)this.values[0];
    }

    public List<String> getStringValues() throws ClassCastException {
        return Collections.unmodifiableList(Arrays.asList((String[])this.values));
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(StringBuilder buffer) {
        buffer.append("MonitorAttribute(name='");
        buffer.append(this.name);
        buffer.append("', values={");
        for (int i = 0; i < this.values.length; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append('\'');
            buffer.append(String.valueOf(this.values[i]));
            buffer.append('\'');
        }
        buffer.append("})");
    }
}

