/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.tasks;

import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.unboundidds.tasks.AddSchemaFileTask;
import com.unboundid.ldap.sdk.unboundidds.tasks.AlertTask;
import com.unboundid.ldap.sdk.unboundidds.tasks.AuditDataSecurityTask;
import com.unboundid.ldap.sdk.unboundidds.tasks.BackupTask;
import com.unboundid.ldap.sdk.unboundidds.tasks.DisconnectClientTask;
import com.unboundid.ldap.sdk.unboundidds.tasks.DumpDBDetailsTask;
import com.unboundid.ldap.sdk.unboundidds.tasks.EnterLockdownModeTask;
import com.unboundid.ldap.sdk.unboundidds.tasks.ExportTask;
import com.unboundid.ldap.sdk.unboundidds.tasks.FailedDependencyAction;
import com.unboundid.ldap.sdk.unboundidds.tasks.GroovyScriptedTask;
import com.unboundid.ldap.sdk.unboundidds.tasks.ImportTask;
import com.unboundid.ldap.sdk.unboundidds.tasks.LeaveLockdownModeTask;
import com.unboundid.ldap.sdk.unboundidds.tasks.ReEncodeEntriesTask;
import com.unboundid.ldap.sdk.unboundidds.tasks.RebuildTask;
import com.unboundid.ldap.sdk.unboundidds.tasks.RefreshEncryptionSettingsTask;
import com.unboundid.ldap.sdk.unboundidds.tasks.ReloadGlobalIndexTask;
import com.unboundid.ldap.sdk.unboundidds.tasks.RestoreTask;
import com.unboundid.ldap.sdk.unboundidds.tasks.RotateLogTask;
import com.unboundid.ldap.sdk.unboundidds.tasks.SearchTask;
import com.unboundid.ldap.sdk.unboundidds.tasks.ShutdownTask;
import com.unboundid.ldap.sdk.unboundidds.tasks.SynchronizeEncryptionSettingsTask;
import com.unboundid.ldap.sdk.unboundidds.tasks.TaskException;
import com.unboundid.ldap.sdk.unboundidds.tasks.TaskMessages;
import com.unboundid.ldap.sdk.unboundidds.tasks.TaskProperty;
import com.unboundid.ldap.sdk.unboundidds.tasks.TaskState;
import com.unboundid.ldap.sdk.unboundidds.tasks.ThirdPartyTask;
import com.unboundid.util.Debug;
import com.unboundid.util.NotExtensible;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

@NotExtensible
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public class Task
implements Serializable {
    static final String ATTR_ACTUAL_START_TIME = "ds-task-actual-start-time";
    static final String ATTR_COMPLETION_TIME = "ds-task-completion-time";
    static final String ATTR_DEPENDENCY_ID = "ds-task-dependency-id";
    static final String ATTR_FAILED_DEPENDENCY_ACTION = "ds-task-failed-dependency-action";
    static final String ATTR_LOG_MESSAGE = "ds-task-log-message";
    static final String ATTR_NOTIFY_ON_COMPLETION = "ds-task-notify-on-completion";
    static final String ATTR_NOTIFY_ON_ERROR = "ds-task-notify-on-error";
    static final String ATTR_SCHEDULED_START_TIME = "ds-task-scheduled-start-time";
    static final String ATTR_TASK_CLASS = "ds-task-class-name";
    static final String ATTR_TASK_ID = "ds-task-id";
    static final String ATTR_TASK_STATE = "ds-task-state";
    static final String OC_TASK = "ds-task";
    static final String SCHEDULED_TASKS_BASE_DN = "cn=Scheduled Tasks,cn=tasks";
    static final TaskProperty PROPERTY_TASK_ID = new TaskProperty("ds-task-id", TaskMessages.INFO_DISPLAY_NAME_TASK_ID.get(), TaskMessages.INFO_DESCRIPTION_TASK_ID.get(), String.class, false, false, true);
    static final TaskProperty PROPERTY_SCHEDULED_START_TIME = new TaskProperty("ds-task-scheduled-start-time", TaskMessages.INFO_DISPLAY_NAME_SCHEDULED_START_TIME.get(), TaskMessages.INFO_DESCRIPTION_SCHEDULED_START_TIME.get(), Date.class, false, false, true);
    static final TaskProperty PROPERTY_DEPENDENCY_ID = new TaskProperty("ds-task-dependency-id", TaskMessages.INFO_DISPLAY_NAME_DEPENDENCY_ID.get(), TaskMessages.INFO_DESCRIPTION_DEPENDENCY_ID.get(), String.class, false, true, true);
    static final TaskProperty PROPERTY_FAILED_DEPENDENCY_ACTION = new TaskProperty("ds-task-failed-dependency-action", TaskMessages.INFO_DISPLAY_NAME_FAILED_DEPENDENCY_ACTION.get(), TaskMessages.INFO_DESCRIPTION_FAILED_DEPENDENCY_ACTION.get(), String.class, false, false, true, new String[]{FailedDependencyAction.CANCEL.getName(), FailedDependencyAction.DISABLE.getName(), FailedDependencyAction.PROCESS.getName()});
    static final TaskProperty PROPERTY_NOTIFY_ON_COMPLETION = new TaskProperty("ds-task-notify-on-completion", TaskMessages.INFO_DISPLAY_NAME_NOTIFY_ON_COMPLETION.get(), TaskMessages.INFO_DESCRIPTION_NOTIFY_ON_COMPLETION.get(), String.class, false, true, true);
    static final TaskProperty PROPERTY_NOTIFY_ON_ERROR = new TaskProperty("ds-task-notify-on-error", TaskMessages.INFO_DISPLAY_NAME_NOTIFY_ON_ERROR.get(), TaskMessages.INFO_DESCRIPTION_NOTIFY_ON_ERROR.get(), String.class, false, true, true);
    private static final long serialVersionUID = -3521189553470479032L;
    private final Date actualStartTime;
    private final Date completionTime;
    private final Date scheduledStartTime;
    private final Entry taskEntry;
    private final FailedDependencyAction failedDependencyAction;
    private final List<String> dependencyIDs;
    private final List<String> logMessages;
    private final List<String> notifyOnCompletion;
    private final List<String> notifyOnError;
    private final String taskClassName;
    private final String taskEntryDN;
    private final String taskID;
    private final TaskState taskState;

    protected Task() {
        this.actualStartTime = null;
        this.completionTime = null;
        this.scheduledStartTime = null;
        this.taskEntry = null;
        this.failedDependencyAction = null;
        this.dependencyIDs = null;
        this.logMessages = null;
        this.notifyOnCompletion = null;
        this.notifyOnError = null;
        this.taskClassName = null;
        this.taskEntryDN = null;
        this.taskID = null;
        this.taskState = null;
    }

    public Task(String taskID, String taskClassName) {
        this(taskID, taskClassName, null, null, null, null, null);
    }

    public Task(String taskID, String taskClassName, Date scheduledStartTime, List<String> dependencyIDs, FailedDependencyAction failedDependencyAction, List<String> notifyOnCompletion, List<String> notifyOnError) {
        Validator.ensureNotNull(taskClassName);
        this.taskClassName = taskClassName;
        this.scheduledStartTime = scheduledStartTime;
        this.failedDependencyAction = failedDependencyAction;
        this.taskID = taskID == null ? UUID.randomUUID().toString() : taskID;
        this.dependencyIDs = dependencyIDs == null ? Collections.emptyList() : Collections.unmodifiableList(dependencyIDs);
        this.notifyOnCompletion = notifyOnCompletion == null ? Collections.emptyList() : Collections.unmodifiableList(notifyOnCompletion);
        this.notifyOnError = notifyOnError == null ? Collections.emptyList() : Collections.unmodifiableList(notifyOnError);
        this.taskEntry = null;
        this.taskEntryDN = "ds-task-id=" + this.taskID + ',' + SCHEDULED_TASKS_BASE_DN;
        this.actualStartTime = null;
        this.completionTime = null;
        this.logMessages = Collections.emptyList();
        this.taskState = TaskState.UNSCHEDULED;
    }

    public Task(Entry entry) throws TaskException {
        this.taskEntry = entry;
        this.taskEntryDN = entry.getDN();
        if (!entry.hasObjectClass(OC_TASK)) {
            throw new TaskException(TaskMessages.ERR_TASK_MISSING_OC.get(this.taskEntryDN));
        }
        this.taskID = entry.getAttributeValue(ATTR_TASK_ID);
        if (this.taskID == null) {
            throw new TaskException(TaskMessages.ERR_TASK_NO_ID.get(this.taskEntryDN));
        }
        this.taskClassName = entry.getAttributeValue(ATTR_TASK_CLASS);
        if (this.taskClassName == null) {
            throw new TaskException(TaskMessages.ERR_TASK_NO_CLASS.get(this.taskEntryDN));
        }
        String stateStr = entry.getAttributeValue(ATTR_TASK_STATE);
        if (stateStr == null) {
            this.taskState = TaskState.UNSCHEDULED;
        } else {
            this.taskState = TaskState.forName(stateStr);
            if (this.taskState == null) {
                throw new TaskException(TaskMessages.ERR_TASK_INVALID_STATE.get(this.taskEntryDN, stateStr));
            }
        }
        String timestamp = entry.getAttributeValue(ATTR_SCHEDULED_START_TIME);
        if (timestamp == null) {
            this.scheduledStartTime = null;
        } else {
            try {
                this.scheduledStartTime = StaticUtils.decodeGeneralizedTime(timestamp);
            }
            catch (ParseException pe) {
                Debug.debugException(pe);
                throw new TaskException(TaskMessages.ERR_TASK_CANNOT_PARSE_SCHEDULED_START_TIME.get(this.taskEntryDN, timestamp, pe.getMessage()), pe);
            }
        }
        timestamp = entry.getAttributeValue(ATTR_ACTUAL_START_TIME);
        if (timestamp == null) {
            this.actualStartTime = null;
        } else {
            try {
                this.actualStartTime = StaticUtils.decodeGeneralizedTime(timestamp);
            }
            catch (ParseException pe) {
                Debug.debugException(pe);
                throw new TaskException(TaskMessages.ERR_TASK_CANNOT_PARSE_ACTUAL_START_TIME.get(this.taskEntryDN, timestamp, pe.getMessage()), pe);
            }
        }
        timestamp = entry.getAttributeValue(ATTR_COMPLETION_TIME);
        if (timestamp == null) {
            this.completionTime = null;
        } else {
            try {
                this.completionTime = StaticUtils.decodeGeneralizedTime(timestamp);
            }
            catch (ParseException pe) {
                Debug.debugException(pe);
                throw new TaskException(TaskMessages.ERR_TASK_CANNOT_PARSE_COMPLETION_TIME.get(this.taskEntryDN, timestamp, pe.getMessage()), pe);
            }
        }
        String name = entry.getAttributeValue(ATTR_FAILED_DEPENDENCY_ACTION);
        this.failedDependencyAction = name == null ? null : FailedDependencyAction.forName(name);
        this.dependencyIDs = Task.parseStringList(entry, ATTR_DEPENDENCY_ID);
        this.logMessages = Task.parseStringList(entry, ATTR_LOG_MESSAGE);
        this.notifyOnCompletion = Task.parseStringList(entry, ATTR_NOTIFY_ON_COMPLETION);
        this.notifyOnError = Task.parseStringList(entry, ATTR_NOTIFY_ON_ERROR);
    }

    public Task(String taskClassName, Map<TaskProperty, List<Object>> properties) throws TaskException {
        Validator.ensureNotNull(taskClassName, properties);
        this.taskClassName = taskClassName;
        String idStr = UUID.randomUUID().toString();
        Date sst = null;
        String[] depIDs = StaticUtils.NO_STRINGS;
        FailedDependencyAction fda = FailedDependencyAction.CANCEL;
        String[] noc = StaticUtils.NO_STRINGS;
        String[] noe = StaticUtils.NO_STRINGS;
        for (Map.Entry<TaskProperty, List<Object>> entry : properties.entrySet()) {
            TaskProperty p = entry.getKey();
            String attrName = p.getAttributeName();
            List<Object> values = entry.getValue();
            if (attrName.equalsIgnoreCase(ATTR_TASK_ID)) {
                idStr = Task.parseString(p, values, idStr);
                continue;
            }
            if (attrName.equalsIgnoreCase(ATTR_SCHEDULED_START_TIME)) {
                sst = Task.parseDate(p, values, sst);
                continue;
            }
            if (attrName.equalsIgnoreCase(ATTR_DEPENDENCY_ID)) {
                depIDs = Task.parseStrings(p, values, depIDs);
                continue;
            }
            if (attrName.equalsIgnoreCase(ATTR_FAILED_DEPENDENCY_ACTION)) {
                fda = FailedDependencyAction.forName(Task.parseString(p, values, fda.getName()));
                continue;
            }
            if (attrName.equalsIgnoreCase(ATTR_NOTIFY_ON_COMPLETION)) {
                noc = Task.parseStrings(p, values, noc);
                continue;
            }
            if (!attrName.equalsIgnoreCase(ATTR_NOTIFY_ON_ERROR)) continue;
            noe = Task.parseStrings(p, values, noe);
        }
        this.taskID = idStr;
        this.scheduledStartTime = sst;
        this.dependencyIDs = Collections.unmodifiableList(Arrays.asList(depIDs));
        this.failedDependencyAction = fda;
        this.notifyOnCompletion = Collections.unmodifiableList(Arrays.asList(noc));
        this.notifyOnError = Collections.unmodifiableList(Arrays.asList(noe));
        this.taskEntry = null;
        this.taskEntryDN = "ds-task-id=" + this.taskID + ',' + SCHEDULED_TASKS_BASE_DN;
        this.actualStartTime = null;
        this.completionTime = null;
        this.logMessages = Collections.emptyList();
        this.taskState = TaskState.UNSCHEDULED;
    }

    public static List<Task> getAvailableTaskTypes() {
        List<Task> taskList = Arrays.asList(new AddSchemaFileTask(), new AlertTask(), new AuditDataSecurityTask(), new BackupTask(), new DisconnectClientTask(), new DumpDBDetailsTask(), new EnterLockdownModeTask(), new ExportTask(), new GroovyScriptedTask(), new ImportTask(), new LeaveLockdownModeTask(), new RebuildTask(), new ReEncodeEntriesTask(), new RefreshEncryptionSettingsTask(), new ReloadGlobalIndexTask(), new RestoreTask(), new RotateLogTask(), new SearchTask(), new ShutdownTask(), new SynchronizeEncryptionSettingsTask(), new ThirdPartyTask());
        return Collections.unmodifiableList(taskList);
    }

    public String getTaskName() {
        return TaskMessages.INFO_TASK_NAME_GENERIC.get();
    }

    public String getTaskDescription() {
        return TaskMessages.INFO_TASK_DESCRIPTION_GENERIC.get();
    }

    protected final Entry getTaskEntry() {
        return this.taskEntry;
    }

    public final String getTaskEntryDN() {
        return this.taskEntryDN;
    }

    public final String getTaskID() {
        return this.taskID;
    }

    public final String getTaskClassName() {
        return this.taskClassName;
    }

    public final TaskState getState() {
        return this.taskState;
    }

    public final boolean isPending() {
        return this.taskState.isPending();
    }

    public final boolean isRunning() {
        return this.taskState.isRunning();
    }

    public final boolean isCompleted() {
        return this.taskState.isCompleted();
    }

    public final Date getScheduledStartTime() {
        return this.scheduledStartTime;
    }

    public final Date getActualStartTime() {
        return this.actualStartTime;
    }

    public final Date getCompletionTime() {
        return this.completionTime;
    }

    public final List<String> getDependencyIDs() {
        return this.dependencyIDs;
    }

    public final FailedDependencyAction getFailedDependencyAction() {
        return this.failedDependencyAction;
    }

    public final List<String> getLogMessages() {
        return this.logMessages;
    }

    public final List<String> getNotifyOnCompletionAddresses() {
        return this.notifyOnCompletion;
    }

    public final List<String> getNotifyOnErrorAddresses() {
        return this.notifyOnError;
    }

    public final Entry createTaskEntry() {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        ArrayList<String> ocValues = new ArrayList<String>(5);
        ocValues.add("top");
        ocValues.add(OC_TASK);
        ocValues.addAll(this.getAdditionalObjectClasses());
        attributes.add(new Attribute("objectClass", ocValues));
        attributes.add(new Attribute(ATTR_TASK_ID, this.taskID));
        attributes.add(new Attribute(ATTR_TASK_CLASS, this.taskClassName));
        if (this.scheduledStartTime != null) {
            attributes.add(new Attribute(ATTR_SCHEDULED_START_TIME, StaticUtils.encodeGeneralizedTime(this.scheduledStartTime)));
        }
        if (!this.dependencyIDs.isEmpty()) {
            attributes.add(new Attribute(ATTR_DEPENDENCY_ID, this.dependencyIDs));
        }
        if (this.failedDependencyAction != null) {
            attributes.add(new Attribute(ATTR_FAILED_DEPENDENCY_ACTION, this.failedDependencyAction.getName()));
        }
        if (!this.notifyOnCompletion.isEmpty()) {
            attributes.add(new Attribute(ATTR_NOTIFY_ON_COMPLETION, this.notifyOnCompletion));
        }
        if (!this.notifyOnError.isEmpty()) {
            attributes.add(new Attribute(ATTR_NOTIFY_ON_ERROR, this.notifyOnError));
        }
        attributes.addAll(this.getAdditionalAttributes());
        return new Entry(this.taskEntryDN, attributes);
    }

    protected static boolean parseBooleanValue(Entry taskEntry, String attributeName, boolean defaultValue) throws TaskException {
        String valueString = taskEntry.getAttributeValue(attributeName);
        if (valueString == null) {
            return defaultValue;
        }
        if (valueString.equalsIgnoreCase("true")) {
            return true;
        }
        if (valueString.equalsIgnoreCase("false")) {
            return false;
        }
        throw new TaskException(TaskMessages.ERR_TASK_CANNOT_PARSE_BOOLEAN.get(taskEntry.getDN(), valueString, attributeName));
    }

    protected static List<String> parseStringList(Entry taskEntry, String attributeName) {
        String[] valueStrings = taskEntry.getAttributeValues(attributeName);
        if (valueStrings == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(Arrays.asList(valueStrings));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static Boolean parseBoolean(TaskProperty p, List<Object> values, Boolean defaultValue) throws TaskException {
        if (values.isEmpty()) {
            if (!p.isRequired()) return defaultValue;
            throw new TaskException(TaskMessages.ERR_TASK_REQUIRED_PROPERTY_WITHOUT_VALUES.get(p.getDisplayName()));
        }
        if (values.size() > 1) {
            throw new TaskException(TaskMessages.ERR_TASK_PROPERTY_NOT_MULTIVALUED.get(p.getDisplayName()));
        }
        Object o = values.get(0);
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        if (!(o instanceof String)) throw new TaskException(TaskMessages.ERR_TASK_PROPERTY_VALUE_NOT_BOOLEAN.get(p.getDisplayName()));
        String valueStr = (String)o;
        if (valueStr.equalsIgnoreCase("true")) {
            return Boolean.TRUE;
        }
        if (!valueStr.equalsIgnoreCase("false")) throw new TaskException(TaskMessages.ERR_TASK_PROPERTY_VALUE_NOT_BOOLEAN.get(p.getDisplayName()));
        return Boolean.FALSE;
    }

    protected static Date parseDate(TaskProperty p, List<Object> values, Date defaultValue) throws TaskException {
        Date dateValue;
        if (values.isEmpty()) {
            if (p.isRequired()) {
                throw new TaskException(TaskMessages.ERR_TASK_REQUIRED_PROPERTY_WITHOUT_VALUES.get(p.getDisplayName()));
            }
            return defaultValue;
        }
        if (values.size() > 1) {
            throw new TaskException(TaskMessages.ERR_TASK_PROPERTY_NOT_MULTIVALUED.get(p.getDisplayName()));
        }
        Object o = values.get(0);
        if (o instanceof Date) {
            dateValue = (Date)o;
        } else if (o instanceof String) {
            try {
                dateValue = StaticUtils.decodeGeneralizedTime((String)o);
            }
            catch (ParseException pe) {
                throw new TaskException(TaskMessages.ERR_TASK_PROPERTY_VALUE_NOT_DATE.get(p.getDisplayName()), pe);
            }
        } else {
            throw new TaskException(TaskMessages.ERR_TASK_PROPERTY_VALUE_NOT_DATE.get(p.getDisplayName()));
        }
        Object[] allowedValues = p.getAllowedValues();
        if (allowedValues != null) {
            boolean found = false;
            for (Object allowedValue : allowedValues) {
                if (!dateValue.equals(allowedValue)) continue;
                found = true;
                break;
            }
            if (!found) {
                throw new TaskException(TaskMessages.ERR_TASK_PROPERTY_VALUE_NOT_ALLOWED.get(p.getDisplayName(), dateValue.toString()));
            }
        }
        return dateValue;
    }

    protected static Long parseLong(TaskProperty p, List<Object> values, Long defaultValue) throws TaskException {
        Long longValue;
        if (values.isEmpty()) {
            if (p.isRequired()) {
                throw new TaskException(TaskMessages.ERR_TASK_REQUIRED_PROPERTY_WITHOUT_VALUES.get(p.getDisplayName()));
            }
            return defaultValue;
        }
        if (values.size() > 1) {
            throw new TaskException(TaskMessages.ERR_TASK_PROPERTY_NOT_MULTIVALUED.get(p.getDisplayName()));
        }
        Object o = values.get(0);
        if (o instanceof Long) {
            longValue = (Long)o;
        } else if (o instanceof Number) {
            longValue = ((Number)o).longValue();
        } else if (o instanceof String) {
            try {
                longValue = Long.parseLong((String)o);
            }
            catch (Exception e) {
                throw new TaskException(TaskMessages.ERR_TASK_PROPERTY_VALUE_NOT_LONG.get(p.getDisplayName()), e);
            }
        } else {
            throw new TaskException(TaskMessages.ERR_TASK_PROPERTY_VALUE_NOT_LONG.get(p.getDisplayName()));
        }
        Object[] allowedValues = p.getAllowedValues();
        if (allowedValues != null) {
            boolean found = false;
            for (Object allowedValue : allowedValues) {
                if (!longValue.equals(allowedValue)) continue;
                found = true;
                break;
            }
            if (!found) {
                throw new TaskException(TaskMessages.ERR_TASK_PROPERTY_VALUE_NOT_ALLOWED.get(p.getDisplayName(), longValue.toString()));
            }
        }
        return longValue;
    }

    protected static String parseString(TaskProperty p, List<Object> values, String defaultValue) throws TaskException {
        String valueStr;
        if (values.isEmpty()) {
            if (p.isRequired()) {
                throw new TaskException(TaskMessages.ERR_TASK_REQUIRED_PROPERTY_WITHOUT_VALUES.get(p.getDisplayName()));
            }
            return defaultValue;
        }
        if (values.size() > 1) {
            throw new TaskException(TaskMessages.ERR_TASK_PROPERTY_NOT_MULTIVALUED.get(p.getDisplayName()));
        }
        Object o = values.get(0);
        if (o instanceof String) {
            valueStr = (String)o;
        } else if (values.get(0) instanceof CharSequence) {
            valueStr = o.toString();
        } else {
            throw new TaskException(TaskMessages.ERR_TASK_PROPERTY_VALUE_NOT_STRING.get(p.getDisplayName()));
        }
        Object[] allowedValues = p.getAllowedValues();
        if (allowedValues != null) {
            boolean found = false;
            for (Object allowedValue : allowedValues) {
                String s = (String)allowedValue;
                if (!valueStr.equalsIgnoreCase(s)) continue;
                found = true;
                break;
            }
            if (!found) {
                throw new TaskException(TaskMessages.ERR_TASK_PROPERTY_VALUE_NOT_ALLOWED.get(p.getDisplayName(), valueStr));
            }
        }
        return valueStr;
    }

    protected static String[] parseStrings(TaskProperty p, List<Object> values, String[] defaultValues) throws TaskException {
        if (values.isEmpty()) {
            if (p.isRequired()) {
                throw new TaskException(TaskMessages.ERR_TASK_REQUIRED_PROPERTY_WITHOUT_VALUES.get(p.getDisplayName()));
            }
            return defaultValues;
        }
        String[] stringValues = new String[values.size()];
        for (int i = 0; i < values.size(); ++i) {
            String valueStr;
            Object o = values.get(i);
            if (o instanceof String) {
                valueStr = (String)o;
            } else if (o instanceof CharSequence) {
                valueStr = o.toString();
            } else {
                throw new TaskException(TaskMessages.ERR_TASK_PROPERTY_VALUE_NOT_STRING.get(p.getDisplayName()));
            }
            Object[] allowedValues = p.getAllowedValues();
            if (allowedValues != null) {
                boolean found = false;
                for (Object allowedValue : allowedValues) {
                    String s = (String)allowedValue;
                    if (!valueStr.equalsIgnoreCase(s)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    throw new TaskException(TaskMessages.ERR_TASK_PROPERTY_VALUE_NOT_ALLOWED.get(p.getDisplayName(), valueStr));
                }
            }
            stringValues[i] = valueStr;
        }
        return stringValues;
    }

    protected List<String> getAdditionalObjectClasses() {
        return Collections.emptyList();
    }

    protected List<Attribute> getAdditionalAttributes() {
        return Collections.emptyList();
    }

    public static Task decodeTask(Entry entry) throws TaskException {
        String taskClass = entry.getAttributeValue(ATTR_TASK_CLASS);
        if (taskClass == null) {
            throw new TaskException(TaskMessages.ERR_TASK_NO_CLASS.get(entry.getDN()));
        }
        try {
            if (taskClass.equals("com.unboundid.directory.server.tasks.AddSchemaFileTask")) {
                return new AddSchemaFileTask(entry);
            }
            if (taskClass.equals("com.unboundid.directory.server.tasks.AlertTask")) {
                return new AlertTask(entry);
            }
            if (taskClass.equals("com.unboundid.directory.server.tasks.AuditDataSecurityTask")) {
                return new AuditDataSecurityTask(entry);
            }
            if (taskClass.equals("com.unboundid.directory.server.tasks.BackupTask")) {
                return new BackupTask(entry);
            }
            if (taskClass.equals("com.unboundid.directory.server.tasks.DisconnectClientTask")) {
                return new DisconnectClientTask(entry);
            }
            if (taskClass.equals("com.unboundid.directory.server.tasks.DumpDBDetailsTask")) {
                return new DumpDBDetailsTask(entry);
            }
            if (taskClass.equals("com.unboundid.directory.server.tasks.EnterLockdownModeTask")) {
                return new EnterLockdownModeTask(entry);
            }
            if (taskClass.equals("com.unboundid.directory.server.tasks.ExportTask")) {
                return new ExportTask(entry);
            }
            if (taskClass.equals("com.unboundid.directory.sdk.extensions.GroovyScriptedTask")) {
                return new GroovyScriptedTask(entry);
            }
            if (taskClass.equals("com.unboundid.directory.server.tasks.ImportTask")) {
                return new ImportTask(entry);
            }
            if (taskClass.equals("com.unboundid.directory.server.tasks.LeaveLockdownModeTask")) {
                return new LeaveLockdownModeTask(entry);
            }
            if (taskClass.equals("com.unboundid.directory.server.tasks.RebuildTask")) {
                return new RebuildTask(entry);
            }
            if (taskClass.equals("com.unboundid.directory.server.tasks.ReEncodeEntriesTask")) {
                return new ReEncodeEntriesTask(entry);
            }
            if (taskClass.equals("com.unboundid.directory.server.tasks.RefreshEncryptionSettingsTask")) {
                return new RefreshEncryptionSettingsTask(entry);
            }
            if (taskClass.equals("com.unboundid.directory.proxy.tasks.ReloadTask")) {
                return new ReloadGlobalIndexTask(entry);
            }
            if (taskClass.equals("com.unboundid.directory.server.tasks.RestoreTask")) {
                return new RestoreTask(entry);
            }
            if (taskClass.equals("com.unboundid.directory.server.tasks.RotateLogTask")) {
                return new RotateLogTask(entry);
            }
            if (taskClass.equals("com.unboundid.directory.server.tasks.SearchTask")) {
                return new SearchTask(entry);
            }
            if (taskClass.equals("com.unboundid.directory.server.tasks.ShutdownTask")) {
                return new ShutdownTask(entry);
            }
            if (taskClass.equals("com.unboundid.directory.server.crypto.SynchronizeEncryptionSettingsTask")) {
                return new SynchronizeEncryptionSettingsTask(entry);
            }
            if (taskClass.equals("com.unboundid.directory.sdk.extensions.ThirdPartyTask")) {
                return new ThirdPartyTask(entry);
            }
        }
        catch (TaskException te) {
            Debug.debugException(te);
        }
        return new Task(entry);
    }

    public static List<TaskProperty> getCommonTaskProperties() {
        List<TaskProperty> taskList = Arrays.asList(PROPERTY_TASK_ID, PROPERTY_SCHEDULED_START_TIME, PROPERTY_DEPENDENCY_ID, PROPERTY_FAILED_DEPENDENCY_ACTION, PROPERTY_NOTIFY_ON_COMPLETION, PROPERTY_NOTIFY_ON_ERROR);
        return Collections.unmodifiableList(taskList);
    }

    public List<TaskProperty> getTaskSpecificProperties() {
        return Collections.emptyList();
    }

    public Map<TaskProperty, List<Object>> getTaskPropertyValues() {
        LinkedHashMap<TaskProperty, List<Object>> props = new LinkedHashMap<TaskProperty, List<Object>>();
        props.put(PROPERTY_TASK_ID, Collections.unmodifiableList(Arrays.asList(this.taskID)));
        if (this.scheduledStartTime == null) {
            props.put(PROPERTY_SCHEDULED_START_TIME, Collections.emptyList());
        } else {
            props.put(PROPERTY_SCHEDULED_START_TIME, Collections.unmodifiableList(Arrays.asList(this.scheduledStartTime)));
        }
        props.put(PROPERTY_DEPENDENCY_ID, Collections.unmodifiableList(this.dependencyIDs));
        if (this.failedDependencyAction == null) {
            props.put(PROPERTY_FAILED_DEPENDENCY_ACTION, Collections.emptyList());
        } else {
            props.put(PROPERTY_FAILED_DEPENDENCY_ACTION, Collections.unmodifiableList(Arrays.asList(this.failedDependencyAction.getName())));
        }
        props.put(PROPERTY_NOTIFY_ON_COMPLETION, Collections.unmodifiableList(this.notifyOnCompletion));
        props.put(PROPERTY_NOTIFY_ON_ERROR, Collections.unmodifiableList(this.notifyOnError));
        return Collections.unmodifiableMap(props);
    }

    public final String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public final void toString(StringBuilder buffer) {
        buffer.append("Task(name='");
        buffer.append(this.getTaskName());
        buffer.append("', className='");
        buffer.append(this.taskClassName);
        buffer.append(", properties={");
        boolean added = false;
        for (Map.Entry<TaskProperty, List<Object>> e : this.getTaskPropertyValues().entrySet()) {
            if (added) {
                buffer.append(", ");
            } else {
                added = true;
            }
            buffer.append(e.getKey().getAttributeName());
            buffer.append("={");
            Iterator<Object> iterator = e.getValue().iterator();
            while (iterator.hasNext()) {
                buffer.append('\'');
                buffer.append(String.valueOf(iterator.next()));
                buffer.append('\'');
                if (!iterator.hasNext()) continue;
                buffer.append(',');
            }
            buffer.append('}');
        }
        buffer.append("})");
    }
}

