/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.tools;

import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchResultListener;
import com.unboundid.ldap.sdk.SearchResultReference;
import com.unboundid.ldap.sdk.transformations.EntryTransformation;
import com.unboundid.ldap.sdk.unboundidds.tools.LDAPSearchOutputHandler;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.List;

@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
final class LDAPSearchListener
implements SearchResultListener {
    private static final long serialVersionUID = -1334215024363357539L;
    private final LDAPSearchOutputHandler outputHandler;
    private final List<EntryTransformation> entryTransformations;

    LDAPSearchListener(LDAPSearchOutputHandler outputHandler, List<EntryTransformation> entryTransformations) {
        this.outputHandler = outputHandler;
        this.entryTransformations = entryTransformations;
    }

    @Override
    public void searchEntryReturned(SearchResultEntry searchEntry) {
        SearchResultEntry sre;
        if (this.entryTransformations == null) {
            sre = searchEntry;
        } else {
            Entry e = searchEntry;
            for (EntryTransformation t : this.entryTransformations) {
                e = t.transformEntry(e);
            }
            sre = new SearchResultEntry(searchEntry.getMessageID(), e, searchEntry.getControls());
        }
        this.outputHandler.formatSearchResultEntry(sre);
    }

    @Override
    public void searchReferenceReturned(SearchResultReference searchReference) {
        this.outputHandler.formatSearchResultReference(searchReference);
    }
}

