/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.Ref;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;

class SpecialRef
extends Ref {
    private static final int SPECIAL_NONE = 0;
    private static final int SPECIAL_PROTO = 1;
    private static final int SPECIAL_PARENT = 2;
    private int type;
    private String name;

    private SpecialRef(int type, String name) {
        this.type = type;
        this.name = name;
    }

    /*
     * WARNING - void declaration
     */
    static Ref createSpecial(Context cx, Object object, String name) {
        void var4_4;
        int type;
        Scriptable target = ScriptRuntime.toObjectOrNull(cx, object);
        if (target == null) {
            throw ScriptRuntime.undefReadError(object, name);
        }
        if (name.equals("__proto__")) {
            type = 1;
        } else if (name.equals("__parent__")) {
            type = 2;
        } else {
            throw new IllegalArgumentException(name);
        }
        if (!cx.hasFeature(5)) {
            type = 0;
        }
        return Ref.pushTarget(cx, new SpecialRef((int)var4_4, name), target);
    }

    public Object get(Context cx, Scriptable target) {
        switch (this.type) {
            case 0: {
                return ScriptRuntime.getObjectProp(target, this.name, cx);
            }
            case 1: {
                return target.getPrototype();
            }
            case 2: {
                return target.getParentScope();
            }
        }
        throw Kit.codeBug();
    }

    public Object set(Context cx, Scriptable target, Object value) {
        switch (this.type) {
            case 0: {
                return ScriptRuntime.setObjectProp(target, this.name, value, cx);
            }
            case 1: 
            case 2: {
                Scriptable obj = ScriptRuntime.toObjectOrNull(cx, value);
                if (obj != null) {
                    Scriptable search = obj;
                    do {
                        if (search != target) continue;
                        throw Context.reportRuntimeError1("msg.cyclic.value", this.name);
                    } while ((search = this.type == 1 ? search.getPrototype() : search.getParentScope()) != null);
                }
                if (this.type == 1) {
                    target.setPrototype(obj);
                } else {
                    target.setParentScope(obj);
                }
                return obj;
            }
        }
        throw Kit.codeBug();
    }

    public boolean has(Context cx, Scriptable target) {
        if (this.type == 0) {
            return ScriptRuntime.hasObjectElem(target, this.name, cx);
        }
        return true;
    }

    public boolean delete(Context cx, Scriptable target) {
        if (this.type == 0) {
            return ScriptRuntime.deleteObjectElem(target, this.name, cx);
        }
        return false;
    }
}

