/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.Cache;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlLink;
import com.gargoylesoftware.htmlunit.html.HtmlStyle;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.host.HTMLCollection;
import com.gargoylesoftware.htmlunit.javascript.host.HTMLDocument;
import com.gargoylesoftware.htmlunit.javascript.host.HTMLElement;
import com.gargoylesoftware.htmlunit.javascript.host.Stylesheet;
import java.io.Reader;
import java.io.StringReader;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.w3c.css.sac.InputSource;
import org.w3c.dom.css.CSSStyleSheet;

public class StyleSheetList
extends SimpleScriptable {
    private static final long serialVersionUID = -8607630805490604483L;
    private HTMLCollection nodes_;

    public StyleSheetList() {
    }

    public StyleSheetList(HTMLDocument document) {
        this.setParentScope((Scriptable)document);
        this.setPrototype(this.getPrototype(((Object)((Object)this)).getClass()));
        this.nodes_ = new HTMLCollection(document);
        boolean cssEnabled = this.getWindow().getWebWindow().getWebClient().isCssEnabled();
        if (cssEnabled) {
            this.nodes_.init(document.getHtmlPage(), ".//style | .//link[lower-case(@rel)='stylesheet']");
        }
    }

    public int jsxGet_length() {
        return this.nodes_.jsxGet_length();
    }

    public Stylesheet jsxFunction_item(int index) {
        Stylesheet sheet;
        Cache cache = this.getWindow().getWebWindow().getWebClient().getCache();
        HTMLElement element = (HTMLElement)this.nodes_.jsxFunction_item(new Integer(index));
        DomNode node = element.getDomNodeOrDie();
        if (node instanceof HtmlStyle) {
            CSSStyleSheet cached;
            HtmlStyle style = (HtmlStyle)node;
            String css = "";
            if (style.getFirstChild() != null) {
                css = style.getFirstChild().asText();
            }
            if ((cached = cache.getCachedStyleSheet(css)) != null) {
                sheet = new Stylesheet(element, cached);
            } else {
                InputSource source = new InputSource((Reader)new StringReader(css));
                sheet = new Stylesheet(element, source);
                cache.cache(css, sheet.getWrappedSheet());
            }
        } else {
            HtmlLink link = (HtmlLink)node;
            try {
                WebResponse response = link.getWebResponse(true);
                String css = response.getContentAsString();
                CSSStyleSheet cached = cache.getCachedStyleSheet(css);
                if (cached != null) {
                    sheet = new Stylesheet(element, cached);
                } else {
                    InputSource source = new InputSource((Reader)new StringReader(css));
                    sheet = new Stylesheet(element, source);
                    cache.cache(css, sheet.getWrappedSheet());
                }
            }
            catch (Exception e) {
                throw Context.reportRuntimeError((String)("Exception: " + e));
            }
        }
        return sheet;
    }

    public Object get(int index, Scriptable start) {
        if (this == start) {
            return this.jsxFunction_item(index);
        }
        return super.get(index, start);
    }
}

