/*
 * Decompiled with CFR 0.152.
 */
package jdk.incubator.http;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.Authenticator;
import java.net.CookieManager;
import java.net.ProxySelector;
import java.net.URI;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.security.NoSuchAlgorithmException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.stream.Stream;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import jdk.incubator.http.AsyncEvent;
import jdk.incubator.http.AuthenticationFilter;
import jdk.incubator.http.ConnectionPool;
import jdk.incubator.http.CookieFilter;
import jdk.incubator.http.FilterFactory;
import jdk.incubator.http.HeaderFilter;
import jdk.incubator.http.Http2ClientImpl;
import jdk.incubator.http.HttpClient;
import jdk.incubator.http.HttpClientBuilderImpl;
import jdk.incubator.http.HttpRequest;
import jdk.incubator.http.HttpResponse;
import jdk.incubator.http.MultiExchange;
import jdk.incubator.http.RedirectFilter;
import jdk.incubator.http.TimeoutEvent;
import jdk.incubator.http.WebSocket;
import jdk.incubator.http.internal.common.Log;
import jdk.incubator.http.internal.common.Utils;
import jdk.incubator.http.internal.websocket.BuilderImpl;

class HttpClientImpl
extends HttpClient {
    private final CookieManager cookieManager;
    private final HttpClient.Redirect followRedirects;
    private final ProxySelector proxySelector;
    private final Authenticator authenticator;
    private final HttpClient.Version version;
    private final ConnectionPool connections;
    private final Executor executor;
    private final SSLContext sslContext;
    private final SSLParameters sslParams;
    private final SelectorManager selmgr;
    private final FilterFactory filters;
    private final Http2ClientImpl client2;
    private final TreeSet<TimeoutEvent> timeouts;

    public static HttpClientImpl create(HttpClientBuilderImpl httpClientBuilderImpl) {
        HttpClientImpl httpClientImpl = new HttpClientImpl(httpClientBuilderImpl);
        httpClientImpl.start();
        return httpClientImpl;
    }

    private HttpClientImpl(HttpClientBuilderImpl httpClientBuilderImpl) {
        if (httpClientBuilderImpl.sslContext == null) {
            try {
                this.sslContext = SSLContext.getDefault();
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new InternalError(noSuchAlgorithmException);
            }
        } else {
            this.sslContext = httpClientBuilderImpl.sslContext;
        }
        Executor executor = httpClientBuilderImpl.executor;
        executor = executor == null ? Executors.newCachedThreadPool(DefaultThreadFactory.INSTANCE) : httpClientBuilderImpl.executor;
        this.client2 = new Http2ClientImpl(this);
        this.executor = executor;
        this.cookieManager = httpClientBuilderImpl.cookieManager;
        this.followRedirects = httpClientBuilderImpl.followRedirects == null ? HttpClient.Redirect.NEVER : httpClientBuilderImpl.followRedirects;
        this.proxySelector = httpClientBuilderImpl.proxy;
        this.authenticator = httpClientBuilderImpl.authenticator;
        this.version = httpClientBuilderImpl.version == null ? HttpClient.Version.HTTP_2 : httpClientBuilderImpl.version;
        this.sslParams = httpClientBuilderImpl.sslParams == null ? HttpClientImpl.getDefaultParams(this.sslContext) : httpClientBuilderImpl.sslParams;
        this.connections = new ConnectionPool();
        this.connections.start();
        this.timeouts = new TreeSet();
        try {
            this.selmgr = new SelectorManager(this);
        }
        catch (IOException iOException) {
            throw new InternalError(iOException);
        }
        this.selmgr.setDaemon(true);
        this.filters = new FilterFactory();
        this.initFilters();
    }

    private void start() {
        this.selmgr.start();
    }

    private static SSLParameters getDefaultParams(SSLContext sSLContext) {
        SSLParameters sSLParameters = sSLContext.getSupportedSSLParameters();
        sSLParameters.setProtocols(new String[]{"TLSv1.2"});
        return sSLParameters;
    }

    void registerEvent(AsyncEvent asyncEvent) throws IOException {
        this.selmgr.register(asyncEvent);
    }

    void cancelRegistration(SocketChannel socketChannel) {
        this.selmgr.cancel(socketChannel);
    }

    Http2ClientImpl client2() {
        return this.client2;
    }

    @Override
    public <T> HttpResponse<T> send(HttpRequest httpRequest, HttpResponse.BodyHandler<T> bodyHandler) throws IOException, InterruptedException {
        MultiExchange multiExchange = new MultiExchange(httpRequest, this, bodyHandler);
        return multiExchange.response();
    }

    @Override
    public <T> CompletableFuture<HttpResponse<T>> sendAsync(HttpRequest httpRequest, HttpResponse.BodyHandler<T> bodyHandler) {
        MultiExchange multiExchange = new MultiExchange(httpRequest, this, bodyHandler);
        return multiExchange.responseAsync().thenApply(httpResponseImpl -> httpResponseImpl);
    }

    @Override
    public <U, T> CompletableFuture<U> sendAsync(HttpRequest httpRequest, HttpResponse.MultiProcessor<U, T> multiProcessor) {
        MultiExchange<U, T> multiExchange = new MultiExchange<U, T>(httpRequest, this, multiProcessor);
        return multiExchange.multiResponseAsync();
    }

    @Override
    public SSLContext sslContext() {
        Utils.checkNetPermission("getSSLContext");
        return this.sslContext;
    }

    @Override
    public Optional<SSLParameters> sslParameters() {
        return Optional.ofNullable(this.sslParams);
    }

    @Override
    public Optional<Authenticator> authenticator() {
        return Optional.ofNullable(this.authenticator);
    }

    @Override
    public Executor executor() {
        return this.executor;
    }

    ConnectionPool connectionPool() {
        return this.connections;
    }

    @Override
    public HttpClient.Redirect followRedirects() {
        return this.followRedirects;
    }

    @Override
    public Optional<CookieManager> cookieManager() {
        return Optional.ofNullable(this.cookieManager);
    }

    @Override
    public Optional<ProxySelector> proxy() {
        return Optional.ofNullable(this.proxySelector);
    }

    @Override
    public WebSocket.Builder newWebSocketBuilder(URI uRI, WebSocket.Listener listener) {
        return new BuilderImpl(this, uRI, listener);
    }

    @Override
    public HttpClient.Version version() {
        return this.version;
    }

    boolean getHttp2Allowed() {
        return this.version.equals((Object)HttpClient.Version.HTTP_2);
    }

    private void initFilters() {
        this.addFilter(AuthenticationFilter.class);
        this.addFilter(RedirectFilter.class);
        if (this.cookieManager != null) {
            this.addFilter(CookieFilter.class);
        }
    }

    private void addFilter(Class<? extends HeaderFilter> clazz) {
        this.filters.addFilter(clazz);
    }

    final List<HeaderFilter> filterChain() {
        return this.filters.getFilterChain();
    }

    synchronized void registerTimer(TimeoutEvent timeoutEvent) {
        Log.logTrace("Registering timer {0}", timeoutEvent);
        this.timeouts.add(timeoutEvent);
        this.selmgr.wakeupSelector();
    }

    synchronized void cancelTimer(TimeoutEvent timeoutEvent) {
        Log.logTrace("Canceling timer {0}", timeoutEvent);
        this.timeouts.remove(timeoutEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long purgeTimeoutsAndReturnNextDeadline() {
        long l = 0L;
        List list = null;
        int n = 0;
        Object object = this;
        synchronized (object) {
            TimeoutEvent timeoutEvent;
            if (this.timeouts.isEmpty()) {
                return 0L;
            }
            Instant instant = Instant.now();
            Object object2 = this.timeouts.iterator();
            while (object2.hasNext() && (l = instant.until((timeoutEvent = object2.next()).deadline(), ChronoUnit.MILLIS)) <= 0L) {
                object2.remove();
                list = list == null ? new ArrayList() : list;
                list.add(timeoutEvent);
            }
            n = this.timeouts.size();
        }
        if (list != null && Log.trace()) {
            Log.logTrace("purgeTimeoutsAndReturnNextDeadline: handling " + (list == null ? 0 : list.size()) + " events, " + "remaining " + n + ", next deadline: " + (l < 0L ? 0L : l), new Object[0]);
        }
        if (list != null) {
            object = null;
            for (Object object2 : list) {
                try {
                    Log.logTrace("Firing timer {0}", object2);
                    ((TimeoutEvent)object2).handle();
                }
                catch (Error | RuntimeException throwable) {
                    if (object == null) {
                        object = throwable;
                    } else {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                    Log.logTrace("Failed to handle event {0}: {1}", object2, throwable);
                }
            }
            if (object instanceof Error) {
                throw (Error)object;
            }
            if (object instanceof RuntimeException) {
                throw (RuntimeException)object;
            }
        }
        return l < 0L ? 0L : l;
    }

    int getReceiveBufferSize() {
        return Utils.getIntegerNetProperty("jdk.httpclient.connectionWindowSize", 262144);
    }

    private static class SelectorAttachment {
        private final SelectableChannel chan;
        private final Selector selector;
        private final ArrayList<AsyncEvent> pending = new ArrayList();
        private int interestOps;

        SelectorAttachment(SelectableChannel selectableChannel, Selector selector) {
            this.chan = selectableChannel;
            this.selector = selector;
        }

        void register(AsyncEvent asyncEvent) throws ClosedChannelException {
            int n = asyncEvent.interestOps();
            boolean bl = (this.interestOps & n) != n;
            this.interestOps |= n;
            this.pending.add(asyncEvent);
            if (bl) {
                this.chan.register(this.selector, this.interestOps, this);
            }
        }

        Stream<AsyncEvent> events(int n) {
            return this.pending.stream().filter(asyncEvent -> (asyncEvent.interestOps() & n) != 0);
        }

        void resetInterestOps(int n) {
            Object object;
            int n2 = 0;
            Iterator<AsyncEvent> iterator = this.pending.iterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                int n3 = ((AsyncEvent)object).interestOps();
                if (((AsyncEvent)object).repeating()) {
                    n2 |= n3;
                    continue;
                }
                if ((n3 & n) != 0) {
                    iterator.remove();
                    continue;
                }
                n2 |= n3;
            }
            this.interestOps = n2;
            object = this.chan.keyFor(this.selector);
            if (n2 == 0) {
                ((SelectionKey)object).cancel();
            } else {
                ((SelectionKey)object).interestOps(n2);
            }
        }
    }

    private static final class SelectorManager
    extends Thread {
        private static final long NODEADLINE = 3000L;
        private final Selector selector;
        private volatile boolean closed;
        private final List<AsyncEvent> readyList;
        private final List<AsyncEvent> registrations;
        WeakReference<HttpClientImpl> ownerRef;

        SelectorManager(HttpClientImpl httpClientImpl) throws IOException {
            super(null, null, "SelectorManager");
            this.ownerRef = new WeakReference<HttpClientImpl>(httpClientImpl);
            this.readyList = new ArrayList<AsyncEvent>();
            this.registrations = new ArrayList<AsyncEvent>();
            this.selector = Selector.open();
        }

        synchronized void register(AsyncEvent asyncEvent) throws IOException {
            this.registrations.add(asyncEvent);
            this.selector.wakeup();
        }

        synchronized void cancel(SocketChannel socketChannel) {
            SelectionKey selectionKey = socketChannel.keyFor(this.selector);
            if (selectionKey != null) {
                selectionKey.cancel();
            }
            this.selector.wakeup();
        }

        void wakeupSelector() {
            this.selector.wakeup();
        }

        synchronized void shutdown() {
            this.closed = true;
            try {
                this.selector.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public void run() {
            try {
                while (!Thread.currentThread().isInterrupted()) {
                    Iterator<AsyncEvent> iterator;
                    Object object2;
                    SelectorManager selectorManager = this;
                    synchronized (selectorManager) {
                        for (AsyncEvent asyncEvent : this.registrations) {
                            object2 = asyncEvent.channel();
                            try {
                                void var7_15;
                                ((SelectableChannel)object2).configureBlocking(false);
                                iterator = ((SelectableChannel)object2).keyFor(this.selector);
                                if (iterator == null || !((SelectionKey)((Object)iterator)).isValid()) {
                                    if (iterator != null) {
                                        this.selector.selectNow();
                                    }
                                    SelectorAttachment selectorAttachment = new SelectorAttachment((SelectableChannel)object2, this.selector);
                                } else {
                                    SelectorAttachment selectorAttachment = (SelectorAttachment)((SelectionKey)((Object)iterator)).attachment();
                                }
                                var7_15.register(asyncEvent);
                            }
                            catch (IOException iOException) {
                                Log.logError("HttpClientImpl: " + iOException, new Object[0]);
                                ((AbstractInterruptibleChannel)object2).close();
                                this.handleEvent(asyncEvent);
                            }
                        }
                        this.registrations.clear();
                    }
                    HttpClientImpl httpClientImpl = (HttpClientImpl)this.ownerRef.get();
                    if (httpClientImpl == null) {
                        Log.logTrace("HttpClient no longer referenced. Exiting...", new Object[0]);
                        return;
                    }
                    long l = httpClientImpl.purgeTimeoutsAndReturnNextDeadline();
                    httpClientImpl = null;
                    int n = this.selector.select(l == 0L ? 3000L : l);
                    if (n == 0) {
                        httpClientImpl = (HttpClientImpl)this.ownerRef.get();
                        if (httpClientImpl == null) {
                            Log.logTrace("HttpClient no longer referenced. Exiting...", new Object[0]);
                            return;
                        }
                        httpClientImpl.purgeTimeoutsAndReturnNextDeadline();
                        httpClientImpl = null;
                        continue;
                    }
                    object2 = this.selector.selectedKeys();
                    iterator = object2.iterator();
                    while (iterator.hasNext()) {
                        SelectionKey selectionKey = (SelectionKey)iterator.next();
                        SelectorAttachment selectorAttachment = (SelectorAttachment)selectionKey.attachment();
                        int n2 = selectionKey.readyOps();
                        selectorAttachment.events(n2).forEach(this.readyList::add);
                        selectorAttachment.resetInterestOps(n2);
                    }
                    this.selector.selectNow();
                    this.selector.selectedKeys().clear();
                    for (AsyncEvent asyncEvent : this.readyList) {
                        if (asyncEvent.blocking()) {
                            asyncEvent.channel().configureBlocking(true);
                        }
                        this.handleEvent(asyncEvent);
                    }
                    this.readyList.clear();
                }
            }
            catch (Throwable throwable) {
                if (!this.closed) {
                    String string = Utils.stackTrace(throwable);
                    Log.logError("HttpClientImpl: fatal error: " + string, new Object[0]);
                }
            }
            finally {
                this.shutdown();
            }
        }

        void debugPrint(Selector selector) {
            System.err.println("Selector: debugprint start");
            Set<SelectionKey> set = selector.keys();
            for (SelectionKey selectionKey : set) {
                SelectableChannel selectableChannel = selectionKey.channel();
                int n = selectionKey.interestOps();
                System.err.printf("selector chan:%s ops:%d\n", selectableChannel, n);
            }
            System.err.println("Selector: debugprint end");
        }

        void handleEvent(AsyncEvent asyncEvent) {
            if (this.closed) {
                asyncEvent.abort();
            } else {
                asyncEvent.handle();
            }
        }
    }

    private static final class DefaultThreadFactory
    implements ThreadFactory {
        static final ThreadFactory INSTANCE = new DefaultThreadFactory();

        private DefaultThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(null, runnable, "HttpClient_worker");
            thread.setDaemon(true);
            return thread;
        }
    }
}

