/*
 * Decompiled with CFR 0.152.
 */
package jdk.incubator.http;

import java.net.URI;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import jdk.incubator.http.HttpClient;
import jdk.incubator.http.HttpRequest;
import jdk.incubator.http.HttpRequestImpl;
import jdk.incubator.http.internal.common.HttpHeadersImpl;
import jdk.incubator.http.internal.common.Utils;

class HttpRequestBuilderImpl
extends HttpRequest.Builder {
    private HttpHeadersImpl userHeaders;
    private URI uri;
    private String method;
    private boolean expectContinue;
    private HttpRequest.BodyProcessor body;
    private volatile Optional<HttpClient.Version> version;
    private Duration duration;

    public HttpRequestBuilderImpl(URI uRI) {
        HttpRequestBuilderImpl.checkURI(uRI);
        this.uri = uRI;
        this.userHeaders = new HttpHeadersImpl();
        this.method = "GET";
        this.version = Optional.empty();
    }

    public HttpRequestBuilderImpl() {
        this.userHeaders = new HttpHeadersImpl();
        this.version = Optional.empty();
    }

    @Override
    public HttpRequestBuilderImpl uri(URI uRI) {
        Objects.requireNonNull(uRI);
        HttpRequestBuilderImpl.checkURI(uRI);
        this.uri = uRI;
        return this;
    }

    private static void checkURI(URI uRI) {
        String string = uRI.getScheme().toLowerCase();
        if (!string.equals("https") && !string.equals("http")) {
            throw new IllegalArgumentException("invalid URI scheme");
        }
    }

    @Override
    public HttpRequestBuilderImpl header(String string, String string2) {
        this.checkNameAndValue(string, string2);
        this.userHeaders.addHeader(string, string2);
        return this;
    }

    @Override
    public HttpRequestBuilderImpl headers(String ... stringArray) {
        Objects.requireNonNull(stringArray);
        if (stringArray.length % 2 != 0) {
            throw new IllegalArgumentException("wrong number of parameters");
        }
        for (int i = 0; i < stringArray.length; i += 2) {
            String string = stringArray[i];
            String string2 = stringArray[i + 1];
            this.header(string, string2);
        }
        return this;
    }

    @Override
    public HttpRequestBuilderImpl copy() {
        HttpRequestBuilderImpl httpRequestBuilderImpl = new HttpRequestBuilderImpl(this.uri);
        httpRequestBuilderImpl.userHeaders = this.userHeaders.deepCopy();
        httpRequestBuilderImpl.method = this.method;
        httpRequestBuilderImpl.expectContinue = this.expectContinue;
        httpRequestBuilderImpl.body = this.body;
        httpRequestBuilderImpl.uri = this.uri;
        return httpRequestBuilderImpl;
    }

    @Override
    public HttpRequestBuilderImpl setHeader(String string, String string2) {
        this.checkNameAndValue(string, string2);
        this.userHeaders.setHeader(string, string2);
        return this;
    }

    private void checkNameAndValue(String string, String string2) {
        Objects.requireNonNull(string, "name");
        Objects.requireNonNull(string2, "value");
        if (!Utils.isValidName(string)) {
            throw new IllegalArgumentException("invalid header name");
        }
        if (!Utils.isValidValue(string2)) {
            throw new IllegalArgumentException("invalid header value");
        }
    }

    @Override
    public HttpRequestBuilderImpl expectContinue(boolean bl) {
        this.expectContinue = bl;
        return this;
    }

    @Override
    public HttpRequestBuilderImpl version(HttpClient.Version version) {
        Objects.requireNonNull(version);
        this.version = Optional.of(version);
        return this;
    }

    HttpHeadersImpl headers() {
        return this.userHeaders;
    }

    URI uri() {
        return this.uri;
    }

    String method() {
        return this.method;
    }

    boolean expectContinue() {
        return this.expectContinue;
    }

    public HttpRequest.BodyProcessor body() {
        return this.body;
    }

    Optional<HttpClient.Version> version() {
        return this.version;
    }

    @Override
    public HttpRequest.Builder GET() {
        return this.method("GET", null);
    }

    @Override
    public HttpRequest.Builder POST(HttpRequest.BodyProcessor bodyProcessor) {
        return this.method("POST", bodyProcessor);
    }

    @Override
    public HttpRequest.Builder DELETE(HttpRequest.BodyProcessor bodyProcessor) {
        return this.method("DELETE", bodyProcessor);
    }

    @Override
    public HttpRequest.Builder PUT(HttpRequest.BodyProcessor bodyProcessor) {
        return this.method("PUT", bodyProcessor);
    }

    @Override
    public HttpRequest.Builder method(String string, HttpRequest.BodyProcessor bodyProcessor) {
        this.method = Objects.requireNonNull(string);
        this.body = bodyProcessor;
        return this;
    }

    @Override
    public HttpRequest build() {
        return new HttpRequestImpl(this);
    }

    @Override
    public HttpRequest.Builder timeout(Duration duration) {
        Objects.requireNonNull(duration);
        if (duration.isNegative() || Duration.ZERO.equals(duration)) {
            throw new IllegalArgumentException("Invalid duration: " + duration);
        }
        this.duration = duration;
        return this;
    }

    Duration duration() {
        return this.duration;
    }
}

