/*
 * Decompiled with CFR 0.152.
 */
package jdk.incubator.http.internal.common;

import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import jdk.incubator.http.internal.common.ByteBufferReference;
import jdk.incubator.http.internal.frame.DataFrame;
import jdk.incubator.http.internal.frame.Http2Frame;

public class AsyncDataReadQueue
implements Closeable {
    private static final int BLOCKING = 0;
    private static final int FLUSHING = 1;
    private static final int REFLUSHING = 2;
    private static final int ASYNC = 3;
    private static final int CLOSED = 4;
    private final AtomicInteger state = new AtomicInteger(0);
    private final BlockingQueue<Http2Frame> queue = new LinkedBlockingQueue<Http2Frame>();
    private Executor executor;
    private DataConsumer onData;
    private Consumer<Throwable> onError;

    public boolean tryPut(Http2Frame http2Frame) {
        if (this.state.get() == 4) {
            return false;
        }
        this.queue.offer(http2Frame);
        this.flushAsync(false);
        return true;
    }

    public void put(Http2Frame http2Frame) throws IOException {
        if (!this.tryPut(http2Frame)) {
            throw new IOException("stream closed");
        }
    }

    public void blockingReceive(DataConsumer dataConsumer, Consumer<Throwable> consumer) {
        if (this.state.get() == 4) {
            consumer.accept(new IOException("stream closed"));
            return;
        }
        assert (this.state.get() == 0);
        try {
            while (dataConsumer.accept(this.queue.take())) {
            }
            assert (this.state.get() == 4);
        }
        catch (Throwable throwable) {
            consumer.accept(throwable);
        }
    }

    public void asyncReceive(Executor executor, DataConsumer dataConsumer, Consumer<Throwable> consumer) {
        if (this.state.get() == 4) {
            consumer.accept(new IOException("stream closed"));
            return;
        }
        assert (this.state.get() == 0);
        if (!(AsyncDataReadQueue.checkCanSet("executor", this.executor, consumer) && AsyncDataReadQueue.checkCanSet("onData", this.onData, consumer) && AsyncDataReadQueue.checkCanSet("onError", this.onError, consumer))) {
            return;
        }
        this.executor = executor;
        this.onData = dataConsumer;
        this.onError = consumer;
        if (!this.state.compareAndSet(0, 3)) {
            consumer.accept(new IOException(new IllegalStateException("State: " + this.state.get())));
            return;
        }
        this.flushAsync(true);
    }

    private static <T> boolean checkCanSet(String string, T t, Consumer<Throwable> consumer) {
        if (t != null) {
            consumer.accept(new IOException(new IllegalArgumentException(string)));
            return false;
        }
        return true;
    }

    @Override
    public void close() {
        int n = this.state.getAndSet(4);
        if (n == 0) {
            this.queue.offer(new DataFrame(0, 1, new ByteBufferReference[0]));
        }
    }

    private void flushAsync(boolean bl) {
        while (true) {
            switch (this.state.get()) {
                case 0: 
                case 2: 
                case 4: {
                    return;
                }
                case 3: {
                    if (!this.state.compareAndSet(3, 1)) break;
                    if (bl) {
                        this.flushLoop();
                    } else {
                        this.executor.execute(this::flushLoop);
                    }
                    return;
                }
                case 1: {
                    if (!this.state.compareAndSet(1, 2)) break;
                    return;
                }
            }
        }
    }

    private void flushLoop() {
        try {
            while (true) {
                Http2Frame http2Frame = (Http2Frame)this.queue.poll();
                while (http2Frame != null) {
                    if (!this.onData.accept(http2Frame)) {
                        assert (this.state.get() == 4);
                        return;
                    }
                    http2Frame = (Http2Frame)this.queue.poll();
                }
                switch (this.state.get()) {
                    case 0: {
                        assert (false);
                        break;
                    }
                    case 3: {
                        throw new RuntimeException("Shouldn't happen");
                    }
                    case 1: {
                        if (!this.state.compareAndSet(1, 3)) break;
                        return;
                    }
                    case 2: {
                        this.state.compareAndSet(2, 1);
                        break;
                    }
                    case 4: {
                        return;
                    }
                }
            }
        }
        catch (Throwable throwable) {
            this.onError.accept(throwable);
            this.close();
            return;
        }
    }

    @FunctionalInterface
    public static interface DataConsumer {
        public boolean accept(Http2Frame var1) throws Throwable;
    }
}

