/*
 * Decompiled with CFR 0.152.
 */
package jdk.incubator.http.internal.websocket;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.time.Duration;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import jdk.incubator.http.HttpClient;
import jdk.incubator.http.HttpHeaders;
import jdk.incubator.http.HttpRequest;
import jdk.incubator.http.HttpResponse;
import jdk.incubator.http.WebSocketHandshakeException;
import jdk.incubator.http.internal.common.MinimalFuture;
import jdk.incubator.http.internal.common.Pair;
import jdk.incubator.http.internal.common.Utils;
import jdk.incubator.http.internal.common.Utils8;
import jdk.incubator.http.internal.websocket.BuilderImpl;
import jdk.incubator.http.internal.websocket.CheckFailedException;
import jdk.incubator.http.internal.websocket.RawChannel;
import jdk.incubator.http.internal.websocket.WebSocketRequest;

final class OpeningHandshake {
    private static final String HEADER_CONNECTION = "Connection";
    private static final String HEADER_UPGRADE = "Upgrade";
    private static final String HEADER_ACCEPT = "Sec-WebSocket-Accept";
    private static final String HEADER_EXTENSIONS = "Sec-WebSocket-Extensions";
    private static final String HEADER_KEY = "Sec-WebSocket-Key";
    private static final String HEADER_PROTOCOL = "Sec-WebSocket-Protocol";
    private static final String HEADER_VERSION = "Sec-WebSocket-Version";
    private static final Set<String> FORBIDDEN_HEADERS = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
    private static final SecureRandom srandom;
    private final MessageDigest sha1;
    private final HttpClient client;
    private final HttpRequest request;
    private final Collection<String> subprotocols;
    private final String nonce;

    OpeningHandshake(BuilderImpl builderImpl) {
        Object object;
        try {
            this.sha1 = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new InternalError("Minimum requirements", noSuchAlgorithmException);
        }
        this.client = builderImpl.getClient();
        URI uRI = OpeningHandshake.createRequestURI(builderImpl.getUri());
        HttpRequest.Builder builder = HttpRequest.newBuilder(uRI);
        Duration duration = builderImpl.getConnectTimeout();
        if (duration != null) {
            builder.timeout(duration);
        }
        for (Pair<String, String> pair : builderImpl.getHeaders()) {
            if (FORBIDDEN_HEADERS.contains(pair.first)) {
                throw OpeningHandshake.illegal("Illegal header: " + (String)pair.first);
            }
            builder.header((String)pair.first, (String)pair.second);
        }
        this.subprotocols = OpeningHandshake.createRequestSubprotocols(builderImpl.getSubprotocols());
        if (!this.subprotocols.isEmpty()) {
            object = this.subprotocols.stream().collect(Collectors.joining(", "));
            builder.header(HEADER_PROTOCOL, (String)object);
        }
        builder.header(HEADER_VERSION, "13");
        this.nonce = OpeningHandshake.createNonce();
        builder.header(HEADER_KEY, this.nonce);
        this.request = builder.version(HttpClient.Version.HTTP_1_1).GET().build();
        object = (WebSocketRequest)((Object)this.request);
        object.isWebSocket(true);
        object.setSystemHeader(HEADER_UPGRADE, "websocket");
        object.setSystemHeader(HEADER_CONNECTION, HEADER_UPGRADE);
    }

    private static Collection<String> createRequestSubprotocols(Collection<String> collection) {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(collection.size(), 1.0f);
        for (String string : collection) {
            if (string.trim().isEmpty() || !Utils.isValidName(string)) {
                throw OpeningHandshake.illegal("Bad subprotocol syntax: " + string);
            }
            if (linkedHashSet.add(string)) continue;
            throw OpeningHandshake.illegal("Duplicating subprotocol: " + string);
        }
        return Collections.unmodifiableCollection(linkedHashSet);
    }

    private static URI createRequestURI(URI uRI) {
        String string = uRI.getScheme();
        if (!"ws".equalsIgnoreCase(string) && !"wss".equalsIgnoreCase(string) || uRI.getFragment() != null) {
            throw OpeningHandshake.illegal("Bad URI: " + uRI);
        }
        String string2 = "ws".equalsIgnoreCase(string) ? "http" : "https";
        try {
            return new URI(string2, uRI.getUserInfo(), uRI.getHost(), uRI.getPort(), uRI.getPath(), uRI.getQuery(), null);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new InternalError(uRISyntaxException);
        }
    }

    CompletableFuture<Result> send() {
        return this.client.sendAsync(this.request, HttpResponse.BodyHandler.discard(null)).thenCompose(this::resultFrom);
    }

    private CompletableFuture<Result> resultFrom(HttpResponse<?> httpResponse) {
        Result result = null;
        IOException iOException = null;
        try {
            result = this.handleResponse(httpResponse);
        }
        catch (IOException iOException2) {
            iOException = iOException2;
        }
        catch (Exception exception) {
            iOException = new WebSocketHandshakeException(httpResponse).initCause(exception);
        }
        if (iOException == null) {
            return MinimalFuture.completedFuture(result);
        }
        try {
            ((RawChannel.Provider)((Object)httpResponse)).rawChannel().close();
        }
        catch (IOException iOException3) {
            iOException.addSuppressed(iOException3);
        }
        return MinimalFuture.failedFuture(iOException);
    }

    private Result handleResponse(HttpResponse<?> httpResponse) throws IOException {
        int n = httpResponse.statusCode();
        if (n != 101) {
            throw OpeningHandshake.checkFailed("Unexpected HTTP response status code " + n);
        }
        HttpHeaders httpHeaders = httpResponse.headers();
        String string = OpeningHandshake.requireSingle(httpHeaders, HEADER_UPGRADE);
        if (!string.equalsIgnoreCase("websocket")) {
            throw OpeningHandshake.checkFailed("Bad response field: Upgrade");
        }
        String string2 = OpeningHandshake.requireSingle(httpHeaders, HEADER_CONNECTION);
        if (!string2.equalsIgnoreCase(HEADER_UPGRADE)) {
            throw OpeningHandshake.checkFailed("Bad response field: Connection");
        }
        OpeningHandshake.requireAbsent(httpHeaders, HEADER_VERSION);
        OpeningHandshake.requireAbsent(httpHeaders, HEADER_EXTENSIONS);
        String string3 = this.nonce + "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";
        this.sha1.update(string3.getBytes(StandardCharsets.ISO_8859_1));
        String string4 = Base64.getEncoder().encodeToString(this.sha1.digest());
        String string5 = OpeningHandshake.requireSingle(httpHeaders, HEADER_ACCEPT);
        if (!string5.trim().equals(string4)) {
            throw OpeningHandshake.checkFailed("Bad Sec-WebSocket-Accept");
        }
        String string6 = this.checkAndReturnSubprotocol(httpHeaders);
        RawChannel rawChannel = ((RawChannel.Provider)((Object)httpResponse)).rawChannel();
        return new Result(string6, rawChannel);
    }

    private String checkAndReturnSubprotocol(HttpHeaders httpHeaders) throws CheckFailedException {
        Optional<String> optional = httpHeaders.firstValue(HEADER_PROTOCOL);
        if (!optional.isPresent()) {
            return "";
        }
        String string = OpeningHandshake.requireSingle(httpHeaders, HEADER_PROTOCOL);
        if (this.subprotocols.contains(string)) {
            return string;
        }
        throw OpeningHandshake.checkFailed("Unexpected subprotocol: " + string);
    }

    private static void requireAbsent(HttpHeaders httpHeaders, String string) {
        List<String> list = httpHeaders.allValues(string);
        if (!list.isEmpty()) {
            throw OpeningHandshake.checkFailed(String.format("Response field '%s' present: %s", string, Utils.stringOf(list)));
        }
    }

    private static String requireSingle(HttpHeaders httpHeaders, String string) {
        List<String> list = httpHeaders.allValues(string);
        if (list.isEmpty()) {
            throw OpeningHandshake.checkFailed("Response field missing: " + string);
        }
        if (list.size() > 1) {
            throw OpeningHandshake.checkFailed(String.format("Response field '%s' multivalued: %s", string, Utils.stringOf(list)));
        }
        return list.get(0);
    }

    private static String createNonce() {
        byte[] byArray = new byte[16];
        srandom.nextBytes(byArray);
        return Base64.getEncoder().encodeToString(byArray);
    }

    private static IllegalArgumentException illegal(String string) {
        return new IllegalArgumentException(string);
    }

    private static CheckFailedException checkFailed(String string) {
        throw new CheckFailedException(string);
    }

    static {
        FORBIDDEN_HEADERS.addAll(Utils8.listOf(HEADER_ACCEPT, HEADER_EXTENSIONS, HEADER_KEY, HEADER_PROTOCOL, HEADER_VERSION));
        srandom = new SecureRandom();
    }

    static final class Result {
        final String subprotocol;
        final RawChannel channel;

        private Result(String string, RawChannel rawChannel) {
            this.subprotocol = string;
            this.channel = rawChannel;
        }
    }
}

