/*
 * Copyright (c) 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id$ 
 */

package com.sun.ts.tests.jaxrs.api.client.clientrequestcontext;

import java.util.concurrent.atomic.AtomicInteger;

import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.core.Response;

import com.sun.ts.lib.harness.EETest.Fault;

public class GetSetPropertyProvider extends ContextProvider {
	private AtomicInteger counter;
	
	public GetSetPropertyProvider(AtomicInteger counter) {
		super();
		this.counter = counter;
	}

	@Override
	protected void checkFilterContext(ClientRequestContext context)
			throws Fault {
		Object property = context.getProperty("PROPERTY");
		String entity = property == null ? "NULL" : property.toString();
		if (counter.incrementAndGet() == 2) {
			Response r = Response.ok(entity).build();
			context.abortWith(r);
		} else
			context.setProperty("PROPERTY", "value");
	}

}
