/*
 * Copyright (c) 2012, 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 * $Id: Resource.java 70710 2013-03-15 11:47:37Z supol $
 */
package com.sun.ts.tests.jaxrs.ee.resource.java2entity;

import java.lang.reflect.Method;
import java.util.LinkedList;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.Response;

@Path("resource")
public class Resource {

	@Path("linkedlist")
	@GET
	public LinkedList<String> checkDirect() {
		LinkedList<String> list = new LinkedList<String>();
		list.add("linked");
		list.add("list");
		return list;
	}

	@Path("response/linkedlist")
	@GET
	public Response checkResponseDirect() {
		LinkedList<String> list = new LinkedList<String>();
		list.add("linked");
		list.add("list");
		return Response.ok(list).build();
	}

	@Path("response/genericentity/linkedlist")
	@GET
	public Response checkResponseGeneric() {
		GenericEntity<LinkedList<String>> gells = checkGeneric();
		return Response.ok(gells).build();
	}

	@Path("genericentity/linkedlist")
	@GET
	public GenericEntity<LinkedList<String>> checkGeneric() {
		LinkedList<String> list = new LinkedList<String>();
		list.add("linked");
		list.add("list");
		GenericEntity<LinkedList<String>> gells;
		gells = new GenericEntity<LinkedList<String>>(list, getMethodByName(
				"checkDirect").getGenericReturnType());
		return gells;
	}

	private Method getMethodByName(String name) {
		try {
			Method method = getClass().getMethod(name);
			return method;
		} catch (NoSuchMethodException e) {
			e.printStackTrace();
			return null;
		}
	}
}
