/*
 * Copyright (c) 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 * $Id$
 */
package com.sun.ts.tests.jaxrs.ee.rs;

import java.util.IllegalFormatException;
import java.util.MissingFormatArgumentException;

import javax.ws.rs.core.Response;
import javax.ws.rs.core.Response.Status;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;

@Provider
public class RuntimeExceptionMapper implements
		ExceptionMapper<RuntimeException> {

	@Override
	public Response toResponse(RuntimeException exception) {
		Status status = Status.GONE;
		if (exception instanceof MissingFormatArgumentException)
			status = Status.MOVED_PERMANENTLY; // 301
		else if (exception instanceof IllegalFormatException)
			status = Status.SEE_OTHER; // 303
		else if (exception instanceof IllegalArgumentException)
			status = Status.NOT_MODIFIED;// 304
		if (status == Status.GONE)
			exception.printStackTrace();
		return Response.status(status).entity(exception.getMessage()).build();
	}

}
