/*
 * Copyright (c) 2014,  Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 * $Id: Resource.java 74172 2014-10-30 14:11:06Z supol $
 */
package com.sun.ts.tests.jaxrs.ee.rs.beanparam.query.plain;

import javax.ws.rs.BeanParam;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;

import com.sun.ts.tests.jaxrs.ee.rs.Constants;
import com.sun.ts.tests.jaxrs.ee.rs.ParamTest;
import com.sun.ts.tests.jaxrs.ee.rs.beanparam.query.bean.QueryBeanParamEntity;

@Path(value = "resource")
public class Resource extends ParamTest {

	@BeanParam
	QueryBeanParamEntity field;

	@GET
	@Path("Field")
	@Produces(MediaType.TEXT_PLAIN)
	@Consumes(MediaType.APPLICATION_FORM_URLENCODED)
	public String field() {
		sb = new StringBuilder();
		setReturnValues(field.paramEntityWithConstructor,
				field.paramEntityWithFromString, field.paramEntityWithValueOf,
				field.setParamEntityWithFromString,
				field.sortedSetParamEntityWithFromString,
				field.listParamEntityWithFromString, FIELD);
		setReturnValues(field.inner.paramEntityWithConstructor,
				field.inner.paramEntityWithFromString,
				field.inner.paramEntityWithValueOf,
				field.inner.setParamEntityWithFromString,
				field.inner.sortedSetParamEntityWithFromString,
				field.inner.listParamEntityWithFromString, Constants.INNER
						+ FIELD);
		return sb.toString();
	}

	@GET
	@Path("Param")
	@Produces(MediaType.TEXT_PLAIN)
	@Consumes(MediaType.APPLICATION_FORM_URLENCODED)
	public String stringParamHandling(@BeanParam QueryBeanParamEntity bean) {
		sb = new StringBuilder();
		setReturnValues(bean.paramEntityWithConstructor,
				bean.paramEntityWithFromString, bean.paramEntityWithValueOf,
				bean.setParamEntityWithFromString,
				bean.sortedSetParamEntityWithFromString,
				bean.listParamEntityWithFromString, PARAM);
		setReturnValues(bean.inner.paramEntityWithConstructor,
				bean.inner.paramEntityWithFromString,
				bean.inner.paramEntityWithValueOf,
				bean.inner.setParamEntityWithFromString,
				bean.inner.sortedSetParamEntityWithFromString,
				bean.inner.listParamEntityWithFromString, Constants.INNER
						+ PARAM);
		return sb.toString();
	}
}
