/*
 * Copyright (c) 2012, 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: RequestFilter.java 69536 2013-01-16 13:41:41Z supol $ 
 */

package com.sun.ts.tests.jaxrs.ee.rs.container.requestcontext.illegalstate;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;

import javax.ws.rs.ext.Provider;

/**
 * The methods are called here by reflection from the superclass
 */
@Provider
public class RequestFilter extends RequestTemplateFilter {

	public void setMethod() {
		try {
			requestContext.setMethod("OPTIONS");
			setEntity(NOEXCEPTION);
		} catch (IllegalStateException e) {
			setEntity(ISEXCEPTION);
		}
	}

	public void setRequestUri1() throws IOException {
		URI uri;
		try {
			uri = new URI(URI);
		} catch (URISyntaxException e) {
			throw new IOException(e);
		}
		try {
			requestContext.setRequestUri(uri);
			setEntity(NOEXCEPTION);
		} catch (IllegalStateException e) {
			setEntity(ISEXCEPTION);
		}
	}

	public void setRequestUri2() throws IOException {
		URI base;
		URI suffix;
		try {
			base = new URI("http://localhost:888/otherbase");
			suffix = new URI(URI);
		} catch (URISyntaxException e) {
			throw new IOException(e);
		}
		try {
			requestContext.setRequestUri(base, suffix);
			setEntity(NOEXCEPTION);
		} catch (IllegalStateException e) {
			setEntity(ISEXCEPTION);
		}
	}
}
