/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ant.taskdefs.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.jdom.xpath.XPath;

public class JCOVCTSConfig
extends Task {
    private JCOVInfo standAlone;
    private JCOVInfo appClient;
    private JCOVInfo appClient2;
    private JCOVInfo deploy;
    private File tshome;
    private File j2eehome;
    private File jcovPropsFile;
    private File tsPropsFile;
    private File tsPropsFileOut;
    private File jcovJar;
    private File buildFile;
    private File buildFileOut;
    private Properties jcovProps = new Properties();
    private Properties tsJTEProps = new Properties();

    public void setTshome(File tshome) {
        this.tshome = tshome;
    }

    public void setJ2eehome(File j2eehome) {
        this.j2eehome = j2eehome;
    }

    public void execute() throws BuildException {
        this.checkPreConditions();
        this.setProps();
        this.getJcovConfigData();
        this.editTsJte();
        this.editBuildXml();
    }

    private void checkPreConditions() throws BuildException {
        if (this.tshome == null || !this.tshome.isDirectory()) {
            throw new BuildException("TS_HOME is not set or is not an existing directory \"" + this.tshome + "\"");
        }
        if (this.j2eehome == null || !this.j2eehome.isDirectory()) {
            throw new BuildException("J2EE_HOME is not set or is not an existing directory \"" + this.j2eehome + "\"");
        }
    }

    private void setProps() throws BuildException {
        FileInputStream jcovPropsStream = null;
        FileInputStream tsPropsStream = null;
        try {
            this.jcovJar = new File(this.j2eehome, "lib" + File.separator + "jcov.jar");
            if (!this.jcovJar.isFile()) {
                throw new BuildException("JCOV jar does not exist at \"" + this.jcovJar.getPath() + "\"");
            }
            this.jcovPropsFile = new File(this.tshome, "internal" + File.separator + "coverage" + File.separator + "jcov.properties");
            if (!this.jcovPropsFile.isFile()) {
                throw new BuildException("JCOV properties file does not exist at \"" + this.jcovPropsFile.getPath() + "\"");
            }
            this.tsPropsFileOut = new File(this.tshome, "bin" + File.separator + "ts.jte");
            this.tsPropsFile = new File(this.tshome, "bin" + File.separator + "ts.jte.original");
            if (!this.tsPropsFile.isFile()) {
                throw new BuildException("TS JTEproperties file does not exist at \"" + this.tsPropsFile.getPath() + "\"");
            }
            this.buildFileOut = new File(this.tshome, "bin" + File.separator + "build.xml");
            this.buildFile = new File(this.tshome, "bin" + File.separator + "build.xml.original");
            if (!this.buildFile.isFile()) {
                throw new BuildException("Build file does not exist at \"" + this.buildFile.getPath() + "\"");
            }
            jcovPropsStream = new FileInputStream(this.jcovPropsFile);
            this.jcovProps.load(jcovPropsStream);
            tsPropsStream = new FileInputStream(this.tsPropsFile);
            this.tsJTEProps.load(tsPropsStream);
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
        finally {
            try {
                jcovPropsStream.close();
                tsPropsStream.close();
            }
            catch (Throwable t) {}
        }
    }

    private void parseCoverageData(Properties p) throws BuildException {
        this.standAlone = new JCOVInfo(p.getProperty("standalone"));
        this.appClient = new JCOVInfo(p.getProperty("appclient"));
        this.appClient2 = new JCOVInfo(p.getProperty("appclient2"));
        this.deploy = new JCOVInfo(p.getProperty("deploy"));
    }

    private void getJcovConfigData() throws BuildException {
        FileInputStream in = null;
        try {
            in = new FileInputStream(this.jcovPropsFile);
            Properties props = new Properties();
            props.load(in);
            this.parseCoverageData(props);
            this.log("Read JCOV configuration data from file \"" + this.jcovPropsFile + "\"", 2);
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
        finally {
            try {
                in.close();
            }
            catch (Throwable t) {}
        }
    }

    private void editTsJte() throws BuildException {
        this.updatePathProp("javaee.classes.ri");
        this.updatePathProp("javaee.classes");
        this.updatePathProp("ts.run.classpath.ri");
        this.updatePathProp("ts.run.classpath");
        this.updatePathProp("ts.harness.classpath");
        this.editClientVM("command.testExecute");
        this.editClientVM("command.testExecuteAppClient");
        this.editClientVM("command.testExecuteAppClient2");
        this.writeTsJte();
    }

    private void updatePathProp(String pathProp) throws BuildException {
        String path = this.tsJTEProps.getProperty(pathProp);
        if (path == null) {
            throw new BuildException("The ts.jte property \"" + pathProp + "\" does not exist.");
        }
        int index = path.indexOf("jcov.jar");
        if (index == -1) {
            this.tsJTEProps.setProperty(pathProp, path + File.pathSeparator + this.jcovJar.getPath());
            this.log("Added \"" + this.jcovJar.getPath() + "\" to path \"" + pathProp + "\" in ts.jte", 3);
        }
    }

    private void editClientVM(String vm) throws BuildException {
        String vmCommand = this.tsJTEProps.getProperty(vm);
        if (vmCommand == null) {
            throw new BuildException("The ts.jte property \"" + vm + "\" does not exist.");
        }
        int index = vmCommand.indexOf("jcov");
        if (index == -1) {
            StringBuffer buf = new StringBuffer(vmCommand);
            int index2 = buf.indexOf("-D");
            String jcovInfo = "-Djcov.file=" + this.getFile(vm) + " -Djcov.server_port=" + this.getPort(vm);
            buf.insert(index2, jcovInfo + " ");
            this.tsJTEProps.setProperty(vm, buf.toString());
            this.log("Added \"" + jcovInfo + "\" to VM command \"" + vm + "\" in ts.jte", 3);
        }
    }

    private String getFile(String vm) {
        String result = "";
        if (vm.equals("command.testExecute")) {
            result = this.standAlone.getFile();
        } else if (vm.equals("command.testExecuteAppClient")) {
            result = this.appClient.getFile();
        } else if (vm.equals("command.testExecuteAppClient2")) {
            result = this.appClient2.getFile();
        }
        return result;
    }

    private String getPort(String vm) {
        String result = "";
        if (vm.equals("command.testExecute")) {
            result = this.standAlone.getPort();
        } else if (vm.equals("command.testExecuteAppClient")) {
            result = this.appClient.getPort();
        } else if (vm.equals("command.testExecuteAppClient2")) {
            result = this.appClient2.getPort();
        }
        return result;
    }

    private void writeTsJte() throws BuildException {
        FileOutputStream out = null;
        try {
            this.tsPropsFileOut.delete();
            out = new FileOutputStream(this.tsPropsFileOut);
            this.tsJTEProps.store(out, "JCOV Configged ts.jte File");
            this.log("Wrote JCOVed file \"" + this.tsPropsFileOut + "\"", 2);
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
        finally {
            try {
                out.close();
            }
            catch (Throwable t) {}
        }
    }

    private boolean jcovved(Element el) {
        boolean result = false;
        try {
            XPath xpath = XPath.newInstance((String)"sysproperty[@key='jcov.file']");
            List javaElement = xpath.selectNodes((Object)el);
            result = javaElement.size() > 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    private void editBuildXml() throws BuildException {
        List javaElement = null;
        Document doc = null;
        try {
            SAXBuilder builder = new SAXBuilder(false);
            doc = builder.build(this.buildFile);
            XPath xpath = XPath.newInstance((String)"//target[@name='runclient']/java");
            javaElement = xpath.selectNodes((Object)doc);
        }
        catch (Exception e) {
            throw new BuildException("Error parsing build file.");
        }
        if (javaElement.size() != 1) {
            throw new BuildException("Could not find runclient/java element");
        }
        Element javaEl = (Element)javaElement.get(0);
        if (!this.jcovved(javaEl)) {
            javaEl.addContent((Content)new Element("sysproperty").setAttribute("key", "jcov.file").setAttribute("value", this.deploy.getFile()));
            javaEl.addContent((Content)new Element("sysproperty").setAttribute("key", "jcov.server_port").setAttribute("value", this.deploy.getPort()));
            this.log("Added jcov.file \"" + this.deploy.getFile() + "\" jcov.server_port \"" + this.deploy.getPort() + "\" to runclient target in build.xml", 3);
            this.writeBuildXml(doc);
        }
    }

    private void writeBuildXml(Document doc) throws BuildException {
        OutputStreamWriter out = null;
        try {
            this.buildFileOut.delete();
            out = new FileWriter(this.buildFileOut);
            XMLOutputter writer = new XMLOutputter(Format.getPrettyFormat());
            writer.output(doc, (Writer)out);
            this.log("Wrote JCOVed file \"" + this.buildFileOut + "\"", 2);
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
        finally {
            try {
                out.close();
            }
            catch (Throwable t) {}
        }
    }

    public static class JCOVInfo {
        private String file;
        private String port;

        public JCOVInfo(String info) throws BuildException {
            String[] a = info.split(":");
            if (a.length == 1) {
                this.port = a[0];
                this.file = "";
            } else if (a.length == 2) {
                this.file = a[0];
                this.port = a[1];
            } else {
                throw new BuildException("Badly formed JCOV data \"" + info + "\"");
            }
        }

        public String getPort() {
            return this.port;
        }

        public String getFile() {
            return this.file;
        }
    }
}

