/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.api.rs.core.generictype;

import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import jakarta.ws.rs.core.GenericType;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

public class JAXRSClientIT
extends JAXRSCommonClient {
    private static final long serialVersionUID = 1L;

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Test
    public void constructorWithTypeTest() throws JAXRSCommonClient.Fault {
        Method method = null;
        try {
            method = this.getClass().getMethod("dummyMethod", new Class[0]);
        }
        catch (Exception e) {
            throw new JAXRSCommonClient.Fault(e);
        }
        GenericType type = new GenericType(method.getReturnType());
        Assertions.assertTrue((type != null ? 1 : 0) != 0, (String)"Could not create a GenericType instance");
        Assertions.assertTrue((boolean)type.getRawType().isAssignableFrom(ArrayList.class), (String)(type.getRawType() + " != " + List.class));
        Assertions.assertTrue((boolean)type.getType().toString().contains(ArrayList.class.getName()), (String)(type.getType() + " != " + ArrayList.class));
        JAXRSClientIT.logMsg("Succesfully created GenericType<ArrayList<String>>(Type) instance");
    }

    public ArrayList<String> dummyMethod() {
        return null;
    }

    @Test
    public void constructorProtectedTest() throws JAXRSCommonClient.Fault {
        GenericType<TreeSet<String>> type = new GenericType<TreeSet<String>>(){};
        Assertions.assertTrue((type != null ? 1 : 0) != 0, (String)"Could not create a GenericType instance");
        Assertions.assertTrue((boolean)type.getRawType().isAssignableFrom(TreeSet.class), (String)(type.getRawType() + " != " + Set.class));
        Assertions.assertTrue((boolean)type.getType().toString().contains(TreeSet.class.getName()), (String)(type.getType() + " != " + TreeSet.class));
        JAXRSClientIT.logMsg("Succesfully created GenericType<TreeSet<String>>(){} instance");
    }

    @Test
    public void equalsTest() throws JAXRSCommonClient.Fault {
        GenericType<TreeSet<String>> type1 = new GenericType<TreeSet<String>>(){};
        GenericType<TreeSet<String>> type2 = new GenericType<TreeSet<String>>(){};
        GenericType<Set<String>> type3 = new GenericType<Set<String>>(){};
        Assertions.assertTrue((boolean)type1.equals((Object)type1), (String)"GenericType<TreeSet<String>> is not equal itself");
        Assertions.assertTrue((boolean)type2.equals((Object)type2), (String)"GenericType<TreeSet<String>> is not equal itself");
        Assertions.assertTrue((boolean)type1.equals((Object)type2), (String)"GenericType<TreeSet<String>> is not equal GenericType<TreeSet<String>>");
        Assertions.assertTrue((boolean)type2.equals((Object)type1), (String)"GenericType<TreeSet<String>> is not equal GenericType<TreeSet<String>>");
        Assertions.assertTrue((!type3.equals((Object)type1) ? 1 : 0) != 0, (String)"GenericType<Set<String>> is equal GenericType<TreeSet<String>>");
        JAXRSClientIT.logMsg("The tested GenericType<TreeSet<String>> instances are equal");
    }

    @Test
    public void hashCodeTest() throws JAXRSCommonClient.Fault {
        GenericType<TreeSet<String>> type1 = new GenericType<TreeSet<String>>(){};
        GenericType<TreeSet<String>> type2 = new GenericType<TreeSet<String>>(){};
        GenericType<Set<String>> type3 = new GenericType<Set<String>>(){};
        Assertions.assertTrue((type1.hashCode() == type1.hashCode() ? 1 : 0) != 0, (String)"HashCode of itself is random");
        Assertions.assertTrue((type2.hashCode() == type2.hashCode() ? 1 : 0) != 0, (String)"HashCode of itself is random");
        Assertions.assertTrue((type1.hashCode() == type2.hashCode() ? 1 : 0) != 0, (String)"Both GenericType instances should have the same hashCode");
        Assertions.assertTrue((type1.hashCode() != type3.hashCode() ? 1 : 0) != 0, (String)"GenericType<Set<String>>.hashCode()==GenericType<TreeSet<String>>.hashCode()");
        JAXRSClientIT.logMsg("Both GenericType instances have the same hashCode()");
    }

    @Test
    public void toStringTest() throws JAXRSCommonClient.Fault {
        GenericType<TreeSet<String>> type1 = new GenericType<TreeSet<String>>(){};
        GenericType<TreeSet<String>> type2 = new GenericType<TreeSet<String>>(){};
        GenericType<Set<String>> type3 = new GenericType<Set<String>>(){};
        Assertions.assertTrue((boolean)type1.toString().equals(type1.toString()), (String)"toString() of itself is random");
        Assertions.assertTrue((boolean)type2.toString().equals(type2.toString()), (String)"toString() of itself is random");
        Assertions.assertTrue((boolean)type1.toString().equals(type2.toString()), (String)"Both GenericType instances should have the same toString()");
        Assertions.assertTrue((!type1.toString().equals(type3.toString()) ? 1 : 0) != 0, (String)"GenericType<Set<String>>.toString()==GenericType<TreeSet<String>>.toString()");
        JAXRSClientIT.logMsg("Both GenericType instances have the same toString()", type1);
    }
}

