/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.workbench.renderers.fx;

import javafx.scene.Node;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.e4.ui.model.application.ui.SideValue;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimBar;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimElement;
import org.eclipse.fx.ui.workbench.renderers.base.BaseTrimBarRenderer;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WLayoutedWidget;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WTrimBar;
import org.eclipse.fx.ui.workbench.renderers.fx.widget.WLayoutedWidgetImpl;

public class DefTrimBarRenderer
extends BaseTrimBarRenderer<Pane> {
    protected Class<? extends WTrimBar<Pane>> getWidgetClass(MTrimBar trimbar) {
        return WTrimBarImpl.class;
    }

    public static class WTrimBarImpl
    extends WLayoutedWidgetImpl<Pane, Pane, MTrimBar>
    implements WTrimBar<Pane> {
        private SideValue sideValue;

        @Inject
        public WTrimBarImpl(@Named(value="side") SideValue sideValue) {
            this.sideValue = sideValue;
        }

        @Override
        protected Pane createWidget() {
            if (this.isVertical()) {
                VBox box = new VBox();
                box.getStyleClass().add((Object)this.sideValue.getName());
                return box;
            }
            HBox box = new HBox();
            box.getStyleClass().add((Object)this.sideValue.getName());
            return box;
        }

        private boolean isVertical() {
            return this.sideValue == SideValue.LEFT || this.sideValue == SideValue.RIGHT;
        }

        @Override
        public Pane getWidgetNode() {
            return (Pane)this.getWidget();
        }

        public void addChild(WLayoutedWidget<MTrimElement> trimElementWidget) {
            Node n = (Node)trimElementWidget.getStaticLayoutNode();
            MTrimElement element = (MTrimElement)trimElementWidget.getDomElement();
            if (element != null && element.getTags().contains("fillspace")) {
                if (this.isVertical()) {
                    VBox.setVgrow((Node)n, (Priority)Priority.ALWAYS);
                } else {
                    HBox.setHgrow((Node)n, (Priority)Priority.ALWAYS);
                }
            }
            ((Pane)this.getWidget()).getChildren().add((Object)n);
        }

        public void addChild(int idx, WLayoutedWidget<MTrimElement> trimElementWidget) {
            Node n = (Node)trimElementWidget.getStaticLayoutNode();
            MTrimElement element = (MTrimElement)trimElementWidget.getDomElement();
            if (element != null && element.getTags().contains("fillspace")) {
                if (this.isVertical()) {
                    VBox.setVgrow((Node)n, (Priority)Priority.ALWAYS);
                } else {
                    HBox.setHgrow((Node)n, (Priority)Priority.ALWAYS);
                }
            }
            ((Pane)this.getWidget()).getChildren().add(idx, (Object)n);
        }

        public void removeChild(WLayoutedWidget<MTrimElement> trimElementWidget) {
            Node n = (Node)trimElementWidget.getStaticLayoutNode();
            ((Pane)this.getWidget()).getChildren().remove((Object)n);
        }

        @Override
        protected void initDnd(Pane staticLayoutGroup) {
        }
    }
}

