/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.java.engine;

import java.util.Iterator;
import java.util.Map;
import org.eclipse.egf.common.constant.EGFCommonConstants;
import org.eclipse.egf.model.fcore.NamedModelElement;
import org.eclipse.egf.model.pattern.BackCall;
import org.eclipse.egf.model.pattern.MethodCall;
import org.eclipse.egf.model.pattern.Pattern;
import org.eclipse.egf.model.pattern.PatternCall;
import org.eclipse.egf.model.pattern.PatternException;
import org.eclipse.egf.model.pattern.PatternInjectedCall;
import org.eclipse.egf.model.pattern.PatternMethod;
import org.eclipse.egf.model.pattern.PatternParameter;
import org.eclipse.egf.model.pattern.SuperCall;
import org.eclipse.egf.pattern.engine.AssemblyContentProvider;
import org.eclipse.egf.pattern.engine.ParameterMatcher;
import org.eclipse.egf.pattern.engine.PatternHelper;
import org.eclipse.egf.pattern.java.Messages;
import org.eclipse.egf.pattern.utils.JavaMethodGenerationHelper;
import org.eclipse.egf.pattern.utils.ParameterTypeHelper;

public class JavaAssemblyContentProvider
extends AssemblyContentProvider {
    public JavaAssemblyContentProvider(Pattern pattern) {
        super(pattern, new JavaMethodGenerationHelper("out"));
    }

    protected void call(MethodCall object) throws PatternException {
        this.javaMethodHelper.addCallStatement(object.getCalled());
        this.content.append(EGFCommonConstants.LINE_SEPARATOR);
    }

    protected void call(PatternCall call) throws PatternException {
        Pattern pattern = call.getCalled();
        if (call.getParameterMatching().isEmpty()) {
            ParameterMatcher matcher = ParameterMatcher.create((Pattern)call.getPattern(), (Pattern)pattern);
            if (!matcher.matches()) {
                throw new PatternException(Messages.bind((String)Messages.assembly_error7, (Object)call.getPattern().getName()));
            }
            for (Iterator key : matcher.getMatching().keySet()) {
                String called = PatternHelper.uniqueName((NamedModelElement)key);
                this.content.append(ParameterTypeHelper.INSTANCE.getTypeLiteral(key.getType())).append(" ").append(called).append(" = ").append(((PatternParameter)matcher.getMatching().get(key)).getName()).append(";").append(EGFCommonConstants.LINE_SEPARATOR);
            }
        } else {
            for (Map.Entry binding : call.getParameterMatching()) {
                String called = PatternHelper.uniqueName((NamedModelElement)((NamedModelElement)binding.getKey()));
                this.content.append(ParameterTypeHelper.INSTANCE.getTypeLiteral(((PatternParameter)binding.getKey()).getType())).append(" ").append(called).append(" = ").append(((PatternParameter)binding.getValue()).getName()).append(";").append(EGFCommonConstants.LINE_SEPARATOR);
            }
        }
        String ctxName = "ctx_" + PatternHelper.generateID();
        this.content.append("ExecutionContext ").append(ctxName).append(" = new ExecutionContext(ictx);").append(EGFCommonConstants.LINE_SEPARATOR);
        this.content.append("CallHelper.executeWithInjection(\"").append(pattern.getID()).append("\", ").append(ctxName);
        for (PatternParameter parameter : pattern.getAllParameters()) {
            this.content.append(", ").append(PatternHelper.uniqueName((NamedModelElement)parameter));
        }
        this.content.append(");").append(EGFCommonConstants.LINE_SEPARATOR).append(EGFCommonConstants.LINE_SEPARATOR);
    }

    protected void call(BackCall object) throws PatternException {
        this.content.append("CallHelper.callBack(new CallbackContext(ictx)");
        for (PatternParameter parameter : this.pattern.getAllParameters()) {
            this.content.append(", ").append(parameter.getName());
        }
        this.content.append(");").append(EGFCommonConstants.LINE_SEPARATOR);
    }

    protected void call(SuperCall object) throws PatternException {
        if (object.getPattern().getSuperPattern() == null) {
            return;
        }
        String ctxName = "ctx_" + PatternHelper.generateID();
        this.content.append("ExecutionContext ").append(ctxName).append(" = new ExecutionContext(ictx);").append(EGFCommonConstants.LINE_SEPARATOR);
        this.content.append("super.generate(").append(ctxName);
        for (PatternParameter parameter : this.pattern.getSuperPattern().getAllParameters()) {
            this.content.append(", ").append(parameter.getName());
        }
        this.content.append(");").append(EGFCommonConstants.LINE_SEPARATOR);
    }

    protected void call(PatternInjectedCall call) throws PatternException {
        Pattern pattern = call.getCalled();
        String ctxName = "ctx_" + PatternHelper.generateID();
        this.content.append("ExecutionContext ").append(ctxName).append(" = new ExecutionContext(ictx);").append(EGFCommonConstants.LINE_SEPARATOR);
        this.content.append(ctxName).append(".setValue(").append("PatternContext.INJECTED_CONTEXT, ").append(call.getContext().getName()).append(");").append(EGFCommonConstants.LINE_SEPARATOR);
        this.content.append("CallHelper.execute(\"").append(pattern.getID()).append("\", ").append(ctxName).append(");").append(EGFCommonConstants.LINE_SEPARATOR).append(EGFCommonConstants.LINE_SEPARATOR);
    }

    protected void addMethodBodies() throws PatternException {
        for (PatternMethod method : PatternHelper.getUserMethds((Pattern)this.pattern)) {
            this.javaMethodHelper.addSignature(method);
            this.content.append(EGFCommonConstants.LINE_SEPARATOR);
            this.content.append("{").append(EGFCommonConstants.LINE_SEPARATOR);
            this.content.append(this.getMethodContent(method)).append(EGFCommonConstants.LINE_SEPARATOR);
            this.content.append("}").append(EGFCommonConstants.LINE_SEPARATOR).append(EGFCommonConstants.LINE_SEPARATOR);
        }
    }
}

